/*
 * Decompiled with CFR 0.152.
 */
package com.ximpleware;

import com.ximpleware.ContextBuffer;
import com.ximpleware.FastIntBuffer;
import com.ximpleware.FastLongBuffer;
import com.ximpleware.IByteBuffer;
import com.ximpleware.IndexHandler;
import com.ximpleware.IndexWriteException;
import com.ximpleware.NavException;
import com.ximpleware.VTDNav;
import java.io.IOException;
import java.io.OutputStream;

public class VTDNav_L5
extends VTDNav {
    protected int l4index;
    protected int l5index;
    protected int l4upper;
    protected int l4lower;
    protected int l5upper;
    protected int l5lower;
    protected FastLongBuffer l3Buffer;
    protected FastLongBuffer l4Buffer;
    protected FastIntBuffer l5Buffer;

    protected VTDNav_L5(int RootIndex, int enc, boolean NS, int depth, IByteBuffer x, FastLongBuffer vtd, FastLongBuffer l1, FastLongBuffer l2, FastLongBuffer l3, FastLongBuffer l4, FastIntBuffer l5, int so, int length) {
        if (l1 == null || l2 == null || l3 == null || vtd == null || x == null || depth < 0 || RootIndex < 0 || so < 0 || length < 0) {
            throw new IllegalArgumentException();
        }
        this.count = 0;
        this.l1Buffer = l1;
        this.l2Buffer = l2;
        this.l3Buffer = l3;
        this.l4Buffer = l4;
        this.l5Buffer = l5;
        this.vtdBuffer = vtd;
        this.XMLDoc = x;
        this.encoding = enc;
        this.rootIndex = RootIndex;
        this.nestingLevel = depth + 1;
        this.ns = NS;
        this.MASK_TOKEN_OFFSET = !this.ns ? Integer.MAX_VALUE : 0x3FFFFFFFL;
        this.atTerminal = false;
        this.context = new int[this.nestingLevel];
        this.context[0] = 0;
        for (int i = 1; i < this.nestingLevel; ++i) {
            this.context[i] = -1;
        }
        this.contextStack = new ContextBuffer(10, this.nestingLevel + 15);
        this.contextStack2 = new ContextBuffer(10, this.nestingLevel + 15);
        this.stackTemp = new int[this.nestingLevel + 15];
        this.l5index = -1;
        this.l4index = -1;
        this.l3index = -1;
        this.l2index = -1;
        this.l1index = -1;
        this.l5lower = -1;
        this.l4lower = -1;
        this.l3lower = -1;
        this.l2lower = -1;
        this.l5upper = -1;
        this.l4upper = -1;
        this.l3upper = -1;
        this.l2upper = -1;
        this.docOffset = so;
        this.docLen = length;
        this.vtdSize = vtd.size;
        this.name = null;
        this.nameIndex = -1;
        this.localName = null;
        this.localNameIndex = -1;
        this.fib = new FastIntBuffer(5);
        this.shallowDepth = false;
        this.maxLCDepthPlusOne = (short)6;
    }

    public VTDNav cloneNav() {
        VTDNav_L5 vn = new VTDNav_L5(this.rootIndex, this.encoding, this.ns, this.nestingLevel - 1, this.XMLDoc, this.vtdBuffer, this.l1Buffer, this.l2Buffer, this.l3Buffer, this.l4Buffer, this.l5Buffer, this.docOffset, this.docLen);
        vn.atTerminal = this.atTerminal;
        vn.LN = this.LN;
        if (this.context[0] != -1) {
            System.arraycopy(this.context, 0, vn.context, 0, this.context[0] + 1);
        } else {
            vn.context[0] = -1;
        }
        vn.l1index = this.l1index;
        if (this.getCurrentDepth() > 1) {
            vn.l2index = this.l2index;
            vn.l2upper = this.l2upper;
            vn.l2lower = this.l2lower;
        }
        if (this.getCurrentDepth() > 2) {
            vn.l3lower = this.l3lower;
            vn.l3index = this.l3index;
            vn.l3upper = this.l3upper;
        }
        if (this.getCurrentDepth() > 3) {
            vn.l4lower = this.l4lower;
            vn.l4index = this.l4index;
            vn.l4upper = this.l4upper;
        }
        if (this.getCurrentDepth() > 4) {
            vn.l5lower = this.l5lower;
            vn.l5index = this.l5index;
            vn.l5upper = this.l5upper;
        }
        return vn;
    }

    public final VTDNav duplicateNav() {
        return new VTDNav_L5(this.rootIndex, this.encoding, this.ns, this.nestingLevel - 1, this.XMLDoc, this.vtdBuffer, this.l1Buffer, this.l2Buffer, this.l3Buffer, this.l4Buffer, this.l5Buffer, this.docOffset, this.docLen);
    }

    protected final boolean iterateNS(int dp, String URL2, String ln) throws NavException {
        if (!this.ns) {
            return false;
        }
        int index = this.getCurrentIndex() + 1;
        while (index < this.vtdSize) {
            int tokenType = this.getTokenType(index);
            if (tokenType == 2 || tokenType == 3) {
                index += 2;
                continue;
            }
            if (this.isElementOrDocument(index)) {
                int depth = this.getTokenDepth(index);
                if (depth > dp) {
                    this.context[0] = depth;
                    if (depth > 0) {
                        this.context[depth] = index;
                    }
                    if (this.matchElementNS(URL2, ln)) {
                        if (dp < 6) {
                            this.resolveLC();
                        }
                        return true;
                    }
                } else {
                    return false;
                }
            }
            ++index;
        }
        return false;
    }

    protected void resolveLC() {
        if (this.context[0] <= 0) {
            return;
        }
        this.resolveLC_l1();
        if (this.context[0] == 1) {
            return;
        }
        this.resolveLC_l2();
        if (this.context[0] == 2) {
            return;
        }
        this.resolveLC_l3();
        if (this.context[0] == 3) {
            return;
        }
        this.resolveLC_l4();
        if (this.context[0] == 4) {
            return;
        }
        this.resolveLC_l5();
    }

    protected void resolveLC_l3() {
        block16: {
            int temp = this.l2Buffer.lower32At(this.l2index);
            if (this.l3lower != temp) {
                this.l3index = this.l3lower = temp;
                this.l3upper = this.l3Buffer.size - 1;
                for (int i = this.l2index + 1; i < this.l2Buffer.size; ++i) {
                    temp = this.l2Buffer.lower32At(i);
                    if (temp == -1) continue;
                    this.l3upper = temp - 1;
                    break;
                }
            }
            if (this.l3index >= 0 && this.l3index < this.l3Buffer.size && this.context[3] == this.l3Buffer.upper32At(this.l3index)) break block16;
            if (this.l3index >= this.l3Buffer.size || this.l3index < 0) {
                this.l3index = this.l3lower;
            }
            if (this.l3index + 1 < this.l3Buffer.size && this.context[3] == this.l3Buffer.upper32At(this.l3index + 1)) {
                ++this.l3index;
            } else if (this.l3upper - this.l3lower >= 16) {
                int init_guess = this.l3lower + (int)((float)(this.l3upper - this.l3lower) * ((float)this.context[3] - (float)this.l3Buffer.upper32At(this.l3lower)) / (float)(this.l3Buffer.upper32At(this.l3upper) - this.l3Buffer.upper32At(this.l3lower)));
                if (this.l3Buffer.upper32At(init_guess) > this.context[3]) {
                    while (this.context[3] != this.l3Buffer.upper32At(init_guess)) {
                        --init_guess;
                    }
                } else if (this.l3Buffer.upper32At(init_guess) < this.context[3]) {
                    while (this.context[3] != this.l3Buffer.upper32At(init_guess)) {
                        ++init_guess;
                    }
                }
                this.l3index = init_guess;
            } else if (this.context[3] < this.l3Buffer.upper32At(this.l3index)) {
                while (this.context[3] != this.l3Buffer.upper32At(this.l3index)) {
                    --this.l3index;
                }
            } else {
                while (this.context[3] != this.l3Buffer.upper32At(this.l3index)) {
                    ++this.l3index;
                }
            }
        }
    }

    private void resolveLC_l4() {
        block16: {
            int temp = this.l3Buffer.lower32At(this.l3index);
            if (this.l4lower != temp) {
                this.l4index = this.l4lower = temp;
                this.l4upper = this.l4Buffer.size - 1;
                for (int i = this.l3index + 1; i < this.l3Buffer.size; ++i) {
                    temp = this.l3Buffer.lower32At(i);
                    if (temp == -1) continue;
                    this.l4upper = temp - 1;
                    break;
                }
            }
            if (this.l4index >= 0 && this.l4index < this.l4Buffer.size && this.context[4] == this.l4Buffer.upper32At(this.l4index)) break block16;
            if (this.l4index >= this.l4Buffer.size || this.l4index < 0) {
                this.l4index = this.l4lower;
            }
            if (this.l4index + 1 < this.l4Buffer.size && this.context[4] == this.l4Buffer.upper32At(this.l4index + 1)) {
                ++this.l4index;
            } else if (this.l4upper - this.l4lower >= 16) {
                int init_guess = this.l4lower + (int)((float)(this.l4upper - this.l4lower) * ((float)this.context[4] - (float)this.l4Buffer.upper32At(this.l4lower)) / (float)(this.l4Buffer.upper32At(this.l4upper) - this.l4Buffer.upper32At(this.l4lower)));
                if (this.l4Buffer.upper32At(init_guess) > this.context[4]) {
                    while (this.context[4] != this.l4Buffer.upper32At(init_guess)) {
                        --init_guess;
                    }
                } else if (this.l4Buffer.upper32At(init_guess) < this.context[4]) {
                    while (this.context[4] != this.l4Buffer.upper32At(init_guess)) {
                        ++init_guess;
                    }
                }
                this.l4index = init_guess;
            } else if (this.context[4] < this.l4Buffer.upper32At(this.l4index)) {
                while (this.context[4] != this.l4Buffer.upper32At(this.l4index)) {
                    --this.l4index;
                }
            } else {
                while (this.context[4] != this.l4Buffer.upper32At(this.l4index)) {
                    ++this.l4index;
                }
            }
        }
    }

    private void resolveLC_l5() {
        block16: {
            int temp = this.l4Buffer.lower32At(this.l4index);
            if (this.l5lower != temp) {
                this.l5index = this.l5lower = temp;
                this.l5upper = this.l5Buffer.size - 1;
                for (int i = this.l4index + 1; i < this.l4Buffer.size; ++i) {
                    temp = this.l4Buffer.lower32At(i);
                    if (temp == -1) continue;
                    this.l5upper = temp - 1;
                    break;
                }
            }
            if (this.l5index >= 0 && this.l5index < this.l5Buffer.size && this.context[5] == this.l5Buffer.intAt(this.l5index)) break block16;
            if (this.l5index >= this.l5Buffer.size || this.l5index < 0) {
                this.l5index = this.l5lower;
            }
            if (this.l5index + 1 < this.l5Buffer.size && this.context[5] == this.l5Buffer.intAt(this.l5index + 1)) {
                ++this.l5index;
            } else if (this.l5upper - this.l5lower >= 16) {
                int init_guess = this.l5lower + (int)((float)(this.l5upper - this.l5lower) * ((float)(this.context[5] - this.l5Buffer.intAt(this.l5lower)) / (float)(this.l5Buffer.intAt(this.l5upper) - this.l5Buffer.intAt(this.l5lower))));
                if (this.l5Buffer.intAt(init_guess) > this.context[5]) {
                    while (this.context[5] != this.l5Buffer.intAt(init_guess)) {
                        --init_guess;
                    }
                } else if (this.l5Buffer.intAt(init_guess) < this.context[5]) {
                    while (this.context[5] != this.l5Buffer.intAt(init_guess)) {
                        ++init_guess;
                    }
                }
                this.l5index = init_guess;
            } else if (this.context[5] < this.l5Buffer.intAt(this.l5index)) {
                while (this.context[5] != this.l5Buffer.intAt(this.l5index)) {
                    --this.l5index;
                }
            } else {
                while (this.context[5] != this.l5Buffer.intAt(this.l5index)) {
                    ++this.l5index;
                }
            }
        }
    }

    public boolean pop() {
        boolean b = this.contextStack.load(this.stackTemp);
        if (!b) {
            return false;
        }
        for (int i = 0; i < this.nestingLevel; ++i) {
            this.context[i] = this.stackTemp[i];
        }
        this.l1index = this.stackTemp[this.nestingLevel];
        this.l2index = this.stackTemp[this.nestingLevel + 1];
        this.l3index = this.stackTemp[this.nestingLevel + 2];
        this.l4index = this.stackTemp[this.nestingLevel + 3];
        this.l5index = this.stackTemp[this.nestingLevel + 4];
        this.l2lower = this.stackTemp[this.nestingLevel + 5];
        this.l2upper = this.stackTemp[this.nestingLevel + 6];
        this.l3lower = this.stackTemp[this.nestingLevel + 7];
        this.l3upper = this.stackTemp[this.nestingLevel + 8];
        this.l4lower = this.stackTemp[this.nestingLevel + 9];
        this.l4upper = this.stackTemp[this.nestingLevel + 10];
        this.l5lower = this.stackTemp[this.nestingLevel + 11];
        this.l5upper = this.stackTemp[this.nestingLevel + 12];
        this.atTerminal = this.stackTemp[this.nestingLevel + 13] == 1;
        this.LN = this.stackTemp[this.nestingLevel + 14];
        return true;
    }

    protected final boolean pop2() {
        boolean b = this.contextStack2.load(this.stackTemp);
        if (!b) {
            return false;
        }
        for (int i = 0; i < this.nestingLevel; ++i) {
            this.context[i] = this.stackTemp[i];
        }
        this.l1index = this.stackTemp[this.nestingLevel];
        this.l2index = this.stackTemp[this.nestingLevel + 1];
        this.l3index = this.stackTemp[this.nestingLevel + 2];
        this.l4index = this.stackTemp[this.nestingLevel + 3];
        this.l5index = this.stackTemp[this.nestingLevel + 4];
        this.l2lower = this.stackTemp[this.nestingLevel + 5];
        this.l2upper = this.stackTemp[this.nestingLevel + 6];
        this.l3lower = this.stackTemp[this.nestingLevel + 7];
        this.l3upper = this.stackTemp[this.nestingLevel + 8];
        this.l4lower = this.stackTemp[this.nestingLevel + 9];
        this.l4upper = this.stackTemp[this.nestingLevel + 10];
        this.l5lower = this.stackTemp[this.nestingLevel + 11];
        this.l5upper = this.stackTemp[this.nestingLevel + 12];
        this.atTerminal = this.stackTemp[this.nestingLevel + 13] == 1;
        this.LN = this.stackTemp[this.nestingLevel + 14];
        return true;
    }

    public final void push() {
        for (int i = 0; i < this.nestingLevel; ++i) {
            this.stackTemp[i] = this.context[i];
        }
        this.stackTemp[this.nestingLevel] = this.l1index;
        this.stackTemp[this.nestingLevel + 1] = this.l2index;
        this.stackTemp[this.nestingLevel + 2] = this.l3index;
        this.stackTemp[this.nestingLevel + 3] = this.l4index;
        this.stackTemp[this.nestingLevel + 4] = this.l5index;
        this.stackTemp[this.nestingLevel + 5] = this.l2lower;
        this.stackTemp[this.nestingLevel + 6] = this.l2upper;
        this.stackTemp[this.nestingLevel + 7] = this.l3lower;
        this.stackTemp[this.nestingLevel + 8] = this.l3upper;
        this.stackTemp[this.nestingLevel + 9] = this.l4lower;
        this.stackTemp[this.nestingLevel + 10] = this.l4upper;
        this.stackTemp[this.nestingLevel + 11] = this.l5lower;
        this.stackTemp[this.nestingLevel + 12] = this.l5upper;
        this.stackTemp[this.nestingLevel + 13] = this.atTerminal ? 1 : 0;
        this.stackTemp[this.nestingLevel + 14] = this.LN;
        this.contextStack.store(this.stackTemp);
    }

    protected final void push2() {
        for (int i = 0; i < this.nestingLevel; ++i) {
            this.stackTemp[i] = this.context[i];
        }
        this.stackTemp[this.nestingLevel] = this.l1index;
        this.stackTemp[this.nestingLevel + 1] = this.l2index;
        this.stackTemp[this.nestingLevel + 2] = this.l3index;
        this.stackTemp[this.nestingLevel + 3] = this.l4index;
        this.stackTemp[this.nestingLevel + 4] = this.l5index;
        this.stackTemp[this.nestingLevel + 5] = this.l2lower;
        this.stackTemp[this.nestingLevel + 6] = this.l2upper;
        this.stackTemp[this.nestingLevel + 7] = this.l3lower;
        this.stackTemp[this.nestingLevel + 8] = this.l3upper;
        this.stackTemp[this.nestingLevel + 9] = this.l4lower;
        this.stackTemp[this.nestingLevel + 10] = this.l4upper;
        this.stackTemp[this.nestingLevel + 11] = this.l5lower;
        this.stackTemp[this.nestingLevel + 12] = this.l5upper;
        this.stackTemp[this.nestingLevel + 13] = this.atTerminal ? 1 : 0;
        this.stackTemp[this.nestingLevel + 14] = this.LN;
        this.contextStack2.store(this.stackTemp);
    }

    private final void recoverNode_l3(int index) {
        int i = this.l2Buffer.lower32At(this.l2index);
        if (this.l3lower != i) {
            this.l3lower = i;
            this.l3upper = this.l3Buffer.size - 1;
            for (int k = this.l2index + 1; k < this.l2Buffer.size; ++k) {
                i = this.l2Buffer.lower32At(k);
                if (i == -1) continue;
                this.l3upper = i - 1;
                break;
            }
        }
        int t1 = this.l3Buffer.upper32At(this.l3lower);
        int t2 = this.l3Buffer.upper32At(this.l3upper);
        for (i = Math.min(this.l3lower + (int)((float)(index - t1) / (float)(t2 - t1 + 1) * (float)(this.l3upper - this.l3lower)), this.l3upper); i < this.l3Buffer.size - 1 && this.l3Buffer.upper32At(i) < index; ++i) {
        }
        while (this.l3Buffer.upper32At(i) > index && i > 0) {
            --i;
        }
        this.context[3] = this.l3Buffer.upper32At(i);
        this.l3index = i;
    }

    private final void recoverNode_l4(int index) {
        int i = this.l3Buffer.lower32At(this.l3index);
        if (this.l4lower != i) {
            this.l4lower = i;
            this.l4upper = this.l4Buffer.size - 1;
            for (int k = this.l3index + 1; k < this.l3Buffer.size; ++k) {
                i = this.l3Buffer.lower32At(k);
                if (i == -1) continue;
                this.l4upper = i - 1;
                break;
            }
        }
        int t1 = this.l4Buffer.upper32At(this.l4lower);
        int t2 = this.l4Buffer.upper32At(this.l4upper);
        for (i = Math.min(this.l4lower + (int)((float)(index - t1) / (float)(t2 - t1 + 1) * (float)(this.l4upper - this.l4lower)), this.l4upper); i < this.l4Buffer.size - 1 && this.l4Buffer.upper32At(i) < index; ++i) {
        }
        while (this.l4Buffer.upper32At(i) > index && i > 0) {
            --i;
        }
        this.context[4] = this.l4Buffer.upper32At(i);
        this.l4index = i;
    }

    private final void recoverNode_l5(int index) {
        int i = this.l4Buffer.lower32At(this.l4index);
        if (this.l5lower != i) {
            this.l5lower = i;
            this.l5upper = this.l5Buffer.size - 1;
            for (int k = this.l4index + 1; k < this.l4Buffer.size; ++k) {
                i = this.l4Buffer.lower32At(k);
                if (i == -1) continue;
                this.l5upper = i - 1;
                break;
            }
        }
        int t1 = this.l5Buffer.intAt(this.l5lower);
        int t2 = this.l5Buffer.intAt(this.l5upper);
        for (i = Math.min(this.l5lower + (int)((float)(index - t1) / (float)(t2 - t1 + 1) * (float)(this.l5upper - this.l5lower)), this.l5upper); i < this.l5Buffer.size - 1 && this.l5Buffer.intAt(i) < index; ++i) {
        }
        while (this.l5Buffer.intAt(i) > index && i > 0) {
            --i;
        }
        this.context[5] = this.l5Buffer.intAt(i);
        this.l5index = i;
    }

    protected void sync(int depth, int index) {
        switch (depth) {
            case -1: {
                return;
            }
            case 0: {
                if (this.l1Buffer.size == 0) break;
                if (this.l1index == -1) {
                    this.l1index = 0;
                }
                if (index > this.l1Buffer.upper32At(this.l1Buffer.size - 1)) {
                    this.l1index = this.l1Buffer.size - 1;
                    return;
                }
                if (index > this.l1Buffer.upper32At(this.l1index)) {
                    while (this.l1index < this.l1Buffer.size - 1 && this.l1Buffer.upper32At(this.l1index) < index) {
                        ++this.l1index;
                    }
                } else {
                    while (this.l1index > 0 && this.l1Buffer.upper32At(this.l1index - 1) > index) {
                        --this.l1index;
                    }
                }
                break;
            }
            case 1: {
                if (this.l1Buffer.lower32At(this.l1index) == -1) break;
                if (this.l2lower != this.l1Buffer.lower32At(this.l1index)) {
                    this.l2lower = this.l2index = this.l1Buffer.lower32At(this.l1index);
                    this.l2upper = this.l2Buffer.size - 1;
                    int size = this.l1Buffer.size;
                    for (int i = this.l1index + 1; i < size; ++i) {
                        int temp = this.l1Buffer.lower32At(i);
                        if (temp == -1) continue;
                        this.l2upper = temp - 1;
                        break;
                    }
                }
                if (index > this.l2Buffer.upper32At(this.l2index)) {
                    while (this.l2index < this.l2upper && this.l2Buffer.upper32At(this.l2index) < index) {
                        ++this.l2index;
                    }
                } else {
                    while (this.l2index > this.l2lower && this.l2Buffer.upper32At(this.l2index - 1) > index) {
                        --this.l2index;
                    }
                }
                break;
            }
            case 2: {
                if (this.l2Buffer.lower32At(this.l2index) == -1) break;
                if (this.l3lower != this.l2Buffer.lower32At(this.l2index)) {
                    this.l3index = this.l3lower = this.l2Buffer.lower32At(this.l2index);
                    this.l3upper = this.l3Buffer.size - 1;
                    int size = this.l2Buffer.size;
                    for (int i = this.l2index + 1; i < size; ++i) {
                        int temp = this.l2Buffer.lower32At(i);
                        if (temp == -1) continue;
                        this.l3upper = temp - 1;
                        break;
                    }
                }
                if (index > this.l3Buffer.upper32At(this.l3index)) {
                    while (this.l3index < this.l3upper && this.l3Buffer.upper32At(this.l3index) < index) {
                        ++this.l3index;
                    }
                } else {
                    while (this.l3index > this.l3lower && this.l3Buffer.upper32At(this.l3index - 1) > index) {
                        --this.l3index;
                    }
                }
                break;
            }
            case 3: {
                if (this.l3Buffer.lower32At(this.l3index) == -1) break;
                if (this.l4lower != this.l3Buffer.lower32At(this.l3index)) {
                    this.l4index = this.l4lower = this.l3Buffer.lower32At(this.l3index);
                    this.l4upper = this.l4Buffer.size - 1;
                    int size = this.l3Buffer.size;
                    for (int i = this.l3index + 1; i < size; ++i) {
                        int temp = this.l3Buffer.lower32At(i);
                        if (temp == -1) continue;
                        this.l4upper = temp - 1;
                        break;
                    }
                }
                if (index > this.l4Buffer.upper32At(this.l4index)) {
                    while (this.l4index < this.l4upper && this.l4Buffer.upper32At(this.l4index) < index) {
                        ++this.l4index;
                    }
                } else {
                    while (this.l4index > this.l4lower && this.l4Buffer.upper32At(this.l4index - 1) > index) {
                        --this.l4index;
                    }
                }
                break;
            }
            case 4: {
                if (this.l4Buffer.lower32At(this.l4index) == -1) break;
                if (this.l5lower != this.l4Buffer.lower32At(this.l4index)) {
                    this.l5index = this.l5lower = this.l4Buffer.lower32At(this.l4index);
                    this.l5upper = this.l5Buffer.size - 1;
                    int size = this.l4Buffer.size;
                    for (int i = this.l4index + 1; i < size; ++i) {
                        int temp = this.l4Buffer.lower32At(i);
                        if (temp == -1) continue;
                        this.l5upper = temp - 1;
                        break;
                    }
                }
                if (index > this.l5Buffer.intAt(this.l5index)) {
                    while (this.l5index < this.l5upper && this.l5Buffer.intAt(this.l5index) < index) {
                        ++this.l5index;
                    }
                } else {
                    while (this.l5index > this.l5lower && this.l5Buffer.intAt(this.l5index - 1) > index) {
                        --this.l5index;
                    }
                }
                break;
            }
            default: {
                if (this.l4Buffer.lower32At(this.l4index) == -1) break;
                if (this.l5lower != this.l4Buffer.lower32At(this.l4index)) {
                    this.l5index = this.l5lower = this.l4Buffer.lower32At(this.l4index);
                    this.l5upper = this.l5Buffer.size - 1;
                    int size = this.l4Buffer.size;
                    for (int i = this.l4index + 1; i < size; ++i) {
                        int temp = this.l4Buffer.lower32At(i);
                        if (temp == -1) continue;
                        this.l5upper = temp - 1;
                        break;
                    }
                }
                while (this.context[5] != this.l5Buffer.intAt(this.l5index)) {
                    ++this.l5index;
                }
                break block0;
            }
        }
    }

    public void sampleState(FastIntBuffer fib) {
        if (this.context[0] >= 1) {
            fib.append(this.l1index);
        }
        if (this.context[0] >= 2) {
            fib.append(this.l2index);
            fib.append(this.l2lower);
            fib.append(this.l2upper);
        }
        if (this.context[0] >= 3) {
            fib.append(this.l3index);
            fib.append(this.l3lower);
            fib.append(this.l3upper);
        }
        if (this.context[0] >= 4) {
            fib.append(this.l4index);
            fib.append(this.l4lower);
            fib.append(this.l4upper);
        }
        if (this.context[0] >= 5) {
            fib.append(this.l5index);
            fib.append(this.l5lower);
            fib.append(this.l5upper);
        }
    }

    public void dumpState() {
        System.out.println("l1 index ==>" + this.l1index);
        System.out.println("l2 index ==>" + this.l2index);
        System.out.println("l2 lower ==>" + this.l2lower);
        System.out.println("l2 upper ==>" + this.l2upper);
        System.out.println("l3 index ==>" + this.l3index);
        System.out.println("l3 lower ==>" + this.l3lower);
        System.out.println("l3 upper ==>" + this.l3upper);
        System.out.println("l4 index ==>" + this.l4index);
        System.out.println("l4 lower ==>" + this.l4lower);
        System.out.println("l4 upper ==>" + this.l4upper);
        System.out.println("l5 index ==>" + this.l5index);
        System.out.println("l5 lower ==>" + this.l5lower);
        System.out.println("l5 upper ==>" + this.l5upper);
    }

    public boolean toElement(int direction, String en) throws NavException {
        int temp = -1;
        int d = -1;
        int val = 0;
        boolean b = false;
        if (en == null) {
            throw new IllegalArgumentException(" Element name can't be null ");
        }
        if (en.equals("*")) {
            return this.toElement(direction);
        }
        switch (direction) {
            case 0: {
                return this.toElement(0);
            }
            case 1: {
                return this.toElement(1);
            }
            case 2: {
                if (this.atTerminal) {
                    return false;
                }
                if (!this.toElement(2)) {
                    return false;
                }
                if (!this.matchElement(en)) {
                    if (this.toElement(4, en)) {
                        return true;
                    }
                    this.context[0] = this.context[0] - 1;
                    return false;
                }
                return true;
            }
            case 3: {
                if (this.atTerminal) {
                    return false;
                }
                if (!this.toElement(3)) {
                    return false;
                }
                if (!this.matchElement(en)) {
                    if (this.toElement(5, en)) {
                        return true;
                    }
                    this.context[0] = this.context[0] - 1;
                    return false;
                }
                return true;
            }
            case 4: {
                if (this.atTerminal) {
                    if (this.nodeToElement(4)) {
                        b = true;
                        if (this.matchElement(en)) {
                            return true;
                        }
                    } else {
                        return false;
                    }
                }
                if (!b) {
                    d = this.context[0];
                    switch (d) {
                        case -1: 
                        case 0: {
                            return false;
                        }
                        case 1: {
                            val = this.l1index;
                            break;
                        }
                        case 2: {
                            val = this.l2index;
                            break;
                        }
                        case 3: {
                            val = this.l3index;
                            break;
                        }
                        case 4: {
                            val = this.l4index;
                            break;
                        }
                        case 5: {
                            val = this.l5index;
                            break;
                        }
                    }
                    temp = this.context[d];
                }
                while (this.toElement(4)) {
                    if (!this.matchElement(en)) continue;
                    return true;
                }
                if (b) {
                    this.context[0] = this.context[0] - 1;
                    this.atTerminal = true;
                    return false;
                }
                switch (d) {
                    case 1: {
                        this.l1index = val;
                        break;
                    }
                    case 2: {
                        this.l2index = val;
                        break;
                    }
                    case 3: {
                        this.l3index = val;
                        break;
                    }
                    case 4: {
                        this.l4index = val;
                        break;
                    }
                    case 5: {
                        this.l5index = val;
                        break;
                    }
                }
                this.context[d] = temp;
                return false;
            }
            case 5: {
                if (this.atTerminal) {
                    if (this.nodeToElement(5)) {
                        b = true;
                        if (this.matchElement(en)) {
                            return true;
                        }
                    } else {
                        return false;
                    }
                }
                if (!b) {
                    d = this.context[0];
                    switch (d) {
                        case -1: 
                        case 0: {
                            return false;
                        }
                        case 1: {
                            val = this.l1index;
                            break;
                        }
                        case 2: {
                            val = this.l2index;
                            break;
                        }
                        case 3: {
                            val = this.l3index;
                            break;
                        }
                        case 4: {
                            val = this.l4index;
                            break;
                        }
                        case 5: {
                            val = this.l5index;
                            break;
                        }
                    }
                    temp = this.context[d];
                }
                while (this.toElement(5)) {
                    if (!this.matchElement(en)) continue;
                    return true;
                }
                if (b) {
                    this.context[0] = this.context[0] - 1;
                    this.atTerminal = true;
                    return false;
                }
                switch (d) {
                    case 1: {
                        this.l1index = val;
                        break;
                    }
                    case 2: {
                        this.l2index = val;
                        break;
                    }
                    case 3: {
                        this.l3index = val;
                        break;
                    }
                    case 4: {
                        this.l4index = val;
                        break;
                    }
                    case 5: {
                        this.l5index = val;
                        break;
                    }
                }
                this.context[d] = temp;
                return false;
            }
        }
        throw new NavException("illegal navigation options");
    }

    public boolean toElement(int direction) throws NavException {
        switch (direction) {
            case 0: {
                if (this.context[0] != 0) {
                    this.context[0] = 0;
                }
                this.atTerminal = false;
                this.l3index = -1;
                this.l2index = -1;
                this.l1index = -1;
                return true;
            }
            case 1: {
                if (this.atTerminal) {
                    this.atTerminal = false;
                    return true;
                }
                if (this.context[0] > 0) {
                    this.context[this.context[0]] = -1;
                    this.context[0] = this.context[0] - 1;
                    return true;
                }
                if (this.context[0] == 0) {
                    this.context[0] = -1;
                    return true;
                }
                return false;
            }
            case 2: 
            case 3: {
                if (this.atTerminal) {
                    return false;
                }
                switch (this.context[0]) {
                    case -1: {
                        this.context[0] = 0;
                        return true;
                    }
                    case 0: {
                        if (this.l1Buffer.size > 0) {
                            this.context[0] = 1;
                            this.l1index = direction == 2 ? 0 : this.l1Buffer.size - 1;
                            this.context[1] = this.l1Buffer.upper32At(this.l1index);
                            return true;
                        }
                        return false;
                    }
                    case 1: {
                        this.l2lower = this.l1Buffer.lower32At(this.l1index);
                        if (this.l2lower == -1) {
                            return false;
                        }
                        this.context[0] = 2;
                        this.l2upper = this.l2Buffer.size - 1;
                        int size = this.l1Buffer.size;
                        for (int i = this.l1index + 1; i < size; ++i) {
                            int temp = this.l1Buffer.lower32At(i);
                            if (temp == -1) continue;
                            this.l2upper = temp - 1;
                            break;
                        }
                        this.l2index = direction == 2 ? this.l2lower : this.l2upper;
                        this.context[2] = this.l2Buffer.upper32At(this.l2index);
                        return true;
                    }
                    case 2: {
                        this.l3lower = this.l2Buffer.lower32At(this.l2index);
                        if (this.l3lower == -1) {
                            return false;
                        }
                        this.context[0] = 3;
                        this.l3upper = this.l3Buffer.size - 1;
                        int size = this.l2Buffer.size;
                        for (int i = this.l2index + 1; i < size; ++i) {
                            int temp = this.l2Buffer.lower32At(i);
                            if (temp == -1) continue;
                            this.l3upper = temp - 1;
                            break;
                        }
                        this.l3index = direction == 2 ? this.l3lower : this.l3upper;
                        this.context[3] = this.l3Buffer.upper32At(this.l3index);
                        return true;
                    }
                    case 3: {
                        this.l4lower = this.l3Buffer.lower32At(this.l3index);
                        if (this.l4lower == -1) {
                            return false;
                        }
                        this.context[0] = 4;
                        this.l4upper = this.l4Buffer.size - 1;
                        int size = this.l3Buffer.size;
                        for (int i = this.l3index + 1; i < size; ++i) {
                            int temp = this.l3Buffer.lower32At(i);
                            if (temp == -1) continue;
                            this.l4upper = temp - 1;
                            break;
                        }
                        this.l4index = direction == 2 ? this.l4lower : this.l4upper;
                        this.context[4] = this.l4Buffer.upper32At(this.l4index);
                        return true;
                    }
                    case 4: {
                        this.l5lower = this.l4Buffer.lower32At(this.l4index);
                        if (this.l5lower == -1) {
                            return false;
                        }
                        this.context[0] = 5;
                        this.l5upper = this.l5Buffer.size - 1;
                        int size = this.l4Buffer.size;
                        for (int i = this.l4index + 1; i < size; ++i) {
                            int temp = this.l4Buffer.lower32At(i);
                            if (temp == -1) continue;
                            this.l5upper = temp - 1;
                            break;
                        }
                        this.l5index = direction == 2 ? this.l5lower : this.l5upper;
                        this.context[5] = this.l5Buffer.intAt(this.l5index);
                        return true;
                    }
                }
                if (direction == 2) {
                    int size = this.vtdBuffer.size;
                    for (int index = this.context[this.context[0]] + 1; index < size; ++index) {
                        long temp = this.vtdBuffer.longAt(index);
                        int token_type = (int)((0xF000000000000000L & temp) >> 60) & 0xF;
                        if (token_type != 0) continue;
                        int depth = (int)((0xFF0000000000000L & temp) >> 52);
                        if (depth <= this.context[0]) {
                            return false;
                        }
                        if (depth != this.context[0] + 1) continue;
                        this.context[0] = this.context[0] + 1;
                        this.context[this.context[0]] = index;
                        return true;
                    }
                    return false;
                }
                int last_index = -1;
                int size = this.vtdBuffer.size;
                for (int index = this.context[this.context[0]] + 1; index < size; ++index) {
                    long temp = this.vtdBuffer.longAt(index);
                    int depth = (int)((0xFF0000000000000L & temp) >> 52);
                    int token_type = (int)((0xF000000000000000L & temp) >> 60) & 0xF;
                    if (token_type != 0) continue;
                    if (depth <= this.context[0]) break;
                    if (depth != this.context[0] + 1) continue;
                    last_index = index;
                }
                if (last_index == -1) {
                    return false;
                }
                this.context[0] = this.context[0] + 1;
                this.context[this.context[0]] = last_index;
                return true;
            }
            case 4: 
            case 5: {
                if (this.atTerminal) {
                    return this.nodeToElement(direction);
                }
                switch (this.context[0]) {
                    case -1: 
                    case 0: {
                        return false;
                    }
                    case 1: {
                        if (direction == 4) {
                            if (this.l1index + 1 >= this.l1Buffer.size) {
                                return false;
                            }
                            ++this.l1index;
                        } else {
                            if (this.l1index - 1 < 0) {
                                return false;
                            }
                            --this.l1index;
                        }
                        this.context[1] = this.l1Buffer.upper32At(this.l1index);
                        return true;
                    }
                    case 2: {
                        if (direction == 4) {
                            if (this.l2index + 1 > this.l2upper) {
                                return false;
                            }
                            ++this.l2index;
                        } else {
                            if (this.l2index - 1 < this.l2lower) {
                                return false;
                            }
                            --this.l2index;
                        }
                        this.context[2] = this.l2Buffer.upper32At(this.l2index);
                        return true;
                    }
                    case 3: {
                        if (direction == 4) {
                            if (this.l3index + 1 > this.l3upper) {
                                return false;
                            }
                            ++this.l3index;
                        } else {
                            if (this.l3index - 1 < this.l3lower) {
                                return false;
                            }
                            --this.l3index;
                        }
                        this.context[3] = this.l3Buffer.upper32At(this.l3index);
                        return true;
                    }
                    case 4: {
                        if (direction == 4) {
                            if (this.l4index + 1 > this.l4upper) {
                                return false;
                            }
                            ++this.l4index;
                        } else {
                            if (this.l4index - 1 < this.l4lower) {
                                return false;
                            }
                            --this.l4index;
                        }
                        this.context[4] = this.l4Buffer.upper32At(this.l4index);
                        return true;
                    }
                    case 5: {
                        if (direction == 4) {
                            if (this.l5index + 1 > this.l5upper) {
                                return false;
                            }
                            ++this.l5index;
                        } else {
                            if (this.l5index - 1 < this.l5lower) {
                                return false;
                            }
                            --this.l5index;
                        }
                        this.context[5] = this.l5Buffer.intAt(this.l5index);
                        return true;
                    }
                }
                if (direction == 4) {
                    int size = this.vtdBuffer.size;
                    for (int index = this.context[this.context[0]] + 1; index < size; ++index) {
                        long temp = this.vtdBuffer.longAt(index);
                        int token_type = (int)((0xF000000000000000L & temp) >> 60) & 0xF;
                        if (token_type != 0) continue;
                        int depth = (int)((0xFF0000000000000L & temp) >> 52);
                        if (depth < this.context[0]) {
                            return false;
                        }
                        if (depth != this.context[0]) continue;
                        this.context[this.context[0]] = index;
                        return true;
                    }
                    return false;
                }
                for (int index = this.context[this.context[0]] - 1; index > this.context[this.context[0] - 1]; --index) {
                    int depth;
                    long temp = this.vtdBuffer.longAt(index);
                    int token_type = (int)((0xF000000000000000L & temp) >> 60) & 0xF;
                    if (token_type != 0 || (depth = (int)((0xFF0000000000000L & temp) >> 52)) != this.context[0]) continue;
                    this.context[this.context[0]] = index;
                    return true;
                }
                return false;
            }
        }
        throw new NavException("illegal navigation options");
    }

    protected boolean nodeToElement(int direction) {
        switch (direction) {
            case 4: {
                switch (this.context[0]) {
                    case 0: {
                        if (this.l1index != -1) {
                            this.context[0] = 1;
                            this.context[1] = this.l1Buffer.upper32At(this.l1index);
                            this.atTerminal = false;
                            return true;
                        }
                        return false;
                    }
                    case 1: {
                        if (this.l2index != -1) {
                            this.context[0] = 2;
                            this.context[2] = this.l2Buffer.upper32At(this.l2index);
                            this.atTerminal = false;
                            return true;
                        }
                        return false;
                    }
                    case 2: {
                        if (this.l3index != -1) {
                            this.context[0] = 3;
                            this.context[3] = this.l3Buffer.upper32At(this.l3index);
                            this.atTerminal = false;
                            return true;
                        }
                        return false;
                    }
                    case 3: {
                        if (this.l4index != -1) {
                            this.context[0] = 4;
                            this.context[4] = this.l4Buffer.upper32At(this.l4index);
                            this.atTerminal = false;
                            return true;
                        }
                        return false;
                    }
                    case 4: {
                        if (this.l5index != -1) {
                            this.context[0] = 5;
                            this.context[5] = this.l5Buffer.intAt(this.l5index);
                            this.atTerminal = false;
                            return true;
                        }
                        return false;
                    }
                }
                int size = this.vtdBuffer.size;
                for (int index = this.LN + 1; index < size; ++index) {
                    long temp = this.vtdBuffer.longAt(index);
                    int token_type = (int)((0xF000000000000000L & temp) >> 60) & 0xF;
                    if (token_type != 0) continue;
                    int depth = (int)((0xFF0000000000000L & temp) >> 52);
                    if (depth < this.context[0]) {
                        return false;
                    }
                    if (depth != this.context[0]) continue;
                    this.context[this.context[0]] = index;
                    return true;
                }
                return false;
            }
            case 5: {
                switch (this.context[0]) {
                    case 0: {
                        if (this.l1index != -1 && this.l1index > 0) {
                            --this.l1index;
                            this.context[0] = 1;
                            this.context[1] = this.l1Buffer.upper32At(this.l1index);
                            this.atTerminal = false;
                            return true;
                        }
                        return false;
                    }
                    case 1: {
                        if (this.l2index != -1 && this.l2index > this.l2lower) {
                            --this.l2index;
                            this.context[0] = 2;
                            this.context[2] = this.l2Buffer.upper32At(this.l2index);
                            this.atTerminal = false;
                            return true;
                        }
                        return false;
                    }
                    case 2: {
                        if (this.l3index != -1 && this.l3index > this.l3lower) {
                            --this.l3index;
                            this.context[0] = 3;
                            this.context[3] = this.l3Buffer.upper32At(this.l3index);
                            this.atTerminal = false;
                            return true;
                        }
                        return false;
                    }
                    case 3: {
                        if (this.l4index != -1 && this.l4index > this.l4lower) {
                            --this.l4index;
                            this.context[0] = 4;
                            this.context[4] = this.l4Buffer.upper32At(this.l4index);
                            this.atTerminal = false;
                            return true;
                        }
                        return false;
                    }
                    case 4: {
                        if (this.l5index != -1 && this.l5index > this.l5lower) {
                            --this.l5index;
                            this.context[0] = 5;
                            this.context[5] = this.l5Buffer.intAt(this.l5index);
                            this.atTerminal = false;
                            return true;
                        }
                        return false;
                    }
                }
                for (int index = this.LN - 1; index > this.context[this.context[0] - 1]; --index) {
                    int depth;
                    long temp = this.vtdBuffer.longAt(index);
                    int token_type = (int)((0xF000000000000000L & temp) >> 60) & 0xF;
                    if (token_type != 0 || (depth = (int)((0xFF0000000000000L & temp) >> 52)) != this.context[0]) continue;
                    this.context[this.context[0]] = index;
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    public boolean toElementNS(int direction, String URL2, String ln) throws NavException {
        int temp = -1;
        int val = 0;
        int d = -1;
        boolean b = false;
        if (!this.ns) {
            return false;
        }
        switch (direction) {
            case 0: {
                return this.toElement(0);
            }
            case 1: {
                return this.toElement(1);
            }
            case 2: {
                if (this.atTerminal) {
                    return false;
                }
                if (!this.toElement(2)) {
                    return false;
                }
                if (!this.matchElementNS(URL2, ln)) {
                    if (this.toElementNS(4, URL2, ln)) {
                        return true;
                    }
                    this.context[0] = this.context[0] - 1;
                    return false;
                }
                return true;
            }
            case 3: {
                if (this.atTerminal) {
                    return false;
                }
                if (!this.toElement(3)) {
                    return false;
                }
                if (!this.matchElementNS(URL2, ln)) {
                    if (this.toElementNS(5, URL2, ln)) {
                        return true;
                    }
                    this.context[0] = this.context[0] - 1;
                    return false;
                }
                return true;
            }
            case 4: {
                if (this.atTerminal) {
                    if (this.nodeToElement(4)) {
                        b = true;
                        if (this.matchElementNS(URL2, ln)) {
                            return true;
                        }
                    } else {
                        return false;
                    }
                }
                if (!b) {
                    d = this.context[0];
                    temp = this.context[d];
                    switch (d) {
                        case -1: 
                        case 0: {
                            return false;
                        }
                        case 1: {
                            val = this.l1index;
                            break;
                        }
                        case 2: {
                            val = this.l2index;
                            break;
                        }
                        case 3: {
                            val = this.l3index;
                            break;
                        }
                        case 4: {
                            val = this.l4index;
                            break;
                        }
                        case 5: {
                            val = this.l5index;
                            break;
                        }
                    }
                }
                while (this.toElement(4)) {
                    if (!this.matchElementNS(URL2, ln)) continue;
                    return true;
                }
                if (b) {
                    this.context[0] = this.context[0] - 1;
                    this.atTerminal = true;
                    return false;
                }
                switch (d) {
                    case 1: {
                        this.l1index = val;
                        break;
                    }
                    case 2: {
                        this.l2index = val;
                        break;
                    }
                    case 3: {
                        this.l3index = val;
                        break;
                    }
                    case 4: {
                        val = this.l4index;
                        break;
                    }
                    case 5: {
                        val = this.l5index;
                        break;
                    }
                }
                this.context[d] = temp;
                return false;
            }
            case 5: {
                if (this.atTerminal) {
                    if (this.nodeToElement(5)) {
                        b = true;
                        if (this.matchElementNS(URL2, ln)) {
                            return true;
                        }
                    } else {
                        return false;
                    }
                }
                if (!b) {
                    d = this.context[0];
                    temp = this.context[d];
                    switch (d) {
                        case -1: 
                        case 0: {
                            return false;
                        }
                        case 1: {
                            val = this.l1index;
                            break;
                        }
                        case 2: {
                            val = this.l2index;
                            break;
                        }
                        case 3: {
                            val = this.l3index;
                            break;
                        }
                        case 4: {
                            val = this.l4index;
                            break;
                        }
                        case 5: {
                            val = this.l5index;
                            break;
                        }
                    }
                }
                while (this.toElement(5)) {
                    if (!this.matchElementNS(URL2, ln)) continue;
                    return true;
                }
                if (b) {
                    this.context[0] = this.context[0] - 1;
                    this.atTerminal = true;
                    return false;
                }
                switch (d) {
                    case 1: {
                        this.l1index = val;
                        break;
                    }
                    case 2: {
                        this.l2index = val;
                        break;
                    }
                    case 3: {
                        this.l3index = val;
                        break;
                    }
                    case 4: {
                        val = this.l4index;
                        break;
                    }
                    case 5: {
                        val = this.l5index;
                        break;
                    }
                }
                this.context[d] = temp;
                return false;
            }
        }
        throw new NavException("illegal navigation options");
    }

    public void recoverNode(int index) throws NavException {
        int t;
        if (index < 0 || index >= this.vtdSize) {
            throw new NavException("Invalid VTD index");
        }
        int type = this.getTokenType(index);
        if (type == 8 || type == 9 || type == 10 || type == 4) {
            throw new NavException("Token type not yet supported");
        }
        int d = this.getTokenDepth(index);
        switch (d) {
            case -1: {
                this.context[0] = -1;
                if (index != 0) {
                    this.LN = index;
                    this.atTerminal = true;
                }
                return;
            }
            case 0: {
                this.context[0] = 0;
                if (index != this.rootIndex) {
                    this.LN = index;
                    this.atTerminal = true;
                    if (type > 3) {
                        this.sync(0, index);
                    }
                } else {
                    this.atTerminal = false;
                }
                return;
            }
        }
        this.context[0] = d;
        if (type != 0) {
            this.LN = index;
            this.atTerminal = true;
        }
        this.recoverNode_l1(index);
        if (d == 1) {
            if (this.atTerminal && type > 3) {
                this.sync(1, index);
            }
            return;
        }
        this.recoverNode_l2(index);
        if (d == 2) {
            if (this.atTerminal && type > 3) {
                this.sync(2, index);
            }
            return;
        }
        this.recoverNode_l3(index);
        if (d == 3) {
            if (this.atTerminal && type > 3) {
                this.sync(3, index);
            }
            return;
        }
        this.recoverNode_l4(index);
        if (d == 4) {
            if (this.atTerminal && type > 3) {
                this.sync(4, index);
            }
            return;
        }
        this.recoverNode_l5(index);
        if (d == 5) {
            if (this.atTerminal && type > 3) {
                this.sync(5, index);
            }
            return;
        }
        if (type == 0) {
            this.context[d] = index;
        } else {
            t = index - 1;
            while (this.getTokenType(t) != 0 || this.getTokenDepth(t) != d) {
                --t;
            }
            this.context[d] = t;
        }
        t = this.context[d] - 1;
        --d;
        while (d > 5) {
            while (this.getTokenType(t) != 0 || this.getTokenDepth(t) != d) {
                --t;
            }
            this.context[d] = t;
            --d;
        }
    }

    public void writeIndex(OutputStream os) throws IndexWriteException, IOException {
        IndexHandler.writeIndex_L5((byte)1, this.encoding, this.ns, true, this.nestingLevel - 1, 5, this.rootIndex, this.XMLDoc.getBytes(), this.docOffset, this.docLen, this.vtdBuffer, this.l1Buffer, this.l2Buffer, this.l3Buffer, this.l4Buffer, this.l5Buffer, os);
    }

    public void writeSeparateIndex(OutputStream os) throws IndexWriteException, IOException {
        IndexHandler.writeSeparateIndex_L5((byte)2, this.encoding, this.ns, true, this.nestingLevel - 1, 5, this.rootIndex, this.docOffset, this.docLen, this.vtdBuffer, this.l1Buffer, this.l2Buffer, this.l3Buffer, this.l4Buffer, this.l5Buffer, os);
    }

    protected boolean toNode(int dir) throws NavException {
        switch (dir) {
            case 0: {
                if (this.context[0] != 0) {
                    this.context[0] = 0;
                }
                this.atTerminal = false;
                return true;
            }
            case 1: {
                if (this.atTerminal) {
                    this.atTerminal = false;
                    return true;
                }
                if (this.context[0] > 0) {
                    this.context[this.context[0]] = -1;
                    this.context[0] = this.context[0] - 1;
                    return true;
                }
                if (this.context[0] == 0) {
                    this.context[0] = -1;
                    return true;
                }
                return false;
            }
            case 2: {
                if (this.atTerminal) {
                    return false;
                }
                switch (this.context[0]) {
                    case -1: {
                        int index = this.rootIndex - 1;
                        block92: while (index > 0) {
                            int tokenType = this.getTokenType(index);
                            switch (tokenType) {
                                case 6: {
                                    --index;
                                    continue block92;
                                }
                                case 8: {
                                    index -= 2;
                                    continue block92;
                                }
                            }
                        }
                        if (++index != this.rootIndex) {
                            this.atTerminal = true;
                            this.LN = index;
                        } else {
                            this.context[0] = 0;
                        }
                        return true;
                    }
                    case 0: {
                        if (this.l1Buffer.size != 0) {
                            int index = this.l1Buffer.upper32At(0) - 1;
                            block93: while (index > this.rootIndex) {
                                int tokenType = this.getTokenType(index);
                                switch (tokenType) {
                                    case 5: 
                                    case 6: 
                                    case 11: {
                                        --index;
                                        continue block93;
                                    }
                                    case 8: {
                                        index -= 2;
                                        continue block93;
                                    }
                                }
                            }
                            this.l1index = 0;
                            if (++index == this.l1Buffer.upper32At(0)) {
                                this.context[0] = 1;
                                this.context[1] = this.l1Buffer.upper32At(0);
                                this.atTerminal = false;
                            } else {
                                this.atTerminal = true;
                                this.LN = index;
                            }
                            return true;
                        }
                        block94: for (int index = this.rootIndex + 1; index < this.vtdSize; index += 2) {
                            int tokenType = this.getTokenType(index);
                            switch (tokenType) {
                                case 2: 
                                case 3: {
                                    continue block94;
                                }
                            }
                            if (this.getTokenDepth(index) == 0) {
                                this.atTerminal = true;
                                this.LN = index;
                                return true;
                            }
                            return false;
                        }
                        return false;
                    }
                    case 1: {
                        if (this.l1Buffer.lower32At(this.l1index) != -1) {
                            int index;
                            int tmp;
                            this.l2lower = this.l1Buffer.lower32At(this.l1index);
                            for (tmp = this.l1index + 1; tmp < this.l1Buffer.size; ++tmp) {
                                if (this.l1Buffer.lower32At(tmp) == -1) continue;
                                this.l2upper = this.l1Buffer.lower32At(tmp) - 1;
                                break;
                            }
                            if (tmp == this.l1Buffer.size) {
                                this.l2upper = this.l2Buffer.size - 1;
                            }
                            tmp = this.l2Buffer.upper32At(this.l2lower);
                            block96: for (index = this.context[1] + 1; index < tmp; index += 2) {
                                int tokenType = this.getTokenType(index);
                                switch (tokenType) {
                                    case 2: 
                                    case 3: {
                                        continue block96;
                                    }
                                }
                                this.l2index = this.l2lower;
                                this.atTerminal = true;
                                this.LN = index;
                                return true;
                            }
                            this.l2index = this.l2lower;
                            this.context[0] = 2;
                            this.context[2] = index;
                            return true;
                        }
                        block97: for (int index = this.context[1] + 1; index < this.vtdSize; index += 2) {
                            int tokenType = this.getTokenType(index);
                            switch (tokenType) {
                                case 2: 
                                case 3: {
                                    continue block97;
                                }
                            }
                            if (this.getTokenDepth(index) == 1 && this.getTokenType(index) != 0) {
                                this.atTerminal = true;
                                this.LN = index;
                                return true;
                            }
                            return false;
                        }
                        return false;
                    }
                    case 2: {
                        if (this.l2Buffer.lower32At(this.l2index) != -1) {
                            int index;
                            int tmp;
                            this.l3lower = this.l2Buffer.lower32At(this.l2index);
                            for (tmp = this.l2index + 1; tmp < this.l2Buffer.size; ++tmp) {
                                if (this.l2Buffer.lower32At(tmp) == -1) continue;
                                this.l3upper = this.l2Buffer.lower32At(tmp) - 1;
                                break;
                            }
                            if (tmp == this.l2Buffer.size) {
                                this.l3upper = this.l3Buffer.size - 1;
                            }
                            tmp = this.l3Buffer.upper32At(this.l3lower);
                            block99: for (index = this.context[2] + 1; index < tmp; index += 2) {
                                int tokenType = this.getTokenType(index);
                                switch (tokenType) {
                                    case 2: 
                                    case 3: {
                                        continue block99;
                                    }
                                }
                                this.l3index = this.l3lower;
                                this.atTerminal = true;
                                this.LN = index;
                                return true;
                            }
                            this.l3index = this.l3lower;
                            this.context[0] = 3;
                            this.context[3] = index;
                            return true;
                        }
                        block100: for (int index = this.context[2] + 1; index < this.vtdSize; index += 2) {
                            int tokenType = this.getTokenType(index);
                            switch (tokenType) {
                                case 2: 
                                case 3: {
                                    continue block100;
                                }
                            }
                            if (this.getTokenDepth(index) == 2 && this.getTokenType(index) != 0) {
                                this.atTerminal = true;
                                this.LN = index;
                                return true;
                            }
                            return false;
                        }
                        return false;
                    }
                    case 3: {
                        if (this.l3Buffer.lower32At(this.l3index) != -1) {
                            int index;
                            int tmp;
                            this.l4lower = this.l3Buffer.lower32At(this.l3index);
                            for (tmp = this.l3index + 1; tmp < this.l3Buffer.size; ++tmp) {
                                if (this.l3Buffer.lower32At(tmp) == -1) continue;
                                this.l4upper = this.l3Buffer.lower32At(tmp) - 1;
                                break;
                            }
                            if (tmp == this.l3Buffer.size) {
                                this.l4upper = this.l4Buffer.size - 1;
                            }
                            tmp = this.l4Buffer.upper32At(this.l4lower);
                            block102: for (index = this.context[3] + 1; index < tmp; index += 2) {
                                int tokenType = this.getTokenType(index);
                                switch (tokenType) {
                                    case 2: 
                                    case 3: {
                                        continue block102;
                                    }
                                }
                                this.l4index = this.l4lower;
                                this.atTerminal = true;
                                this.LN = index;
                                return true;
                            }
                            this.l4index = this.l4lower;
                            this.context[0] = 4;
                            this.context[4] = index;
                            return true;
                        }
                        block103: for (int index = this.context[3] + 1; index < this.vtdSize; index += 2) {
                            int tokenType = this.getTokenType(index);
                            switch (tokenType) {
                                case 2: 
                                case 3: {
                                    continue block103;
                                }
                            }
                            if (this.getTokenDepth(index) == 3 && this.getTokenType(index) != 0) {
                                this.atTerminal = true;
                                this.LN = index;
                                return true;
                            }
                            return false;
                        }
                        return false;
                    }
                    case 4: {
                        if (this.l4Buffer.lower32At(this.l4index) != -1) {
                            int index;
                            int tmp;
                            this.l5lower = this.l4Buffer.lower32At(this.l4index);
                            for (tmp = this.l4index + 1; tmp < this.l4Buffer.size; ++tmp) {
                                if (this.l4Buffer.lower32At(tmp) == -1) continue;
                                this.l5upper = this.l4Buffer.lower32At(tmp) - 1;
                                break;
                            }
                            if (tmp == this.l4Buffer.size) {
                                this.l5upper = this.l5Buffer.size - 1;
                            }
                            tmp = this.l5Buffer.intAt(this.l5lower);
                            block105: for (index = this.context[4] + 1; index < tmp; index += 2) {
                                int tokenType = this.getTokenType(index);
                                switch (tokenType) {
                                    case 2: 
                                    case 3: {
                                        continue block105;
                                    }
                                }
                                this.l5index = this.l5lower;
                                this.atTerminal = true;
                                this.LN = index;
                                return true;
                            }
                            this.l5index = this.l5lower;
                            this.context[0] = 5;
                            this.context[5] = index;
                            return true;
                        }
                        block106: for (int index2 = this.context[4] + 1; index2 < this.vtdSize; index2 += 2) {
                            int tokenType = this.getTokenType(index2);
                            switch (tokenType) {
                                case 2: 
                                case 3: {
                                    continue block106;
                                }
                            }
                            if (this.getTokenDepth(index2) == 4 && this.getTokenType(index2) != 0) {
                                this.atTerminal = true;
                                this.LN = index2;
                                return true;
                            }
                            return false;
                        }
                        return false;
                    }
                }
                int index2 = this.context[this.context[0]] + 1;
                while (index2 < this.vtdBuffer.size) {
                    long temp = this.vtdBuffer.longAt(index2);
                    int tokenType = (int)((0xF000000000000000L & temp) >>> 60);
                    switch (tokenType) {
                        case 0: {
                            int depth = (int)((0xFF0000000000000L & temp) >> 52);
                            if (depth <= this.context[0]) {
                                return false;
                            }
                            if (depth == this.context[0] + 1) {
                                this.context[0] = this.context[0] + 1;
                                this.context[this.context[0]] = index2;
                                return true;
                            }
                            throw new NavException("impossible condition");
                        }
                        case 2: 
                        case 3: {
                            index2 += 2;
                            break;
                        }
                        case 5: 
                        case 6: 
                        case 11: {
                            int depth = (int)((0xFF0000000000000L & temp) >> 52);
                            if (depth < this.context[0]) {
                                return false;
                            }
                            if (depth == this.context[0]) {
                                this.LN = index2;
                                this.atTerminal = true;
                                return true;
                            }
                            ++index2;
                        }
                        case 7: {
                            int depth = (int)((0xFF0000000000000L & temp) >> 52);
                            if (depth < this.context[0]) {
                                return false;
                            }
                            if (depth == this.context[0]) {
                                this.LN = index2;
                                this.atTerminal = true;
                                return true;
                            }
                            index2 += 2;
                        }
                    }
                }
                return false;
            }
            case 3: {
                if (this.atTerminal) {
                    return false;
                }
                return this.toNode_LastChild();
            }
            case 4: {
                int tmp;
                int index;
                int tokenType;
                switch (this.context[0]) {
                    case -1: {
                        if (this.atTerminal) {
                            int index2 = this.LN;
                            int tokenType2 = this.getTokenType(index2);
                            switch (tokenType2) {
                                case 7: {
                                    index2 += 2;
                                    break;
                                }
                                case 6: {
                                    ++index2;
                                }
                            }
                            if (index2 < this.vtdSize) {
                                tokenType2 = this.getTokenType(index2);
                                int depth = this.getTokenDepth(index2);
                                if (depth == -1) {
                                    this.LN = index2;
                                    return true;
                                }
                                this.atTerminal = false;
                                this.context[0] = 0;
                                return true;
                            }
                            return false;
                        }
                        return false;
                    }
                    case 0: {
                        int index3;
                        if (this.atTerminal) {
                            int index4 = this.LN;
                            int tokenType3 = this.getTokenType(this.LN);
                            if (tokenType3 == 2) {
                                return false;
                            }
                            if (this.l1Buffer.size != 0) {
                                if (index4 < this.l1Buffer.upper32At(this.l1index)) {
                                    ++index4;
                                    if (tokenType3 == 7) {
                                        ++index4;
                                    }
                                    if (index4 <= this.l1Buffer.upper32At(this.l1index)) {
                                        if (index4 == this.l1Buffer.upper32At(this.l1index)) {
                                            this.atTerminal = false;
                                            this.context[0] = 1;
                                            this.context[1] = index4;
                                            return true;
                                        }
                                        int depth = this.getTokenDepth(index4);
                                        if (depth != 0) {
                                            return false;
                                        }
                                        this.LN = index4;
                                        this.atTerminal = true;
                                        return true;
                                    }
                                    return false;
                                }
                                if (this.l1index < this.l1Buffer.size - 1) {
                                    ++this.l1index;
                                    if (tokenType3 == 7) {
                                        ++index4;
                                    }
                                    if (index4 <= this.l1Buffer.upper32At(this.l1index)) {
                                        if (index4 == this.l1Buffer.upper32At(this.l1index)) {
                                            this.atTerminal = false;
                                            this.context[0] = 1;
                                            this.context[1] = index4;
                                            return true;
                                        }
                                        int depth = this.getTokenDepth(index4);
                                        if (depth != 0) {
                                            return false;
                                        }
                                        this.LN = index4;
                                        this.atTerminal = true;
                                        return true;
                                    }
                                    return false;
                                }
                                ++index4;
                                if (tokenType3 == 7) {
                                    ++index4;
                                }
                                if (index4 < this.vtdSize) {
                                    int depth = this.getTokenDepth(index4);
                                    if (depth != 0) {
                                        return false;
                                    }
                                    this.LN = index4;
                                    this.atTerminal = true;
                                    return true;
                                }
                                return false;
                            }
                            ++index4;
                            if (tokenType3 == 7) {
                                ++index4;
                            }
                            if (index4 < this.vtdSize) {
                                int depth = this.getTokenDepth(index4);
                                if (depth != 0) {
                                    return false;
                                }
                                this.LN = index4;
                                this.atTerminal = true;
                                return true;
                            }
                            return false;
                        }
                        int depth = -2;
                        for (index3 = this.vtdSize - 1; index3 > this.rootIndex && (depth = this.getTokenDepth(index3)) == -1; --index3) {
                        }
                        if (++index3 >= this.vtdSize) {
                            return false;
                        }
                        this.context[0] = -1;
                        this.LN = index3;
                        this.atTerminal = true;
                        return true;
                    }
                    case 1: {
                        int index5;
                        if (this.atTerminal) {
                            int tokenType4 = this.getTokenType(this.LN);
                            if (tokenType4 == 2) {
                                return false;
                            }
                            if (this.l1Buffer.lower32At(this.l1index) != -1) {
                                if (this.LN < this.l2Buffer.upper32At(this.l2upper)) {
                                    int tmp2 = this.l2Buffer.upper32At(this.l2index);
                                    int index3 = this.LN + 1;
                                    if (tokenType4 == 7) {
                                        ++index3;
                                    }
                                    if (index3 < tmp2) {
                                        this.LN = index3;
                                        return true;
                                    }
                                    this.context[0] = 2;
                                    this.context[2] = tmp2;
                                    this.atTerminal = false;
                                    return true;
                                }
                                int index6 = this.LN + 1;
                                if (tokenType4 == 7) {
                                    ++index6;
                                }
                                if (index6 < this.vtdSize) {
                                    int depth = this.getTokenDepth(index6);
                                    if (depth == 1 && this.getTokenType(index6) != 0) {
                                        this.LN = index6;
                                        this.atTerminal = true;
                                        return true;
                                    }
                                    return false;
                                }
                                return false;
                            }
                            int index7 = this.LN + 1;
                            if (this.getTokenType(this.LN) == 7) {
                                ++index7;
                            }
                            if (index7 < this.vtdSize) {
                                int depth = this.getTokenDepth(index7);
                                if (depth == 1 && this.getTokenType(index7) != 0) {
                                    this.LN = index7;
                                    this.atTerminal = true;
                                    return true;
                                }
                                return false;
                            }
                            return false;
                        }
                        if (this.l1index != this.l1Buffer.size - 1) {
                            int lastEntry;
                            ++this.l1index;
                            int index8 = lastEntry = this.l1Buffer.upper32At(this.l1index) - 1;
                            while (this.getTokenDepth(index8) == 0) {
                                --index8;
                            }
                            if (lastEntry == index8) {
                                this.atTerminal = false;
                                this.context[0] = 1;
                                this.context[1] = index8 + 1;
                                return true;
                            }
                            this.atTerminal = true;
                            this.context[0] = 0;
                            this.LN = index8 + 1;
                            return true;
                        }
                        for (index5 = this.vtdSize - 1; index5 > this.l1Buffer.upper32At(this.l1index) && this.getTokenDepth(index5) <= 0; --index5) {
                        }
                        if (index5 == this.vtdSize - 1) {
                            if (this.getTokenDepth(index5) == 0) {
                                this.context[0] = 0;
                                this.LN = index5;
                                this.atTerminal = true;
                                return true;
                            }
                            return false;
                        }
                        if (this.getTokenDepth(++index5) == 0) {
                            this.context[0] = 0;
                            this.LN = index5;
                            this.atTerminal = true;
                            return true;
                        }
                        return false;
                    }
                    case 2: {
                        int index9;
                        if (this.atTerminal) {
                            int tokenType5 = this.getTokenType(this.LN);
                            if (tokenType5 == 2) {
                                return false;
                            }
                            if (this.l2Buffer.lower32At(this.l2index) != -1) {
                                if (this.LN < this.l3Buffer.upper32At(this.l3upper)) {
                                    int tmp3 = this.l3Buffer.upper32At(this.l3index);
                                    int index5 = this.LN + 1;
                                    if (tokenType5 == 7) {
                                        ++index5;
                                    }
                                    if (index5 < tmp3) {
                                        this.LN = index5;
                                        return true;
                                    }
                                    this.context[0] = 3;
                                    this.context[3] = tmp3;
                                    this.atTerminal = false;
                                    return true;
                                }
                                int index10 = this.LN + 1;
                                if (tokenType5 == 7) {
                                    ++index10;
                                }
                                if (index10 < this.vtdSize) {
                                    int depth = this.getTokenDepth(index10);
                                    if (depth == 2 && this.getTokenType(index10) != 0) {
                                        this.LN = index10;
                                        return true;
                                    }
                                    return false;
                                }
                                return false;
                            }
                            int index11 = this.LN + 1;
                            if (tokenType5 == 7) {
                                ++index11;
                            }
                            if (index11 < this.vtdSize) {
                                int depth = this.getTokenDepth(index11);
                                if (depth == 2 && this.getTokenType(index11) != 0) {
                                    this.LN = index11;
                                    this.atTerminal = true;
                                    return true;
                                }
                                return false;
                            }
                            return false;
                        }
                        if (this.l2index < this.l2upper) {
                            int index12;
                            int tmp4 = this.l2Buffer.upper32At(this.l2index);
                            ++this.l2index;
                            int lastEntry = index12 = this.l2Buffer.upper32At(this.l2index) - 1;
                            block111: while (index12 > tmp4 && this.getTokenDepth(index12) == 1) {
                                int tokenType6 = this.getTokenType(index12);
                                switch (tokenType6) {
                                    case 5: 
                                    case 6: 
                                    case 11: {
                                        --index12;
                                        continue block111;
                                    }
                                    case 8: {
                                        index12 -= 2;
                                        continue block111;
                                    }
                                }
                            }
                            if (index12 == lastEntry) {
                                this.context[0] = 2;
                                this.context[2] = index12 + 1;
                                return true;
                            }
                            this.context[0] = 1;
                            this.LN = index12 + 1;
                            this.atTerminal = true;
                            return true;
                        }
                        int lastEntry = index9 = this.vtdSize - 1;
                        if (this.l1index != this.l1Buffer.size - 1) {
                            lastEntry = index9 = this.l1Buffer.upper32At(this.l1index + 1) - 1;
                        }
                        int tmp5 = this.l2Buffer.upper32At(this.l2index);
                        while (index9 > tmp5 && this.getTokenDepth(index9) < 2) {
                            --index9;
                        }
                        if (this.getTokenDepth(index9) == 1) {
                            this.LN = index9;
                            this.atTerminal = true;
                            this.context[0] = 1;
                            return true;
                        }
                        if (lastEntry != index9 && this.getTokenDepth(index9 + 1) == 1) {
                            this.LN = index9 + 1;
                            this.atTerminal = true;
                            this.context[0] = 1;
                            return true;
                        }
                        return false;
                    }
                    case 3: {
                        int index13;
                        if (this.atTerminal) {
                            int tokenType7 = this.getTokenType(this.LN);
                            if (tokenType7 == 2) {
                                return false;
                            }
                            if (this.l3Buffer.lower32At(this.l3index) != -1) {
                                if (this.LN < this.l4Buffer.upper32At(this.l4upper)) {
                                    int tmp5 = this.l4Buffer.upper32At(this.l4index);
                                    int index9 = this.LN + 1;
                                    if (tokenType7 == 7) {
                                        ++index9;
                                    }
                                    if (index9 < tmp5) {
                                        this.LN = index9;
                                        return true;
                                    }
                                    this.context[0] = 4;
                                    this.context[4] = tmp5;
                                    this.atTerminal = false;
                                    return true;
                                }
                                int index14 = this.LN + 1;
                                if (tokenType7 == 7) {
                                    ++index14;
                                }
                                if (index14 < this.vtdSize) {
                                    int depth = this.getTokenDepth(index14);
                                    if (depth == 3 && this.getTokenType(index14) != 0) {
                                        this.LN = index14;
                                        return true;
                                    }
                                    return false;
                                }
                                return false;
                            }
                            int index15 = this.LN + 1;
                            if (tokenType7 == 7) {
                                ++index15;
                            }
                            if (index15 < this.vtdSize) {
                                int depth = this.getTokenDepth(index15);
                                if (depth == 3 && this.getTokenType(index15) != 0) {
                                    this.LN = index15;
                                    this.atTerminal = true;
                                    return true;
                                }
                                return false;
                            }
                            return false;
                        }
                        if (this.l3index < this.l3upper) {
                            int index16;
                            int tmp6 = this.l3Buffer.upper32At(this.l3index);
                            ++this.l3index;
                            int lastEntry = index16 = this.l3Buffer.upper32At(this.l3index) - 1;
                            block113: while (index16 > tmp6 && this.getTokenDepth(index16) == 2) {
                                int tokenType8 = this.getTokenType(index16);
                                switch (tokenType8) {
                                    case 5: 
                                    case 6: 
                                    case 11: {
                                        --index16;
                                        continue block113;
                                    }
                                    case 8: {
                                        index16 -= 2;
                                        continue block113;
                                    }
                                }
                            }
                            if (index16 == lastEntry) {
                                this.context[0] = 3;
                                this.context[3] = index16 + 1;
                                return true;
                            }
                            this.context[0] = 2;
                            this.LN = index16 + 1;
                            this.atTerminal = true;
                            return true;
                        }
                        int lastEntry = index13 = this.vtdSize - 1;
                        if (this.l1index != this.l1Buffer.size - 1) {
                            lastEntry = index13 = this.l1Buffer.upper32At(this.l1index + 1) - 1;
                        }
                        if (this.l2index != this.l2Buffer.size - 1 && this.l2index != this.l2upper) {
                            lastEntry = index13 = this.l2Buffer.upper32At(this.l2index + 1) - 1;
                        }
                        int tmp7 = this.l3Buffer.upper32At(this.l3index);
                        while (index13 > tmp7 && this.getTokenDepth(index13) < 3) {
                            --index13;
                        }
                        if (this.getTokenDepth(index13) == 2) {
                            this.LN = index13;
                            this.atTerminal = true;
                            this.context[0] = 2;
                            return true;
                        }
                        if (lastEntry != index13 && this.getTokenDepth(index13 + 1) == 2) {
                            this.LN = index13 + 1;
                            this.atTerminal = true;
                            this.context[0] = 2;
                            return true;
                        }
                        return false;
                    }
                    case 4: {
                        int index17;
                        if (this.atTerminal) {
                            int tokenType9 = this.getTokenType(this.LN);
                            if (tokenType9 == 2) {
                                return false;
                            }
                            if (this.l4Buffer.lower32At(this.l4index) != -1) {
                                if (this.LN < this.l5Buffer.intAt(this.l5upper)) {
                                    int tmp7 = this.l5Buffer.intAt(this.l5index);
                                    int index13 = this.LN + 1;
                                    if (tokenType9 == 7) {
                                        ++index13;
                                    }
                                    if (index13 < tmp7) {
                                        this.LN = index13;
                                        return true;
                                    }
                                    this.context[0] = 5;
                                    this.context[5] = tmp7;
                                    this.atTerminal = false;
                                    return true;
                                }
                                int index18 = this.LN + 1;
                                if (tokenType9 == 7) {
                                    ++index18;
                                }
                                if (index18 < this.vtdSize) {
                                    int depth = this.getTokenDepth(index18);
                                    if (depth == 4 && this.getTokenType(index18) != 0) {
                                        this.LN = index18;
                                        return true;
                                    }
                                    return false;
                                }
                                return false;
                            }
                            int index19 = this.LN + 1;
                            if (tokenType9 == 7) {
                                ++index19;
                            }
                            if (index19 < this.vtdSize) {
                                int depth = this.getTokenDepth(index19);
                                if (depth == 4 && this.getTokenType(index19) != 0) {
                                    this.LN = index19;
                                    this.atTerminal = true;
                                    return true;
                                }
                                return false;
                            }
                            return false;
                        }
                        if (this.l4index < this.l4upper) {
                            int index20;
                            int tmp8 = this.l4Buffer.upper32At(this.l4index);
                            ++this.l4index;
                            int lastEntry = index20 = this.l4Buffer.upper32At(this.l4index) - 1;
                            block115: while (index20 > tmp8 && this.getTokenDepth(index20) == 3) {
                                int tokenType10 = this.getTokenType(index20);
                                switch (tokenType10) {
                                    case 5: 
                                    case 6: 
                                    case 11: {
                                        --index20;
                                        continue block115;
                                    }
                                    case 8: {
                                        index20 -= 2;
                                        continue block115;
                                    }
                                }
                            }
                            if (index20 == lastEntry) {
                                this.context[0] = 4;
                                this.context[4] = index20 + 1;
                                return true;
                            }
                            this.context[0] = 3;
                            this.LN = index20 + 1;
                            this.atTerminal = true;
                            return true;
                        }
                        int lastEntry = index17 = this.vtdSize - 1;
                        if (this.l1index != this.l1Buffer.size - 1) {
                            lastEntry = index17 = this.l1Buffer.upper32At(this.l1index + 1) - 1;
                        }
                        if (this.l2index != this.l2Buffer.size - 1 && this.l2index != this.l2upper) {
                            lastEntry = index17 = this.l2Buffer.upper32At(this.l2index + 1) - 1;
                        }
                        if (this.l3index != this.l3Buffer.size - 1 && this.l3index != this.l3upper) {
                            lastEntry = index17 = this.l3Buffer.upper32At(this.l3index + 1) - 1;
                        }
                        int tmp9 = this.l4Buffer.upper32At(this.l4index);
                        while (index17 > tmp9 && this.getTokenDepth(index17) < 4) {
                            --index17;
                        }
                        if (this.getTokenDepth(index17) == 3) {
                            this.LN = index17;
                            this.atTerminal = true;
                            this.context[0] = 3;
                            return true;
                        }
                        if (lastEntry != index17 && this.getTokenDepth(index17 + 1) == 3) {
                            this.LN = index17 + 1;
                            this.atTerminal = true;
                            this.context[0] = 3;
                            return true;
                        }
                        return false;
                    }
                    case 5: {
                        int index21;
                        if (this.atTerminal) break;
                        if (this.l5index < this.l5upper) {
                            int index17;
                            int tmp9 = this.l5Buffer.intAt(this.l5index);
                            ++this.l5index;
                            int lastEntry = index17 = this.l5Buffer.intAt(this.l5index) - 1;
                            block117: while (index17 > tmp9 && this.getTokenDepth(index17) == 4) {
                                int tokenType11 = this.getTokenType(index17);
                                switch (tokenType11) {
                                    case 5: 
                                    case 6: 
                                    case 11: {
                                        --index17;
                                        continue block117;
                                    }
                                    case 8: {
                                        index17 -= 2;
                                        continue block117;
                                    }
                                }
                            }
                            if (index17 == lastEntry) {
                                this.context[0] = 5;
                                this.context[5] = index17 + 1;
                                return true;
                            }
                            this.context[0] = 4;
                            this.LN = index17 + 1;
                            this.atTerminal = true;
                            return true;
                        }
                        int lastEntry = index21 = this.vtdSize - 1;
                        if (this.l1index != this.l1Buffer.size - 1) {
                            lastEntry = index21 = this.l1Buffer.upper32At(this.l1index + 1) - 1;
                        }
                        if (this.l2index != this.l2Buffer.size - 1 && this.l2index != this.l2upper) {
                            lastEntry = index21 = this.l2Buffer.upper32At(this.l2index + 1) - 1;
                        }
                        if (this.l3index != this.l3Buffer.size - 1 && this.l3index != this.l3upper) {
                            lastEntry = index21 = this.l3Buffer.upper32At(this.l3index + 1) - 1;
                        }
                        if (this.l4index != this.l4Buffer.size - 1 && this.l4index != this.l4upper) {
                            lastEntry = index21 = this.l4Buffer.upper32At(this.l4index + 1) - 1;
                        }
                        int tmp10 = this.l5Buffer.intAt(this.l5index);
                        while (index21 > tmp10 && this.getTokenDepth(index21) < 5) {
                            --index21;
                        }
                        if (this.getTokenDepth(index21) == 4) {
                            this.LN = index21;
                            this.atTerminal = true;
                            this.context[0] = 4;
                            return true;
                        }
                        if (lastEntry != index21 && this.getTokenDepth(index21 + 1) == 4) {
                            this.LN = index21 + 1;
                            this.atTerminal = true;
                            this.context[0] = 4;
                            return true;
                        }
                        return false;
                    }
                }
                if (this.atTerminal) {
                    tokenType = this.getTokenType(this.LN);
                    if (tokenType == 2) {
                        return false;
                    }
                    index = this.LN + 1;
                    tmp = this.context[0] + 1;
                } else {
                    index = this.context[this.context[0]] + 1;
                    tmp = this.context[0];
                }
                block119: while (index < this.vtdSize) {
                    long temp = this.vtdBuffer.longAt(index);
                    tokenType = (int)((0xF000000000000000L & temp) >>> 60);
                    int depth = (int)((0xFF0000000000000L & temp) >> 52);
                    switch (tokenType) {
                        case 0: {
                            if (depth < tmp) {
                                return false;
                            }
                            if (depth == tmp) {
                                this.context[0] = tmp;
                                this.context[this.context[0]] = index;
                                this.atTerminal = false;
                                return true;
                            }
                            ++index;
                            continue block119;
                        }
                        case 2: 
                        case 3: {
                            index += 2;
                            continue block119;
                        }
                        case 5: 
                        case 6: 
                        case 11: {
                            if (depth < tmp - 1) {
                                return false;
                            }
                            if (depth == tmp - 1) {
                                this.context[0] = tmp - 1;
                                this.LN = index;
                                this.atTerminal = true;
                                return true;
                            }
                            ++index;
                            continue block119;
                        }
                        case 7: {
                            if (depth < tmp - 1) {
                                return false;
                            }
                            if (depth == tmp - 1) {
                                this.context[0] = tmp - 1;
                                this.LN = index;
                                this.atTerminal = true;
                                return true;
                            }
                            index += 2;
                            continue block119;
                        }
                    }
                    ++index;
                }
                return false;
            }
            case 5: {
                return this.toNode_PrevSibling();
            }
        }
        throw new NavException("illegal navigation options");
    }

    protected boolean toNode_PrevSibling() {
        int tmp;
        int index;
        switch (this.context[0]) {
            case -1: {
                if (this.atTerminal) {
                    int index2 = this.LN - 1;
                    if (index2 > 0) {
                        int depth = this.getTokenDepth(index2);
                        if (depth == -1) {
                            int tokenType = this.getTokenType(index2);
                            switch (tokenType) {
                                case 8: {
                                    --index2;
                                }
                                case 6: {
                                    this.LN = index2;
                                    return true;
                                }
                            }
                            return false;
                        }
                        this.context[0] = 0;
                        this.atTerminal = false;
                        return true;
                    }
                    return false;
                }
                return false;
            }
            case 0: {
                if (this.atTerminal) {
                    if (this.l1Buffer.size != 0) {
                        if (this.LN < this.l1Buffer.upper32At(this.l1index)) {
                            int index3 = this.LN - 1;
                            if (index3 > this.rootIndex) {
                                int tokenType = this.getTokenType(index3);
                                int depth = this.getTokenDepth(index3);
                                if (depth == 0) {
                                    switch (tokenType) {
                                        case 5: 
                                        case 6: 
                                        case 11: {
                                            this.LN = index3;
                                            return true;
                                        }
                                        case 8: {
                                            this.LN = index3 - 1;
                                            return true;
                                        }
                                    }
                                }
                                if (this.l1index == 0) {
                                    return false;
                                }
                                --this.l1index;
                                this.atTerminal = false;
                                this.context[0] = 1;
                                this.context[1] = this.l1Buffer.upper32At(this.l1index);
                                return true;
                            }
                            return false;
                        }
                        int index4 = this.LN - 1;
                        if (index4 > this.l1Buffer.upper32At(this.l1index)) {
                            int tokenType = this.getTokenType(index4);
                            int depth = this.getTokenDepth(index4);
                            if (depth == 0) {
                                switch (tokenType) {
                                    case 5: 
                                    case 6: 
                                    case 11: {
                                        this.LN = index4;
                                        return true;
                                    }
                                    case 8: {
                                        this.LN = index4 - 1;
                                        return true;
                                    }
                                }
                            }
                        }
                        this.atTerminal = false;
                        this.context[0] = 1;
                        this.context[1] = this.l1Buffer.upper32At(this.l1index);
                        return true;
                    }
                    int index5 = this.LN - 1;
                    if (index5 > this.rootIndex) {
                        int tokenType = this.getTokenType(index5);
                        switch (tokenType) {
                            case 8: {
                                --index5;
                            }
                            case 5: 
                            case 6: 
                            case 11: {
                                this.LN = index5;
                                this.atTerminal = true;
                                this.context[0] = 0;
                                return true;
                            }
                        }
                        return false;
                    }
                    return false;
                }
                int index6 = this.rootIndex - 1;
                if (index6 > 0) {
                    int tokenType = this.getTokenType(index6);
                    switch (tokenType) {
                        case 8: {
                            --index6;
                        }
                        case 6: {
                            this.LN = index6;
                            this.atTerminal = true;
                            this.context[0] = -1;
                            return true;
                        }
                    }
                    return false;
                }
                return false;
            }
            case 1: {
                if (this.atTerminal) {
                    if (this.l1Buffer.lower32At(this.l1index) != -1) {
                        int tmp2 = this.l2Buffer.upper32At(this.l2index);
                        if (this.LN > tmp2) {
                            int index6 = this.LN - 1;
                            if (this.getTokenType(index6) == 8) {
                                --index6;
                            }
                            if (this.getTokenDepth(index6) == 1) {
                                this.LN = index6;
                                return true;
                            }
                            this.atTerminal = false;
                            this.context[0] = 2;
                            this.context[2] = tmp2;
                            return true;
                        }
                        if (this.l2index != this.l2lower) {
                            --this.l2index;
                            this.atTerminal = false;
                            this.context[0] = 2;
                            this.context[2] = this.l2Buffer.upper32At(this.l2index);
                            return true;
                        }
                        int index7 = this.LN - 1;
                        int tokenType = this.getTokenType(index7);
                        switch (tokenType) {
                            case 8: {
                                --index7;
                            }
                            case 5: 
                            case 6: 
                            case 11: {
                                this.LN = index7;
                                this.atTerminal = true;
                                this.context[0] = 1;
                                return true;
                            }
                        }
                        return false;
                    }
                    int index8 = this.LN - 1;
                    if (this.getTokenType(index8) == 8) {
                        --index8;
                    }
                    if (index8 > this.context[1]) {
                        int tokenType = this.getTokenType(index8);
                        if (tokenType != 4) {
                            this.LN = index8;
                            this.atTerminal = true;
                            return true;
                        }
                        return false;
                    }
                    return false;
                }
                int index9 = this.context[1] - 1;
                int tokenType = this.getTokenType(index9);
                if (this.getTokenDepth(index9) == 0 && tokenType != 4 && tokenType != 0) {
                    if (tokenType == 8) {
                        --index9;
                    }
                    this.context[0] = 0;
                    this.atTerminal = true;
                    this.LN = index9;
                    return true;
                }
                if (this.l1index != 0) {
                    --this.l1index;
                    this.context[1] = this.l1Buffer.upper32At(this.l1index);
                    return true;
                }
                return false;
            }
            case 2: {
                if (this.atTerminal) {
                    if (this.l2Buffer.lower32At(this.l2index) != -1) {
                        int tmp3 = this.l3Buffer.upper32At(this.l3index);
                        if (this.LN > tmp3) {
                            int index9 = this.LN - 1;
                            if (this.getTokenType(index9) == 8) {
                                --index9;
                            }
                            if (this.getTokenDepth(index9) == 2) {
                                this.LN = index9;
                                return true;
                            }
                            this.atTerminal = false;
                            this.context[0] = 3;
                            this.context[3] = tmp3;
                            return true;
                        }
                        if (this.l3index != this.l3lower) {
                            --this.l3index;
                            this.atTerminal = false;
                            this.context[0] = 3;
                            this.context[3] = this.l3Buffer.upper32At(this.l3index);
                            return true;
                        }
                        int index10 = this.LN - 1;
                        int tokenType = this.getTokenType(index10);
                        switch (tokenType) {
                            case 8: {
                                --index10;
                            }
                            case 5: 
                            case 6: 
                            case 11: {
                                this.LN = index10;
                                this.atTerminal = true;
                                this.context[0] = 2;
                                return true;
                            }
                        }
                        return false;
                    }
                    int index11 = this.LN - 1;
                    if (this.getTokenType(index11) == 8) {
                        --index11;
                    }
                    if (index11 > this.context[2]) {
                        int tokenType = this.getTokenType(index11);
                        if (tokenType != 4) {
                            this.LN = index11;
                            this.atTerminal = true;
                            return true;
                        }
                        return false;
                    }
                    return false;
                }
                int index12 = this.context[2] - 1;
                int tokenType = this.getTokenType(index12);
                if (this.getTokenDepth(index12) == 1 && tokenType != 4 && tokenType != 0) {
                    if (tokenType == 8) {
                        --index12;
                    }
                    this.context[0] = 1;
                    this.atTerminal = true;
                    this.LN = index12;
                    return true;
                }
                if (this.l2index != this.l2lower) {
                    --this.l2index;
                    this.context[2] = this.l2Buffer.upper32At(this.l2index);
                    return true;
                }
                return false;
            }
            case 3: {
                if (this.atTerminal) {
                    if (this.l3Buffer.lower32At(this.l3index) != -1) {
                        int tmp4 = this.l4Buffer.upper32At(this.l4index);
                        if (this.LN > tmp4) {
                            int index12 = this.LN - 1;
                            if (this.getTokenType(index12) == 8) {
                                --index12;
                            }
                            if (this.getTokenDepth(index12) == 3) {
                                this.LN = index12;
                                return true;
                            }
                            this.atTerminal = false;
                            this.context[0] = 4;
                            this.context[4] = tmp4;
                            return true;
                        }
                        if (this.l4index != this.l4lower) {
                            --this.l4index;
                            this.atTerminal = false;
                            this.context[0] = 4;
                            this.context[4] = this.l4Buffer.upper32At(this.l4index);
                            return true;
                        }
                        int index13 = this.LN - 1;
                        int tokenType = this.getTokenType(index13);
                        switch (tokenType) {
                            case 8: {
                                --index13;
                            }
                            case 5: 
                            case 6: 
                            case 11: {
                                this.LN = index13;
                                this.atTerminal = true;
                                this.context[0] = 3;
                                return true;
                            }
                        }
                        return false;
                    }
                    int index14 = this.LN - 1;
                    if (this.getTokenType(index14) == 8) {
                        --index14;
                    }
                    if (index14 > this.context[3]) {
                        int tokenType = this.getTokenType(index14);
                        if (tokenType != 4) {
                            this.LN = index14;
                            this.atTerminal = true;
                            return true;
                        }
                        return false;
                    }
                    return false;
                }
                int index15 = this.context[3] - 1;
                int tokenType = this.getTokenType(index15);
                if (this.getTokenDepth(index15) == 2 && tokenType != 4 && tokenType != 0) {
                    if (tokenType == 8) {
                        --index15;
                    }
                    this.context[0] = 2;
                    this.atTerminal = true;
                    this.LN = index15;
                    return true;
                }
                if (this.l3index != this.l3lower) {
                    --this.l3index;
                    this.context[3] = this.l3Buffer.upper32At(this.l3index);
                    return true;
                }
                return false;
            }
            case 4: {
                if (this.atTerminal) {
                    if (this.l4Buffer.lower32At(this.l4index) != -1) {
                        int tmp5 = this.l5Buffer.intAt(this.l5index);
                        if (this.LN > tmp5) {
                            int index15 = this.LN - 1;
                            if (this.getTokenType(index15) == 8) {
                                --index15;
                            }
                            if (this.getTokenDepth(index15) == 4) {
                                this.LN = index15;
                                return true;
                            }
                            this.atTerminal = false;
                            this.context[0] = 5;
                            this.context[5] = tmp5;
                            return true;
                        }
                        if (this.l5index != this.l5lower) {
                            --this.l5index;
                            this.atTerminal = false;
                            this.context[0] = 5;
                            this.context[5] = this.l5Buffer.intAt(this.l5index);
                            return true;
                        }
                        int index16 = this.LN - 1;
                        int tokenType = this.getTokenType(index16);
                        switch (tokenType) {
                            case 8: {
                                --index16;
                            }
                            case 5: 
                            case 6: 
                            case 11: {
                                this.LN = index16;
                                this.atTerminal = true;
                                this.context[0] = 4;
                                return true;
                            }
                        }
                        return false;
                    }
                    int index17 = this.LN - 1;
                    if (this.getTokenType(index17) == 8) {
                        --index17;
                    }
                    if (index17 > this.context[4]) {
                        int tokenType = this.getTokenType(index17);
                        if (tokenType != 4) {
                            this.LN = index17;
                            this.atTerminal = true;
                            return true;
                        }
                        return false;
                    }
                    return false;
                }
                int index18 = this.context[4] - 1;
                int tokenType = this.getTokenType(index18);
                if (this.getTokenDepth(index18) == 3 && tokenType != 4 && tokenType != 0) {
                    if (tokenType == 8) {
                        --index18;
                    }
                    this.context[0] = 3;
                    this.atTerminal = true;
                    this.LN = index18;
                    return true;
                }
                if (this.l4index != this.l4lower) {
                    --this.l4index;
                    this.context[4] = this.l4Buffer.upper32At(this.l4index);
                    return true;
                }
                return false;
            }
            case 5: {
                if (this.atTerminal) break;
                int index18 = this.context[5] - 1;
                int tokenType = this.getTokenType(index18);
                if (this.getTokenDepth(index18) == 4 && tokenType != 4 && tokenType != 0) {
                    if (tokenType == 8) {
                        --index18;
                    }
                    this.context[0] = 4;
                    this.atTerminal = true;
                    this.LN = index18;
                    return true;
                }
                if (this.l5index != this.l5lower) {
                    --this.l5index;
                    this.context[5] = this.l5Buffer.intAt(this.l5index);
                    return true;
                }
                return false;
            }
        }
        if (this.atTerminal) {
            index = this.LN - 1;
            tmp = this.context[0] + 1;
        } else {
            index = this.context[this.context[0]] - 1;
            tmp = this.context[0];
        }
        block51: while (index > this.context[tmp - 1]) {
            long temp = this.vtdBuffer.longAt(index);
            int tokenType = (int)((0xF000000000000000L & temp) >>> 60);
            int depth = (int)((0xFF0000000000000L & temp) >> 52);
            switch (tokenType) {
                case 0: {
                    if (depth == tmp) {
                        this.context[0] = tmp;
                        this.context[this.context[0]] = index;
                        this.atTerminal = false;
                        return true;
                    }
                    --index;
                    continue block51;
                }
                case 4: {
                    index -= 2;
                    continue block51;
                }
                case 5: 
                case 6: 
                case 11: {
                    if (depth == tmp - 1) {
                        this.context[0] = tmp - 1;
                        this.LN = index;
                        this.atTerminal = true;
                        return true;
                    }
                    --index;
                    continue block51;
                }
                case 8: {
                    if (depth == tmp - 1) {
                        this.context[0] = tmp - 1;
                        this.LN = index - 1;
                        this.atTerminal = true;
                        return true;
                    }
                    index -= 2;
                    continue block51;
                }
            }
            --index;
        }
        return false;
    }

    protected boolean toNode_LastChild() {
        switch (this.context[0]) {
            case -1: {
                int index = this.vtdSize - 1;
                int tokenType = this.getTokenType(index);
                int depth = this.getTokenDepth(index);
                if (depth == -1) {
                    switch (tokenType) {
                        case 6: {
                            this.LN = index;
                            this.atTerminal = true;
                            return true;
                        }
                        case 8: {
                            this.LN = index - 1;
                            this.atTerminal = true;
                            return true;
                        }
                    }
                }
                this.context[0] = 0;
                return true;
            }
            case 0: {
                if (this.l1Buffer.size != 0) {
                    int lastEntry = this.l1Buffer.upper32At(this.l1Buffer.size - 1);
                    for (int index = this.vtdSize - 1; index > lastEntry; --index) {
                        int depth = this.getTokenDepth(index);
                        if (depth == -1) {
                            continue;
                        }
                        if (depth == 0) {
                            int tokenType = this.getTokenType(index);
                            switch (tokenType) {
                                case 5: 
                                case 6: 
                                case 11: {
                                    this.LN = index;
                                    this.atTerminal = true;
                                    this.l1index = this.l1Buffer.size - 1;
                                    return true;
                                }
                                case 8: {
                                    this.LN = index - 1;
                                    this.atTerminal = true;
                                    this.l1index = this.l1Buffer.size - 1;
                                    return true;
                                }
                            }
                            return false;
                        }
                        this.l1index = this.l1Buffer.size - 1;
                        this.context[0] = 1;
                        this.context[1] = lastEntry;
                        return true;
                    }
                    this.l1index = this.l1Buffer.size - 1;
                    this.context[0] = 1;
                    this.context[1] = lastEntry;
                    return true;
                }
                for (int index2 = this.vtdSize - 1; index2 > this.rootIndex; --index2) {
                    int depth = this.getTokenDepth(index2);
                    if (depth == -1) {
                        continue;
                    }
                    int tokenType = this.getTokenType(index2);
                    switch (tokenType) {
                        case 5: 
                        case 6: 
                        case 11: {
                            this.LN = index2;
                            this.atTerminal = true;
                            return true;
                        }
                        case 8: {
                            this.LN = index2 - 1;
                            this.atTerminal = true;
                            return true;
                        }
                    }
                    return false;
                }
                return false;
            }
            case 1: {
                int tokenType;
                int index3;
                if (this.l1Buffer.lower32At(this.l1index) != -1) {
                    int tmp;
                    this.l2lower = this.l1Buffer.lower32At(this.l1index);
                    for (tmp = this.l1index + 1; tmp < this.l1Buffer.size; ++tmp) {
                        if (this.l1Buffer.lower32At(tmp) == -1) continue;
                        this.l2upper = this.l1Buffer.lower32At(tmp) - 1;
                        break;
                    }
                    if (tmp == this.l1Buffer.size) {
                        this.l2upper = this.l2Buffer.size - 1;
                    }
                    this.l2index = this.l2upper;
                    int index2 = this.vtdSize - 1;
                    if (this.l1index != this.l1Buffer.size - 1) {
                        index2 = this.l1Buffer.upper32At(this.l1index + 1) - 1;
                    }
                    tmp = this.l2Buffer.upper32At(this.l2index);
                    while (index2 > tmp) {
                        int depth = this.getTokenDepth(index2);
                        if (depth < 1) {
                            --index2;
                            continue;
                        }
                        if (depth != 1) break;
                        int tokenType2 = this.getTokenType(index2);
                        this.LN = tokenType2 == 8 ? index2 - 1 : index2;
                        this.atTerminal = true;
                        return true;
                    }
                    this.context[0] = 2;
                    this.context[2] = tmp;
                    return true;
                }
                block58: for (index3 = this.context[1] + 1; index3 < this.vtdSize; index3 += 2) {
                    tokenType = this.getTokenType(index3);
                    switch (tokenType) {
                        case 2: 
                        case 3: {
                            continue block58;
                        }
                    }
                }
                if (index3 < this.vtdSize && this.getTokenDepth(index3) == 1 && this.getTokenType(index3) != 0) {
                    int lastEntry = index3++;
                    block59: while (index3 < this.vtdSize) {
                        tokenType = this.getTokenType(index3);
                        int depth = this.getTokenDepth(index3);
                        if (depth != 1) break;
                        switch (tokenType) {
                            case 5: 
                            case 6: 
                            case 11: {
                                lastEntry = index3++;
                                continue block59;
                            }
                            case 7: {
                                lastEntry = index3;
                                index3 += 2;
                                continue block59;
                            }
                        }
                    }
                    this.LN = lastEntry;
                    this.atTerminal = true;
                    return true;
                }
                return false;
            }
            case 2: {
                int tokenType;
                int index4;
                if (this.l2Buffer.lower32At(this.l2index) != -1) {
                    int tmp;
                    this.l3lower = this.l2Buffer.lower32At(this.l2index);
                    for (tmp = this.l2index + 1; tmp < this.l2Buffer.size; ++tmp) {
                        if (this.l2Buffer.lower32At(tmp) == -1) continue;
                        this.l3upper = this.l2Buffer.lower32At(tmp) - 1;
                        break;
                    }
                    if (tmp == this.l2Buffer.size) {
                        this.l3upper = this.l3Buffer.size - 1;
                    }
                    this.l3index = this.l3upper;
                    int index3 = this.vtdSize - 1;
                    if (this.l1index != this.l1Buffer.size - 1) {
                        index3 = this.l1Buffer.upper32At(this.l1index + 1) - 1;
                    }
                    if (this.l2index != this.l2Buffer.size - 1 && this.l2index != this.l2upper) {
                        index3 = this.l2Buffer.upper32At(this.l2index + 1) - 1;
                    }
                    tmp = this.l3Buffer.upper32At(this.l3index);
                    while (index3 > tmp) {
                        int depth = this.getTokenDepth(index3);
                        if (depth < 2) {
                            --index3;
                            continue;
                        }
                        if (depth != 2) break;
                        int tokenType3 = this.getTokenType(index3);
                        this.LN = tokenType3 == 8 ? index3 - 1 : index3;
                        this.atTerminal = true;
                        return true;
                    }
                    this.context[0] = 3;
                    this.context[3] = tmp;
                    return true;
                }
                block62: for (index4 = this.context[2] + 1; index4 < this.vtdSize; index4 += 2) {
                    tokenType = this.getTokenType(index4);
                    switch (tokenType) {
                        case 2: 
                        case 3: {
                            continue block62;
                        }
                    }
                }
                if (index4 < this.vtdSize && this.getTokenDepth(index4) == 2 && this.getTokenType(index4) != 0) {
                    int lastEntry = index4++;
                    block63: while (index4 < this.vtdSize) {
                        tokenType = this.getTokenType(index4);
                        int depth = this.getTokenDepth(index4);
                        if (depth != 2) break;
                        switch (tokenType) {
                            case 5: 
                            case 6: 
                            case 11: {
                                lastEntry = index4++;
                                continue block63;
                            }
                            case 7: {
                                lastEntry = index4;
                                index4 += 2;
                                continue block63;
                            }
                        }
                    }
                    this.LN = lastEntry;
                    this.atTerminal = true;
                    return true;
                }
                return false;
            }
            case 3: {
                int tokenType;
                int index5;
                if (this.l3Buffer.lower32At(this.l3index) != -1) {
                    int tmp;
                    this.l4lower = this.l3Buffer.lower32At(this.l3index);
                    for (tmp = this.l3index + 1; tmp < this.l3Buffer.size; ++tmp) {
                        if (this.l3Buffer.lower32At(tmp) == -1) continue;
                        this.l4upper = this.l3Buffer.lower32At(tmp) - 1;
                        break;
                    }
                    if (tmp == this.l3Buffer.size) {
                        this.l4upper = this.l4Buffer.size - 1;
                    }
                    this.l4index = this.l4upper;
                    int index4 = this.vtdSize - 1;
                    if (this.l1index != this.l1Buffer.size - 1) {
                        index4 = this.l1Buffer.upper32At(this.l1index + 1) - 1;
                    }
                    if (this.l2index != this.l2Buffer.size - 1 && this.l2index != this.l2upper) {
                        index4 = this.l2Buffer.upper32At(this.l2index + 1) - 1;
                    }
                    if (this.l3index != this.l3Buffer.size - 1 && this.l3index != this.l3upper) {
                        index4 = this.l3Buffer.upper32At(this.l3index + 1) - 1;
                    }
                    tmp = this.l4Buffer.upper32At(this.l4index);
                    while (index4 > tmp) {
                        int depth = this.getTokenDepth(index4);
                        if (depth < 3) {
                            --index4;
                            continue;
                        }
                        if (depth != 3) break;
                        int tokenType4 = this.getTokenType(index4);
                        this.LN = tokenType4 == 8 ? index4 - 1 : index4;
                        this.atTerminal = true;
                        return true;
                    }
                    this.context[0] = 4;
                    this.context[4] = tmp;
                    return true;
                }
                block66: for (index5 = this.context[3] + 1; index5 < this.vtdSize; index5 += 2) {
                    tokenType = this.getTokenType(index5);
                    switch (tokenType) {
                        case 2: 
                        case 3: {
                            continue block66;
                        }
                    }
                }
                if (index5 < this.vtdSize && this.getTokenDepth(index5) == 3 && this.getTokenType(index5) != 0) {
                    int lastEntry = index5++;
                    block67: while (index5 < this.vtdSize) {
                        tokenType = this.getTokenType(index5);
                        int depth = this.getTokenDepth(index5);
                        if (depth != 3) break;
                        switch (tokenType) {
                            case 5: 
                            case 6: 
                            case 11: {
                                lastEntry = index5++;
                                continue block67;
                            }
                            case 7: {
                                lastEntry = index5;
                                index5 += 2;
                                continue block67;
                            }
                        }
                    }
                    this.LN = lastEntry;
                    this.atTerminal = true;
                    return true;
                }
                return false;
            }
            case 4: {
                int tokenType;
                int index;
                if (this.l4Buffer.lower32At(this.l4index) != -1) {
                    int tmp;
                    this.l5lower = this.l4Buffer.lower32At(this.l4index);
                    for (tmp = this.l4index + 1; tmp < this.l4Buffer.size; ++tmp) {
                        if (this.l4Buffer.lower32At(tmp) == -1) continue;
                        this.l5upper = this.l4Buffer.lower32At(tmp) - 1;
                        break;
                    }
                    if (tmp == this.l4Buffer.size) {
                        this.l5upper = this.l5Buffer.size - 1;
                    }
                    this.l5index = this.l5upper;
                    int index5 = this.vtdSize - 1;
                    if (this.l1index != this.l1Buffer.size - 1) {
                        index5 = this.l1Buffer.upper32At(this.l1index + 1) - 1;
                    }
                    if (this.l2index != this.l2Buffer.size - 1 && this.l2index != this.l2upper) {
                        index5 = this.l2Buffer.upper32At(this.l2index + 1) - 1;
                    }
                    if (this.l3index != this.l3Buffer.size - 1 && this.l3index != this.l3upper) {
                        index5 = this.l3Buffer.upper32At(this.l3index + 1) - 1;
                    }
                    if (this.l4index != this.l4Buffer.size - 1 && this.l4index != this.l4upper) {
                        index5 = this.l4Buffer.upper32At(this.l4index + 1) - 1;
                    }
                    tmp = this.l5Buffer.intAt(this.l5index);
                    while (index5 > tmp) {
                        int depth = this.getTokenDepth(index5);
                        if (depth < 4) {
                            --index5;
                            continue;
                        }
                        if (depth != 4) break;
                        int tokenType5 = this.getTokenType(index5);
                        this.LN = tokenType5 == 8 ? index5 - 1 : index5;
                        this.atTerminal = true;
                        return true;
                    }
                    this.context[0] = 5;
                    this.context[5] = tmp;
                    return true;
                }
                block70: for (index = this.context[4] + 1; index < this.vtdSize; index += 2) {
                    tokenType = this.getTokenType(index);
                    switch (tokenType) {
                        case 2: 
                        case 3: {
                            continue block70;
                        }
                    }
                }
                if (index < this.vtdSize && this.getTokenDepth(index) == 4 && this.getTokenType(index) != 0) {
                    int lastEntry = index++;
                    block71: while (index < this.vtdSize) {
                        tokenType = this.getTokenType(index);
                        int depth = this.getTokenDepth(index);
                        if (depth != 4) break;
                        switch (tokenType) {
                            case 5: 
                            case 6: 
                            case 11: {
                                lastEntry = index++;
                                continue block71;
                            }
                            case 7: {
                                lastEntry = index;
                                index += 2;
                                continue block71;
                            }
                        }
                    }
                    this.LN = lastEntry;
                    this.atTerminal = true;
                    return true;
                }
                return false;
            }
        }
        int index = this.context[this.context[0]] + 1;
        int lastEntry = -1;
        this.atTerminal = false;
        while (index < this.vtdBuffer.size) {
            long temp = this.vtdBuffer.longAt(index);
            int tokenType = (int)((0xF000000000000000L & temp) >>> 60);
            int depth = this.getTokenDepth(index);
            switch (tokenType) {
                case 0: {
                    if (depth <= this.context[0]) {
                        if (lastEntry != -1) {
                            if (this.atTerminal) {
                                this.LN = lastEntry;
                            } else {
                                this.context[0] = this.context[0] + 1;
                                this.context[this.context[0]] = lastEntry;
                            }
                            return true;
                        }
                        return false;
                    }
                    if (depth == this.context[0] + 1) {
                        lastEntry = index;
                        this.atTerminal = false;
                    }
                    ++index;
                    break;
                }
                case 2: 
                case 3: {
                    index += 2;
                    break;
                }
                case 5: 
                case 6: 
                case 11: {
                    if (depth < this.context[0]) {
                        if (lastEntry != -1) {
                            if (this.atTerminal) {
                                this.LN = lastEntry;
                            } else {
                                this.context[0] = this.context[0] + 1;
                                this.context[this.context[0]] = lastEntry;
                            }
                            return true;
                        }
                        return false;
                    }
                    if (depth == this.context[0]) {
                        lastEntry = index;
                        this.atTerminal = true;
                    }
                    ++index;
                    break;
                }
                case 7: {
                    if (depth < this.context[0]) {
                        if (lastEntry != -1) {
                            if (this.atTerminal) {
                                this.LN = lastEntry;
                            } else {
                                this.context[0] = this.context[0] + 1;
                                this.context[this.context[0]] = lastEntry;
                            }
                            return true;
                        }
                        return false;
                    }
                    if (depth == this.context[0]) {
                        lastEntry = index;
                        this.atTerminal = true;
                    }
                    index += 2;
                }
            }
        }
        if (lastEntry != -1) {
            if (this.atTerminal) {
                this.LN = lastEntry;
            } else {
                this.context[0] = this.context[0] + 1;
                this.context[this.context[0]] = lastEntry;
            }
            return true;
        }
        return false;
    }

    public boolean verifyNodeCorrectness() {
        if (this.atTerminal) {
            int tmp;
            if (this.getTokenDepth(this.LN) != this.context[0]) {
                return false;
            }
            switch (this.context[0]) {
                case -1: {
                    return true;
                }
                case 0: {
                    if (this.l1Buffer.size != 0) {
                        if (this.l1index >= this.l1Buffer.size || this.l1index < 0) {
                            return false;
                        }
                        return this.l1index == this.l1Buffer.size - 1 || this.l1Buffer.upper32At(this.l1index) >= this.LN;
                    }
                    return true;
                }
                case 1: {
                    if (this.LN > this.context[1]) {
                        if (this.l1index < 0 || this.l1index > this.l1Buffer.size) {
                            return false;
                        }
                        int i1 = this.l1Buffer.lower32At(this.l1index);
                        if (i1 != -1) {
                            int i2 = this.l2Buffer.size - 1;
                            for (int tmp2 = this.l1index + 1; tmp2 < this.l1Buffer.size; ++tmp2) {
                                if (this.l1Buffer.lower32At(tmp2) == -1) continue;
                                i2 = this.l1Buffer.lower32At(tmp2) - 1;
                                break;
                            }
                            if (i1 != this.l2lower) {
                                return false;
                            }
                            if (this.l2upper != i2) {
                                return false;
                            }
                            if (this.l2index > this.l2upper || this.l2index < this.l2lower) {
                                return false;
                            }
                            if (this.l2index != this.l2upper && this.l2Buffer.upper32At(this.l2index) < this.LN) {
                                return false;
                            }
                        }
                        return true;
                    }
                    return false;
                }
                case 2: {
                    if (this.LN > this.context[2] && this.context[2] > this.context[1]) {
                        int tmp3;
                        if (this.l1index < 0 || this.l1index > this.l1Buffer.size) {
                            return false;
                        }
                        int i1 = this.l1Buffer.lower32At(this.l1index);
                        if (i1 == -1) {
                            return false;
                        }
                        if (i1 != this.l2lower) {
                            return false;
                        }
                        int i2 = this.l2Buffer.size - 1;
                        for (tmp3 = this.l1index + 1; tmp3 < this.l1Buffer.size; ++tmp3) {
                            if (this.l1Buffer.lower32At(tmp3) == -1) continue;
                            i2 = this.l1Buffer.lower32At(tmp3) - 1;
                            break;
                        }
                        if (this.context[2] != this.l2Buffer.upper32At(this.l2index)) {
                            return false;
                        }
                        if (this.l2index > this.l2upper || this.l2index < this.l2lower) {
                            return false;
                        }
                        i1 = this.l2Buffer.lower32At(this.l2index);
                        if (i1 != -1) {
                            if (this.l3lower != i1) {
                                return false;
                            }
                            i2 = this.l3Buffer.size - 1;
                            for (tmp3 = this.l2index + 1; tmp3 < this.l2Buffer.size; ++tmp3) {
                                if (this.l2Buffer.lower32At(tmp3) == -1) continue;
                                i2 = this.l2Buffer.lower32At(tmp3) - 1;
                                break;
                            }
                            if (this.l3lower != i1) {
                                return false;
                            }
                            if (this.l3upper != i2) {
                                return false;
                            }
                            if (this.l3index > this.l3upper || this.l3index < this.l3lower) {
                                return false;
                            }
                            if (this.l3index != this.l3upper && this.l3Buffer.upper32At(this.l3index) < this.LN) {
                                return false;
                            }
                        }
                        return true;
                    }
                    return false;
                }
                case 3: {
                    if (this.LN > this.context[3] && this.context[3] > this.context[2] && this.context[2] > this.context[1]) {
                        int tmp4;
                        if (this.l1index < 0 || this.l1index > this.l1Buffer.size) {
                            return false;
                        }
                        int i1 = this.l1Buffer.lower32At(this.l1index);
                        if (i1 == -1) {
                            return false;
                        }
                        if (i1 != this.l2lower) {
                            return false;
                        }
                        int i2 = this.l2Buffer.size - 1;
                        for (tmp4 = this.l1index + 1; tmp4 < this.l1Buffer.size; ++tmp4) {
                            if (this.l1Buffer.lower32At(tmp4) == -1) continue;
                            i2 = this.l1Buffer.lower32At(tmp4) - 1;
                            break;
                        }
                        if (this.context[2] != this.l2Buffer.upper32At(this.l2index)) {
                            return false;
                        }
                        if (this.l2index > this.l2upper || this.l2index < this.l2lower) {
                            return false;
                        }
                        i1 = this.l2Buffer.lower32At(this.l2index);
                        if (i1 == -1) {
                            return false;
                        }
                        if (this.l3lower != i1) {
                            return false;
                        }
                        i2 = this.l3Buffer.size - 1;
                        for (tmp4 = this.l2index + 1; tmp4 < this.l2Buffer.size; ++tmp4) {
                            if (this.l2Buffer.lower32At(tmp4) == -1) continue;
                            i2 = this.l2Buffer.lower32At(tmp4) - 1;
                            break;
                        }
                        if (this.l3lower != i1) {
                            return false;
                        }
                        if (this.l3upper != i2) {
                            return false;
                        }
                        if (this.l3index > this.l3upper || this.l3index < this.l3lower) {
                            return false;
                        }
                        i1 = this.l3Buffer.lower32At(this.l3index);
                        if (i1 != -1) {
                            if (this.l4lower != i1) {
                                return false;
                            }
                            i2 = this.l4Buffer.size - 1;
                            for (tmp4 = this.l3index + 1; tmp4 < this.l3Buffer.size; ++tmp4) {
                                if (this.l3Buffer.lower32At(tmp4) == -1) continue;
                                i2 = this.l3Buffer.lower32At(tmp4) - 1;
                                break;
                            }
                            if (this.l4lower != i1) {
                                return false;
                            }
                            if (this.l4upper != i2) {
                                return false;
                            }
                            if (this.l4index > this.l4upper || this.l4index < this.l4lower) {
                                return false;
                            }
                            if (this.l4index != this.l4upper && this.l4Buffer.upper32At(this.l4index) < this.LN) {
                                return false;
                            }
                        }
                        return true;
                    }
                    return false;
                }
                case 4: {
                    if (this.LN > this.context[3] && this.context[3] > this.context[2] && this.context[2] > this.context[1]) {
                        int tmp5;
                        if (this.l1index < 0 || this.l1index > this.l1Buffer.size) {
                            return false;
                        }
                        int i1 = this.l1Buffer.lower32At(this.l1index);
                        if (i1 == -1) {
                            return false;
                        }
                        if (i1 != this.l2lower) {
                            return false;
                        }
                        int i2 = this.l2Buffer.size - 1;
                        for (tmp5 = this.l1index + 1; tmp5 < this.l1Buffer.size; ++tmp5) {
                            if (this.l1Buffer.lower32At(tmp5) == -1) continue;
                            i2 = this.l1Buffer.lower32At(tmp5) - 1;
                            break;
                        }
                        if (this.context[2] != this.l2Buffer.upper32At(this.l2index)) {
                            return false;
                        }
                        if (this.l2index > this.l2upper || this.l2index < this.l2lower) {
                            return false;
                        }
                        i1 = this.l2Buffer.lower32At(this.l2index);
                        if (i1 == -1) {
                            return false;
                        }
                        if (this.l3lower != i1) {
                            return false;
                        }
                        i2 = this.l3Buffer.size - 1;
                        for (tmp5 = this.l2index + 1; tmp5 < this.l2Buffer.size; ++tmp5) {
                            if (this.l2Buffer.lower32At(tmp5) == -1) continue;
                            i2 = this.l2Buffer.lower32At(tmp5) - 1;
                            break;
                        }
                        if (this.l3lower != i1) {
                            return false;
                        }
                        if (this.l3upper != i2) {
                            return false;
                        }
                        if (this.l3index > this.l3upper || this.l3index < this.l3lower) {
                            return false;
                        }
                        i1 = this.l3Buffer.lower32At(this.l3index);
                        if (i1 == -1) {
                            return false;
                        }
                        if (this.l4lower != i1) {
                            return false;
                        }
                        i2 = this.l4Buffer.size - 1;
                        for (tmp5 = this.l3index + 1; tmp5 < this.l3Buffer.size; ++tmp5) {
                            if (this.l3Buffer.lower32At(tmp5) == -1) continue;
                            i2 = this.l3Buffer.lower32At(tmp5) - 1;
                            break;
                        }
                        if (this.l4lower != i1) {
                            return false;
                        }
                        if (this.l4upper != i2) {
                            return false;
                        }
                        if (this.l4index > this.l4upper || this.l4index < this.l4lower) {
                            return false;
                        }
                        i1 = this.l4Buffer.lower32At(this.l4index);
                        if (i1 != -1) {
                            if (i1 != this.l5lower) {
                                return false;
                            }
                            i2 = this.l5Buffer.size - 1;
                            for (tmp5 = this.l4index + 1; tmp5 < this.l4Buffer.size; ++tmp5) {
                                if (this.l4Buffer.lower32At(tmp5) == -1) continue;
                                i2 = this.l4Buffer.lower32At(tmp5) - 1;
                                break;
                            }
                            if (this.l5lower != i1) {
                                return false;
                            }
                            if (this.l5upper != i2) {
                                return false;
                            }
                            if (this.l5index < i1 || this.l5index > i2) {
                                return false;
                            }
                            if (this.l5index != this.l5upper && this.l5Buffer.intAt(this.l5index) < this.LN) {
                                return false;
                            }
                        }
                        return true;
                    }
                    return false;
                }
            }
            if (this.l1index < 0 || this.l1index > this.l1Buffer.size) {
                return false;
            }
            int i1 = this.l1Buffer.lower32At(this.l1index);
            if (i1 == -1) {
                return false;
            }
            if (i1 != this.l2lower) {
                return false;
            }
            int i2 = this.l2Buffer.size - 1;
            for (tmp = this.l1index + 1; tmp < this.l1Buffer.size; ++tmp) {
                if (this.l1Buffer.lower32At(tmp) == -1) continue;
                i2 = this.l1Buffer.lower32At(tmp) - 1;
                break;
            }
            if (this.context[2] != this.l2Buffer.upper32At(this.l2index)) {
                return false;
            }
            if (this.l2index > this.l2upper || this.l2index < this.l2lower) {
                return false;
            }
            i1 = this.l2Buffer.lower32At(this.l2index);
            if (i1 == -1) {
                return false;
            }
            if (this.l3lower != i1) {
                return false;
            }
            i2 = this.l3Buffer.size - 1;
            for (tmp = this.l2index + 1; tmp < this.l2Buffer.size; ++tmp) {
                if (this.l2Buffer.lower32At(tmp) == -1) continue;
                i2 = this.l2Buffer.lower32At(tmp) - 1;
                break;
            }
            if (this.l3lower != i1) {
                return false;
            }
            if (this.l3upper != i2) {
                return false;
            }
            if (this.l3index > this.l3upper || this.l3index < this.l3lower) {
                return false;
            }
            i1 = this.l3Buffer.lower32At(this.l3index);
            if (i1 == -1) {
                return false;
            }
            if (this.l4lower != i1) {
                return false;
            }
            i2 = this.l4Buffer.size - 1;
            for (tmp = this.l3index + 1; tmp < this.l3Buffer.size; ++tmp) {
                if (this.l3Buffer.lower32At(tmp) == -1) continue;
                i2 = this.l3Buffer.lower32At(tmp) - 1;
                break;
            }
            if (this.l4lower != i1) {
                return false;
            }
            if (this.l4upper != i2) {
                return false;
            }
            if (this.l4index > this.l4upper || this.l4index < this.l4lower) {
                return false;
            }
            i1 = this.l4Buffer.lower32At(this.l4index);
            if (i1 != this.l5lower) {
                return false;
            }
            i2 = this.l5Buffer.size - 1;
            for (tmp = this.l4index + 1; tmp < this.l4Buffer.size; ++tmp) {
                if (this.l4Buffer.lower32At(tmp) == -1) continue;
                i2 = this.l4Buffer.lower32At(tmp) - 1;
                break;
            }
            if (this.l5lower != i1) {
                return false;
            }
            if (this.l5upper != i2) {
                return false;
            }
            if (this.l5index < i1 || this.l5index > i2) {
                return false;
            }
            if (this.context[this.context[0]] > this.LN) {
                return false;
            }
            if (this.context[0] == 5) {
                if (this.l5index != this.l5upper && this.l5Buffer.intAt(this.l5index) > this.LN) {
                    return false;
                }
                if (this.l5index + 1 <= this.l5Buffer.size - 1 && this.l5Buffer.intAt(this.l5index + 1) < this.LN) {
                    return false;
                }
            }
            return true;
        }
        switch (this.context[0]) {
            default: 
        }
        return true;
    }
}

