/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mgfboost.ui;

import fr.profi.mgfboost.ui.CustomFilter;
import fr.profi.mgfboost.ui.MS2CollectionManager;
import fr.profi.mgfboost.ui.SpectrumViewer;
import fr.proline.mzscope.model.IFeature;
import fr.proline.mzscope.model.IRawFile;
import fr.proline.mzscope.ui.IMzScopeController;
import fr.proline.mzscope.ui.IRawFileViewer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.prefs.Preferences;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;

public class MainPanel
extends JPanel
implements IMzScopeController {
    private static final String LAST_DIR = "mgfBoost.last.open.folder";
    private SpectrumViewer viewer;
    private JToolBar toolBar;
    private MS2CollectionManager ms2CollectionManager = new MS2CollectionManager(this);
    private JTabbedPane tabbedPane;
    private JFileChooser fileChooser = null;
    private JProgressBar progressBar;

    public IRawFileViewer getCurrentRawFileViewer() {
        return this.viewer;
    }

    public IRawFileViewer getRawFileViewer(IRawFile iRawFile, boolean b) {
        return this.viewer;
    }

    public IRawFileViewer getTabbedMultiRawFileViewer() {
        return this.viewer;
    }

    public void displayFeatures(Map<String, List<IFeature>> map) {
        throw new UnsupportedOperationException();
    }

    public MainPanel() {
        this.initComponents();
    }

    public JTabbedPane getTabbedPane() {
        return this.tabbedPane;
    }

    private void initComponents() {
        this.toolBar = new JToolBar();
        JSplitPane splitPane = new JSplitPane();
        JScrollPane scrollPane = new JScrollPane();
        this.tabbedPane = new JTabbedPane();
        this.viewer = new SpectrumViewer();
        this.setLayout(new BorderLayout());
        this.toolBar.setFloatable(false);
        this.add((Component)this.toolBar, "North");
        splitPane.setOneTouchExpandable(true);
        splitPane.setDividerSize(6);
        scrollPane.setViewportView(this.ms2CollectionManager.getMs2CollectionList());
        splitPane.setLeftComponent(scrollPane);
        JSplitPane splitPane1 = new JSplitPane(0);
        splitPane1.setOneTouchExpandable(true);
        splitPane1.setDividerSize(6);
        splitPane1.setDividerLocation(100);
        splitPane1.setLeftComponent(this.tabbedPane);
        splitPane1.setRightComponent(this.viewer);
        splitPane.setRightComponent(splitPane1);
        this.add((Component)splitPane, "Center");
        JPanel statusPanel = new JPanel();
        statusPanel.setLayout(new BorderLayout());
        this.progressBar = new JProgressBar();
        statusPanel.add((Component)this.progressBar, "Center");
        this.add((Component)statusPanel, "South");
    }

    public void displayExecutionStatus(String label, boolean running) {
        this.progressBar.setIndeterminate(running);
        this.progressBar.setStringPainted(running);
        this.progressBar.setString(label);
    }

    protected void openFileAction(String fileType) {
        Preferences prefs = Preferences.userNodeForPackage(this.getClass());
        String prefName = LAST_DIR + '.' + fileType.toLowerCase();
        String directory = prefs.get(prefName, this.getFileChooser(fileType).getCurrentDirectory().getAbsolutePath());
        this.fileChooser.setCurrentDirectory(new File(directory));
        this.fileChooser.setMultiSelectionEnabled(true);
        int returnVal = this.fileChooser.showOpenDialog(null);
        if (returnVal == 0) {
            File[] files;
            for (File file : files = this.fileChooser.getSelectedFiles()) {
                prefs.put(prefName, file.getParentFile().getAbsolutePath());
                this.ms2CollectionManager.addToMS2Collection(file, FileType.valueOf(fileType.toUpperCase()));
            }
        } else {
            System.out.println("File access cancelled by user.");
        }
    }

    private JFileChooser getFileChooser(String fileType) {
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser();
        }
        this.fileChooser.setDialogTitle("Open " + fileType + " file");
        this.fileChooser.resetChoosableFileFilters();
        this.fileChooser.setFileSelectionMode(2);
        if (!fileType.equalsIgnoreCase(FileType.MAXQUANT.name())) {
            CustomFilter customFilter = new CustomFilter(fileType);
            this.fileChooser.addChoosableFileFilter(customFilter);
            this.fileChooser.setFileFilter(customFilter);
        } else {
            this.fileChooser.setFileSelectionMode(1);
        }
        return this.fileChooser;
    }

    public static enum FileType {
        MZDB,
        MGF,
        MAXQUANT;

    }
}

