/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mgfboost.ui.command.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class OutputFilePanel
extends JPanel {
    private OutputType outputType = OutputType.FILE;
    private JTextField outputTF;
    private File rootFolder;

    public OutputFilePanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.outputTF = new JTextField();
        this.outputTF.setColumns(15);
        JButton outputBtn = new JButton();
        this.setLayout(new GridBagLayout());
        Insets defaultInsets = new Insets(0, 5, 0, 5);
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, defaultInsets, 0, 0);
        JLabel label = new JLabel("output file:");
        this.add((Component)label, gbc);
        ++gbc.gridx;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        this.add((Component)this.outputTF, gbc);
        ++gbc.gridx;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        outputBtn.setText("Choose");
        outputBtn.addActionListener(e -> this.showSaveAsChooserDialog());
        this.add((Component)outputBtn, gbc);
    }

    public void setOutputType(OutputType type) {
        this.outputType = type;
    }

    public String getOutputFilepath() {
        return this.outputTF.getText().trim();
    }

    public void showSaveAsChooserDialog() {
        JFileChooser chooser = new JFileChooser();
        File parentFile = this.outputTF.getText() != null && !this.outputTF.getText().isEmpty() ? new File(this.outputTF.getText()).getParentFile() : this.rootFolder;
        chooser.setCurrentDirectory(parentFile);
        chooser.setFileSelectionMode(this.outputType.equals((Object)OutputType.FILE) ? 0 : 1);
        int res = chooser.showSaveDialog(this.outputTF.getTopLevelAncestor());
        if (res == 0) {
            this.outputTF.setText(chooser.getSelectedFile().getAbsolutePath());
        }
    }

    public void setRootFolder(File parentFile) {
        this.rootFolder = parentFile;
    }

    public static enum OutputType {
        FILE,
        FOLDER;

    }
}

