/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mgfboost.ui.model;

import fr.profi.mgfboost.ui.MainPanel;
import fr.profi.mzdb.MzDbReader;
import fr.profi.mzdb.model.SpectrumData;
import fr.profi.mzdb.model.SpectrumHeader;
import fr.profi.mzscope.InvalidMGFFormatException;
import fr.profi.mzscope.MGFConstants;
import fr.profi.mzscope.MGFReader;
import fr.profi.mzscope.MSMSSpectrum;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MS2Collection {
    private static final Logger logger = LoggerFactory.getLogger(MS2Collection.class);
    private File file;
    private MainPanel.FileType type;

    public MS2Collection(File file, MainPanel.FileType type) {
        this.file = file;
        this.type = type;
    }

    public String getName() {
        return this.file.getName();
    }

    public MainPanel.FileType getFileType() {
        return this.type;
    }

    public File getFile() {
        return this.file;
    }

    public List<MSMSSpectrum> getSpectrumList() {
        if (this.getFileType() == MainPanel.FileType.MGF) {
            MGFReader reader = new MGFReader();
            try {
                return reader.read(this.getFile());
            }
            catch (InvalidMGFFormatException e) {
                logger.error("Unable to read MGF file " + this.getFile().getAbsolutePath(), (Throwable)e);
            }
        } else if (this.getFileType() == MainPanel.FileType.MZDB) {
            return Mzdb.readSpectrumList(this.getFile().getAbsolutePath());
        }
        return null;
    }

    public static class Mzdb {
        public static List<MSMSSpectrum> readSpectrumList(String filepath) {
            try (MzDbReader reader = null;){
                reader = new MzDbReader(filepath, true);
                reader.enablePrecursorListLoading();
                reader.enableScanListLoading();
                SpectrumHeader[] ms2SpectrumHeaders = reader.getMs2SpectrumHeaders();
                ArrayList<MSMSSpectrum> spectrumList = new ArrayList<MSMSSpectrum>(ms2SpectrumHeaders.length);
                for (SpectrumHeader header : ms2SpectrumHeaders) {
                    MSMSSpectrum msmsSpectrum = new MSMSSpectrum(header.getPrecursorMz().doubleValue(), (double)header.getTIC(), header.getPrecursorCharge().intValue(), (double)header.getElutionTime());
                    msmsSpectrum.setAnnotation(MGFConstants.SCANS, (Object)header.getSpectrumId());
                    SpectrumData spectrumData = reader.getSpectrum(header.getSpectrumId()).getData();
                    float[] intensityList = spectrumData.getIntensityList();
                    double[] mzList = spectrumData.getMzList();
                    for (int k = 0; k < mzList.length; ++k) {
                        msmsSpectrum.addPeak(mzList[k], (double)intensityList[k]);
                    }
                    spectrumList.add(msmsSpectrum);
                }
                reader.close();
                ArrayList<MSMSSpectrum> arrayList = spectrumList;
                return arrayList;
            }
        }
    }

    public static class MaxQuant {
        public static File[] locateAPLFiles(MS2Collection collection) {
            if (collection.getFileType() == MainPanel.FileType.MAXQUANT) {
                File[] files = new File[2];
                Optional<Path> sil0FileOpt = MaxQuant.findFile(collection.getFile().toPath(), ".sil0.apl");
                Optional<Path> peakFileOpt = MaxQuant.findFile(collection.getFile().toPath(), ".peak.apl");
                files[0] = sil0FileOpt.isPresent() ? sil0FileOpt.get().toFile() : null;
                files[1] = peakFileOpt.isPresent() ? peakFileOpt.get().toFile() : null;
                return files;
            }
            return new File[0];
        }

        private static Optional<Path> findFile(Path path, String extension) {
            Optional<Path> optional;
            block8: {
                Stream<Path> walk = Files.walk(path, 3, new FileVisitOption[0]);
                try {
                    Optional<Path> optionalPath;
                    optional = optionalPath = walk.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(p -> {
                        try {
                            return p.getFileName().toString().toLowerCase().endsWith(extension) && Files.size(p) > 0L;
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }).findFirst();
                    if (walk == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (walk != null) {
                            try {
                                walk.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                walk.close();
            }
            return optional;
        }
    }
}

