/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.api.progress;

import com.typesafe.scalalogging.Logger;
import fr.profi.api.progress.IProgressPlanSequence;
import fr.profi.api.progress.IProgressStepIdentity;
import fr.profi.api.progress.IProgressUpdatedListener;
import fr.profi.api.progress.IStepCompletedListener;
import fr.profi.api.progress.ProgressPlan;
import fr.profi.api.progress.ProgressStep;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005Ee\u0001B\u000f\u001f\u0001\u001dB\u0001b\f\u0001\u0003\u0006\u0004%\t\u0001\r\u0005\t\u0001\u0002\u0011\t\u0011)A\u0005c!A\u0011\t\u0001B\u0001B\u0003-!\tC\u0003I\u0001\u0011\u0005\u0011\nC\u0004O\u0001\u0001\u0007I\u0011B(\t\u000fM\u0003\u0001\u0019!C\u0005)\"1!\f\u0001Q!\nACqa\u0017\u0001A\u0002\u0013%A\fC\u0004a\u0001\u0001\u0007I\u0011B1\t\r\r\u0004\u0001\u0015)\u0003^\u0011\u001d!\u0007A1A\u0005\n\u0015Da\u0001\u001e\u0001!\u0002\u00131\u0007bB;\u0001\u0005\u0004%I!\u001a\u0005\u0007m\u0002\u0001\u000b\u0011\u00024\t\u000b]\u0004A\u0011\u0002=\t\u000bi\u0004A\u0011A>\t\u000f\u0005]\u0001\u0001\"\u0001\u0002\u001a!9\u00111\u0004\u0001\u0005\u0002\u0005u\u0001bBA\u0010\u0001\u0011\u0005\u0011\u0011\u0005\u0005\b\u0003S\u0001A\u0011AA\u0016\u0011\u001d\ti\u0003\u0001C\u0001\u0003WAq!a\f\u0001\t#\ti\u0002C\u0004\u00022\u0001!\t!a\r\t\u000f\u0005E\u0003\u0001\"\u0001\u0002T!9\u0011\u0011\f\u0001\u0005\u0002\u0005m\u0003bBA4\u0001\u0011\u0005\u0011\u0011\u000e\u0005\b\u0003[\u0002A\u0011AA8\u0011\u001d\t)\b\u0001C\u0001\u0003o\u0012\u0001\u0003\u0015:pOJ,7o]\"p[B,H/\u001a:\u000b\u0005}\u0001\u0013\u0001\u00039s_\u001e\u0014Xm]:\u000b\u0005\u0005\u0012\u0013aA1qS*\u00111\u0005J\u0001\u0006aJ|g-\u001b\u0006\u0002K\u0005\u0011aM]\u0002\u0001+\tAsg\u0005\u0002\u0001SA\u0011!&L\u0007\u0002W)\tA&A\u0003tG\u0006d\u0017-\u0003\u0002/W\t1\u0011I\\=SK\u001a\fA\u0002\u001d:pOJ,7o\u001d)mC:,\u0012!\r\t\u0004eM*T\"\u0001\u0010\n\u0005Qr\"\u0001\u0004)s_\u001e\u0014Xm]:QY\u0006t\u0007C\u0001\u001c8\u0019\u0001!Q\u0001\u000f\u0001C\u0002e\u0012\u0011aU\t\u0003uu\u0002\"AK\u001e\n\u0005qZ#a\u0002(pi\"Lgn\u001a\t\u0003eyJ!a\u0010\u0010\u0003+%\u0003&o\\4sKN\u001c\b\u000b\\1o'\u0016\fX/\u001a8dK\u0006i\u0001O]8he\u0016\u001c8\u000f\u00157b]\u0002\naa]3r)\u0006<\u0007cA\"Gk5\tAI\u0003\u0002FW\u00059!/\u001a4mK\u000e$\u0018BA$E\u0005!\u0019E.Y:t)\u0006<\u0017A\u0002\u001fj]&$h\b\u0006\u0002K\u001bR\u00111\n\u0014\t\u0004e\u0001)\u0004\"B!\u0005\u0001\b\u0011\u0005\"B\u0018\u0005\u0001\u0004\t\u0014\u0001D0jg\u000e{W\u000e\u001d7fi\u0016$W#\u0001)\u0011\u0005)\n\u0016B\u0001*,\u0005\u001d\u0011un\u001c7fC:\f\u0001cX5t\u0007>l\u0007\u000f\\3uK\u0012|F%Z9\u0015\u0005UC\u0006C\u0001\u0016W\u0013\t96F\u0001\u0003V]&$\bbB-\u0007\u0003\u0003\u0005\r\u0001U\u0001\u0004q\u0012\n\u0014!D0jg\u000e{W\u000e\u001d7fi\u0016$\u0007%A\u0005`aJ|wM]3tgV\tQ\f\u0005\u0002+=&\u0011ql\u000b\u0002\u0006\r2|\u0017\r^\u0001\u000e?B\u0014xn\u001a:fgN|F%Z9\u0015\u0005U\u0013\u0007bB-\n\u0003\u0003\u0005\r!X\u0001\u000b?B\u0014xn\u001a:fgN\u0004\u0013!G0p]B\u0013xn\u001a:fgN,\u0006\u000fZ1uK\u0012\f5\r^5p]N,\u0012A\u001a\t\u0004O2tW\"\u00015\u000b\u0005%T\u0017aB7vi\u0006\u0014G.\u001a\u0006\u0003W.\n!bY8mY\u0016\u001cG/[8o\u0013\ti\u0007NA\u0006BeJ\f\u0017PQ;gM\u0016\u0014\b#\u0002\u0016pcv+\u0016B\u00019,\u0005%1UO\\2uS>t'\u0007\u0005\u00023e&\u00111O\b\u0002\u0016\u0013B\u0013xn\u001a:fgN\u001cF/\u001a9JI\u0016tG/\u001b;z\u0003iyvN\u001c)s_\u001e\u0014Xm]:Va\u0012\fG/\u001a3BGRLwN\\:!\u0003]yvN\\*uKB\u001cu.\u001c9mKR,G-Q2uS>t7/\u0001\r`_:\u001cF/\u001a9D_6\u0004H.\u001a;fI\u0006\u001bG/[8og\u0002\nqbX:fi\u0006\u001b8i\\7qY\u0016$X\r\u001a\u000b\u0002s6\t\u0001!\u0001\u0005hKR\u001cF/\u001a9t)\u0005a\b#B?\u0002\f\u0005Eab\u0001@\u0002\b9\u0019q0!\u0002\u000e\u0005\u0005\u0005!bAA\u0002M\u00051AH]8pizJ\u0011\u0001L\u0005\u0004\u0003\u0013Y\u0013a\u00029bG.\fw-Z\u0005\u0005\u0003\u001b\tyAA\u0002TKFT1!!\u0003,!\u0011\u0011\u00141C\u001b\n\u0007\u0005UaD\u0001\u0007Qe><'/Z:t'R,\u0007/\u0001\bhKR\u001cUO\u001d:f]R\u001cF/\u001a9\u0015\u0005\u0005E\u0011!G:fi\u000e+(O]3oiN#X\r]!t\u0007>l\u0007\u000f\\3uK\u0012$\u0012!V\u0001\u001aO\u0016$h*^7cKJ|emQ8na2,G/\u001a3Ti\u0016\u00048\u000f\u0006\u0002\u0002$A\u0019!&!\n\n\u0007\u0005\u001d2FA\u0002J]R\f1bZ3u!J|wM]3tgR\tQ,\u0001\nhKR,\u0006\u000fZ1uK\u0012\u0004&o\\4sKN\u001c\u0018AD;qI\u0006$X\r\u0015:pOJ,7o]\u0001\u001dO\u0016$xJ\u001c)s_\u001e\u0014Xm]:Va\u0012\fG/\u001a3MSN$XM\\3s)\t\t)D\u0005\u0004\u00028\u0005m\u00121\n\u0004\u0007\u0003s9\u0002!!\u000e\u0003\u0019q\u0012XMZ5oK6,g\u000e\u001e \u0011\t\u0005u\u0012qI\u0007\u0003\u0003\u007fQA!!\u0011\u0002D\u0005!A.\u00198h\u0015\t\t)%\u0001\u0003kCZ\f\u0017\u0002BA%\u0003\u007f\u0011aa\u00142kK\u000e$\bc\u0001\u001a\u0002N%\u0019\u0011q\n\u0010\u00031%\u0003&o\\4sKN\u001cX\u000b\u001d3bi\u0016$G*[:uK:,'/A\u0010sK\u001eL7\u000f^3s\u001f:\u0004&o\\4sKN\u001cX\u000b\u001d3bi\u0016$\u0017i\u0019;j_:$2AZA+\u0011\u0019\t9\u0006\u0007a\u0001]\u00061\u0011m\u0019;j_:\f!dZ3u\u001f:\u001cF/\u001a9D_6\u0004H.\u001a;fI2K7\u000f^3oKJ$\"!!\u0018\u0013\r\u0005}\u00131HA1\r\u0019\tI$\u0007\u0001\u0002^A\u0019!'a\u0019\n\u0007\u0005\u0015dD\u0001\fJ'R,\u0007oQ8na2,G/\u001a3MSN$XM\\3s\u0003u\u0011XmZ5ti\u0016\u0014xJ\\*uKB\u001cu.\u001c9mKR,G-Q2uS>tGc\u00014\u0002l!1\u0011q\u000b\u000eA\u00029\fQC]3tKR\u001cF/\u001a9Ti\u0006\u0014H/\u001b8h)&lW\r\u0006\u0003\u0002\u0012\u0005E\u0004BBA:7\u0001\u0007\u0011/\u0001\u0007ti\u0016\u0004\u0018\nZ3oi&$\u00180\u0001\fm_\u001e,\u00050Z2vi&|gn\u0015;bi&\u001cH/[2t)\r)\u0016\u0011\u0010\u0005\b\u0003wb\u0002\u0019AA?\u0003\u0019awnZ4feB!\u0011qPAG\u001b\t\t\tI\u0003\u0003\u0002\u0004\u0006\u0015\u0015\u0001D:dC2\fGn\\4hS:<'\u0002BAD\u0003\u0013\u000b\u0001\u0002^=qKN\fg-\u001a\u0006\u0003\u0003\u0017\u000b1aY8n\u0013\u0011\ty)!!\u0003\r1{wmZ3s\u0001")
public class ProgressComputer<S extends IProgressPlanSequence> {
    private final ProgressPlan<S> progressPlan;
    private boolean _isCompleted;
    private float _progress;
    private final ArrayBuffer<Function2<IProgressStepIdentity, Object, BoxedUnit>> _onProgressUpdatedActions;
    private final ArrayBuffer<Function2<IProgressStepIdentity, Object, BoxedUnit>> _onStepCompletedActions;

    public ProgressPlan<S> progressPlan() {
        return this.progressPlan;
    }

    private boolean _isCompleted() {
        return this._isCompleted;
    }

    private void _isCompleted_$eq(boolean x$1) {
        this._isCompleted = x$1;
    }

    private float _progress() {
        return this._progress;
    }

    private void _progress_$eq(float x$1) {
        this._progress = x$1;
    }

    private ArrayBuffer<Function2<IProgressStepIdentity, Object, BoxedUnit>> _onProgressUpdatedActions() {
        return this._onProgressUpdatedActions;
    }

    private ArrayBuffer<Function2<IProgressStepIdentity, Object, BoxedUnit>> _onStepCompletedActions() {
        return this._onStepCompletedActions;
    }

    private synchronized ProgressComputer<S> _setAsCompleted() {
        this._progress_$eq(1.0f);
        this._isCompleted_$eq(true);
        return this;
    }

    public Seq<ProgressStep<S>> getSteps() {
        return this.progressPlan().steps();
    }

    public ProgressStep<S> getCurrentStep() {
        Seq allSteps = this.getSteps();
        return (ProgressStep)allSteps.find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ProgressComputer.$anonfun$getCurrentStep$1(x$1))).getOrElse((Function0 & Serializable & scala.Serializable)() -> (ProgressStep)allSteps.last());
    }

    public void setCurrentStepAsCompleted() {
        this.getCurrentStep().setAsCompleted();
    }

    public int getNumberOfCompletedSteps() {
        if (this._isCompleted()) {
            return this.progressPlan().getNumberOfSteps();
        }
        return this.getSteps().count((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isCompleted()));
    }

    public float getProgress() {
        return this._progress();
    }

    public float getUpdatedProgress() {
        this.updateProgress();
        return this._progress();
    }

    public synchronized void updateProgress() {
        if (this._isCompleted()) {
            return;
        }
        Seq<ProgressStep<S>> steps = this.getSteps();
        float weightSum = BoxesRunTime.unboxToFloat((Object)steps.foldLeft((Object)BoxesRunTime.boxToFloat((float)0.0f), (Function2 & Serializable & scala.Serializable)(sum, step) -> BoxesRunTime.boxToFloat((float)ProgressComputer.$anonfun$updateProgress$1(BoxesRunTime.unboxToFloat((Object)sum), step))));
        float progressSum = BoxesRunTime.unboxToFloat((Object)steps.foldLeft((Object)BoxesRunTime.boxToFloat((float)0.0f), (Function2 & Serializable & scala.Serializable)(sum, step) -> BoxesRunTime.boxToFloat((float)ProgressComputer.$anonfun$updateProgress$2(BoxesRunTime.unboxToFloat((Object)sum), step))));
        float averageProgress = progressSum / weightSum;
        if (averageProgress >= 1.0f) {
            this._setAsCompleted();
            this._progress_$eq(1.0f);
        } else {
            this._progress_$eq(averageProgress);
        }
    }

    public IProgressUpdatedListener getOnProgressUpdatedListener() {
        ProgressComputer progressComputer = this;
        return new IProgressUpdatedListener(null, progressComputer){
            private final ProgressComputer progressComputer$1;

            public void listenOnProgressUpdatedAction(Function2<IProgressStepIdentity, Object, BoxedUnit> action) {
                this.progressComputer$1.registerOnProgressUpdatedAction(action);
            }
            {
                this.progressComputer$1 = progressComputer$1;
            }
        };
    }

    public ArrayBuffer<Function2<IProgressStepIdentity, Object, BoxedUnit>> registerOnProgressUpdatedAction(Function2<IProgressStepIdentity, Object, BoxedUnit> action) {
        return this._onProgressUpdatedActions().$plus$eq(action);
    }

    public IStepCompletedListener getOnStepCompletedListener() {
        ProgressComputer progressComputer = this;
        return new IStepCompletedListener(null, progressComputer){
            private final ProgressComputer progressComputer$2;

            public void listenOnStepCompletedAction(Function2<IProgressStepIdentity, Object, BoxedUnit> action) {
                this.progressComputer$2.registerOnStepCompletedAction(action);
            }
            {
                this.progressComputer$2 = progressComputer$2;
            }
        };
    }

    public ArrayBuffer<Function2<IProgressStepIdentity, Object, BoxedUnit>> registerOnStepCompletedAction(Function2<IProgressStepIdentity, Object, BoxedUnit> action) {
        return this._onStepCompletedActions().$plus$eq(action);
    }

    /*
     * WARNING - void declaration
     */
    public ProgressStep<S> resetStepStartingTime(IProgressStepIdentity stepIdentity) {
        void var3_3;
        Option<ProgressStep<S>> stepOpt = this.progressPlan().get(stepIdentity);
        Predef$.MODULE$.require(stepOpt.isDefined(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("can't find a step in progress plan with identity = ").append(stepIdentity.stepName()).toString());
        ProgressStep step = (ProgressStep)stepOpt.get();
        step.resetStartingTime();
        return var3_3;
    }

    public void logExecutionStatistics(Logger logger) {
        this.getSteps().foreach((Function1 & Serializable & scala.Serializable)step -> {
            ProgressComputer.$anonfun$logExecutionStatistics$1(this, logger, step);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$getCurrentStep$1(ProgressStep x$1) {
        return !x$1.isCompleted();
    }

    public static final /* synthetic */ float $anonfun$updateProgress$1(float sum, ProgressStep step) {
        return sum + step.weight();
    }

    public static final /* synthetic */ float $anonfun$updateProgress$2(float sum, ProgressStep step) {
        return sum + step.weight() * step.getProgress();
    }

    public static final /* synthetic */ void $anonfun$logExecutionStatistics$1(ProgressComputer $this, Logger logger$1, ProgressStep step) {
        BoxedUnit boxedUnit;
        Tuple2<Object, Object> execStats = step.getExecutionStatistics();
        if (logger$1.underlying().isDebugEnabled()) {
            logger$1.underlying().debug(new StringBuilder(37).append("execution stats in progress plan '").append($this.progressPlan().name()).append("': ").append(execStats).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public ProgressComputer(ProgressPlan<S> progressPlan, ClassTag<S> seqTag) {
        this.progressPlan = progressPlan;
        Predef$.MODULE$.require(progressPlan != null, (Function0 & Serializable & scala.Serializable)() -> "progressPlan is null");
        this._isCompleted = false;
        this._progress = 0.0f;
        this._onProgressUpdatedActions = new ArrayBuffer(0);
        this._onStepCompletedActions = new ArrayBuffer(0);
        this.getSteps().foreach((Function1 & Serializable & scala.Serializable)step -> {
            step.registerOnProgressUpdatedAction((Function1<Object, BoxedUnit>)(JFunction1.mcVF.sp & Serializable & scala.Serializable)newProgress -> {
                block0: {
                    if (this._onProgressUpdatedActions().isEmpty()) break block0;
                    this.updateProgress();
                    this._onProgressUpdatedActions().foreach((Function1 & Serializable & scala.Serializable)action -> {
                        action.apply((Object)step.identity(), (Object)BoxesRunTime.boxToFloat((float)this._progress()));
                        return BoxedUnit.UNIT;
                    });
                }
            });
            return step.registerOnStepCompletedAction((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                block0: {
                    this.getCurrentStep().resetStartingTime();
                    if (this._onStepCompletedActions().isEmpty()) break block0;
                    this.updateProgress();
                    this._onStepCompletedActions().foreach((Function1 & Serializable & scala.Serializable)action -> {
                        action.apply((Object)step.identity(), (Object)BoxesRunTime.boxToFloat((float)this._progress()));
                        return BoxedUnit.UNIT;
                    });
                }
            });
        });
    }
}

