/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.jdbc;

import com.typesafe.scalalogging.LazyLogging;
import java.sql.Connection;
import java.sql.SQLException;
import scala.Enumeration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001A3qAC\u0006\u0011\u0002\u0007\u0005!\u0003C\u0003$\u0001\u0011\u0005A\u0005C\u0004)\u0001\t\u0007i\u0011C\u0015\t\u000fI\u0002!\u0019!D\tg!)Q\b\u0001C\u0001I!)a\b\u0001C\u0001I!)q\t\u0001C\u0001I!)\u0001\n\u0001C\u0001I!)!\n\u0001C\u0001I!)1\n\u0001C\u0001\u0019\n)BK]1og\u0006\u001cG/[8o\u001b\u0006t\u0017mZ3nK:$(B\u0001\u0007\u000e\u0003\u0011QGMY2\u000b\u00059y\u0011!\u00029s_\u001aL'\"\u0001\t\u0002\u0005\u0019\u00148\u0001A\n\u0004\u0001MI\u0002C\u0001\u000b\u0018\u001b\u0005)\"\"\u0001\f\u0002\u000bM\u001c\u0017\r\\1\n\u0005a)\"AB!osJ+g\r\u0005\u0002\u001bC5\t1D\u0003\u0002\u001d;\u0005a1oY1mC2|wmZ5oO*\u0011adH\u0001\tif\u0004Xm]1gK*\t\u0001%A\u0002d_6L!AI\u000e\u0003\u00171\u000b'0\u001f'pO\u001eLgnZ\u0001\u0007I%t\u0017\u000e\u001e\u0013\u0015\u0003\u0015\u0002\"\u0001\u0006\u0014\n\u0005\u001d*\"\u0001B+oSR\f!bY8o]\u0016\u001cG/[8o+\u0005Q\u0003CA\u00161\u001b\u0005a#BA\u0017/\u0003\r\u0019\u0018\u000f\u001c\u0006\u0002_\u0005!!.\u0019<b\u0013\t\tDF\u0001\u0006D_:tWm\u0019;j_:\f\u0001\u0003\u001e=Jg>d\u0017\r^5p]2+g/\u001a7\u0016\u0003Q\u0002\"!N\u001d\u000f\u0005Y:T\"A\u0006\n\u0005aZ\u0011!\u0005+y\u0013N|G.\u0019;j_:dUM^3mg&\u0011!h\u000f\u0002\u0006-\u0006dW/Z\u0005\u0003yU\u00111\"\u00128v[\u0016\u0014\u0018\r^5p]\u0006\u0001\"-Z4j]R\u0013\u0018M\\:bGRLwN\\\u0001\u0014e>dGNY1dWR\u0013\u0018M\\:bGRLwN\u001c\u0015\u0004\u000b\u00013\u0005c\u0001\u000bB\u0007&\u0011!)\u0006\u0002\u0007i\"\u0014xn^:\u0011\u0005-\"\u0015BA#-\u00051\u0019\u0016\u000bT#yG\u0016\u0004H/[8oG\u0005\u0019\u0015\u0001\u0003:pY2\u0014\u0017mY6\u0002#\r|W.\\5u)J\fgn]1di&|g\u000eK\u0002\b\u0001\u001a\u000baaY8n[&$\u0018aD5t\u0013:$&/\u00198tC\u000e$\u0018n\u001c8\u0015\u00035\u0003\"\u0001\u0006(\n\u0005=+\"a\u0002\"p_2,\u0017M\u001c")
public interface TransactionManagement
extends LazyLogging {
    public Connection connection();

    public Enumeration.Value txIsolationLevel();

    public static /* synthetic */ void beginTransaction$(TransactionManagement $this) {
        $this.beginTransaction();
    }

    default public void beginTransaction() {
        BoxedUnit boxedUnit;
        this.connection().setAutoCommit(false);
        int oldTransactionIsolation = this.connection().getTransactionIsolation();
        int newTransactionIsolation = this.txIsolationLevel().id();
        if (oldTransactionIsolation != newTransactionIsolation) {
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn(new StringBuilder(59).append("Current TransactionIsolation level: ").append(oldTransactionIsolation).append("  Unable to change to: ").append(newTransactionIsolation).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static /* synthetic */ void rollbackTransaction$(TransactionManagement $this) {
        $this.rollbackTransaction();
    }

    default public void rollbackTransaction() throws SQLException {
        this.connection().rollback();
        this.connection().setAutoCommit(true);
    }

    public static /* synthetic */ void rollback$(TransactionManagement $this) {
        $this.rollback();
    }

    default public void rollback() {
        this.rollbackTransaction();
    }

    public static /* synthetic */ void commitTransaction$(TransactionManagement $this) {
        $this.commitTransaction();
    }

    default public void commitTransaction() throws SQLException {
        this.connection().commit();
        this.connection().setAutoCommit(true);
    }

    public static /* synthetic */ void commit$(TransactionManagement $this) {
        $this.commit();
    }

    default public void commit() {
        this.commitTransaction();
    }

    public static /* synthetic */ boolean isInTransaction$(TransactionManagement $this) {
        return $this.isInTransaction();
    }

    default public boolean isInTransaction() {
        return !this.connection().getAutoCommit();
    }

    public static void $init$(TransactionManagement $this) {
    }
}

