/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.mzscope.model;

import fr.proline.mzscope.model.IRawFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;

public class QCMetrics {
    public static String MAX_MS_LEVEL = "Max MS level";
    private Map<String, List<Object>> scalarMSLevelMetrics;
    private Map<String, List<DescriptiveStatistics>> populationMSLevelMetrics;
    private String name;
    private transient IRawFile rawFile;

    public QCMetrics(IRawFile rawFile) {
        this.rawFile = rawFile;
        this.name = rawFile.getName();
        this.scalarMSLevelMetrics = new LinkedHashMap<String, List<Object>>();
        this.populationMSLevelMetrics = new LinkedHashMap<String, List<DescriptiveStatistics>>();
    }

    protected QCMetrics() {
    }

    public IRawFile getRawFile() {
        return this.rawFile;
    }

    public String getName() {
        return this.name;
    }

    public void setRawFile(IRawFile rawFile) {
        this.rawFile = rawFile;
    }

    public void addMetric(String name, Object value) {
        if (this.populationMSLevelMetrics.containsKey(name)) {
            throw new IllegalArgumentException("Metric name already used to describe a population metric");
        }
        if (!this.scalarMSLevelMetrics.containsKey(name)) {
            this.scalarMSLevelMetrics.put(name, new ArrayList());
        }
        this.scalarMSLevelMetrics.get(name).add(value);
    }

    public void addMetric(String name, Object[] values) {
        if (this.populationMSLevelMetrics.containsKey(name)) {
            throw new IllegalArgumentException("Metric name already used to describe a population metric");
        }
        if (!this.scalarMSLevelMetrics.containsKey(name)) {
            this.scalarMSLevelMetrics.put(name, new ArrayList());
        }
        this.scalarMSLevelMetrics.get(name).add(null);
        this.scalarMSLevelMetrics.get(name).addAll(Arrays.asList(values));
    }

    public void addMetric(String name, DescriptiveStatistics value) {
        if (this.scalarMSLevelMetrics.containsKey(name)) {
            throw new IllegalArgumentException("Metric name already used to describe a scalar metric");
        }
        if (!this.populationMSLevelMetrics.containsKey(name)) {
            this.populationMSLevelMetrics.put(name, new ArrayList());
        }
        this.populationMSLevelMetrics.get(name).add(value);
    }

    public void addMetric(String name, DescriptiveStatistics[] values) {
        if (this.scalarMSLevelMetrics.containsKey(name)) {
            throw new IllegalArgumentException("Metric name already used to describe a scalar metric");
        }
        if (!this.populationMSLevelMetrics.containsKey(name)) {
            this.populationMSLevelMetrics.put(name, new ArrayList());
        }
        this.populationMSLevelMetrics.get(name).add(null);
        this.populationMSLevelMetrics.get(name).addAll(Arrays.asList(values));
    }

    public DescriptiveStatistics[] getMetricStatistics(String name) {
        List<DescriptiveStatistics> stats = this.populationMSLevelMetrics.get(name);
        if (stats == null) {
            return null;
        }
        return stats.toArray(new DescriptiveStatistics[0]);
    }

    public List<String> getPopulationMetricNames() {
        return new ArrayList<String>(this.populationMSLevelMetrics.keySet());
    }

    public Object[] getMetricValue(String name) {
        return this.scalarMSLevelMetrics.get(name).toArray(new Object[0]);
    }

    public Map<String, Object> asSummary() {
        String key;
        List<Object> values;
        LinkedHashMap<String, Object> metrics = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, List<Object>> entry : this.scalarMSLevelMetrics.entrySet()) {
            values = entry.getValue();
            if (values.get(0) == null) {
                for (int msLevel = 1; msLevel < values.size(); ++msLevel) {
                    if (values.get(msLevel) == null) continue;
                    key = QCMetrics.buildKey(entry.getKey(), msLevel);
                    metrics.put(key, values.get(msLevel));
                }
                continue;
            }
            metrics.put(entry.getKey(), values.get(0));
        }
        for (Map.Entry<String, List<Object>> entry : this.populationMSLevelMetrics.entrySet()) {
            values = entry.getValue();
            if (values.get(0) == null) {
                for (int msLevel = 1; msLevel < values.size(); ++msLevel) {
                    if (values.get(msLevel) == null) continue;
                    key = QCMetrics.buildKey(entry.getKey(), msLevel);
                    DescriptiveStatistics stats = (DescriptiveStatistics)values.get(msLevel);
                    metrics.put(key + " Q1", stats.getPercentile(25.0));
                    metrics.put(key + " Q2", stats.getPercentile(50.0));
                    metrics.put(key + " Q3", stats.getPercentile(75.0));
                    metrics.put(key + " Q4", stats.getPercentile(100.0));
                    metrics.put(key + " mean", stats.getMean());
                    metrics.put(key + " stdev", stats.getStandardDeviation());
                }
                continue;
            }
            DescriptiveStatistics stats = (DescriptiveStatistics)values.get(0);
            metrics.put(entry.getKey() + " Q1", stats.getPercentile(25.0));
            metrics.put(entry.getKey() + " Q2", stats.getPercentile(50.0));
            metrics.put(entry.getKey() + " Q3", stats.getPercentile(75.0));
            metrics.put(entry.getKey() + " Q4", stats.getPercentile(100.0));
        }
        return metrics;
    }

    private static String buildKey(String key, int msLevel) {
        StringBuilder builder = new StringBuilder();
        int idx = key.indexOf("MS");
        if (idx == -1) {
            return builder.append(key).append(msLevel).toString();
        }
        return builder.append(key.substring(0, idx + 2)).append(msLevel).append(key.substring(idx + 2)).toString();
    }
}

