/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.mzscope.model;

import fr.proline.mzscope.model.IonMobilityIndex;
import fr.proline.mzscope.utils.BinarySearch;

public class TIMSMobilityIndex
implements IonMobilityIndex {
    BinarySearch bs = new BinarySearch();
    private double[] mobilityIndexes;

    public TIMSMobilityIndex(double[] mobilities) {
        this.mobilityIndexes = new double[mobilities.length];
        for (int k = 0; k < mobilities.length; ++k) {
            this.mobilityIndexes[mobilities.length - 1 - k] = mobilities[k];
        }
    }

    @Override
    public int getIndex(double value) {
        int index = this.bs.searchIndex(this.mobilityIndexes, value, 0, this.mobilityIndexes.length);
        if (index >= 0) {
            return this.mobilityIndexes.length - 1 - index;
        }
        return value < this.mobilityIndexes[0] ? this.getMaxIndex() : 0;
    }

    @Override
    public int[] getIndexRange(double min, double max) {
        int minIdx = this.getIndex(min);
        int maxIdx = this.getIndex(max);
        if (!(max > this.mobilityIndexes[maxIdx]) || maxIdx < this.mobilityIndexes.length - 1) {
            // empty if block
        }
        return new int[]{++maxIdx, minIdx};
    }

    @Override
    public double getMobility(int index) {
        return this.mobilityIndexes[this.mobilityIndexes.length - 1 - index];
    }

    @Override
    public int getMaxIndex() {
        return this.mobilityIndexes.length - 1;
    }

    @Override
    public double getMinValue() {
        return this.mobilityIndexes[0];
    }

    @Override
    public double getMaxValue() {
        return this.mobilityIndexes[this.mobilityIndexes.length - 1];
    }

    @Override
    public int getNextMobilityIndex(int index) {
        return index > 0 ? index - 1 : index;
    }

    @Override
    public int getPreviousMobilityIndex(int index) {
        return index < this.mobilityIndexes.length - 1 ? index + 1 : index;
    }
}

