/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.mzscope.mzdb;

import fr.profi.mzdb.model.Feature;
import fr.profi.mzdb.model.Peakel;
import fr.proline.mzscope.model.IFeature;
import fr.proline.mzscope.model.IRawFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MzdbFeatureWrapper
implements IFeature {
    private static final Logger logger = LoggerFactory.getLogger(MzdbFeatureWrapper.class);
    private final Feature mzdbFeature;
    private IRawFile rawFile;
    private final int msLevel;

    public MzdbFeatureWrapper(Feature mzdbFeature, IRawFile rawfile, int msLevel) {
        this.mzdbFeature = mzdbFeature;
        this.rawFile = rawfile;
        this.msLevel = msLevel;
    }

    @Override
    public float getArea() {
        return this.mzdbFeature.getArea();
    }

    @Override
    public int getScanCount() {
        return this.mzdbFeature.getMs1Count();
    }

    @Override
    public int getPeakelsCount() {
        return this.mzdbFeature.getPeakelsCount();
    }

    @Override
    public double getMz() {
        return this.mzdbFeature.getMz();
    }

    @Override
    public int getCharge() {
        return this.mzdbFeature.getCharge();
    }

    @Override
    public float getElutionTime() {
        return this.mzdbFeature.getElutionTime();
    }

    @Override
    public float getDuration() {
        return this.mzdbFeature.calcDuration();
    }

    @Override
    public float getApexIntensity() {
        return this.mzdbFeature.getBasePeakel().getApexIntensity();
    }

    @Override
    public float getFirstElutionTime() {
        return this.mzdbFeature.getBasePeakel().getFirstElutionTime();
    }

    @Override
    public float getLastElutionTime() {
        return this.mzdbFeature.getBasePeakel().getLastElutionTime();
    }

    @Override
    public IRawFile getRawFile() {
        return this.rawFile;
    }

    @Override
    public void setRawFile(IRawFile rawfile) {
        this.rawFile = rawfile;
    }

    @Override
    public int getMsLevel() {
        return this.msLevel;
    }

    @Override
    public double getParentMz() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Peakel getPeakel() {
        return this.getPeakels()[0];
    }

    @Override
    public Peakel[] getPeakels() {
        return this.mzdbFeature.getPeakels();
    }
}

