/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.mzscope.mzdb;

import com.almworks.sqlite4java.SQLiteConnection;
import com.almworks.sqlite4java.SQLiteException;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.Floats;
import fr.profi.mzdb.FeatureDetectorConfig;
import fr.profi.mzdb.MzDbFeatureDetector;
import fr.profi.mzdb.MzDbFeatureExtractor;
import fr.profi.mzdb.MzDbReader;
import fr.profi.mzdb.PeakelFinderConfig;
import fr.profi.mzdb.SmartPeakelFinderConfig;
import fr.profi.mzdb.XicMethod;
import fr.profi.mzdb.algo.feature.extraction.FeatureExtractorConfig;
import fr.profi.mzdb.db.model.SharedParamTree;
import fr.profi.mzdb.db.model.params.IsolationWindowParamTree;
import fr.profi.mzdb.db.model.params.Precursor;
import fr.profi.mzdb.db.model.params.param.CVParam;
import fr.profi.mzdb.db.model.params.param.UserText;
import fr.profi.mzdb.io.reader.provider.RunSliceDataProvider;
import fr.profi.mzdb.io.writer.MsSpectrumTSVWriter;
import fr.profi.mzdb.io.writer.mgf.MgfWriter;
import fr.profi.mzdb.model.AcquisitionMode;
import fr.profi.mzdb.model.DataEncoding;
import fr.profi.mzdb.model.DataMode;
import fr.profi.mzdb.model.Feature;
import fr.profi.mzdb.model.ILcContext;
import fr.profi.mzdb.model.Peak;
import fr.profi.mzdb.model.Peakel;
import fr.profi.mzdb.model.PutativeFeature;
import fr.profi.mzdb.model.RunSlice;
import fr.profi.mzdb.model.SpectrumData;
import fr.profi.mzdb.model.SpectrumHeader;
import fr.profi.mzdb.model.SpectrumSlice;
import fr.proline.mzscope.model.Chromatogram;
import fr.proline.mzscope.model.ExtractionRequest;
import fr.proline.mzscope.model.FeaturesExtractionRequest;
import fr.proline.mzscope.model.IChromatogram;
import fr.proline.mzscope.model.IExportParameters;
import fr.proline.mzscope.model.IFeature;
import fr.proline.mzscope.model.IPeakel;
import fr.proline.mzscope.model.IRawFile;
import fr.proline.mzscope.model.IonMobilityIndex;
import fr.proline.mzscope.model.IsolationWindow;
import fr.proline.mzscope.model.QCMetrics;
import fr.proline.mzscope.model.Spectrum;
import fr.proline.mzscope.model.TIMSMobilityIndex;
import fr.proline.mzscope.mzdb.MzdbFeatureWrapper;
import fr.proline.mzscope.mzdb.MzdbMetricsCollector;
import fr.proline.mzscope.mzdb.MzdbPeakelWrapper;
import fr.proline.mzscope.processing.PeakelsHelper;
import fr.proline.mzscope.processing.SpectrumUtils;
import fr.proline.mzscope.ui.MgfExportParameters;
import fr.proline.mzscope.ui.ScanHeaderExportParameters;
import fr.proline.mzscope.ui.ScanHeaderType;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.StreamCorruptedException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;
import scala.collection.JavaConversions;
import scala.collection.Seq;

public class MzdbRawFile
implements IRawFile {
    private static final Logger LOG = LoggerFactory.getLogger(MzdbRawFile.class);
    private static final DecimalFormat MASS_FORMATTER = new DecimalFormat("0.####");
    private static final DecimalFormat TIME_FORMATTER = new DecimalFormat("0.00");
    private final File mzDbFile;
    private MzDbReader reader;
    private SpectrumHeader[] ms2SpectrumHeaders = null;
    private double[] ms2SpectrumHeaderByMz = null;
    private double elutionStartTime = Double.NaN;
    private double elutionEndTime = Double.NaN;
    private boolean isDIAFile;
    private Map<SpectrumHeader, IsolationWindow> isolationWindowByHeaders;
    private Map<Integer, DataMode> dataModeByMsLevel = new HashMap<Integer, DataMode>();
    private boolean hasIonMobilitySeparation;
    private IonMobilityIndex ionMobilityIndex;

    public MzdbRawFile(File file) {
        this.mzDbFile = file;
        this.init();
    }

    public MzDbReader getMzDbReader() {
        return this.reader;
    }

    private void init() {
        try {
            this.reader = new MzDbReader(this.mzDbFile, true);
            this.isDIAFile = this.checkDIAFile();
            if (this.isDIAFile) {
                LOG.debug("MzdbRawFile " + this.getName() + " is a DIA File");
            }
            this.hasIonMobilitySeparation = this.hasIonMobilitySeparation();
            if (this.hasIonMobilitySeparation) {
                this.readIonMobilityIndexes();
                LOG.debug("MzdbRawFile " + this.getName() + " has Ion mobility separation");
            }
        }
        catch (SQLiteException | FileNotFoundException e) {
            LOG.error("cannot read file " + this.mzDbFile.getAbsolutePath(), e);
        }
    }

    private void buildMs2SpectrumHeaderIndexes(SpectrumHeader[] spectrums) {
        this.ms2SpectrumHeaders = SpectrumUtils.sortMs2SpectrumHeaders(spectrums);
        this.ms2SpectrumHeaderByMz = new double[this.ms2SpectrumHeaders.length];
        int i = 0;
        for (SpectrumHeader spectrum : this.ms2SpectrumHeaders) {
            this.ms2SpectrumHeaderByMz[i] = spectrum.getPrecursorMz();
            ++i;
        }
    }

    private double getElutionStartTime() {
        if (Double.isNaN(this.elutionStartTime)) {
            this.updateElutionTimes();
        }
        return this.elutionStartTime;
    }

    private double getElutionEndTime() {
        if (Double.isNaN(this.elutionEndTime)) {
            this.updateElutionTimes();
        }
        return this.elutionEndTime;
    }

    private void updateElutionTimes() {
        try {
            SpectrumHeader[] headers = this.reader.getSpectrumHeaders();
            this.elutionStartTime = Math.floor((double)headers[0].getElutionTime() / 60.0);
            this.elutionEndTime = Math.ceil((double)headers[headers.length - 1].getElutionTime() / 60.0);
        }
        catch (SQLiteException ex) {
            LOG.error("Cannot generate TIC chromatogram", (Throwable)ex);
        }
    }

    @Override
    public String getName() {
        return this.mzDbFile.getName();
    }

    @Override
    public File getFile() {
        return this.mzDbFile;
    }

    public String toString() {
        return this.mzDbFile.getName();
    }

    @Override
    public IChromatogram getTIC(int msLevel) {
        Chromatogram chromatogram = null;
        try {
            SpectrumHeader[] headers = msLevel < 0 ? this.reader.getSpectrumHeaders() : this.reader.getMs1SpectrumHeaders();
            double[] xAxisData = new double[headers.length];
            double[] yAxisData = new double[headers.length];
            for (int i = 0; i < headers.length; ++i) {
                xAxisData[i] = (double)headers[i].getElutionTime() / 60.0;
                yAxisData[i] = headers[i].getTIC();
            }
            if (Double.isNaN(this.elutionEndTime)) {
                this.elutionEndTime = (double)this.reader.getLastTime() / 60.0;
            }
            if (Double.isNaN(this.elutionStartTime)) {
                this.elutionStartTime = Math.floor(xAxisData[0]);
            }
            chromatogram = new Chromatogram(this.getName(), this.getName() + " TIC", xAxisData, yAxisData, this.getElutionStartTime(), this.getElutionEndTime());
            return chromatogram;
        }
        catch (SQLiteException ex) {
            LOG.error("Cannot generate TIC chromatogram", (Throwable)ex);
            return chromatogram;
        }
    }

    @Override
    public IChromatogram getBPI() {
        Chromatogram chromatogram = null;
        try {
            SpectrumHeader[] headers = this.reader.getSpectrumHeaders();
            double[] xAxisData = new double[headers.length];
            double[] yAxisData = new double[headers.length];
            for (int i = 0; i < headers.length; ++i) {
                xAxisData[i] = (double)headers[i].getElutionTime() / 60.0;
                yAxisData[i] = headers[i].getBasePeakIntensity();
            }
            chromatogram = new Chromatogram(this.getName(), this.getName() + " BPC", xAxisData, yAxisData, this.getElutionStartTime(), this.getElutionEndTime());
            return chromatogram;
        }
        catch (SQLiteException ex) {
            LOG.error("Cannot generate BPC chromatogram", (Throwable)ex);
            return chromatogram;
        }
    }

    @Override
    public IChromatogram getXIC(ExtractionRequest params) {
        long start = System.currentTimeMillis();
        Chromatogram chromatogram = null;
        LOG.info("Extract XIC with params : " + params.toString());
        DataMode dataMode = this.getDataMode(params.getMsLevel());
        XicMethod method = dataMode.equals((Object)DataMode.PROFILE) || dataMode.equals((Object)DataMode.FITTED) ? XicMethod.MAX : XicMethod.SUM;
        try {
            if (!this.hasIonMobilitySeparation() || params.getMobilityRequestType() == ExtractionRequest.Type.NONE) {
                Peak[] peaks = params.getMsLevel() > 1 ? this.reader.getMsnXIC(params.getMz(), params.getFragmentMz(), (double)params.getFragmentMzTolPPM() * params.getFragmentMz() / 1000000.0, params.getElutionTimeLowerBound(), params.getElutionTimeUpperBound(), method) : this.reader.getMsXicInMzRtRanges(params.getMinMz(), params.getMaxMz(), params.getElutionTimeLowerBound(), params.getElutionTimeUpperBound(), method);
                chromatogram = this.buildChromatogram(peaks, params);
            } else {
                SpectrumSlice[] spectrumSlices;
                if (params.getMsLevel() > 1) {
                    spectrumSlices = this.reader.getMsnSpectrumSlices(params.getMz(), params.getFragmentMz(), (double)params.getFragmentMzTolPPM() * params.getFragmentMz() / 1000000.0, params.getElutionTimeLowerBound(), params.getElutionTimeUpperBound());
                } else {
                    float minRtForRtree = params.getElutionTimeLowerBound() >= 0.0f ? params.getElutionTimeLowerBound() : 0.0f;
                    float maxRtForRtree = params.getElutionTimeUpperBound() > 0.0f ? params.getElutionTimeUpperBound() : (float)this.getElutionEndTime() * 60.0f;
                    spectrumSlices = this.reader.getMsSpectrumSlices(params.getMinMz(), params.getMaxMz(), minRtForRtree, maxRtForRtree);
                }
                Peak[] peaks = this._spectrumSlicesToXIC(spectrumSlices, params, method);
                chromatogram = this.buildChromatogram(peaks, params);
            }
            if (chromatogram == null) {
                LOG.info("mzdb extracted chromatogram is empty");
            }
            LOG.info("mzdb chromatogram extracted in {} ms", (Object)(System.currentTimeMillis() - start));
        }
        catch (SQLiteException | StreamCorruptedException e) {
            LOG.error("Error during chromatogram extraction", e);
        }
        return chromatogram;
    }

    private DataMode getDataMode(int msLevel) {
        try {
            if (!this.dataModeByMsLevel.containsKey(msLevel)) {
                SpectrumHeader[] headers;
                for (SpectrumHeader header : headers = this.reader.getSpectrumHeaders()) {
                    if (header.getMsLevel() != msLevel) continue;
                    this.dataModeByMsLevel.put(msLevel, this.reader.getSpectrumDataEncoding(header.getId()).getMode());
                }
            }
        }
        catch (SQLiteException e) {
            LOG.error("Error while reading DataMode", (Throwable)e);
        }
        return this.dataModeByMsLevel.get(msLevel);
    }

    private Chromatogram buildChromatogram(Peak[] peaks, ExtractionRequest params) {
        Chromatogram chromatogram = null;
        int msLevel = params.getMsLevel();
        if (peaks != null && peaks.length > 0) {
            ArrayList<Double> xAxisData = new ArrayList<Double>(peaks.length);
            ArrayList<Double> yAxisData = new ArrayList<Double>(peaks.length);
            try {
                int previousSpectrumId = (int)peaks[0].getLcContext().getSpectrumId();
                for (Peak peak : peaks) {
                    int spectrumId = (int)peak.getLcContext().getSpectrumId();
                    if (msLevel == 1 && previousSpectrumId != this.getPreviousSpectrumId(spectrumId, msLevel)) {
                        xAxisData.add((double)((SpectrumHeader)this.reader.getSpectrumHeaderById().get(this.getNextSpectrumId(previousSpectrumId, msLevel))).getElutionTime() / 60.0);
                        yAxisData.add(0.0);
                        if (this.getPreviousSpectrumId(spectrumId, msLevel) > this.getNextSpectrumId(previousSpectrumId, msLevel)) {
                            xAxisData.add((double)((SpectrumHeader)this.reader.getSpectrumHeaderById().get(this.getPreviousSpectrumId(spectrumId, msLevel))).getElutionTime() / 60.0);
                            yAxisData.add(0.0);
                        }
                    }
                    double rt = (double)peak.getLcContext().getElutionTime() / 60.0;
                    xAxisData.add(rt);
                    yAxisData.add(Double.valueOf(peak.getIntensity()));
                    previousSpectrumId = (int)peak.getLcContext().getSpectrumId();
                }
            }
            catch (SQLiteException sle) {
                LOG.error("Error while reading mzdb file", (Throwable)sle);
            }
            chromatogram = new Chromatogram(this.getName(), "", Doubles.toArray(xAxisData), Doubles.toArray(yAxisData), this.getElutionStartTime(), this.getElutionEndTime());
            chromatogram.setMinMz(params.getMsLevel() == 1 ? params.getMinMz() : params.getFragmentMinMz());
            chromatogram.setMaxMz(params.getMsLevel() == 1 ? params.getMaxMz() : params.getFragmentMaxMz());
            StringBuilder builder = new StringBuilder();
            builder.append("MS").append(params.getMsLevel()).append(" m/z: ");
            builder.append(MASS_FORMATTER.format(chromatogram.getMinMz())).append("-").append(MASS_FORMATTER.format(chromatogram.getMaxMz()));
            if (params.getMsLevel() > 1) {
                builder.append(" (prec m/z: ").append(MASS_FORMATTER.format(params.getMz())).append(')');
            }
            chromatogram.setTitle(builder.toString());
        }
        return chromatogram;
    }

    private Peak[] _spectrumSlicesToXIC(SpectrumSlice[] spectrumSlices, ExtractionRequest params, XicMethod method) {
        if (spectrumSlices == null) {
            LOG.warn("null detected");
        }
        if (spectrumSlices.length == 0) {
            return new Peak[0];
        }
        int minIndex = this.ionMobilityIndex.getIndex(params.getMinMobility());
        int maxIndex = this.ionMobilityIndex.getIndex(params.getMaxMobility());
        int minMobilityIndex = Math.min(minIndex, maxIndex);
        int maxMobilityIndex = Math.max(minIndex, maxIndex);
        int spectrumSlicesCount = spectrumSlices.length;
        ArrayList<Peak> xicPeaks = new ArrayList<Peak>(spectrumSlicesCount);
        switch (method) {
            case MAX: {
                for (int i = 0; i < spectrumSlicesCount; ++i) {
                    SpectrumSlice sl = spectrumSlices[i];
                    Peak[] peaks = this.toPeaks(sl, minMobilityIndex, maxMobilityIndex);
                    int peaksCount = peaks.length;
                    if (peaksCount == 0) continue;
                    Arrays.sort(peaks, Peak.getIntensityComp());
                    xicPeaks.add(peaks[peaksCount - 1]);
                }
                return xicPeaks.toArray(new Peak[xicPeaks.size()]);
            }
            case SUM: {
                for (int i = 0; i < spectrumSlicesCount; ++i) {
                    SpectrumSlice sl = spectrumSlices[i];
                    Peak[] peaks = this.toPeaks(sl, minMobilityIndex, maxMobilityIndex);
                    int peaksCount = peaks.length;
                    if (peaksCount == 0) continue;
                    Arrays.sort(peaks, Peak.getIntensityComp());
                    float sum = 0.0f;
                    for (Peak p : peaks) {
                        sum += p.getIntensity();
                    }
                    Peak refPeak = peaks[(int)Math.floor(0.5 * (double)peaksCount)];
                    xicPeaks.add(new Peak(refPeak.getMz(), sum, refPeak.getLeftHwhm(), refPeak.getRightHwhm(), refPeak.getLcContext()));
                }
                return xicPeaks.toArray(new Peak[xicPeaks.size()]);
            }
        }
        LOG.error("[_spectrumSlicesToXIC]: method must be one of 'MAX' or 'SUM', returning null");
        return null;
    }

    public Peak[] toPeaks(SpectrumSlice spectrumSlice, int minMobilityIndex, int maxMobilityIndex) {
        SpectrumData data = spectrumSlice.getData();
        ArrayList<Peak> peaks = new ArrayList<Peak>();
        float[] leftHwhmList = data.getLeftHwhmList();
        float[] rightHwhmList = data.getRightHwhmList();
        double[] mzList = data.getMzList();
        float[] intensityList = data.getIntensityList();
        for (int i = 0; i < data.getPeaksCount(); ++i) {
            float leftHwhm = 0.0f;
            float rightHwhm = 0.0f;
            if (leftHwhmList != null && rightHwhmList != null) {
                leftHwhm = leftHwhmList[i];
                rightHwhm = rightHwhmList[i];
            }
            peaks.add(new Peak(mzList[i], intensityList[i], leftHwhm, rightHwhm, (ILcContext)spectrumSlice.getHeader()));
        }
        return peaks.toArray(new Peak[peaks.size()]);
    }

    @Override
    public List<IPeakel> extractPeakels(FeaturesExtractionRequest params) {
        ArrayList<IPeakel> result = new ArrayList<IPeakel>();
        LOG.info("Extract peakels with params : " + params.toString());
        try {
            Iterator runSlices = params.getMinMz() <= 0.0 && params.getMaxMz() <= 0.0 ? (params.isMsnExtraction() ? this.getMzDbReader().getLcMsnRunSliceIterator(params.getMinMz(), params.getMaxMz()) : this.getMzDbReader().getLcMsRunSliceIterator()) : (params.isMsnExtraction() ? (params.getFragmentMinMz() <= 0.0 && params.getFragmentMaxMz() <= 0.0 ? this.getMzDbReader().getLcMsnRunSliceIterator(params.getMinMz(), params.getMaxMz()) : this.getMzDbReader().getLcMsnRunSliceIterator(params.getMinMz(), params.getMaxMz(), params.getFragmentMinMz(), params.getFragmentMaxMz())) : this.getMzDbReader().getLcMsRunSliceIterator(params.getMinMz(), params.getMaxMz()));
            FeatureDetectorConfig detectorConfig = this.buildFeatureDetectorConfig(params);
            MzDbFeatureDetector detector = new MzDbFeatureDetector(this.reader, detectorConfig);
            Peakel[] peakels = detector.detectPeakels(runSlices, Option.empty());
            double min = params.getMsLevel() == 1 ? params.getMinMz() : params.getFragmentMinMz();
            double max = params.getMsLevel() == 1 ? params.getMaxMz() : params.getFragmentMaxMz();
            LOG.info("{} peakels found", (Object)peakels.length);
            for (Peakel peakel : peakels) {
                MzdbPeakelWrapper feature;
                MzdbPeakelWrapper mzdbPeakelWrapper = feature = params.getMsLevel() == 1 ? new MzdbPeakelWrapper(peakel, this) : new MzdbPeakelWrapper(peakel, (IRawFile)this, this.getMzDbReader().getSpectrumHeader(peakel.getApexSpectrumId()).getPrecursorMz());
                if (min <= 0.0 && max <= 0.0) {
                    result.add(feature);
                    continue;
                }
                if (!(feature.getMz() >= min) || !(feature.getMz() <= max)) continue;
                result.add(feature);
            }
        }
        catch (SQLiteException | StreamCorruptedException ex) {
            LOG.error("Error while getting LcMs RunSlice Iterator: " + (Exception)ex);
        }
        catch (Exception e) {
            LOG.error("unexpected error ", (Throwable)e);
        }
        return result;
    }

    @Override
    public List<IFeature> extractFeatures(FeaturesExtractionRequest params) {
        switch (params.getExtractionMethod()) {
            case EXTRACT_MS2_FEATURES: {
                return this.extractFeaturesFromMs2(params.getMzTolPPM());
            }
            case DETECT_FEATURES: {
                return this.detectFeatures(params);
            }
        }
        return null;
    }

    private List<IFeature> detectFeatures(FeaturesExtractionRequest params) {
        ArrayList<IFeature> result = new ArrayList<IFeature>();
        FeatureDetectorConfig detectorConfig = this.buildFeatureDetectorConfig(params);
        MzDbFeatureDetector detector = new MzDbFeatureDetector(this.reader, detectorConfig);
        try {
            double minMz = params.getMinMz();
            double maxMz = params.getMaxMz();
            Iterator runSlices = minMz == 0.0 && maxMz == 0.0 ? this.getMzDbReader().getLcMsRunSliceIterator() : this.getMzDbReader().getLcMsRunSliceIterator(minMz, maxMz);
            Peakel[] peakels = detector.detectPeakels(runSlices, Option.empty());
            Iterator tmpRunSlices = minMz == 0.0 && maxMz == 0.0 ? this.getMzDbReader().getLcMsRunSliceIterator() : this.getMzDbReader().getLcMsRunSliceIterator(minMz, maxMz);
            this.logSliceBounds(tmpRunSlices);
            Arrays.sort(peakels, (p1, p2) -> Double.compare(p2.getApexIntensity(), p1.getApexIntensity()));
            long start = System.currentTimeMillis();
            PeakelsHelper helper = new PeakelsHelper(peakels);
            Map<String, List<Feature>> featuresMap = helper.deisotopePeakels(params.getMzTolPPM(), params.getCoelutionRtTolerance());
            featuresMap.get("valid features").forEach(f -> result.add(new MzdbFeatureWrapper((Feature)f, this, 1)));
            LOG.info("Deisotoping took {} ms", (Object)(System.currentTimeMillis() - start));
        }
        catch (SQLiteException | StreamCorruptedException ex) {
            LOG.error("Error while getting LcMs RunSlice Iterator: " + (Exception)ex);
        }
        return result;
    }

    private FeatureDetectorConfig buildFeatureDetectorConfig(FeaturesExtractionRequest params) {
        return new FeatureDetectorConfig(params.getMsLevel(), params.isMsnExtraction() ? params.getFragmentMzTolPPM() : params.getMzTolPPM(), 5, params.getIntensityPercentile(), params.getMaxConsecutiveGaps(), (PeakelFinderConfig)new SmartPeakelFinderConfig(params.getMinPeaksCount(), params.getMinmaxDistanceThreshold(), params.getMaxIntensityRelativeThreshold(), false, 10, false, params.isRemoveBaseline(), params.isUseSmoothing()));
    }

    private void logSliceBounds(Iterator<RunSlice> tmpRunSlices) {
        double min = Double.MAX_VALUE;
        double max = Double.MIN_VALUE;
        while (tmpRunSlices.hasNext()) {
            RunSlice rs = tmpRunSlices.next();
            min = Math.min(min, rs.getHeader().getBeginMz());
            max = Math.max(max, rs.getHeader().getEndMz());
        }
        LOG.info("Real bounds : " + min + " - " + max);
    }

    private List<IFeature> extractFeaturesFromMs2(float tolPPM) {
        ArrayList<IFeature> result = new ArrayList<IFeature>();
        try {
            LOG.info("retrieve spectrum headers...");
            SpectrumHeader[] readMs2SpectrumHeaders = this.reader.getMs2SpectrumHeaders();
            ArrayList<PutativeFeature> pfs = new ArrayList<PutativeFeature>();
            LOG.info("building putative features list from MS2 spectrum events...");
            for (SpectrumHeader spectrumH : readMs2SpectrumHeaders) {
                pfs.add(new PutativeFeature(PutativeFeature.generateNewId(), spectrumH.getPrecursorMz().doubleValue(), spectrumH.getPrecursorCharge().intValue(), spectrumH.getId(), 2));
            }
            List<Feature> mzdbResult = this.extractPutativeFeatures(pfs, tolPPM);
            for (Feature f : mzdbResult) {
                result.add(new MzdbFeatureWrapper(f, this, 1));
            }
        }
        catch (SQLiteException ex) {
            LOG.error("error while extracting features", (Throwable)ex);
        }
        return result;
    }

    private List<Feature> extractPutativeFeatures(List<PutativeFeature> pfs, float tolPPM) {
        ArrayList<Feature> result = new ArrayList<Feature>();
        try {
            RunSliceDataProvider rsdProv = new RunSliceDataProvider(this.reader.getLcMsRunSliceIterator());
            FeatureExtractorConfig extractorConfig = new FeatureExtractorConfig(tolPPM, 5, 1, 3, 1200.0f, 0.05f, Option.empty(), 90, Option.empty());
            MzDbFeatureExtractor extractor = new MzDbFeatureExtractor(this.reader, 5, 5, extractorConfig);
            List tmpresult = JavaConversions.seqAsJavaList((Seq)extractor.extractFeatures(rsdProv, (Seq)JavaConversions.asScalaBuffer(pfs), tolPPM));
            tmpresult.stream().forEach(f -> result.add((Feature)f));
        }
        catch (SQLiteException | StreamCorruptedException ex) {
            LOG.error("error while extracting features", ex);
        }
        return result;
    }

    @Override
    public Spectrum getSpectrum(int spectrumIndex, boolean forceFittedToCentroid) {
        Spectrum spectrum = null;
        try {
            Spectrum.ScanType scanType;
            fr.profi.mzdb.model.Spectrum rawSpectrum = this.reader.getSpectrum((long)spectrumIndex);
            SpectrumData data = rawSpectrum.getData();
            Map map = this.reader.getDataEncodingReader().getDataEncodingById();
            DataEncoding encoding = this.reader.getSpectrumDataEncoding((long)spectrumIndex);
            Spectrum.ScanType scanType2 = scanType = encoding.getMode().equals((Object)DataMode.CENTROID) ? Spectrum.ScanType.CENTROID : Spectrum.ScanType.PROFILE;
            if (forceFittedToCentroid) {
                Spectrum.ScanType scanType3 = scanType = encoding.getMode().equals((Object)DataMode.PROFILE) ? Spectrum.ScanType.PROFILE : Spectrum.ScanType.CENTROID;
            }
            if (!forceFittedToCentroid && data.getLeftHwhmList() != null && data.getRightHwhmList() != null && !encoding.getMode().equals((Object)DataMode.PROFILE)) {
                double[] mzList = data.getMzList();
                double[] leftSigma = new double[mzList.length];
                double[] rightSigma = new double[mzList.length];
                float[] intensityList = data.getIntensityList();
                ArrayList<Float> xAxisData = new ArrayList<Float>(mzList.length);
                ArrayList<Float> yAxisData = new ArrayList<Float>(mzList.length);
                for (int count = 0; count < mzList.length; ++count) {
                    double y;
                    int k;
                    leftSigma[count] = 2.0 * (double)data.getLeftHwhmList()[count] / 2.35482;
                    double x = mzList[count] - 4.0 * leftSigma[count];
                    if (!xAxisData.isEmpty()) {
                        for (k = xAxisData.size() - 1; k >= 0 && (double)((Float)xAxisData.get(k)).floatValue() >= x; --k) {
                        }
                        ++k;
                        while (k < xAxisData.size()) {
                            x = ((Float)xAxisData.get(k)).floatValue();
                            y = MzdbRawFile.getGaussianPoint(x, mzList[count], intensityList[count], leftSigma[count]);
                            yAxisData.set(k, Float.valueOf(((Float)yAxisData.get(k)).floatValue() + (float)y));
                            ++k;
                        }
                    }
                    while (x < mzList[count]) {
                        double y2 = MzdbRawFile.getGaussianPoint(x, mzList[count], intensityList[count], leftSigma[count]);
                        xAxisData.add(Float.valueOf((float)x));
                        yAxisData.add(Float.valueOf((float)y2));
                        x += leftSigma[count] / 2.0;
                    }
                    xAxisData.add(Float.valueOf((float)mzList[count]));
                    yAxisData.add(Float.valueOf(intensityList[count]));
                    rightSigma[count] = 2.0 * (double)data.getRightHwhmList()[count] / 2.35482;
                    x = mzList[count] + rightSigma[count] / 2.0;
                    if (!xAxisData.isEmpty()) {
                        for (k = xAxisData.size() - 1; k >= 0 && (double)((Float)xAxisData.get(k)).floatValue() > x; --k) {
                        }
                        ++k;
                        while (k < xAxisData.size()) {
                            x = ((Float)xAxisData.get(k)).floatValue();
                            y = MzdbRawFile.getGaussianPoint(x, mzList[count], intensityList[count], rightSigma[count]);
                            yAxisData.set(k, Float.valueOf(((Float)yAxisData.get(k)).floatValue() + (float)y));
                            ++k;
                        }
                    }
                    while (x < mzList[count] + 4.0 * rightSigma[count]) {
                        double y3 = MzdbRawFile.getGaussianPoint(x, mzList[count], intensityList[count], rightSigma[count]);
                        xAxisData.add(Float.valueOf((float)x));
                        yAxisData.add(Float.valueOf((float)y3));
                        x += rightSigma[count] / 2.0;
                    }
                }
                spectrum = new Spectrum(spectrumIndex, rawSpectrum.getHeader().getElutionTime(), Doubles.toArray(xAxisData), Floats.toArray(yAxisData), rawSpectrum.getHeader().getMsLevel(), scanType);
            } else {
                spectrum = new Spectrum((Integer)spectrumIndex, rawSpectrum.getHeader().getElutionTime(), data, rawSpectrum.getHeader().getMsLevel(), scanType);
            }
            spectrum.setTitle(rawSpectrum.getHeader().getTitle());
            if (spectrum.getMsLevel() == 2) {
                spectrum.setPrecursorMz(rawSpectrum.getHeader().getPrecursorMz());
                spectrum.setPrecursorCharge(rawSpectrum.getHeader().getPrecursorCharge());
            } else {
                spectrum.setPrecursorMz(null);
                spectrum.setPrecursorCharge(null);
            }
        }
        catch (SQLiteException | StreamCorruptedException ex) {
            LOG.error("enable to retrieve Spectrum data", ex);
        }
        catch (Exception e) {
            LOG.error("Error while retrieving Spectrum data", (Throwable)e);
        }
        return spectrum;
    }

    @Override
    public Spectrum getSpectrum(int spectrumIndex) {
        return this.getSpectrum(spectrumIndex, false);
    }

    @Override
    public double[] getElutionTimes(int msLevel) {
        try {
            SpectrumHeader[] headers = msLevel == 1 ? this.reader.getMs1SpectrumHeaders() : this.reader.getMs2SpectrumHeaders();
            return Arrays.stream(headers).mapToDouble(h -> (double)h.getElutionTime() / 60.0).toArray();
        }
        catch (SQLiteException e) {
            LOG.error("enable to retrieve spectrum headers");
            return null;
        }
    }

    @Override
    public double getSpectrumElutionTime(int spectrumIndex) {
        try {
            SpectrumHeader header = (SpectrumHeader)this.reader.getSpectrumHeaderById().get(spectrumIndex);
            return header.getElutionTime();
        }
        catch (SQLiteException e) {
            LOG.error("enable to retrieve Spectrum Id", (Throwable)e);
            return -1.0;
        }
    }

    @Override
    public int getSpectrumId(double retentionTime) {
        try {
            return (int)this.reader.getSpectrumHeaderForTime((float)retentionTime, 1).getSpectrumId();
        }
        catch (Exception ex) {
            LOG.error("enable to retrieve Spectrum Id", (Throwable)ex);
            return 0;
        }
    }

    @Override
    public int getNextSpectrumId(int spectrumIndex, int msLevel) {
        return this.getNextSiblingSpectrumId(spectrumIndex, msLevel, 1);
    }

    @Override
    public int getPreviousSpectrumId(int spectrumIndex, int msLevel) {
        return this.getNextSiblingSpectrumId(spectrumIndex, msLevel, -1);
    }

    private int getNextSiblingSpectrumId(int spectrumIndex, int msLevel, int way) {
        try {
            long k;
            SpectrumHeader header = (SpectrumHeader)this.reader.getSpectrumHeaderById().get(spectrumIndex);
            int maxSpectrum = this.reader.getSpectraCount();
            for (k = Math.max(1L, Math.min((long)maxSpectrum, header.getSpectrumId() + (long)way)); k > 0L && k < (long)maxSpectrum && ((SpectrumHeader)this.reader.getSpectrumHeaderById().get(k)).getMsLevel() != msLevel; k += (long)way) {
            }
            return (int)k;
        }
        catch (SQLiteException e) {
            LOG.error("Error while reading spectrumsCount", (Throwable)e);
            return 0;
        }
    }

    private static double getGaussianPoint(double mz, double peakMz, double intensity, double sigma) {
        return intensity * Math.exp(-((mz - peakMz) * (mz - peakMz)) / (2.0 * sigma * sigma));
    }

    public static void main(String[] args) {
        for (double m = 500.0; m < 510.0; m += 0.1) {
            System.out.println(m + "\t" + MzdbRawFile.getGaussianPoint(m, 502.0, 100.0, 1.0));
        }
    }

    @Override
    public List<Float> getMsMsEvent(double minMz, double maxMz) {
        Long startTime = System.currentTimeMillis();
        ArrayList<Float> listMsMsEventTime = new ArrayList<Float>();
        if (this.ms2SpectrumHeaders == null) {
            try {
                LOG.debug("retrieve Ms2 SpectrumHeader");
                this.buildMs2SpectrumHeaderIndexes(this.reader.getMs2SpectrumHeaders());
            }
            catch (SQLiteException ex) {
                LOG.error("Exception while retrieving SpectrumHeader " + ex);
            }
        }
        if (this.ms2SpectrumHeaders != null) {
            int minId = ~Arrays.binarySearch(this.ms2SpectrumHeaderByMz, minMz);
            int maxId = ~Arrays.binarySearch(this.ms2SpectrumHeaderByMz, maxMz);
            if (minId != -1 && maxId != -1) {
                for (int i = minId; i <= maxId; ++i) {
                    SpectrumHeader spectrumHeader = this.ms2SpectrumHeaders[i];
                    double mz = spectrumHeader.getPrecursorMz();
                    if (!(mz >= minMz) || !(mz <= maxMz)) continue;
                    listMsMsEventTime.add(Float.valueOf(spectrumHeader.getElutionTime()));
                }
            }
        }
        LOG.debug("retrieve MS/MS events finished in " + (System.currentTimeMillis() - startTime) + "+ ms");
        return listMsMsEventTime;
    }

    @Override
    public int getSpectrumCount() {
        try {
            return this.reader.getSpectraCount();
        }
        catch (SQLiteException sle) {
            LOG.error("Error while reading mzdb file", (Throwable)sle);
            return 0;
        }
    }

    @Override
    public boolean exportRawFile(String outputFileName, IExportParameters exportParams) {
        long start = System.currentTimeMillis();
        IExportParameters.ExportType exportType = exportParams.getExportType();
        switch (exportType) {
            case MGF: {
                try {
                    MgfExportParameters mgfExportParam = (MgfExportParameters)exportParams;
                    LOG.debug("MGF writer start for " + this.getName() + ": mgfFilePath=" + outputFileName + ", precursorMzComputation=" + mgfExportParam.getPrecComp().getMethodName() + ", mzTol=" + mgfExportParam.getMzTolPPM() + ", intensityCutoff=" + mgfExportParam.getIntensityCutoff() + ", exportProlineTitle=" + mgfExportParam.isExportProlineTitle());
                    MgfWriter writer = new MgfWriter(this.getFile().getAbsolutePath());
                    writer.write(outputFileName, mgfExportParam.getPrecComp(), mgfExportParam.getIntensityCutoff(), mgfExportParam.isExportProlineTitle());
                    LOG.debug(" mgf created in " + (System.currentTimeMillis() - start) + " ms");
                    break;
                }
                catch (SQLiteException ex) {
                    LOG.error("SQLiteException while exporting mgf file", (Throwable)ex);
                    return false;
                }
                catch (FileNotFoundException ex) {
                    LOG.error("FileNotFoundException while exporting mgf file: ", (Throwable)ex);
                    return false;
                }
                catch (IOException ex) {
                    LOG.error("IOException while exporting mgf file: ", (Throwable)ex);
                    return false;
                }
            }
            case SCAN_HEADER: {
                SpectrumHeader[] spectrumHeaders;
                ScanHeaderExportParameters scanHeaderExportParam = (ScanHeaderExportParameters)exportParams;
                ScanHeaderType type = scanHeaderExportParam.getScanHeadertype();
                File outFile = new File(outputFileName);
                switch (type) {
                    case MS1: {
                        try {
                            spectrumHeaders = this.reader.getMs1SpectrumHeaders();
                            break;
                        }
                        catch (SQLiteException ex) {
                            LOG.error("SQLiteException while exporting spectrum Header file", (Throwable)ex);
                            return false;
                        }
                    }
                    case MS2: {
                        try {
                            spectrumHeaders = this.reader.getMs2SpectrumHeaders();
                            break;
                        }
                        catch (SQLiteException ex) {
                            LOG.error("SQLiteException while exporting scpectrum Header file", (Throwable)ex);
                            return false;
                        }
                    }
                    default: {
                        spectrumHeaders = new SpectrumHeader[]{};
                    }
                }
                MsSpectrumTSVWriter.writeRun((SpectrumHeader[])spectrumHeaders, (Integer)-1, (File)outFile);
                LOG.debug(" scan header file created in " + (System.currentTimeMillis() - start) + " ms");
                break;
            }
        }
        return true;
    }

    private boolean checkDIAFile() {
        try {
            AcquisitionMode acqMode = this.reader.getAcquisitionMode();
            if (acqMode != null && acqMode.equals((Object)AcquisitionMode.SWATH)) {
                return true;
            }
        }
        catch (SQLiteException ex) {
            LOG.error("Check DIA: SQLiteException while reading acquisition mode", (Throwable)ex);
            return false;
        }
        return false;
    }

    @Override
    public boolean isDIAFile() {
        return this.isDIAFile;
    }

    @Override
    public boolean hasIonMobilitySeparation() {
        return false;
    }

    protected void readIonMobilityIndexes() {
        try {
            Optional<SharedParamTree> ionMobilityParams = this.reader.getSharedParamTreeList().stream().filter(sp -> sp.getSchemaName().equals("IonMobilityParams")).findFirst();
            if (ionMobilityParams.isPresent()) {
                String text = ((UserText)ionMobilityParams.get().getData().getUserTexts().get(0)).getText();
                String[] lines = text.split("\n");
                List stringList = Arrays.stream(lines).filter(s -> s.contains(";")).collect(Collectors.toList());
                double[] mobilities = new double[stringList.size()];
                for (String s2 : stringList) {
                    int idx = s2.indexOf(59);
                    mobilities[Integer.parseInt((String)s2.substring((int)0, (int)idx))] = Double.parseDouble(s2.substring(idx + 1));
                }
                this.ionMobilityIndex = new TIMSMobilityIndex(mobilities);
            }
        }
        catch (SQLiteException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Map<String, Object> getFileProperties() {
        try {
            return MzdbMetricsCollector.getFileFormatData(this.getMzDbReader());
        }
        catch (SQLiteException ex) {
            LOG.error("Enable to extract information from mzdb file", (Throwable)ex);
            return null;
        }
    }

    @Override
    public QCMetrics getFileMetrics() {
        try {
            QCMetrics metrics = MzdbMetricsCollector.getMSMetrics(this);
            return metrics;
        }
        catch (SQLiteException ex) {
            LOG.error("Enable to extract information from mzdb file", (Throwable)ex);
            return null;
        }
    }

    @Override
    public void closeIRawFile() {
        this.reader.close();
    }

    @Override
    public IonMobilityIndex getIonMobilityIndex() {
        return this.ionMobilityIndex;
    }

    @Override
    public Map<SpectrumHeader, IsolationWindow> getIsolationWindowByMs2Headers() {
        if (!this.isDIAFile) {
            return null;
        }
        if (this.isolationWindowByHeaders == null) {
            try {
                this.isolationWindowByHeaders = MzdbRawFile.retrieveTrueIsolationWindows(this.reader);
            }
            catch (SQLiteException e) {
                return null;
            }
        }
        return this.isolationWindowByHeaders;
    }

    private static Map<SpectrumHeader, IsolationWindow> retrieveTrueIsolationWindows(MzDbReader reader) throws SQLiteException {
        HashMap<SpectrumHeader, IsolationWindow> windows = new HashMap<SpectrumHeader, IsolationWindow>();
        SpectrumHeader[] headers = reader.getMs2SpectrumHeaders();
        SpectrumHeader.loadPrecursors((SpectrumHeader[])headers, (SQLiteConnection)reader.getConnection());
        for (SpectrumHeader header : headers) {
            Precursor precursor = header.getPrecursor();
            if (precursor == null) continue;
            String center = null;
            String upper = null;
            String lower = null;
            IsolationWindowParamTree tree = precursor.getIsolationWindow();
            for (CVParam cvParam : tree.getCVParams()) {
                if (cvParam.getAccession().equals("MS:1000827")) {
                    center = cvParam.getValue();
                    continue;
                }
                if (cvParam.getAccession().equals("MS:1000828")) {
                    lower = cvParam.getValue();
                    continue;
                }
                if (!cvParam.getAccession().equals("MS:1000829")) continue;
                upper = cvParam.getValue();
            }
            windows.put(header, new IsolationWindow(center, Double.valueOf(center) - Double.valueOf(lower), Double.valueOf(center) + Double.valueOf(upper)));
        }
        return windows;
    }
}

