/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.mzscope.processing;

import fr.profi.ms.algo.IsotopePatternEstimator;
import fr.profi.ms.model.TheoreticalIsotopePattern;
import fr.profi.mzdb.model.SpectrumData;
import fr.proline.mzscope.processing.Scorer;
import fr.proline.mzscope.processing.SpectrumUtils;
import java.util.Arrays;
import scala.Tuple2;

public class LeastSquareScorer
implements Scorer {
    @Override
    public Tuple2<Double, TheoreticalIsotopePattern> score(SpectrumData currentSpectrum, double intialMz, int shift, int charge, double ppmTol) {
        double score = 0.0;
        double mz = intialMz - (double)shift * IsotopePatternEstimator.avgIsoMassDiff() / (double)charge;
        TheoreticalIsotopePattern pattern = IsotopePatternEstimator.getTheoreticalPattern((double)mz, (int)charge);
        double scale = currentSpectrum.getIntensityList()[SpectrumUtils.getNearestPeakIndex(currentSpectrum.getMzList(), intialMz)] / ((Float)pattern.mzAbundancePairs()[shift]._2).floatValue();
        Double ipMoz = mz;
        double[] observed = new double[pattern.mzAbundancePairs().length];
        double[] expected = new double[pattern.mzAbundancePairs().length];
        int observations = 0;
        for (int rank = 0; rank < pattern.mzAbundancePairs().length; ++rank) {
            ipMoz = rank == 0 ? ipMoz : ipMoz + IsotopePatternEstimator.avgIsoMassDiff() / (double)charge;
            int nearestPeakIdx = SpectrumUtils.getNearestPeakIndex(currentSpectrum.getMzList(), ipMoz);
            if (1000000.0 * Math.abs(currentSpectrum.getMzList()[nearestPeakIdx] - ipMoz) / ipMoz < ppmTol) {
                observed[rank] = currentSpectrum.getIntensityList()[nearestPeakIdx];
                ++observations;
            } else {
                observed[rank] = (double)(-((Float)pattern.mzAbundancePairs()[rank]._2).floatValue()) * scale;
            }
            expected[rank] = ((Float)pattern.mzAbundancePairs()[rank]._2).floatValue();
        }
        score = LeastSquareScorer.leastSquare(observed, expected);
        return new Tuple2((Object)score, (Object)pattern);
    }

    private static double leastSquare(double[] observed, double[] expected) {
        double sumExpected = 0.0;
        double score = 0.0;
        double max = Arrays.stream(observed).max().getAsDouble();
        for (int k = 0; k < observed.length && expected[k] > 0.1; ++k) {
            score += (100.0 * observed[k] / max - expected[k]) * (100.0 * observed[k] / max - expected[k]);
            sumExpected += expected[k] * expected[k];
        }
        return sumExpected == 0.0 ? 0.0 : score / sumExpected;
    }
}

