/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.mzscope.processing;

import com.google.common.primitives.Doubles;
import com.google.common.primitives.Floats;
import fr.profi.ms.model.TheoreticalIsotopePattern;
import fr.profi.mzdb.algo.signal.filtering.SavitzkyGolaySmoother;
import fr.profi.mzdb.algo.signal.filtering.SavitzkyGolaySmoothingConfig;
import fr.profi.mzdb.model.DataMode;
import fr.profi.mzdb.model.Peakel;
import fr.profi.mzdb.model.SpectrumData;
import fr.profi.mzdb.model.SpectrumHeader;
import fr.profi.mzdb.peakeldb.PeakelDbHelper;
import fr.proline.mzscope.model.Spectrum;
import fr.proline.mzscope.processing.IsotopicPatternUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.stream.IntStream;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.math3.stat.correlation.PearsonsCorrelation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple2;

public class SpectrumUtils {
    private static final Logger logger = LoggerFactory.getLogger(SpectrumUtils.class);
    public static final double MIN_CORRELATION_SCORE = 0.5;

    public static SpectrumHeader[] sortMs2SpectrumHeaders(SpectrumHeader[] spectrums) {
        SpectrumHeader[] ms2SpectrumHeaders = null;
        if (spectrums != null) {
            int nbSc = spectrums.length;
            ms2SpectrumHeaders = new SpectrumHeader[nbSc];
            List<SpectrumHeader> list = Arrays.asList(spectrums);
            Collections.sort(list, new Comparator<SpectrumHeader>(){

                @Override
                public int compare(SpectrumHeader sc1, SpectrumHeader sc2) {
                    if (sc1.getPrecursorMz() <= sc2.getPrecursorMz()) {
                        return -1;
                    }
                    return 1;
                }
            });
            ms2SpectrumHeaders = list.toArray(new SpectrumHeader[nbSc]);
        }
        return ms2SpectrumHeaders;
    }

    public static int getNearestPeakIndex(double[] peaksMz, double value) {
        int idx = Arrays.binarySearch(peaksMz, value);
        idx = idx < 0 ? ~idx : idx;
        double min = Double.MAX_VALUE;
        for (int k = Math.max(0, idx - 1); k <= Math.min(peaksMz.length - 1, idx + 1); ++k) {
            if (!(Math.abs(peaksMz[k] - value) < min)) continue;
            min = Math.abs(peaksMz[k] - value);
            idx = k;
        }
        return idx;
    }

    public static int getPeakIndex(double[] peaksMz, double value, double ppmTol) {
        int idx = Arrays.binarySearch(peaksMz, value);
        idx = idx < 0 ? ~idx : idx;
        double min = Double.MAX_VALUE;
        int resultIdx = -1;
        for (int k = Math.max(0, idx - 1); k <= Math.min(peaksMz.length - 1, idx + 1); ++k) {
            if (!(1000000.0 * Math.abs(peaksMz[k] - value) / value < ppmTol) || !(Math.abs(peaksMz[k] - value) < min)) continue;
            min = Math.abs(peaksMz[k] - value);
            resultIdx = k;
        }
        return resultIdx;
    }

    public static boolean isInRange(double m1, double m2, double ppmTol) {
        return 1000000.0 * Math.abs(m1 - m2) / m2 < ppmTol;
    }

    public static int findPeakIndex(Peakel[] peakels, Pair<Double, Integer>[] peakelIndexesByMz, double moz, Peakel referencePeakel, float mzTolPPM) {
        double min = Double.MAX_VALUE;
        int resultIdx = -1;
        Comparator<Pair<Double, Integer>> c = new Comparator<Pair<Double, Integer>>(){

            @Override
            public int compare(Pair<Double, Integer> o1, Pair<Double, Integer> o2) {
                return Double.compare((Double)o1.getLeft(), (Double)o2.getLeft());
            }
        };
        int lowerIdx = Arrays.binarySearch(peakelIndexesByMz, new ImmutablePair((Object)(moz - moz * (double)mzTolPPM / 1000000.0), (Object)0), c);
        lowerIdx = lowerIdx < 0 ? Math.max(0, ~lowerIdx - 1) : Math.max(0, lowerIdx - 1);
        int upperIdx = Arrays.binarySearch(peakelIndexesByMz, new ImmutablePair((Object)(moz + moz * (double)mzTolPPM / 1000000.0), (Object)0), c);
        upperIdx = upperIdx < 0 ? Math.min(peakelIndexesByMz.length - 1, ~upperIdx) : Math.min(peakelIndexesByMz.length - 1, upperIdx + 1);
        for (int i = lowerIdx; i <= upperIdx; ++i) {
            int k = (Integer)peakelIndexesByMz[i].getRight();
            if (!(1000000.0 * Math.abs(peakels[k].getMz() - moz) / moz < (double)mzTolPPM) || !((double)(Math.abs(peakels[k].getElutionTime() - referencePeakel.getElutionTime()) / referencePeakel.calcDuration()) < 0.25) || !(Math.abs(peakels[k].getMz() - moz) < min)) continue;
            min = Math.abs(peakels[k].getMz() - moz);
            resultIdx = k;
        }
        return resultIdx;
    }

    public static int findCorrelatingPeakelIndex(Peakel[] peakels, Pair<Double, Integer>[] peakelIndexesByMz, double moz, Peakel referencePeakel, float mzTolPPM) {
        double maxCorr = Double.MIN_VALUE;
        int resultIdx = -1;
        Comparator<Pair<Double, Integer>> c = new Comparator<Pair<Double, Integer>>(){

            @Override
            public int compare(Pair<Double, Integer> o1, Pair<Double, Integer> o2) {
                return Double.compare((Double)o1.getLeft(), (Double)o2.getLeft());
            }
        };
        int lowerIdx = Arrays.binarySearch(peakelIndexesByMz, new ImmutablePair((Object)(moz - moz * (double)mzTolPPM / 1000000.0), (Object)0), c);
        lowerIdx = lowerIdx < 0 ? Math.max(0, ~lowerIdx - 1) : Math.max(0, lowerIdx - 1);
        int upperIdx = Arrays.binarySearch(peakelIndexesByMz, new ImmutablePair((Object)(moz + moz * (double)mzTolPPM / 1000000.0), (Object)0), c);
        upperIdx = upperIdx < 0 ? Math.min(peakelIndexesByMz.length - 1, ~upperIdx) : Math.min(peakelIndexesByMz.length - 1, upperIdx + 1);
        for (int i = lowerIdx; i <= upperIdx; ++i) {
            double corr;
            int k = (Integer)peakelIndexesByMz[i].getRight();
            if (!(1000000.0 * Math.abs(peakels[k].getMz() - moz) / moz < (double)mzTolPPM) || !(peakels[k].getElutionTime() >= referencePeakel.getFirstElutionTime()) || !(peakels[k].getElutionTime() <= referencePeakel.getLastElutionTime()) || !((corr = SpectrumUtils.correlation(referencePeakel, peakels[k])) > 0.5) || !(corr > maxCorr)) continue;
            maxCorr = corr;
            resultIdx = k;
        }
        return resultIdx;
    }

    public static double correlation(Peakel p1, Peakel p2) {
        int nbrPoints = Math.min(p1.peaksCount() / 4, 9);
        SavitzkyGolaySmoother smoother = new SavitzkyGolaySmoother(new SavitzkyGolaySmoothingConfig(nbrPoints, 2, 1));
        Peakel sp1 = nbrPoints > 0 ? smoother.smoothPeakel(p1) : p1;
        nbrPoints = Math.min(p2.peaksCount() / 4, 9);
        smoother = new SavitzkyGolaySmoother(new SavitzkyGolaySmoothingConfig(nbrPoints, 2, 1));
        Peakel sp2 = nbrPoints > 0 ? smoother.smoothPeakel(p2) : p2;
        return SpectrumUtils.correlation(sp1.getElutionTimes(), sp1.getIntensityValues(), sp2.getElutionTimes(), sp2.getIntensityValues());
    }

    public static double correlationOMP(Peakel p1, Peakel p2, boolean smooth) {
        if (smooth) {
            int nbrPoints = Math.min(p1.peaksCount() / 4, 9);
            SavitzkyGolaySmoother smoother = new SavitzkyGolaySmoother(new SavitzkyGolaySmoothingConfig(nbrPoints, 2, 1));
            Peakel sp1 = smoother.smoothPeakel(p1);
            nbrPoints = Math.min(p2.peaksCount() / 4, 9);
            smoother = new SavitzkyGolaySmoother(new SavitzkyGolaySmoothingConfig(nbrPoints, 2, 1));
            Peakel sp2 = smoother.smoothPeakel(p2);
            return PeakelDbHelper.computeCorrelation((Peakel)sp1, (Peakel)sp2);
        }
        return PeakelDbHelper.computeCorrelation((Peakel)p1, (Peakel)p2);
    }

    public static double correlation(float[] x1, float[] y1, float[] x2, float[] y2) {
        Pair<double[], double[]> values = SpectrumUtils.zipValues(x1, y1, x2, y2);
        PearsonsCorrelation pearson = new PearsonsCorrelation();
        double corr = pearson.correlation((double[])values.getLeft(), (double[])values.getRight());
        return corr;
    }

    public static double correlation(double[] x1, double[] y1, double[] x2, double[] y2) {
        Pair<double[], double[]> values = SpectrumUtils.zipValues(x1, y1, x2, y2);
        PearsonsCorrelation pearson = new PearsonsCorrelation();
        double corr = pearson.correlation((double[])values.getLeft(), (double[])values.getRight());
        return corr;
    }

    public static Pair<double[], double[]> zipValues(double[] x1, double[] y1, double[] x2, double[] y2) {
        int offset1 = 0;
        int offset2 = 0;
        double[] c = Arrays.copyOf(x1, x1.length + x2.length);
        System.arraycopy(x2, 0, c, x1.length, x2.length);
        double[] time = Arrays.stream(c).sorted().distinct().toArray();
        double[] a1 = new double[time.length];
        double[] a2 = new double[time.length];
        for (int k = 0; k < time.length; ++k) {
            a1[k] = 0.0;
            a2[k] = 0.0;
            while (offset1 < x1.length && time[k] == x1[offset1]) {
                a1[k] = y1[offset1];
                ++offset1;
            }
            while (offset2 < x2.length && time[k] == x2[offset2]) {
                a2[k] = y2[offset2];
                ++offset2;
            }
        }
        return new ImmutablePair((Object)a1, (Object)a2);
    }

    public static Pair<double[], double[]> zipValues(float[] x1, float[] y1, float[] x2, float[] y2) {
        int offset1 = 0;
        int offset2 = 0;
        float[] c = Arrays.copyOf(x1, x1.length + x2.length);
        System.arraycopy(x2, 0, c, x1.length, x2.length);
        double[] time = IntStream.range(0, c.length).mapToDouble(i -> c[i]).sorted().distinct().toArray();
        double[] a1 = new double[time.length];
        double[] a2 = new double[time.length];
        for (int k = 0; k < time.length; ++k) {
            a1[k] = 0.0;
            a2[k] = 0.0;
            while (offset1 < x1.length && time[k] == (double)x1[offset1]) {
                a1[k] = y1[offset1];
                ++offset1;
            }
            while (offset2 < x2.length && time[k] == (double)x2[offset2]) {
                a2[k] = y2[offset2];
                ++offset2;
            }
        }
        return new ImmutablePair((Object)a1, (Object)a2);
    }

    public static Spectrum buildSpectrum(double[] mzList, float[] intensityList, double fwhm, DataMode mode) {
        ArrayList<Float> xAxisData = new ArrayList<Float>(mzList.length);
        ArrayList<Float> yAxisData = new ArrayList<Float>(mzList.length);
        double[] leftSigma = new double[mzList.length];
        double[] rightSigma = new double[mzList.length];
        for (int count = 0; count < mzList.length; ++count) {
            double y;
            int k;
            double x;
            if (fwhm > 0.0 && !mode.equals((Object)DataMode.PROFILE)) {
                leftSigma[count] = 2.0 * fwhm / 2.35482;
                x = mzList[count] - 4.0 * leftSigma[count];
                if (!xAxisData.isEmpty()) {
                    for (k = xAxisData.size() - 1; k >= 0 && (double)((Float)xAxisData.get(k)).floatValue() >= x; --k) {
                    }
                    ++k;
                    while (k < xAxisData.size()) {
                        x = ((Float)xAxisData.get(k)).floatValue();
                        y = SpectrumUtils.getGaussianPoint(x, mzList[count], intensityList[count], leftSigma[count]);
                        yAxisData.set(k, Float.valueOf(((Float)yAxisData.get(k)).floatValue() + (float)y));
                        ++k;
                    }
                }
                while (x < mzList[count]) {
                    double y2 = SpectrumUtils.getGaussianPoint(x, mzList[count], intensityList[count], leftSigma[count]);
                    xAxisData.add(Float.valueOf((float)x));
                    yAxisData.add(Float.valueOf((float)y2));
                    x += leftSigma[count] / 2.0;
                }
            }
            xAxisData.add(Float.valueOf((float)mzList[count]));
            yAxisData.add(Float.valueOf(intensityList[count]));
            if (!(fwhm > 0.0) || mode.equals((Object)DataMode.PROFILE)) continue;
            rightSigma[count] = 2.0 * fwhm / 2.35482;
            x = mzList[count] + rightSigma[count] / 2.0;
            if (!xAxisData.isEmpty()) {
                for (k = xAxisData.size() - 1; k >= 0 && (double)((Float)xAxisData.get(k)).floatValue() > x; --k) {
                }
                ++k;
                while (k < xAxisData.size()) {
                    x = ((Float)xAxisData.get(k)).floatValue();
                    y = SpectrumUtils.getGaussianPoint(x, mzList[count], intensityList[count], rightSigma[count]);
                    yAxisData.set(k, Float.valueOf(((Float)yAxisData.get(k)).floatValue() + (float)y));
                    ++k;
                }
            }
            while (x < mzList[count] + 4.0 * rightSigma[count]) {
                double y3 = SpectrumUtils.getGaussianPoint(x, mzList[count], intensityList[count], rightSigma[count]);
                xAxisData.add(Float.valueOf((float)x));
                yAxisData.add(Float.valueOf((float)y3));
                x += rightSigma[count] / 2.0;
            }
        }
        Spectrum.ScanType scanType = mode.equals((Object)DataMode.CENTROID) ? Spectrum.ScanType.CENTROID : Spectrum.ScanType.PROFILE;
        Spectrum spectrum = new Spectrum(0, 0.0f, Doubles.toArray(xAxisData), Floats.toArray(yAxisData), 1, scanType);
        spectrum.setPrecursorMz(null);
        spectrum.setPrecursorCharge(null);
        return spectrum;
    }

    private static double getGaussianPoint(double mz, double peakMz, double intensity, double sigma) {
        return intensity * Math.exp(-((mz - peakMz) * (mz - peakMz)) / (2.0 * sigma * sigma));
    }

    public static Spectrum deisotopeCentroidSpectrum(Spectrum spectrum) {
        Object p;
        int k;
        double tolPpm = 20.0;
        double[] masses = spectrum.getMasses();
        float[] intensities = spectrum.getIntensities();
        SpectrumData spectrumData = spectrum.getSpectrumData();
        ArrayList<Peak> peaks = new ArrayList<Peak>(spectrumData.getPeaksCount());
        ArrayList<Peak> result = new ArrayList<Peak>(spectrumData.getPeaksCount());
        HashMap<Integer, Peak> peaksByIndex = new HashMap<Integer, Peak>();
        for (k = 0; k < masses.length; ++k) {
            p = new Peak(masses[k], intensities[k], k);
            peaks.add((Peak)p);
            peaksByIndex.put(((Peak)p).index, (Peak)p);
        }
        peaks.sort((o1, o2) -> Float.compare(o2.intensity, o1.intensity));
        for (k = 0; k < peaks.size(); ++k) {
            p = (Peak)peaks.get(k);
            if (((Peak)p).used) continue;
            Tuple2<Object, TheoreticalIsotopePattern> prediction = IsotopicPatternUtils.predictIsotopicPattern(spectrumData, ((Peak)p).mass, tolPpm);
            if (1000000.0 * (((TheoreticalIsotopePattern)prediction._2).monoMz() - ((Peak)p).mass) / ((Peak)p).mass <= tolPpm) {
                Peak newPeak;
                float intensity = 0.0f;
                int charge = ((TheoreticalIsotopePattern)prediction._2).charge();
                for (Tuple2 t : ((TheoreticalIsotopePattern)prediction._2).mzAbundancePairs()) {
                    Double mz = (Double)t._1;
                    Float ab = (Float)t._2;
                    int peakIdx = SpectrumUtils.getPeakIndex(spectrumData.getMzList(), mz, tolPpm);
                    if (peakIdx == -1 || !(spectrumData.getIntensityList()[peakIdx] <= ((Peak)p).intensity)) break;
                    intensity += spectrumData.getIntensityList()[peakIdx];
                    ((Peak)peaksByIndex.get((Object)Integer.valueOf((int)peakIdx))).used = true;
                }
                if (charge == 1 || intensity == ((Peak)p).intensity) {
                    newPeak = new Peak(((Peak)p).mass, intensity, ((Peak)p).index);
                    result.add(newPeak);
                    continue;
                }
                newPeak = new Peak(((Peak)p).mass * (double)charge - (double)(charge - 1) * 1.00728, intensity, ((Peak)p).index);
                logger.info("Move peak ({},{}) to ({},{})", new Object[]{((Peak)p).mass, Float.valueOf(((Peak)p).intensity), newPeak.mass, Float.valueOf(newPeak.intensity)});
                result.add(newPeak);
                continue;
            }
            ((Peak)p).used = true;
            result.add(new Peak((Peak)p));
        }
        result.sort(Comparator.comparingDouble(o -> o.mass));
        masses = new double[result.size()];
        intensities = new float[result.size()];
        k = 0;
        for (Peak p2 : result) {
            masses[k] = p2.mass;
            intensities[k++] = p2.intensity;
        }
        Spectrum newSpectrum = new Spectrum(-1, spectrum.getRetentionTime(), masses, intensities, spectrum.getMsLevel(), Spectrum.ScanType.CENTROID);
        return newSpectrum;
    }

    static class Peak {
        final double mass;
        final float intensity;
        final int index;
        boolean used = false;

        public Peak(Peak peak) {
            this(peak.mass, peak.intensity, peak.index);
        }

        public Peak(double mass, float intensity, int index) {
            this.mass = mass;
            this.intensity = intensity;
            this.index = index;
        }
    }
}

