/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.mzscope.ui;

import fr.proline.mzscope.model.IChromatogram;
import fr.proline.mzscope.model.IPeakel;
import fr.proline.mzscope.ui.event.AxisRangeChromatogramListener;
import fr.proline.mzscope.ui.model.ChromatogramTableModel;
import fr.proline.mzscope.utils.Display;
import fr.proline.studio.Exceptions;
import fr.proline.studio.extendedtablemodel.ExtendedTableModelInterface;
import fr.proline.studio.graphics.BasePlotPanel;
import fr.proline.studio.graphics.PlotBaseAbstract;
import fr.proline.studio.graphics.PlotLinear;
import fr.proline.studio.graphics.PlotPanel;
import fr.proline.studio.graphics.PlotPanelListener;
import fr.proline.studio.graphics.PlotXYAbstract;
import fr.proline.studio.graphics.marker.AbstractMarker;
import fr.proline.studio.graphics.marker.LineMarker;
import fr.proline.studio.graphics.measurement.AbstractMeasurement;
import fr.proline.studio.graphics.measurement.IntegralMeasurement;
import fr.proline.studio.utils.CyclicColorPalette;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChromatogramPanel
extends JPanel
implements PlotPanelListener {
    private static final Logger logger = LoggerFactory.getLogger(ChromatogramPanel.class);
    public static final String SCAN_TIME = "scan time";
    protected BasePlotPanel chromatogramPlotPanel;
    protected List<PlotLinear> chromatogramPlots;
    protected IChromatogram currentChromatogram;
    protected List<IChromatogram> listChromatogram;
    protected List<LineMarker> listMsMsMarkers;
    protected LineMarker currentScanMarker;
    protected Float currentScanTime = null;
    protected String lastDisplayIdentifier;
    private PropertyChangeSupport changeSupport;
    private List<AxisRangeChromatogramListener> m_listeners = new ArrayList<AxisRangeChromatogramListener>();

    public ChromatogramPanel() {
        this.listMsMsMarkers = new ArrayList<LineMarker>();
        this.listChromatogram = new ArrayList<IChromatogram>();
        this.changeSupport = new PropertyChangeSupport(this);
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        PlotPanel plotPanel = new PlotPanel();
        this.chromatogramPlotPanel = plotPanel.getBasePlotPanel();
        this.chromatogramPlotPanel.addListener((PlotPanelListener)this);
        this.chromatogramPlotPanel.setDrawCursor(true);
        this.chromatogramPlotPanel.repaint();
        this.currentScanMarker = new LineMarker(this.chromatogramPlotPanel, 0.0, 1, Color.BLUE, false);
        this.chromatogramPlots = new ArrayList<PlotLinear>();
        this.add((Component)plotPanel, "Center");
    }

    public void addListener(AxisRangeChromatogramListener listener) {
        this.m_listeners.add(listener);
    }

    public void showMSMSEvents(List<Float> listMsMsTime) {
        PlotLinear chromatogramPlot;
        PlotLinear plotLinear = chromatogramPlot = this.chromatogramPlots.isEmpty() ? null : this.chromatogramPlots.get(0);
        if (chromatogramPlot != null) {
            for (Float time : listMsMsTime) {
                LineMarker marker = new LineMarker(this.chromatogramPlotPanel, (double)time.floatValue() / 60.0, CyclicColorPalette.getColor((int)8));
                this.listMsMsMarkers.add(marker);
                chromatogramPlot.addMarker((AbstractMarker)marker);
                this.chromatogramPlotPanel.repaintUpdateDoubleBuffer();
            }
        }
    }

    public void hideMSMSEvents() {
        PlotLinear chromatogramPlot;
        PlotLinear plotLinear = chromatogramPlot = this.chromatogramPlots.isEmpty() ? null : this.chromatogramPlots.get(0);
        if (chromatogramPlot != null) {
            for (LineMarker marker : this.listMsMsMarkers) {
                chromatogramPlot.removeMarker((AbstractMarker)marker);
            }
            this.chromatogramPlotPanel.repaintUpdateDoubleBuffer();
        }
        this.listMsMsMarkers = new ArrayList<LineMarker>();
    }

    public Color displayChromatogram(IChromatogram chromato, Display display) {
        double[] bounds;
        if (display.getMode() == Display.Mode.REPLACE || display.getMode() == Display.Mode.SERIES && !display.getIdentifier().equals(this.lastDisplayIdentifier)) {
            PlotLinear chromatogramPlot;
            this.currentChromatogram = chromato;
            this.listChromatogram = new ArrayList<IChromatogram>();
            this.chromatogramPlotPanel.setPlotTitle(chromato.getTitle());
            this.chromatogramPlotPanel.clearPlots();
            PlotLinear plotLinear = chromatogramPlot = this.chromatogramPlots.isEmpty() ? null : this.chromatogramPlots.get(0);
            if (chromatogramPlot != null) {
                chromatogramPlot.clearMarkers();
            }
            this.chromatogramPlots = new ArrayList<PlotLinear>();
        } else if (!this.listChromatogram.isEmpty()) {
            this.chromatogramPlotPanel.setPlotTitle("<" + (this.listChromatogram.size() + 1) + " chromatograms>");
        }
        this.listChromatogram.add(chromato);
        double xMin = Double.NaN;
        double xMax = Double.NaN;
        if (this.chromatogramPlotPanel.hasPlots()) {
            bounds = this.chromatogramPlotPanel.getXAxisBounds();
            if (Double.isNaN(bounds[0]) || bounds[0] < this.chromatogramPlotPanel.getXAxis().getMinValue()) {
                xMin = this.chromatogramPlotPanel.getXAxis().getMinValue();
            }
            if (Double.isNaN(bounds[1]) || bounds[1] > this.chromatogramPlotPanel.getXAxis().getMaxValue()) {
                xMax = this.chromatogramPlotPanel.getXAxis().getMaxValue();
            }
        }
        if (this.chromatogramPlotPanel.hasPlots()) {
            bounds = this.chromatogramPlotPanel.getXAxisBounds();
            this.chromatogramPlotPanel.setXAxisBounds(Math.min(chromato.getElutionStartTime(), bounds[0]), Math.max(chromato.getElutionEndTime(), bounds[1]));
        } else {
            this.chromatogramPlotPanel.setXAxisBounds(chromato.getElutionStartTime(), chromato.getElutionEndTime());
        }
        Color plotColor = CyclicColorPalette.getColor((int)(this.chromatogramPlots.size() + 1));
        ChromatogramTableModel chromatoModel = new ChromatogramTableModel(chromato);
        chromatoModel.setColor(plotColor);
        PlotLinear chromatogramPlot = new PlotLinear(this.chromatogramPlotPanel, (ExtendedTableModelInterface)chromatoModel, null, 0, 1);
        chromatogramPlot.setPlotInformation(chromatoModel.getPlotInformation());
        chromatogramPlot.setIsPaintMarker(true);
        chromatogramPlot.setStrokeFixed(true);
        chromatogramPlot.addMeasurement((AbstractMeasurement)new IntegralMeasurement((PlotBaseAbstract)chromatogramPlot));
        this.chromatogramPlotPanel.addPlot((PlotXYAbstract)chromatogramPlot, true);
        this.chromatogramPlots.add(chromatogramPlot);
        if (!Double.isNaN(xMax) && !Double.isNaN(xMin)) {
            this.chromatogramPlotPanel.getXAxis().setRange(xMin, xMax);
        }
        if (display.getMode() == Display.Mode.REPLACE || display.getMode() == Display.Mode.SERIES && !display.getIdentifier().equals(this.lastDisplayIdentifier)) {
            this.chromatogramPlots.get(0).addMarker((AbstractMarker)this.currentScanMarker);
            if (this.currentScanTime != null) {
                this.currentScanMarker.setValue((double)this.currentScanTime.floatValue() / 60.0);
            }
            this.chromatogramPlotPanel.lockMinXValue();
            this.chromatogramPlotPanel.lockMinYValue();
        }
        this.displayMarkers((PlotBaseAbstract)chromatogramPlot, this.chromatogramPlotPanel, display);
        this.chromatogramPlotPanel.repaintUpdateDoubleBuffer();
        this.lastDisplayIdentifier = display.getIdentifier();
        return plotColor;
    }

    private void displayMarkers(PlotBaseAbstract plot, BasePlotPanel plotPanel, Display display) {
        if (display.getMarkers() != null) {
            for (AbstractMarker marker : display.getMarkers()) {
                try {
                    AbstractMarker clone = marker.clone(plotPanel);
                    plot.addMarker(clone);
                }
                catch (CloneNotSupportedException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
    }

    public void displayFeature(IPeakel f, Display display) {
        PlotLinear chromatogramPlot;
        PlotLinear plotLinear = chromatogramPlot = this.chromatogramPlots.isEmpty() ? null : this.chromatogramPlots.get(0);
        if (chromatogramPlot != null) {
            chromatogramPlot.clearMarkers();
            this.displayMarkers((PlotBaseAbstract)chromatogramPlot, this.chromatogramPlotPanel, display);
            this.currentScanMarker.setValue((double)f.getElutionTime() / 60.0);
            chromatogramPlot.addMarker((AbstractMarker)this.currentScanMarker);
        }
    }

    public IChromatogram getCurrentChromatogram() {
        return this.currentChromatogram;
    }

    public void plotPanelMouseClicked(MouseEvent e, double xValue, double yValue) {
        this.setCurrentScanTime((float)xValue * 60.0f, false);
    }

    public Float getCurrentScanTime() {
        return this.currentScanTime;
    }

    public void setCurrentScanTime(float scanTime) {
        this.setCurrentScanTime(scanTime, true);
    }

    private void setCurrentScanTime(float scanTime, boolean silently) {
        float oldValue = this.currentScanTime == null ? Float.NaN : this.currentScanTime.floatValue();
        this.currentScanTime = Float.valueOf(scanTime);
        if (!this.chromatogramPlots.isEmpty()) {
            this.currentScanMarker.setVisible(true);
            this.currentScanMarker.setValue((double)(scanTime / 60.0f));
            this.chromatogramPlotPanel.repaintUpdateDoubleBuffer();
        }
        if (!silently) {
            this.changeSupport.firePropertyChange(SCAN_TIME, Float.valueOf(oldValue), Float.valueOf(scanTime));
        }
    }

    Iterable<IChromatogram> getChromatograms() {
        return this.listChromatogram;
    }

    public BasePlotPanel getChromatogramPlotPanel() {
        return this.chromatogramPlotPanel;
    }

    void setCurrentChromatogram(IChromatogram chromatogram) {
        if (this.listChromatogram.contains(chromatogram)) {
            this.currentChromatogram = chromatogram;
        } else {
            logger.warn("current chromatogram supplied is not in the list of extracted chromatograms : " + chromatogram.toString());
        }
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
    }

    public void updateAxisRange(double[] oldX, double[] newX, double[] oldY, double[] newY) {
        this.fireUpdateAxisRange(oldX, newX, oldY, newY);
    }

    protected void fireUpdateAxisRange(double[] oldX, double[] newX, double[] oldY, double[] newY) {
        for (AxisRangeChromatogramListener l : this.m_listeners) {
            l.updateAxisRange(oldX, newX, oldY, newY);
        }
    }

    public void updateAxisRange(double zoomXLevel, double relativeXValue, double zoomYLevel, double relativeYValue) {
        double oldXMin = this.chromatogramPlotPanel.getXAxis().getMinValue();
        double oldXMax = this.chromatogramPlotPanel.getXAxis().getMaxValue();
        double oldYMin = this.chromatogramPlotPanel.getYAxis().getMinValue();
        double oldYMax = this.chromatogramPlotPanel.getYAxis().getMaxValue();
        double newRangeX = zoomXLevel * (oldXMax - oldXMin) / 100.0;
        double x = oldXMin + relativeXValue * (oldXMax - oldXMin) / 100.0;
        double newRangeY = zoomYLevel * (oldYMax - oldYMin) / 100.0;
        double y = oldYMin + relativeYValue * (oldYMax - oldYMin) / 100.0;
        double newXMin = x - newRangeX / 2.0;
        double newXMax = x + newRangeX / 2.0;
        double newYMin = y - newRangeY / 2.0;
        double newYMax = y + newRangeY / 2.0;
        logger.debug("{} move from min={}, max={} to min={}, max={}", new Object[]{this.currentChromatogram.getRawFilename(), oldXMin, oldXMax, newXMin, newXMax});
        this.chromatogramPlotPanel.getXAxis().setRange(newXMin, newXMax);
        this.chromatogramPlotPanel.getYAxis().setRange(newYMin, newYMax);
        this.chromatogramPlotPanel.repaintUpdateDoubleBuffer();
    }

    public void updateAxisRange2(double zoomXRange, double relativeXPosition, double zoomYLevel, double relativeYValue) {
        double oldYMin = this.chromatogramPlotPanel.getYAxis().getMinValue();
        double oldYMax = this.chromatogramPlotPanel.getYAxis().getMaxValue();
        double newRangeY = zoomYLevel * (oldYMax - oldYMin) / 100.0;
        double y = oldYMin + relativeYValue * (oldYMax - oldYMin) / 100.0;
        double newXMin = relativeXPosition * (this.currentChromatogram.getElutionEndTime() - this.currentChromatogram.getElutionStartTime());
        double newXMax = newXMin + zoomXRange;
        double newYMin = y - newRangeY / 2.0;
        double newYMax = y + newRangeY / 2.0;
        this.chromatogramPlotPanel.getXAxis().setRange(newXMin, newXMax);
        this.chromatogramPlotPanel.getYAxis().setRange(newYMin, newYMax);
        this.chromatogramPlotPanel.repaintUpdateDoubleBuffer();
    }
}

