/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.mzscope.ui;

import fr.proline.mzscope.model.IRawFile;
import fr.proline.mzscope.ui.RawFilePropertiesTableModel;
import fr.proline.studio.table.DecoratedMarkerTable;
import fr.proline.studio.table.TablePopupMenu;
import fr.proline.studio.utils.CyclicColorPalette;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

class PropertiesPanel
extends JPanel {
    private List<IRawFile> rawfiles;
    private RawFilePropertiesTableModel model;

    PropertiesPanel(List<IRawFile> rawfiles) {
        this.rawfiles = rawfiles;
        List<String> names = rawfiles.stream().map(f -> f.getName()).collect(Collectors.toList());
        this.model = new RawFilePropertiesTableModel(names);
        this.initComponents();
        this.initContent();
    }

    private void initComponents() {
        JScrollPane scroll = new JScrollPane();
        DecoratedMarkerTable table = new DecoratedMarkerTable(){

            public TablePopupMenu initPopupMenu() {
                return new TablePopupMenu();
            }

            public void prepostPopupMenu() {
            }

            public void addTableModelListener(TableModelListener l) {
            }
        };
        table.setModel((TableModel)((Object)this.model));
        scroll.setViewportView((Component)table);
        table.setFillsViewportHeight(true);
        table.setViewport(scroll.getViewport());
        table.removeStriping();
        this.setLayout(new BorderLayout());
        this.add((Component)scroll, "Center");
    }

    private void initContent() {
        List<Map<String, Object>> data = this.rawfiles.stream().map(f -> f.getFileProperties()).collect(Collectors.toList());
        this.model.addData(data, "Format", CyclicColorPalette.getColor((int)0));
    }
}

