/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.mzscope.ui;

import fr.proline.mzscope.model.EmptyRawFile;
import fr.proline.mzscope.model.IRawFile;
import fr.proline.mzscope.ui.model.RawFileListModel;
import fr.proline.mzscope.utils.IPopupMenuDelegate;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RawFilesPanel
extends JPanel
implements ListCellRenderer {
    private static final Logger logger = LoggerFactory.getLogger(RawFilesPanel.class);
    private final RawFileListModel rawFilesListModel;
    private JList<IRawFile> rawFilesList;
    private JPopupMenu popupMenu;
    private JScrollPane scrollPane;
    private JLabel openedRawFilesLabel;
    private final IPopupMenuDelegate popupMenuDelegate;
    private ListCellRenderer defaultListCellRenderer;

    public RawFilesPanel(IPopupMenuDelegate popupDelegate) {
        this.popupMenuDelegate = popupDelegate;
        this.initComponents();
        this.rawFilesListModel = (RawFileListModel)this.rawFilesList.getModel();
    }

    private void initComponents() {
        this.openedRawFilesLabel = new JLabel();
        this.scrollPane = new JScrollPane();
        this.rawFilesList = new JList();
        this.popupMenu = new JPopupMenu();
        this.popupMenuDelegate.initPopupMenu(this.popupMenu);
        this.openedRawFilesLabel.setText("mzDB files");
        this.rawFilesList.setModel(new RawFileListModel());
        this.rawFilesList.setComponentPopupMenu(this.popupMenu);
        this.rawFilesList.setLayoutOrientation(0);
        this.rawFilesList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                RawFilesPanel.this.rawFilesListMouseClicked(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                RawFilesPanel.this.rawFilesListMousePressed(evt);
            }
        });
        this.defaultListCellRenderer = this.rawFilesList.getCellRenderer();
        this.rawFilesList.setCellRenderer(this);
        this.scrollPane.setViewportView(this.rawFilesList);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(5, 5, 5).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.scrollPane).addGap(5, 5, 5)).addGroup(layout.createSequentialGroup().addComponent(this.openedRawFilesLabel).addContainerGap(156, Short.MAX_VALUE)))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(5, 5, 5).addComponent(this.openedRawFilesLabel, -2, 19, -2).addGap(5, 5, 5).addComponent(this.scrollPane, -1, 192, Short.MAX_VALUE).addGap(5, 5, 5)));
        this.openedRawFilesLabel.getAccessibleContext().setAccessibleName("Raw files");
    }

    private void rawFilesListMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2 && this.rawFilesList.getSelectedIndex() > -1) {
            this.popupMenuDelegate.getDefaultAction().actionPerformed(new ActionEvent(this, 1001, "default"));
        }
    }

    private void rawFilesListMousePressed(MouseEvent evt) {
        this.popupMenuDelegate.updatePopupMenu();
        if (this.rawFilesList.getSelectedIndex() > -1 && SwingUtilities.isRightMouseButton(evt)) {
            this.popupMenu.show((JComponent)evt.getSource(), evt.getX(), evt.getY());
        }
    }

    public JPopupMenu getPopupMenu() {
        return this.popupMenu;
    }

    public List<IRawFile> getSelectedValues() {
        return this.rawFilesList.getSelectedValuesList();
    }

    public void addFile(IRawFile file) {
        this.rawFilesListModel.add(file);
    }

    public void removeFile(IRawFile file) {
        this.rawFilesListModel.removeFile(file);
    }

    public void removeAllFiles() {
        this.rawFilesListModel.removeAllFiles();
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        Component c = this.defaultListCellRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        if (value instanceof EmptyRawFile) {
            c.setEnabled(false);
        }
        return c;
    }
}

