/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.mzscope.ui;

import com.github.psambit9791.jdsp.filter.Median;
import com.github.psambit9791.jdsp.filter.Savgol;
import com.github.psambit9791.jdsp.filter.Wiener;
import com.github.psambit9791.jdsp.signal.Convolution;
import com.github.psambit9791.jdsp.signal.Smooth;
import com.github.psambit9791.jdsp.signal.peaks.FindPeak;
import com.github.psambit9791.jdsp.signal.peaks.Peak;
import fr.profi.mzdb.algo.signal.detection.SmartPeakelFinder;
import fr.profi.mzdb.algo.signal.filtering.BaselineRemover;
import fr.profi.mzdb.algo.signal.filtering.ISignalSmoother;
import fr.profi.mzdb.algo.signal.filtering.PartialSavitzkyGolaySmoother;
import fr.profi.mzdb.algo.signal.filtering.SavitzkyGolaySmoother;
import fr.profi.mzdb.algo.signal.filtering.SavitzkyGolaySmoothingConfig;
import fr.profi.mzdb.util.math.DerivativeAnalysis;
import fr.proline.mzscope.model.Signal;
import fr.proline.mzscope.ui.SignalPanel;
import fr.proline.mzscope.ui.SignalWrapper;
import fr.proline.mzscope.ui.dialog.SmoothingParamDialog;
import fr.proline.mzscope.ui.dialog.WaveletSmootherParamDialog;
import fr.proline.mzscope.utils.SmoothUtils;
import fr.proline.studio.WindowManager;
import fr.proline.studio.extendedtablemodel.ExtendedTableModelInterface;
import fr.proline.studio.graphics.BasePlotPanel;
import fr.proline.studio.graphics.PlotBaseAbstract;
import fr.proline.studio.graphics.PlotLinear;
import fr.proline.studio.graphics.PlotXYAbstract;
import fr.proline.studio.graphics.marker.AbstractMarker;
import fr.proline.studio.graphics.marker.LineMarker;
import fr.proline.studio.graphics.marker.PointMarker;
import fr.proline.studio.graphics.marker.coordinates.AbstractCoordinates;
import fr.proline.studio.graphics.marker.coordinates.DataCoordinates;
import fr.proline.studio.utils.CyclicColorPalette;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSpinner;
import javax.swing.JToolBar;
import javax.swing.SpinnerNumberModel;
import jwave.exceptions.JWaveException;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.math3.fitting.GaussianCurveFitter;
import org.apache.commons.math3.fitting.WeightedObservedPoints;
import org.apache.commons.math3.stat.descriptive.moment.StandardDeviation;
import org.apache.commons.math3.util.Precision;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple2;

public class SignalEditorPanel
extends SignalPanel {
    private static final Logger logger = LoggerFactory.getLogger(SignalEditorPanel.class);
    private Map<Signal, PlotLinear> m_smoothedSignals;
    private JButton minmaxBtn;
    private JButton maxBtn;
    private JButton maxJDSPButton;
    private JButton waveletJWaveButton;
    private JButton clearButton;
    private JButton baseLineBtn;
    private JPanel smoothStatsPanel;
    private JLabel initialSmoothnessLabel;
    private JLabel finalSmoothnessLabelValue;
    private JLabel displaySNRJLabel;
    private JLabel displayBiasValue;
    private JLabel displayQualityValueJLabel;
    private JLabel smoothMethodUsedLabel;
    private JLabel displayComputeTime;
    private JLabel displaySizeSignalJLabel;
    private JLabel displayAreaVariationJLabel;
    private JProgressBar progressBar;
    private Signal initialSignal;
    private Map<Integer, Signal> history;
    private Map<Integer, Object[]> smoothSignalHistory;
    private int index;
    private JSpinner historySpinner;
    private JButton viewSignalButton;

    public SignalEditorPanel(Signal signal) {
        super(signal);
        this.setPreferredSize(new Dimension(700, 900));
        this.m_smoothedSignals = new HashMap<Signal, PlotLinear>();
        this.createStatsPanel();
        this.initialSignal = signal;
        this.index = 0;
        this.history = new HashMap<Integer, Signal>();
        this.smoothSignalHistory = new HashMap<Integer, Object[]>();
    }

    @Override
    protected JToolBar createToolBar() {
        JToolBar toolbar = new JToolBar();
        JButton smoothBtn = new JButton("Smooth");
        smoothBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    SignalEditorPanel.this.runSmoothing();
                }
                catch (JWaveException ex) {
                    throw new RuntimeException(ex);
                }
            }
        });
        toolbar.add(smoothBtn);
        this.minmaxBtn = new JButton("Min/Max");
        this.minmaxBtn.setEnabled(false);
        this.minmaxBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                logger.info("detect significant min max");
                SignalEditorPanel.this.detectSignificantMinMax();
            }
        });
        toolbar.add(this.minmaxBtn);
        this.maxBtn = new JButton("Max");
        this.maxBtn.setEnabled(false);
        this.maxBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                logger.info("detect max");
                SignalEditorPanel.this.detectMax();
            }
        });
        toolbar.add(this.maxBtn);
        this.maxJDSPButton = new JButton("Max JDSP");
        this.maxJDSPButton.setEnabled(false);
        this.maxJDSPButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SignalEditorPanel.this.detectMaxJDSP();
            }
        });
        toolbar.add(this.maxJDSPButton);
        this.waveletJWaveButton = new JButton("Wavelet smooth");
        this.waveletJWaveButton.setEnabled(true);
        this.waveletJWaveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    SignalEditorPanel.this.runWaveletSmoothing();
                }
                catch (JWaveException ex) {
                    throw new RuntimeException(ex);
                }
            }
        });
        toolbar.add(this.waveletJWaveButton);
        this.baseLineBtn = new JButton("Baseline");
        this.baseLineBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List<Tuple2> input = SignalEditorPanel.this.m_signal.toScalaArrayTuple(false);
                Tuple2[] rtIntPairs = input.toArray(new Tuple2[input.size()]);
                BaselineRemover baselineRemover = new BaselineRemover(1, 3);
                double threshold = baselineRemover.calcNoiseThreshold(rtIntPairs);
                logger.info("detected baseline at threshold " + threshold);
                LineMarker positionMarker = new LineMarker(SignalEditorPanel.this.m_plotPanel.getBasePlotPanel(), threshold, 0, Color.BLUE, true);
                SignalEditorPanel.this.m_linear.addMarker((AbstractMarker)positionMarker);
                SmartPeakelFinder peakelFinder = new SmartPeakelFinder(5, 3, 0.66f, false, 10, false, false, true);
                Tuple2[] indices = peakelFinder.findPeakelsIndices(rtIntPairs);
            }
        });
        toolbar.add(this.baseLineBtn);
        this.clearButton = new JButton("Clear");
        this.clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SignalEditorPanel.this.removeSmoothedSignals();
            }
        });
        this.clearButton.setEnabled(false);
        toolbar.add(this.clearButton);
        this.viewSignalButton = new JButton("view signal: ");
        this.viewSignalButton.addActionListener(e -> {
            int index = (Integer)this.historySpinner.getValue();
            if (index <= this.m_smoothedSignals.size()) {
                this.displaySignal((Integer)this.historySpinner.getValue());
            }
        });
        this.viewSignalButton.setEnabled(false);
        toolbar.add(this.viewSignalButton);
        SpinnerNumberModel model = new SpinnerNumberModel(1, 1, 1, 1);
        this.historySpinner = new JSpinner();
        this.historySpinner.setModel(model);
        toolbar.add(this.historySpinner);
        return toolbar;
    }

    private void runSmoothing() throws JWaveException {
        SmoothingParamDialog dialog = new SmoothingParamDialog((Window)WindowManager.getDefault().getMainWindow());
        dialog.pack();
        dialog.setVisible(true);
        if (dialog.getButtonClicked() == 0) {
            boolean initialMethods;
            List<Tuple2> input = this.m_signal.toScalaArrayTuple(false);
            int nbrPoints = dialog.getNbrPoint();
            boolean usePeakRestore = dialog.getUsePeakrestore();
            double ratio = 0.0;
            if (usePeakRestore) {
                ratio = dialog.getJSpinnerValue();
            }
            String smoothMethod = dialog.getMethod();
            String modeOfConvolution = null;
            String savitskyMode = null;
            int polyOrder = 3;
            int derivatives = 0;
            int delta = 5;
            if (smoothMethod.equals("SmoothingJDSP")) {
                modeOfConvolution = dialog.getModeOfConvolution();
            }
            if (smoothMethod.equals("SavitskyJDSP")) {
                savitskyMode = dialog.getSavitskyMode();
                polyOrder = dialog.getPolyOrder();
                derivatives = dialog.getDerivativeOrder();
                delta = dialog.getDeltaSpacing();
            }
            boolean bl = initialMethods = dialog.getMethod().equals("Savitzky-Golay Smoother") || dialog.getMethod().equals("Partial Savitzky-Golay Smoother") || dialog.getMethod().equals("All Smoothers");
            if (initialMethods && nbrPoints == 0) {
                nbrPoints = Math.min(input.size() / 4, 9);
            }
            switch (smoothMethod) {
                case "Savitzky-Golay Smoother": {
                    logger.info("display smoothed signal, SG nb smoothing points = " + nbrPoints);
                    SavitzkyGolaySmoother sgSmoother = new SavitzkyGolaySmoother(new SavitzkyGolaySmoothingConfig(nbrPoints, 2, 1));
                    this.smooth(input, (ISignalSmoother)sgSmoother, "SG");
                    break;
                }
                case "Partial Savitzky-Golay Smoother": {
                    logger.info("display smoothed signal, Partial SG nb smoothing points = " + nbrPoints);
                    PartialSavitzkyGolaySmoother psgSmoother = new PartialSavitzkyGolaySmoother(new SavitzkyGolaySmoothingConfig(nbrPoints, 4, 1));
                    this.smooth(input, (ISignalSmoother)psgSmoother, "Partial SG");
                    break;
                }
                case "All Smoothers": {
                    logger.info("display smoothed signal, SG nb smoothing points = " + nbrPoints);
                    SavitzkyGolaySmoother sgSmoother = new SavitzkyGolaySmoother(new SavitzkyGolaySmoothingConfig(nbrPoints, 2, 1));
                    this.smooth(input, (ISignalSmoother)sgSmoother, "SG");
                    logger.info("display smoothed signal, Partial SG nb smoothing points = " + nbrPoints);
                    PartialSavitzkyGolaySmoother psgSmoother = new PartialSavitzkyGolaySmoother(new SavitzkyGolaySmoothingConfig(nbrPoints, 4, 1));
                    this.smooth(input, (ISignalSmoother)psgSmoother, "Partial SG");
                    break;
                }
                case "SmoothingJDSP": {
                    logger.info("JDSP smooth method with initial window size: " + nbrPoints);
                    this.smoothJDSP(input, "smooth method with window size: ", nbrPoints, usePeakRestore, ratio, modeOfConvolution);
                    break;
                }
                case "ConvolutionJDSP": {
                    logger.info("Convolution method kernel size = " + nbrPoints);
                    this.smoothByConvolution(input, "convolution", nbrPoints, usePeakRestore, ratio);
                    break;
                }
                case "Apache gaussian fitting": {
                    logger.info("Fitting of curves by gaussian regression, optimization = " + usePeakRestore);
                    this.GaussianFitter(input, "gaussian fitting", nbrPoints, usePeakRestore, ratio);
                    break;
                }
                case "WienerJDSP": {
                    logger.info("Wiener filter with window size= " + nbrPoints + " peak restore used= " + usePeakRestore);
                    this.filterWiener(input, "Wiener filter", nbrPoints, usePeakRestore, ratio);
                    break;
                }
                case "SavitskyJDSP": {
                    logger.info("Savitsky Golay JDSP smoothing, number of points= " + nbrPoints);
                    this.savitskyJDSP(input, "Savitsky JDSP Smoothing", nbrPoints, usePeakRestore, ratio, savitskyMode, polyOrder, derivatives, delta);
                    break;
                }
                case "Experimental method": {
                    logger.info("Experimental calculus for test");
                    this.experimentalMethod(input, "Experimental Smoothing", nbrPoints, usePeakRestore, ratio);
                    break;
                }
                case "medianFilterJDSP": {
                    logger.info("Median filter with window size= " + nbrPoints + " peak restored= " + usePeakRestore);
                    this.medianFilterJDSP(input, "median filter method", nbrPoints, usePeakRestore, ratio);
                    break;
                }
                case "signal quality evaluation": {
                    logger.info("Evaluation of smoothness and quality of the signal");
                    this.evaluateSignalQuality(input, nbrPoints, usePeakRestore, ratio);
                }
            }
        }
    }

    private void runWaveletSmoothing() throws JWaveException {
        WaveletSmootherParamDialog dialog = new WaveletSmootherParamDialog((Window)WindowManager.getDefault().getMainWindow());
        dialog.pack();
        dialog.setVisible(true);
        if (dialog.getButtonClicked() == 0) {
            List<Tuple2> input = this.m_signal.toScalaArrayTuple(false);
            String smoothMethod = dialog.getMethod();
            double threshold = dialog.getJSpinnerValue();
            boolean userHasSelectedAWavelet = dialog.getUserChoice();
            if (userHasSelectedAWavelet) {
                String waveletName = dialog.getWaveletSelected();
                int waveletIndex = SmoothUtils.getIndexOfWaveletByName(waveletName);
                this.waveletPacketSmoother(input, threshold, smoothMethod, waveletIndex, true);
            } else {
                this.waveletPacketSmoother(input, threshold, smoothMethod, 0, false);
            }
        }
    }

    private void waveletPacketSmoother(List<Tuple2> input, double threshold, String smoothMethod, int waveletIndex, boolean userSelectedWavelet) {
        long startTime = System.nanoTime();
        Tuple2[] result = input.toArray(new Tuple2[input.size()]);
        double[] x = new double[result.length];
        double[] y = new double[result.length];
        for (int k = 0; k < result.length; ++k) {
            x[k] = (Double)result[k]._1;
            y[k] = (Double)result[k]._2;
        }
        Pair<double[], String> smoothResult = SmoothUtils.waveletSmoother(input, smoothMethod, threshold, waveletIndex, userSelectedWavelet);
        double[] smoothedSignal = (double[])smoothResult.getLeft();
        String waveletUsedForSmoothing = (String)smoothResult.getRight();
        Signal convolutedSignal = new Signal(x, smoothedSignal);
        long computeTime = System.nanoTime() - startTime;
        String thresholdString = Double.toString(threshold);
        this.addSmoothedSignal(convolutedSignal, "wavelet transform");
        String displayMethod = "Wavelet transform: " + waveletUsedForSmoothing + " level: " + Double.toString(threshold);
        this.displaySmoothStats(x, y, smoothedSignal, displayMethod, computeTime);
        this.revalidate();
        this.repaint();
    }

    private void addSmoothedSignal(Signal s, String title) {
        this.minmaxBtn.setEnabled(true);
        this.maxBtn.setEnabled(true);
        this.maxJDSPButton.setEnabled(true);
        this.waveletJWaveButton.setEnabled(true);
        this.clearButton.setEnabled(true);
        BasePlotPanel basePlot = this.m_plotPanel.getBasePlotPanel();
        SignalWrapper wrappedSignal = new SignalWrapper(s, "smoothed signal : " + title, CyclicColorPalette.getColor((int)((this.m_smoothedSignals.size() + 1) * 2)));
        PlotLinear linear = new PlotLinear(basePlot, (ExtendedTableModelInterface)wrappedSignal, null, 0, 1);
        linear.setPlotInformation(wrappedSignal.getPlotInformation());
        linear.setStrokeFixed(true);
        linear.setAntiAliasing(true);
        basePlot.addPlot((PlotXYAbstract)linear, true);
        basePlot.repaintUpdateDoubleBuffer();
        this.m_smoothedSignals.put(s, linear);
        if (this.m_smoothedSignals.size() > 1) {
            this.viewSignalButton.setEnabled(true);
        }
        ++this.index;
        this.history.put(this.index, s);
        this.historySpinner.setModel(new SpinnerNumberModel(1, 1, this.m_smoothedSignals.size(), 1));
        this.revalidate();
        this.repaint();
    }

    private void removeSmoothedSignals() {
        BasePlotPanel basePlot = this.m_plotPanel.getBasePlotPanel();
        this.m_smoothedSignals.clear();
        this.history.clear();
        this.index = 0;
        this.viewSignalButton.setEnabled(false);
        this.clearButton.setEnabled(false);
        basePlot.clearPlots();
        SignalWrapper wrappedSignal = new SignalWrapper(this.initialSignal, "original signal", CyclicColorPalette.getColor((int)1));
        PlotLinear linear = new PlotLinear(basePlot, (ExtendedTableModelInterface)wrappedSignal, null, 0, 1);
        linear.setPlotInformation(wrappedSignal.getPlotInformation());
        linear.setStrokeFixed(true);
        linear.setAntiAliasing(true);
        basePlot.repaintUpdateDoubleBuffer();
        basePlot.setPlot((PlotBaseAbstract)linear);
        this.revalidate();
        this.repaint();
        this.clearStatsPanel();
        this.historySpinner.setModel(new SpinnerNumberModel(1, 1, 1, 1));
    }

    private void displaySignal(int index) {
        BasePlotPanel basePlot = this.m_plotPanel.getBasePlotPanel();
        basePlot.clearPlots();
        SignalWrapper wrappedSignalInitial = new SignalWrapper(this.m_signal, "original signal", CyclicColorPalette.getColor((int)1));
        PlotLinear linear1 = new PlotLinear(basePlot, (ExtendedTableModelInterface)wrappedSignalInitial, null, 0, 1);
        linear1.setPlotInformation(wrappedSignalInitial.getPlotInformation());
        linear1.setStrokeFixed(true);
        linear1.setAntiAliasing(true);
        basePlot.repaintUpdateDoubleBuffer();
        basePlot.addPlot((PlotXYAbstract)linear1);
        Signal signalDisplayed = this.history.get(index);
        SignalWrapper wrappedSignal = new SignalWrapper(signalDisplayed, "Smoothed signal number: " + index, CyclicColorPalette.getColor((int)3));
        PlotLinear linear2 = new PlotLinear(basePlot, (ExtendedTableModelInterface)wrappedSignal, null, 0, 1);
        linear2.setPlotInformation(wrappedSignal.getPlotInformation());
        linear2.setStrokeFixed(true);
        linear2.setAntiAliasing(true);
        basePlot.repaintUpdateDoubleBuffer();
        basePlot.addPlot((PlotXYAbstract)linear2);
        this.clearStatsPanel();
        this.revalidate();
        this.repaint();
    }

    private void detectMax() {
        for (Map.Entry<Signal, PlotLinear> e : this.m_smoothedSignals.entrySet()) {
            Signal s = e.getKey();
            DerivativeAnalysis.ILocalDerivativeChange[] mm = DerivativeAnalysis.findMiniMaxi((double[])s.getYSeries());
            PlotLinear plot = e.getValue();
            for (int k = 0; k < mm.length; ++k) {
                if (!mm[k].isMaximum()) continue;
                plot.addMarker((AbstractMarker)new PointMarker(this.m_plotPanel.getBasePlotPanel(), (AbstractCoordinates)new DataCoordinates(s.getXSeries()[mm[k].index()], s.getYSeries()[mm[k].index()]), plot.getPlotInformation().getPlotColor()));
            }
        }
        this.m_plotPanel.getBasePlotPanel().repaintUpdateDoubleBuffer();
    }

    private void detectMaxJDSP() {
        for (Map.Entry<Signal, PlotLinear> e : this.m_smoothedSignals.entrySet()) {
            Signal s = e.getKey();
            double[] ySignal = s.getYSeries();
            double[] xSignal = s.getXSeries();
            FindPeak fp = new FindPeak(ySignal);
            Peak out = fp.detectPeaks();
            int[] peaks = out.getPeaks();
            double[] heightOfPeaks = out.getHeights();
            Peak out2 = fp.detectTroughs();
            int[] troughs = out2.getPeaks();
            double[] heightOfTroughs = out2.getHeights();
            double[] xValuesOfPeaks = new double[peaks.length];
            for (int i = 0; i < peaks.length; ++i) {
                int index = peaks[i];
                xValuesOfPeaks[i] = xSignal[index];
            }
            double[] xValuesOfTroughs = new double[troughs.length];
            for (int i = 0; i < troughs.length; ++i) {
                int index = troughs[i];
                xValuesOfTroughs[i] = xSignal[index];
            }
            PlotLinear plot = e.getValue();
            for (int k = 0; k < heightOfTroughs.length; ++k) {
                plot.addMarker((AbstractMarker)new PointMarker(this.m_plotPanel.getBasePlotPanel(), (AbstractCoordinates)new DataCoordinates(xValuesOfTroughs[k], heightOfTroughs[k]), plot.getPlotInformation().getPlotColor()));
                plot.addMarker((AbstractMarker)new PointMarker(this.m_plotPanel.getBasePlotPanel(), (AbstractCoordinates)new DataCoordinates(xValuesOfPeaks[k], heightOfPeaks[k]), plot.getPlotInformation().getPlotColor()));
            }
        }
        this.m_plotPanel.getBasePlotPanel().repaintUpdateDoubleBuffer();
    }

    private void detectSignificantMinMax() {
        for (Map.Entry<Signal, PlotLinear> e : this.m_smoothedSignals.entrySet()) {
            Signal s = e.getKey();
            DerivativeAnalysis.ILocalDerivativeChange[] mm = DerivativeAnalysis.findSignificantMiniMaxi((double[])s.getYSeries(), (int)3, (float)0.75f);
            for (int k = 0; k < mm.length; ++k) {
                PlotLinear plot = e.getValue();
                plot.addMarker((AbstractMarker)new PointMarker(this.m_plotPanel.getBasePlotPanel(), (AbstractCoordinates)new DataCoordinates(s.getXSeries()[mm[k].index()], s.getYSeries()[mm[k].index()]), plot.getPlotInformation().getPlotColor()));
            }
        }
        this.m_plotPanel.getBasePlotPanel().repaintUpdateDoubleBuffer();
    }

    private void smooth(List<Tuple2> xyPairs, ISignalSmoother smoother, String title) {
        logger.info("signal length before smoothing = " + xyPairs.size());
        long startTime = System.nanoTime();
        Tuple2[] initialSetOfValues = xyPairs.toArray(new Tuple2[xyPairs.size()]);
        double[] initialValues = new double[xyPairs.size()];
        for (int k = 0; k < initialSetOfValues.length; ++k) {
            initialValues[k] = (Double)initialSetOfValues[k]._2;
        }
        Tuple2[] result = smoother.smoothTimeIntensityPairs(xyPairs.toArray(new Tuple2[xyPairs.size()]));
        logger.info("signal length after smoothing = " + result.length);
        double[] x = new double[result.length];
        double[] y = new double[result.length];
        for (int k = 0; k < result.length; ++k) {
            x[k] = (Double)result[k]._1;
            y[k] = (Double)result[k]._2;
        }
        Signal s = new Signal(x, y);
        long computeTime = System.nanoTime() - startTime;
        this.addSmoothedSignal(s, title);
        this.displaySmoothStats(x, initialValues, y, " Savitsky Golay ", computeTime);
    }

    private void smoothJDSP(List<Tuple2> xyPairs, String title, int windowSize, boolean recalculateSize, double ratio, String mode) {
        long startTime = System.nanoTime();
        logger.info("signal length before smoothing = " + xyPairs.size());
        Tuple2[] result = xyPairs.toArray(new Tuple2[xyPairs.size()]);
        double[] x = new double[result.length];
        double[] y = new double[result.length];
        for (int k = 0; k < result.length; ++k) {
            x[k] = (Double)result[k]._1;
            y[k] = (Double)result[k]._2;
        }
        int optimalWindowSize = windowSize;
        if (recalculateSize) {
            optimalWindowSize = SmoothUtils.getBestSmoothWindowSize(y);
        }
        Smooth smoother = new Smooth(y, optimalWindowSize, mode);
        double[] kernel = smoother.getKernel();
        System.out.println("kernel used for JDSP smoothing: " + Arrays.toString(kernel));
        double[] smoothedSignal = smoother.smoothSignal("same");
        Signal s = new Signal(x, smoothedSignal);
        long computeTime = System.nanoTime() - startTime;
        this.addSmoothedSignal(s, title);
        this.displaySmoothStats(x, y, smoothedSignal, "smooth method JDSP window size: " + optimalWindowSize + " mode: " + mode, computeTime);
    }

    private void smoothByConvolution(List<Tuple2> xyPairs, String title, int nbrPoints, boolean usePeakRestore, double ratio) {
        long startTime = System.nanoTime();
        Tuple2[] result = xyPairs.toArray(new Tuple2[xyPairs.size()]);
        double[] x = new double[result.length];
        double[] y = new double[result.length];
        for (int k = 0; k < result.length; ++k) {
            x[k] = (Double)result[k]._1;
            y[k] = (Double)result[k]._2;
        }
        double[] kernel = SmoothUtils.buildKernel(nbrPoints);
        System.out.println("kernel used for convolution: " + Arrays.toString(kernel));
        Convolution con = new Convolution(y, kernel);
        double[] convolvedSignal = con.convolve("same");
        SmoothUtils.correctNegativeValues(y, convolvedSignal);
        if (usePeakRestore) {
            SmoothUtils.peakRestorer(y, convolvedSignal, x, ratio);
        }
        long computeTime = System.nanoTime() - startTime;
        Signal s = new Signal(x, convolvedSignal);
        this.addSmoothedSignal(s, title);
        this.displaySmoothStats(x, y, convolvedSignal, "Convolution kernel size: " + nbrPoints, computeTime);
    }

    private void GaussianFitter(List<Tuple2> xyPairs, String title, int nbrPoints, boolean correctionApplied, double ratio) {
        double[] fittedSignal;
        long startTime = System.nanoTime();
        Tuple2[] result = xyPairs.toArray(new Tuple2[xyPairs.size()]);
        double[] x = new double[result.length];
        double[] y = new double[result.length];
        for (int k = 0; k < result.length; ++k) {
            x[k] = (Double)result[k]._1;
            y[k] = (Double)result[k]._2;
        }
        GaussianCurveFitter fitter = GaussianCurveFitter.create();
        WeightedObservedPoints obs = new WeightedObservedPoints();
        for (int index = 0; index < result.length; ++index) {
            obs.add(x[index], y[index]);
        }
        double[] bestFit = fitter.fit((Collection)obs.toList());
        if (!correctionApplied) {
            fittedSignal = SmoothUtils.buildSymmetricGaussian(bestFit, x[0], x[result.length - 1], result.length);
        } else {
            double bestNorm;
            double bestMean;
            bestFit[1] = bestMean = SmoothUtils.getBestGaussianMean(bestFit, x[0], x[result.length - 1], result.length, y);
            double[] sigmas = SmoothUtils.computeOptimalSigmas(bestFit, x[0], x[result.length - 1], result.length, y);
            bestFit[0] = bestNorm = SmoothUtils.getBestGaussianNorm(bestFit, x[0], x[result.length - 1], result.length, y);
            fittedSignal = SmoothUtils.buildAsymmetricGaussian(bestFit[0], bestFit[1], sigmas[0], sigmas[1], x[0], x[result.length - 1], result.length);
        }
        Signal finalSignal = new Signal(x, fittedSignal);
        long computeTime = System.nanoTime() - startTime;
        this.addSmoothedSignal(finalSignal, "Gaussian regression");
        this.displaySmoothStats(x, y, fittedSignal, "Asymmetric gaussian regression", computeTime);
    }

    private void filterWiener(List<Tuple2> xyPairs, String title, int windowSize, boolean usePeakRestore, double ratio) {
        long startTime = System.nanoTime();
        Tuple2[] result = xyPairs.toArray(new Tuple2[xyPairs.size()]);
        double[] x = new double[result.length];
        double[] y = new double[result.length];
        for (int k = 0; k < result.length; ++k) {
            x[k] = (Double)result[k]._1;
            y[k] = (Double)result[k]._2;
        }
        Wiener wienerFilter = new Wiener(windowSize);
        double[] filteredSignal = wienerFilter.filter(y);
        if (usePeakRestore) {
            SmoothUtils.peakRestorer(y, filteredSignal, x, ratio);
        }
        Signal wienerSignal = new Signal(x, filteredSignal);
        long computeTime = System.nanoTime() - startTime;
        this.addSmoothedSignal(wienerSignal, title);
        this.displaySmoothStats(x, y, filteredSignal, "Wiener Method with window size: " + windowSize, computeTime);
    }

    private void savitskyJDSP(List<Tuple2> xyPairs, String savitskyJdspTitle, int windowSize, boolean peakRestore, double ratio, String mode, int polyOrder, int deriv, int delta) {
        long startTime = System.nanoTime();
        Tuple2[] result = xyPairs.toArray(new Tuple2[xyPairs.size()]);
        double[] x = new double[result.length];
        double[] y = new double[result.length];
        for (int k = 0; k < result.length; ++k) {
            x[k] = (Double)result[k]._1;
            y[k] = (Double)result[k]._2;
        }
        Savgol savgolFilter = new Savgol(windowSize, polyOrder, deriv, (double)delta);
        double[] filteredSignal = savgolFilter.filter(y, mode);
        SmoothUtils.correctNegativeValues(y, filteredSignal);
        if (peakRestore) {
            SmoothUtils.peakRestorer(y, filteredSignal, x, ratio);
        }
        logger.info("initial smoothness: " + SmoothUtils.getSmoothness(y) + "  ,final smoothness: " + SmoothUtils.getSmoothness(filteredSignal));
        Signal JDSPSavitskyGolaySignal = new Signal(x, filteredSignal);
        long computeTime = System.nanoTime() - startTime;
        this.addSmoothedSignal(JDSPSavitskyGolaySignal, savitskyJdspTitle);
        this.displaySmoothStats(x, y, filteredSignal, "JDSP SVG window size: " + windowSize + " poly order: " + polyOrder, computeTime);
    }

    private void experimentalMethod(List<Tuple2> xyPairs, String title, int nbrPoints, boolean peakRestore, double ratio) {
        long startTime = System.nanoTime();
        Tuple2[] result = xyPairs.toArray(new Tuple2[xyPairs.size()]);
        double[] x = new double[result.length];
        double[] y = new double[result.length];
        for (int k = 0; k < result.length; ++k) {
            x[k] = (Double)result[k]._1;
            y[k] = (Double)result[k]._2;
        }
        GaussianCurveFitter fitter = GaussianCurveFitter.create();
        WeightedObservedPoints obs = new WeightedObservedPoints();
        for (int index = 0; index < result.length; ++index) {
            obs.add(x[index], y[index]);
        }
        double[] bestFit = fitter.fit((Collection)obs.toList());
        double[] fittedSignal = SmoothUtils.buildAsymmetricGaussian(bestFit[0], bestFit[1], bestFit[2], bestFit[2], x[0], x[result.length - 1], result.length);
        Signal polySignal = new Signal(x, fittedSignal);
        long computeTime = System.nanoTime() - startTime;
        this.addSmoothedSignal(polySignal, title);
        this.displaySmoothStats(x, y, y, "Experimental test", computeTime);
    }

    private void medianFilterJDSP(List<Tuple2> xyPairs, String find_peakTitle, int windowSize, boolean peakRestore, double ratio) {
        long startTime = System.nanoTime();
        Tuple2[] result = xyPairs.toArray(new Tuple2[xyPairs.size()]);
        double[] x = new double[result.length];
        double[] y = new double[result.length];
        for (int k = 0; k < result.length; ++k) {
            x[k] = (Double)result[k]._1;
            y[k] = (Double)result[k]._2;
        }
        Median medianFilter = new Median(windowSize);
        double[] medianSignal = medianFilter.filter(y);
        SmoothUtils.correctNegativeValues(y, medianSignal);
        if (peakRestore) {
            SmoothUtils.peakRestorer(y, medianSignal, x, ratio);
        }
        Signal convolutedSignal = new Signal(x, medianSignal);
        long computeTime = System.nanoTime() - startTime;
        this.addSmoothedSignal(convolutedSignal, find_peakTitle);
        this.displaySmoothStats(x, y, medianSignal, "median filter window size: " + windowSize, computeTime);
    }

    private void evaluateSignalQuality(List<Tuple2> xyPairs, int nbrPoints, boolean usePeakRestore, double ratio) {
        long startTime = System.nanoTime();
        Tuple2[] result = xyPairs.toArray(new Tuple2[xyPairs.size()]);
        double[] x = new double[result.length];
        double[] y = new double[result.length];
        for (int k = 0; k < result.length; ++k) {
            x[k] = (Double)result[k]._1;
            y[k] = (Double)result[k]._2;
        }
        double[] derivatives = SmoothUtils.getDerivatives(x, y);
        double qualitySignal = SmoothUtils.evaluateSignalRoughnessV3(y);
        System.out.println("Roughness of signal: " + qualitySignal);
        double smoothness = SmoothUtils.getSmoothness(y);
        System.out.println("overall smoothness of signal : " + smoothness);
        double maxHeight1 = Arrays.stream(y).max().getAsDouble();
        StandardDeviation std = new StandardDeviation();
        double derivativesDeviation = std.evaluate(derivatives) / maxHeight1;
        logger.info("Standard deviation of derivatives: " + derivativesDeviation);
        double initialLength = SmoothUtils.computeLengthOfSignal(x, y);
        double[] kernel = SmoothUtils.buildKernel(nbrPoints);
        Convolution con = new Convolution(y, kernel);
        double[] convolvedSignal = con.convolve("same");
        double finalLength = SmoothUtils.computeLengthOfSignal(x, convolvedSignal);
        double variationRate = 100.0 * (finalLength - initialLength) / initialLength;
        logger.info("Evaluation of signal quality:" + variationRate + " %");
        long computeTime = System.nanoTime() - startTime;
        this.displaySmoothStats(x, y, y, "signal quality evaluation", computeTime);
    }

    private void createStatsPanel() {
        this.smoothStatsPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.weightx = 0.0;
        this.smoothStatsPanel.setBackground(new Color(230, 232, 238));
        this.smoothStatsPanel.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        this.smoothStatsPanel.setMinimumSize(new Dimension(this.getWidth(), 50));
        JLabel titleLabel = new JLabel("Smoothing statistics");
        titleLabel.setFont(new Font("Serif", 0, 20));
        titleLabel.setForeground(Color.DARK_GRAY);
        gbc.anchor = 10;
        gbc.gridwidth = 2;
        this.smoothStatsPanel.add((Component)titleLabel, gbc);
        gbc.gridwidth = 1;
        JLabel smoothnessLabel = new JLabel("Initial smoothness: ");
        ++gbc.gridy;
        this.smoothStatsPanel.add((Component)smoothnessLabel, gbc);
        this.initialSmoothnessLabel = new JLabel();
        ++gbc.gridx;
        this.smoothStatsPanel.add((Component)this.initialSmoothnessLabel, gbc);
        JLabel finalSmoothnessLabel = new JLabel("Final smoothness: ");
        gbc.gridx = 0;
        ++gbc.gridy;
        this.smoothStatsPanel.add((Component)finalSmoothnessLabel, gbc);
        this.finalSmoothnessLabelValue = new JLabel();
        ++gbc.gridx;
        this.smoothStatsPanel.add((Component)this.finalSmoothnessLabelValue, gbc);
        JLabel sizeOfSignalJLabel = new JLabel("Signal length: ");
        gbc.gridx = 0;
        ++gbc.gridy;
        this.smoothStatsPanel.add((Component)sizeOfSignalJLabel, gbc);
        this.displaySizeSignalJLabel = new JLabel();
        ++gbc.gridx;
        this.smoothStatsPanel.add((Component)this.displaySizeSignalJLabel, gbc);
        JLabel estimatedSNRJLabel = new JLabel("Estimated signal to noise ratio: ");
        ++gbc.gridy;
        gbc.gridx = 0;
        this.smoothStatsPanel.add((Component)estimatedSNRJLabel, gbc);
        this.displaySNRJLabel = new JLabel();
        ++gbc.gridx;
        this.smoothStatsPanel.add((Component)this.displaySNRJLabel, gbc);
        JLabel displayBiasJLabel = new JLabel("Calculated bias: ");
        ++gbc.gridy;
        gbc.gridx = 0;
        this.smoothStatsPanel.add((Component)displayBiasJLabel, gbc);
        this.displayBiasValue = new JLabel();
        ++gbc.gridx;
        this.smoothStatsPanel.add((Component)this.displayBiasValue, gbc);
        JLabel qualityDisplayLabel = new JLabel("Roughness of signal");
        qualityDisplayLabel.setToolTipText("Indicator of the roughness of the signal, low value will correspond to smooth signal");
        gbc.gridx = 0;
        ++gbc.gridy;
        this.smoothStatsPanel.add((Component)qualityDisplayLabel, gbc);
        this.displayQualityValueJLabel = new JLabel();
        ++gbc.gridx;
        this.smoothStatsPanel.add((Component)this.displayQualityValueJLabel, gbc);
        JLabel qualityLabel = new JLabel("Quality of signal: ");
        qualityLabel.setToolTipText("Value can go from 0 to 100, a large value shall represent a signal with low noise");
        gbc.gridx = 0;
        ++gbc.gridy;
        this.smoothStatsPanel.add((Component)qualityLabel, gbc);
        this.progressBar = new JProgressBar(0, 100);
        this.progressBar.setStringPainted(true);
        ++gbc.gridx;
        this.smoothStatsPanel.add((Component)this.progressBar, gbc);
        JLabel deviationJLabel = new JLabel("Area variation");
        gbc.gridx = 0;
        ++gbc.gridy;
        this.smoothStatsPanel.add((Component)deviationJLabel, gbc);
        this.displayAreaVariationJLabel = new JLabel();
        ++gbc.gridx;
        this.smoothStatsPanel.add((Component)this.displayAreaVariationJLabel, gbc);
        JLabel displayMethod = new JLabel("Method used for smoothing: ");
        ++gbc.gridy;
        gbc.gridx = 0;
        this.smoothStatsPanel.add((Component)displayMethod, gbc);
        this.smoothMethodUsedLabel = new JLabel();
        ++gbc.gridx;
        this.smoothStatsPanel.add((Component)this.smoothMethodUsedLabel, gbc);
        JLabel timeJLabel = new JLabel("Calculation time: ");
        ++gbc.gridy;
        gbc.gridx = 0;
        this.smoothStatsPanel.add((Component)timeJLabel, gbc);
        this.displayComputeTime = new JLabel();
        ++gbc.gridx;
        this.smoothStatsPanel.add((Component)this.displayComputeTime, gbc);
        this.add((Component)this.smoothStatsPanel, "South");
        this.revalidate();
        this.repaint();
    }

    private void displaySmoothStats(double[] x, double[] initialSignal, double[] finalSignal, String smoothMethod, long computeTime) {
        int signalLength = x.length;
        this.displaySizeSignalJLabel.setText(signalLength + " points");
        double smoothness = Precision.round((double)SmoothUtils.getSmoothness(initialSignal), (int)4);
        this.initialSmoothnessLabel.setText(Double.toString(smoothness));
        double finalSmoothness = Precision.round((double)SmoothUtils.getSmoothness(finalSignal), (int)4);
        this.finalSmoothnessLabelValue.setText(Double.toString(finalSmoothness));
        double estimatedSNRValue = Precision.round((double)SmoothUtils.computeSignalToNoiseRatio(initialSignal, finalSignal), (int)4);
        double bias = Precision.round((double)SmoothUtils.computeAbsoluteBias(initialSignal, finalSignal), (int)4);
        double initialArea = Precision.round((double)SmoothUtils.calculateArea(x, initialSignal), (int)4);
        double finalArea = Precision.round((double)SmoothUtils.calculateArea(x, finalSignal), (int)4);
        double areaVariation = Precision.round((double)(100.0 * (finalArea - initialArea) / initialArea), (int)4);
        if (smoothMethod.equals("signal quality evaluation")) {
            this.smoothStatsPanel.setBackground(new Color(220, 224, 245));
            this.displaySNRJLabel.setText("No estimation of noise available");
            this.displayBiasValue.setText("No smoothing done, no bias");
            this.displayAreaVariationJLabel.setText("No smoothing done, no variation of area");
        } else {
            this.displaySNRJLabel.setText(estimatedSNRValue + " decibels");
            this.displayBiasValue.setText(Double.toString(bias));
            this.displayAreaVariationJLabel.setText(areaVariation + " %");
        }
        double estimatedQualityValue = Precision.round((double)SmoothUtils.evaluateSignalRoughnessV3(initialSignal), (int)4);
        this.displayQualityValueJLabel.setText(String.valueOf(estimatedQualityValue));
        this.smoothMethodUsedLabel.setText(smoothMethod);
        this.displayComputeTime.setText(SmoothUtils.displayTime(computeTime));
        double initialLength = SmoothUtils.computeLengthOfSignal(x, initialSignal);
        double[] kernel = SmoothUtils.buildKernel(5);
        Convolution con = new Convolution(initialSignal, kernel);
        double[] convolvedSignal = con.convolve("same");
        double finalLength = SmoothUtils.computeLengthOfSignal(x, convolvedSignal);
        double variationRateOfLength = 100.0 + 100.0 * (finalLength - initialLength) / initialLength;
        this.progressBar.setValue((int)variationRateOfLength);
        if (variationRateOfLength < 20.0) {
            this.progressBar.setForeground(new Color(183, 102, 104));
        } else if (variationRateOfLength < 50.0) {
            this.progressBar.setForeground(new Color(51, 70, 159));
        } else {
            this.progressBar.setForeground(new Color(97, 192, 97));
        }
    }

    private void clearStatsPanel() {
        this.displaySizeSignalJLabel.setText("");
        this.initialSmoothnessLabel.setText("");
        this.finalSmoothnessLabelValue.setText("");
        this.displaySNRJLabel.setText("");
        this.displayBiasValue.setText("");
        this.displayAreaVariationJLabel.setText("");
        this.displayQualityValueJLabel.setText("");
        this.smoothMethodUsedLabel.setText("");
        this.displayComputeTime.setText("");
        this.progressBar.setValue(0);
    }
}

