/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.mzscope.ui;

import fr.profi.mzdb.algo.signal.filtering.PartialSavitzkyGolaySmoother;
import fr.profi.mzdb.algo.signal.filtering.SavitzkyGolaySmoother;
import fr.profi.mzdb.algo.signal.filtering.SavitzkyGolaySmoothingConfig;
import fr.profi.mzdb.util.math.DerivativeAnalysis;
import fr.proline.mzscope.model.ExtractionRequest;
import fr.proline.mzscope.model.IonMobilityIndex;
import fr.proline.mzscope.model.MobilitySpectrum;
import fr.proline.mzscope.model.Mobilogram;
import fr.proline.mzscope.model.Signal;
import fr.proline.mzscope.model.Spectrum;
import fr.proline.mzscope.processing.SpectrumUtils;
import fr.proline.mzscope.ui.AbstractSpectrumPanel;
import fr.proline.mzscope.ui.IRawFileViewer;
import fr.proline.mzscope.ui.ScanHeaderPanel;
import fr.proline.mzscope.ui.SignalViewerBuilder;
import fr.proline.mzscope.ui.dialog.SmoothingParamDialog;
import fr.proline.mzscope.ui.event.ScanHeaderListener;
import fr.proline.mzscope.ui.model.MobilogramTableModel;
import fr.proline.mzscope.ui.model.MzScopePreferences;
import fr.proline.mzscope.utils.Display;
import fr.proline.studio.WindowManager;
import fr.proline.studio.export.ExportButton;
import fr.proline.studio.extendedtablemodel.ExtendedTableModelInterface;
import fr.proline.studio.graphics.BasePlotPanel;
import fr.proline.studio.graphics.PlotBaseAbstract;
import fr.proline.studio.graphics.PlotLinear;
import fr.proline.studio.graphics.PlotPanel;
import fr.proline.studio.graphics.PlotXYAbstract;
import fr.proline.studio.graphics.marker.AbstractMarker;
import fr.proline.studio.graphics.marker.IntervalMarker;
import fr.proline.studio.graphics.measurement.AbstractMeasurement;
import fr.proline.studio.graphics.measurement.IntegralMeasurement;
import fr.proline.studio.graphics.measurement.WidthMeasurement;
import fr.proline.studio.utils.IconManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractSpinnerModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple2;

public class SpectrumPanel
extends AbstractSpectrumPanel
implements ScanHeaderListener {
    private static final Logger logger = LoggerFactory.getLogger(SpectrumPanel.class);
    private static final int OVERLAY_KEY = 128;
    private ScanHeaderPanel headerSpectrumPanel;
    protected JToolBar spectrumToolbar;
    private boolean keepSameMsLevel = true;
    private ScansSpinnerModel spinnerModel;
    private JToggleButton m_freezeSpectrumBtn;
    private JToggleButton viewMobilogramBtn;
    private final BasePlotPanel mobilogramPlotPanel;
    private Mobilogram mobilogram;
    private MobilitySpectrum mobilitySpectrum;

    public SpectrumPanel(IRawFileViewer rawFilePanel) {
        super(rawFilePanel);
        PlotPanel plotPanel = new PlotPanel();
        this.mobilogramPlotPanel = plotPanel.getBasePlotPanel();
        this.mobilogramPlotPanel.setDrawCursor(true);
        this.mobilogramPlotPanel.setVisible(false);
    }

    @Override
    protected JToolBar getSpectrumToolbar() {
        this.spectrumToolbar = new JToolBar(0);
        this.spectrumToolbar.setFloatable(false);
        ExportButton exportImageButton = new ExportButton("Graphic", (JPanel)this.spectrumPlotPanel);
        this.spectrumToolbar.add((Component)exportImageButton);
        JButton displayIPBtn = new JButton();
        displayIPBtn.setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.ISOTOPES_PREDICTION));
        displayIPBtn.setToolTipText("Display Isotopic Patterns");
        displayIPBtn.addActionListener(e -> this.displayIsotopicPrediction(this.positionMarker.getValue()));
        this.spectrumToolbar.add(displayIPBtn);
        this.m_freezeSpectrumBtn = new JToggleButton(IconManager.getIcon((IconManager.IconType)IconManager.IconType.PIN));
        this.m_freezeSpectrumBtn.addActionListener(e -> {
            JToggleButton tBtn = (JToggleButton)e.getSource();
            if (tBtn.isSelected()) {
                this.setReferenceSpectrum(this.currentScan, Float.valueOf(1.0f));
            } else {
                this.clearReferenceSpectrumData();
            }
        });
        this.spectrumToolbar.add(this.m_freezeSpectrumBtn);
        JToggleButton autoZoomBtn = new JToggleButton();
        autoZoomBtn.setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.AUTO_ZOOM));
        autoZoomBtn.addActionListener(e -> {
            this.autoZoom = ((JToggleButton)e.getSource()).isSelected();
        });
        this.spectrumToolbar.add(autoZoomBtn);
        this.spectrumToolbar.addSeparator();
        JButton m_showCentroidBtn = new JButton();
        m_showCentroidBtn.setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.CENTROID_SPECTRA));
        m_showCentroidBtn.setToolTipText("Compute and show centroid peaks");
        m_showCentroidBtn.addActionListener(e -> this.showCentroid());
        this.spectrumToolbar.add(m_showCentroidBtn);
        JButton m_editSignalBtn = new JButton();
        m_editSignalBtn.setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.SIGNAL));
        m_editSignalBtn.setToolTipText("Spectrum signal processing dialog");
        m_editSignalBtn.addActionListener(e -> this.editSignal());
        this.spectrumToolbar.add(m_editSignalBtn);
        JButton testBtn = new JButton("iso");
        testBtn.setToolTipText("de-isotope centroid spectrum");
        testBtn.addActionListener(e -> this.processMS2Spectrum());
        this.spectrumToolbar.add(testBtn);
        this.viewMobilogramBtn = new JToggleButton("IM");
        this.viewMobilogramBtn.setToolTipText("View mobilogram");
        this.viewMobilogramBtn.setEnabled(false);
        this.viewMobilogramBtn.addActionListener(e -> this.toggleMobilogramPlot());
        this.spectrumToolbar.add(this.viewMobilogramBtn);
        this.spectrumToolbar.addSeparator();
        JButton m_forceCentroidBtn = new JButton();
        m_forceCentroidBtn.setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.FITTED_2_CENTROID));
        m_forceCentroidBtn.setToolTipText("Force Fitted to Centroid");
        m_forceCentroidBtn.addActionListener(e -> this.rawFileViewer.changeForceFittedToCentroid());
        this.spectrumToolbar.add(m_forceCentroidBtn);
        this.spectrumToolbar.addSeparator();
        this.spinnerModel = new ScansSpinnerModel();
        this.headerSpectrumPanel = new ScanHeaderPanel(null, this.spinnerModel);
        this.headerSpectrumPanel.addScanHeaderListener(this);
        this.spectrumToolbar.add(this.headerSpectrumPanel);
        return this.spectrumToolbar;
    }

    private void toggleMobilogramPlot() {
        if (this.splitPane.getRightComponent() == null) {
            if (this.currentScan != null) {
                this.mobilogramPlotPanel.setPlot((PlotBaseAbstract)this.buildMobilogramPlot());
            }
            this.mobilogramPlotPanel.setVisible(true);
            this.splitPane.setRightComponent((Component)this.mobilogramPlotPanel);
            this.splitPane.setDividerSize(3);
            this.splitPane.setDividerLocation(0.8);
        } else {
            this.mobilogramPlotPanel.setVisible(false);
            this.splitPane.setRightComponent(null);
            this.splitPane.setDividerLocation(1.0);
            this.splitPane.setDividerSize(0);
        }
    }

    protected PlotXYAbstract buildMobilogramPlot() {
        Color plotColor = this.rawFileViewer.getPlotColor(this.rawFileViewer.getCurrentRawfile() == null ? null : this.rawFileViewer.getCurrentRawfile().getName());
        MobilogramTableModel model = new MobilogramTableModel(this.mobilogram);
        PlotLinear plot = null;
        model.setColor(plotColor);
        plot = new PlotLinear(this.mobilogramPlotPanel, (ExtendedTableModelInterface)model, null, 0, 1);
        plot.addMeasurement((AbstractMeasurement)new IntegralMeasurement((PlotBaseAbstract)plot));
        plot.addMeasurement((AbstractMeasurement)new WidthMeasurement((PlotBaseAbstract)plot));
        plot.setStrokeFixed(true);
        plot.setPlotInformation(model.getPlotInformation());
        plot.setIsPaintMarker(true);
        return plot;
    }

    private void processMS2Spectrum() {
        if (this.currentScan.getDataType() == Spectrum.ScanType.CENTROID) {
            Spectrum newSpectrum = SpectrumUtils.deisotopeCentroidSpectrum(this.currentScan);
            this.setReferenceSpectrum(newSpectrum, Float.valueOf(-1.0f));
        }
    }

    private void showCentroid() {
        Signal signal = this.getSignal();
        this.scanPlot.clearMarkers();
        SmoothingParamDialog dialog = new SmoothingParamDialog((Window)WindowManager.getDefault().getMainWindow());
        dialog.pack();
        dialog.setVisible(true);
        if (dialog.getButtonClicked() == 0) {
            String smoothMethod;
            long start = System.currentTimeMillis();
            int nbrPoints = dialog.getNbrPoint();
            SavitzkyGolaySmoother smoother = switch (smoothMethod = dialog.getMethod()) {
                case "Savitzky-Golay Smoother" -> new SavitzkyGolaySmoother(new SavitzkyGolaySmoothingConfig(nbrPoints, 2, 1));
                case "Partial Savitzky-Golay Smoother" -> new PartialSavitzkyGolaySmoother(new SavitzkyGolaySmoothingConfig(nbrPoints, 4, 1));
                case "All Smoothers" -> {
                    JOptionPane.showMessageDialog(this, "Can't use all smoothing methods, Savitzky-Golay will be used.", "Smoothing Error", 2);
                    yield new SavitzkyGolaySmoother(new SavitzkyGolaySmoothingConfig(nbrPoints, 2, 1));
                }
                default -> new SavitzkyGolaySmoother(new SavitzkyGolaySmoothingConfig(nbrPoints, 2, 1));
            };
            List<Tuple2> input = signal.toScalaArrayTuple(false);
            Tuple2[] param = input.toArray(new Tuple2[input.size()]);
            long step1a = System.currentTimeMillis();
            Tuple2[] result = smoother.smoothTimeIntensityPairs(param);
            long step1 = System.currentTimeMillis();
            int resultLength = result.length;
            logger.debug("Smoothing: signal length after smoothing = " + resultLength + " vs before " + input.size() + ". TIME: " + (step1 - start) + " which " + (step1a - start) + " for arrays");
            double[] x = new double[resultLength];
            double[] y = new double[resultLength];
            for (int k = 0; k < resultLength; ++k) {
                x[k] = (Double)result[k]._1;
                y[k] = (Double)result[k]._2;
            }
            Signal newSignal = new Signal(x, y);
            long step2 = System.currentTimeMillis();
            logger.debug("Created new Signal. TIME: " + (step2 - step1));
            DerivativeAnalysis.ILocalDerivativeChange[] mm = DerivativeAnalysis.findMiniMaxi((double[])newSignal.getYSeries());
            long step3 = System.currentTimeMillis();
            logger.debug("DerivativeAnalysis Done, number min/max points = " + mm.length + ". TIME: " + (step3 - step2));
            int realLenght = 0;
            double[] newSpMasses = new double[mm.length];
            float[] newSpIntensities = new float[mm.length];
            double[] centroidSignalX = new double[mm.length];
            double[] centroidSignalY = new double[mm.length];
            for (int k = 0; k < mm.length; ++k) {
                if (!mm[k].isMaximum()) continue;
                double massIdx = newSignal.getXSeries()[mm[k].index()];
                double intensityIdx = signal.getYSeries()[mm[k].index()];
                centroidSignalY[realLenght] = centroidSignalX[realLenght] = massIdx;
                centroidSignalY[realLenght] = intensityIdx;
                newSpMasses[realLenght] = massIdx;
                newSpIntensities[realLenght] = (float)intensityIdx;
                ++realLenght;
            }
            Spectrum newSpectrum = new Spectrum(-1, this.currentScan.getRetentionTime(), Arrays.copyOfRange(newSpMasses, 0, realLenght), Arrays.copyOfRange(newSpIntensities, 0, realLenght), this.currentScan.getMsLevel(), Spectrum.ScanType.CENTROID);
            long step4 = System.currentTimeMillis();
            logger.debug("Create CentroidSignal values + display markers.Nbr real points = " + realLenght + ". TIME: " + (step4 - step3) + "TOTAL == " + (step4 - start));
            this.setReferenceSpectrum(newSpectrum, Float.valueOf(1.0f));
            this.m_freezeSpectrumBtn.setSelected(true);
        }
    }

    private void editSignal() {
        Signal signal = this.getSignal();
        ArrayList<Signal> signals = new ArrayList<Signal>();
        signals.add(signal);
        JDialog dialog = new JDialog((JFrame)this.getTopLevelAncestor(), "Spectra editor", true);
        dialog.setContentPane(SignalViewerBuilder.buildEditor(signals));
        dialog.pack();
        dialog.setVisible(true);
    }

    private Signal getSignal() {
        double min = this.spectrumPlotPanel.getXAxis().getMinValue();
        double max = this.spectrumPlotPanel.getXAxis().getMaxValue();
        int minIdx = SpectrumUtils.getNearestPeakIndex(this.currentScan.getMasses(), min);
        int maxIdx = Math.min(SpectrumUtils.getNearestPeakIndex(this.currentScan.getMasses(), max) + 1, this.currentScan.getMasses().length);
        Signal currentSignal = new Signal(Arrays.copyOfRange(this.currentScan.getMasses(), minIdx, maxIdx), Arrays.copyOfRange(this.currentScan.getIntensities(), minIdx, maxIdx));
        if (this.currentScan.getDataType().equals((Object)Spectrum.ScanType.CENTROID)) {
            currentSignal.setSignalType(1);
        }
        return currentSignal;
    }

    public void plotPanelMouseClicked(MouseEvent e, double mz, double yValue) {
        if (e.getClickCount() == 2) {
            if ((e.getModifiersEx() & 0x80) == 0 && this.rawFileViewer.getChromatogramDisplayMode() != Display.Mode.OVERLAY) {
                this.scanPlot.clearMarkers();
                this.scanPlot.addMarker((AbstractMarker)this.positionMarker);
            }
            this.positionMarker.setValue(mz);
            this.positionMarker.setVisible(true);
            float ppmTol = this.currentScan.getMsLevel() == 1 ? MzScopePreferences.getInstance().getMzPPMTolerance() : MzScopePreferences.getInstance().getFragmentMzPPMTolerance();
            double maxMz = mz + mz * (double)ppmTol / 1000000.0;
            double minMz = mz - mz * (double)ppmTol / 1000000.0;
            this.scanPlot.addMarker((AbstractMarker)new IntervalMarker(this.spectrumPlotPanel, Color.orange, Color.RED, minMz, maxMz));
            ExtractionRequest.Builder<?> builder = ExtractionRequest.builder(this);
            if (this.currentScan.getMsLevel() == 1) {
                ((ExtractionRequest.Builder)builder.setMz(mz)).setMzTolPPM(ppmTol);
            } else {
                ((ExtractionRequest.Builder)((ExtractionRequest.Builder)builder.setMz(this.currentScan.getPrecursorMz())).setFragmentMz(mz)).setFragmentMzTolPPM(ppmTol);
            }
            ExtractionRequest lastExtractionRequest = MzScopePreferences.getInstance().getLastExtractionRequest();
            if (lastExtractionRequest != null && !lastExtractionRequest.getMobilityRequestType().equals((Object)ExtractionRequest.Type.NONE)) {
                if (lastExtractionRequest.getMobilityRequestType().equals((Object)ExtractionRequest.Type.CENTERED)) {
                    builder.setMobility(lastExtractionRequest.getMobility());
                    builder.setMobilityTol(lastExtractionRequest.getMobilityTol());
                } else {
                    builder.setMinMobility(lastExtractionRequest.getMinMobility());
                    builder.setMaxMobility(lastExtractionRequest.getMaxMobility());
                }
            }
            ExtractionRequest extractionRequest = builder.build();
            if ((e.getModifiersEx() & 0x80) != 0) {
                this.rawFileViewer.extractAndDisplay(extractionRequest, new Display(Display.Mode.OVERLAY), null);
            } else {
                this.rawFileViewer.extractAndDisplay(extractionRequest, new Display(this.rawFileViewer.getChromatogramDisplayMode()), null);
            }
            this.updateMzRange(extractionRequest.getMinMz(), extractionRequest.getMaxMz());
        } else if (SwingUtilities.isLeftMouseButton(e)) {
            this.positionMarker.setValue(mz);
            this.positionMarker.setVisible(true);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("lastExtractionRequest")) {
            ExtractionRequest request = (ExtractionRequest)evt.getNewValue();
            if (request.getSource() != this) {
                logger.info("IRawFileViewer last extraction applied was " + request);
                if (this.mobilitySpectrum != null) {
                    if (!request.getMobilityRequestType().equals((Object)ExtractionRequest.Type.NONE)) {
                        this.updateMobilityRange(request.getMinMobility(), request.getMaxMobility());
                    } else if (this.rawFileViewer.getCurrentRawfile() != null) {
                        IonMobilityIndex mobilityIndex = this.rawFileViewer.getCurrentRawfile().getIonMobilityIndex();
                        this.updateMobilityRange(mobilityIndex.getMinValue(), mobilityIndex.getMaxValue());
                    }
                }
                if (this.currentScan != null && !request.getMzRequestType().equals((Object)ExtractionRequest.Type.NONE)) {
                    if (this.rawFileViewer.getChromatogramDisplayMode() != Display.Mode.OVERLAY) {
                        this.scanPlot.clearMarkers();
                        this.scanPlot.addMarker((AbstractMarker)this.positionMarker);
                    }
                    this.positionMarker.setValue(request.getMz());
                    this.positionMarker.setVisible(true);
                    this.scanPlot.addMarker((AbstractMarker)new IntervalMarker(this.spectrumPlotPanel, Color.orange, Color.RED, request.getMinMz(), request.getMaxMz()));
                    this.spectrumPlotPanel.repaint();
                }
                if (this.mobilitySpectrum != null && this.mobilogramPlotPanel.isVisible()) {
                    if (request.getMzRequestType().equals((Object)ExtractionRequest.Type.NONE)) {
                        this.updateMzRange(Double.MIN_VALUE, Double.MAX_VALUE);
                    } else {
                        this.updateMzRange(request.getMinMz(), request.getMaxMz());
                    }
                    ((PlotBaseAbstract)this.mobilogramPlotPanel.getPlots().get(0)).clearMarkers();
                    if (!request.getMobilityRequestType().equals((Object)ExtractionRequest.Type.NONE)) {
                        ((PlotBaseAbstract)this.mobilogramPlotPanel.getPlots().get(0)).addMarker((AbstractMarker)new IntervalMarker(this.mobilogramPlotPanel, Color.orange, Color.RED, request.getMinMobility(), request.getMaxMobility()));
                    }
                    this.mobilogramPlotPanel.repaint();
                }
            } else {
                logger.debug("Event ignored : " + evt);
            }
        }
    }

    public void updateMobilityRange(double min, double max) {
        if (this.mobilitySpectrum.getMsLevel() == 1) {
            Spectrum spectrum = this.mobilitySpectrum.applyMobilityFilterbySum(min, max);
            this._displayScan(spectrum);
        }
    }

    public void updateMzRange(double min, double max) {
        if (this.mobilogramPlotPanel.isVisible() && this.mobilogram != null) {
            this.mobilogram.setMzFilter(min, max);
            ((PlotBaseAbstract)this.mobilogramPlotPanel.getPlots().get(0)).update();
            this.mobilogramPlotPanel.repaint();
        }
    }

    private MobilitySpectrum asMobilitySpectrum(Spectrum scan) {
        if (MobilitySpectrum.class.isAssignableFrom(scan.getClass())) {
            return (MobilitySpectrum)scan;
        }
        return new MobilitySpectrum(scan, this.rawFileViewer.getCurrentRawfile().getIonMobilityIndex());
    }

    @Override
    public void updateRetentionTime(float retentionTime) {
        int scanIdx = this.rawFileViewer.getCurrentRawfile().getSpectrumId(retentionTime);
        this.rawFileViewer.displayScan(scanIdx);
    }

    @Override
    public void keepMsLevel(boolean keep) {
        this.keepSameMsLevel = keep;
    }

    @Override
    public void addMarkerRange(double minMz, double maxMz) {
        this.scanPlot.addMarker((AbstractMarker)new IntervalMarker(this.spectrumPlotPanel, Color.orange, Color.RED, minMz, maxMz));
    }

    @Override
    public void displayScan(Spectrum scan) {
        if (scan != null && !MobilitySpectrum.class.isAssignableFrom(scan.getClass())) {
            Spectrum wScan = scan;
            if (scan.hasIonMobilitySeparation()) {
                this.mobilitySpectrum = this.asMobilitySpectrum(scan);
                this.mobilogram = new Mobilogram(this.mobilitySpectrum);
                wScan = this.mobilitySpectrum.applyMobilityFilterbySum(Double.MIN_VALUE, Double.MAX_VALUE);
            } else {
                this.mobilitySpectrum = null;
                this.mobilogram = null;
            }
            this._displayScan(wScan);
            this.headerSpectrumPanel.setMzdbFileName(this.rawFileViewer.getCurrentRawfile().getName());
            this.spinnerModel.setValue(this.currentScan.getIndex());
            this.headerSpectrumPanel.setScan(this.currentScan);
            this.viewMobilogramBtn.setEnabled(this.mobilitySpectrum != null);
            if (this.mobilogramPlotPanel.isVisible() && this.mobilogram != null) {
                this.mobilogramPlotPanel.setPlot((PlotBaseAbstract)this.buildMobilogramPlot());
                this.mobilogramPlotPanel.repaint();
            }
        } else {
            this._displayScan(scan);
            this.viewMobilogramBtn.setEnabled(scan != null && scan.hasIonMobilitySeparation());
        }
    }

    private void _displayScan(Spectrum scan) {
        super.displayScan(scan);
    }

    public int getNextScanIndex(Integer spectrumIndex) {
        if (this.keepSameMsLevel) {
            return this.rawFileViewer.getCurrentRawfile().getNextSpectrumId(spectrumIndex, this.currentScan.getMsLevel());
        }
        return Math.min(this.currentScan.getIndex() + 1, this.rawFileViewer.getCurrentRawfile().getSpectrumCount() - 1);
    }

    public int getPreviousScanIndex(Integer spectrumIndex) {
        if (this.keepSameMsLevel) {
            return this.rawFileViewer.getCurrentRawfile().getPreviousSpectrumId(spectrumIndex, this.currentScan.getMsLevel());
        }
        return Math.max(1, this.currentScan.getIndex() - 1);
    }

    class ScansSpinnerModel
    extends AbstractSpinnerModel {
        ScansSpinnerModel() {
        }

        @Override
        public Object getValue() {
            return SpectrumPanel.this.currentScan == null ? 0 : SpectrumPanel.this.currentScan.getIndex();
        }

        @Override
        public void setValue(Object value) {
            if (((Integer)value).intValue() != ((Integer)this.getValue()).intValue()) {
                SpectrumPanel.this.rawFileViewer.displayScan(((Integer)value).intValue());
            }
            this.fireStateChanged();
        }

        @Override
        public Object getNextValue() {
            return SpectrumPanel.this.currentScan == null ? 0 : SpectrumPanel.this.getNextScanIndex(SpectrumPanel.this.currentScan.getIndex());
        }

        @Override
        public Object getPreviousValue() {
            return SpectrumPanel.this.currentScan == null ? 0 : SpectrumPanel.this.getPreviousScanIndex(SpectrumPanel.this.currentScan.getIndex());
        }
    }
}

