/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.mzscope.ui.peakels;

import fr.profi.mzdb.model.Peakel;
import fr.proline.studio.extendedtablemodel.ExtendedTableModelInterface;
import fr.proline.studio.extendedtablemodel.ExtraDataType;
import fr.proline.studio.graphics.PlotDataSpec;
import fr.proline.studio.graphics.PlotInformation;
import fr.proline.studio.utils.CyclicColorPalette;
import fr.proline.studio.utils.DataFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

class PeakelWrapper
implements ExtendedTableModelInterface {
    Peakel m_peakel;
    int m_isotopeIndex;
    PlotInformation m_plotInformation = null;

    public PeakelWrapper(Peakel p, int i) {
        this.m_peakel = p;
        this.m_isotopeIndex = i;
    }

    public int getRowCount() {
        return this.m_peakel.getElutionTimes().length;
    }

    public int getColumnCount() {
        return 2;
    }

    public String getDataColumnIdentifier(int columnIndex) {
        return columnIndex == 0 ? "rt" : "intensity";
    }

    public Class getDataColumnClass(int columnIndex) {
        return Float.class;
    }

    public Object getDataValueAt(int rowIndex, int columnIndex) {
        return Float.valueOf(columnIndex == 0 ? this.m_peakel.getElutionTimes()[rowIndex] / 60.0f : this.m_peakel.getIntensityValues()[rowIndex]);
    }

    public int[] getKeysColumn() {
        return new int[]{0};
    }

    public int getInfoColumn() {
        return 0;
    }

    public void setName(String name) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String getName() {
        return "Elution peak";
    }

    public Map<String, Object> getExternalData() {
        return null;
    }

    public PlotInformation getPlotInformation() {
        if (this.m_plotInformation == null) {
            this.m_plotInformation = new PlotInformation();
            this.m_plotInformation.setPlotColor(CyclicColorPalette.getColor((int)1));
            this.m_plotInformation.setPlotTitle("Elution peak\n");
            this.m_plotInformation.setDrawPoints(false);
            this.m_plotInformation.setDrawGap(true);
            HashMap<String, String> plotInfo = new HashMap<String, String>();
            plotInfo.put("m/z", Double.toString(this.m_peakel.getApexMz()));
            plotInfo.put("Apex Int.", DataFormat.formatWithGroupingSep((Number)Float.valueOf(this.m_peakel.getApexIntensity()), (int)0));
            plotInfo.put("Isotope index", Integer.toString(this.m_isotopeIndex));
            this.m_plotInformation.setPlotInfo(plotInfo);
        }
        return this.m_plotInformation;
    }

    public long row2UniqueId(int rowIndex) {
        return rowIndex;
    }

    public int uniqueId2Row(long id) {
        return (int)id;
    }

    public ArrayList<ExtraDataType> getExtraDataTypes() {
        return null;
    }

    public Object getValue(Class c) {
        return null;
    }

    public Object getRowValue(Class c, int row) {
        return null;
    }

    public Object getColValue(Class c, int col) {
        return null;
    }

    public void addSingleValue(Object v) {
    }

    public Object getSingleValue(Class c) {
        return null;
    }

    public PlotDataSpec getDataSpecAt(int i) {
        return null;
    }
}

