/*
 * Decompiled with CFR 0.152.
 */
package javolution.context;

import javolution.context.AbstractContext;
import javolution.lang.Configurable;
import javolution.lang.MathLib;
import javolution.osgi.internal.OSGiServices;

public abstract class ConcurrentContext
extends AbstractContext {
    public static final Configurable<Integer> CONCURRENCY = new Configurable<Integer>(){

        @Override
        protected Integer getDefault() {
            return Runtime.getRuntime().availableProcessors() - 1;
        }

        @Override
        protected Integer initialized(Integer value) {
            return MathLib.min(value, 65536);
        }

        @Override
        protected Integer reconfigured(Integer oldCount, Integer newCount) {
            throw new UnsupportedOperationException("Concurrency reconfiguration not supported.");
        }
    };

    protected ConcurrentContext() {
    }

    public static ConcurrentContext enter() {
        ConcurrentContext ctx = ConcurrentContext.current(ConcurrentContext.class);
        if (ctx == null) {
            ctx = OSGiServices.getConcurrentContext();
        }
        return (ConcurrentContext)ctx.enterInner();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execute(Runnable ... logics) {
        ConcurrentContext ctx = ConcurrentContext.enter();
        try {
            for (Runnable logic : logics) {
                ctx.execute(logic);
            }
        }
        finally {
            ctx.exit();
        }
    }

    public abstract void execute(Runnable var1);

    public abstract void setConcurrency(int var1);

    public abstract int getConcurrency();

    @Override
    public void exit() {
        super.exit();
    }
}

