/*
 * Decompiled with CFR 0.152.
 */
package javolution.context.internal;

import com.nativelibs4java.opencl.CLBuffer;
import com.nativelibs4java.opencl.CLContext;
import com.nativelibs4java.opencl.CLDevice;
import com.nativelibs4java.opencl.CLEvent;
import com.nativelibs4java.opencl.CLKernel;
import com.nativelibs4java.opencl.CLMem;
import com.nativelibs4java.opencl.CLPlatform;
import com.nativelibs4java.opencl.CLProgram;
import com.nativelibs4java.opencl.CLQueue;
import com.nativelibs4java.opencl.JavaCL;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javolution.context.ComputeContext;
import javolution.context.LogContext;
import javolution.util.FastMap;
import javolution.util.FastTable;
import org.bridj.Pointer;

public final class ComputeContextImpl
extends ComputeContext {
    private static final String PRAGMA_DOUBLE_SUPPORT = "#pragma OPENCL EXTENSION cl_khr_fp64 : enable\n";
    private static CLContext clContext;
    private static CLQueue clQueue;
    private final ComputeContextImpl parent;
    private final FastMap<Class<? extends ComputeContext.Program>, ProgramImpl> programs = new FastMap();
    private final FastTable<BufferImpl> buffers = new FastTable();

    public ComputeContextImpl() {
        this.parent = null;
    }

    public ComputeContextImpl(ComputeContextImpl parent) {
        this.parent = parent;
    }

    @Override
    protected BufferImpl createBuffer(Buffer init) {
        BufferImpl buffer = new BufferImpl(init);
        if (this.parent != null) {
            this.buffers.add(buffer);
        }
        return buffer;
    }

    @Override
    protected BufferImpl createBuffer(long byteCount) {
        ComputeContextImpl.checkOpenCL();
        BufferImpl buffer = new BufferImpl(byteCount);
        if (this.parent != null) {
            this.buffers.add(buffer);
        }
        return buffer;
    }

    @Override
    protected KernelImpl createKernel(Class<? extends ComputeContext.Program> programClass, String kernelName) {
        CLKernel clKernel;
        ComputeContextImpl.checkOpenCL();
        ProgramImpl program = this.searchProgram(programClass);
        if (program == null) {
            this.loadAndBuild(ComputeContextImpl.newInstance(programClass));
            program = this.programs.get(programClass);
        }
        if ((clKernel = program.kernels.get(kernelName)) == null) {
            throw new IllegalArgumentException("Kernel " + kernelName + " not defined in " + programClass.getName());
        }
        return new KernelImpl(clKernel);
    }

    @Override
    public void exit() {
        for (BufferImpl buffer : this.buffers) {
            buffer.release();
        }
        for (ProgramImpl program : this.programs.values()) {
            program.release();
        }
        super.exit();
    }

    @Override
    protected ComputeContextImpl inner() {
        return new ComputeContextImpl(this);
    }

    @Override
    protected void loadAndBuild(ComputeContext.Program program) {
        ComputeContextImpl.checkOpenCL();
        if (this.searchProgram(program.getClass()) != null) {
            return;
        }
        ProgramImpl prg = new ProgramImpl(program.toOpenCL());
        this.programs.put(program.getClass(), prg);
    }

    private ProgramImpl searchProgram(Class<? extends ComputeContext.Program> cls) {
        ProgramImpl program = this.programs.get(cls);
        if (program != null) {
            return program;
        }
        if (this.parent != null) {
            return this.parent.searchProgram(cls);
        }
        return null;
    }

    @Override
    protected void unloadAndFree(ComputeContext.Program program) {
        ComputeContextImpl.checkOpenCL();
        ProgramImpl prg = this.programs.remove(program.getClass());
        if (prg != null) {
            prg.release();
        }
    }

    private static void checkOpenCL() {
        if (clQueue == null) {
            throw new UnsupportedOperationException("No OpenCL Driver Installed.");
        }
    }

    private static CLContext createContext() {
        CLDevice[] devices;
        boolean doublePrecisionRequired = ComputeContext.DOUBLE_PRECISION_REQUIRED.get();
        CLContext context = doublePrecisionRequired ? JavaCL.createBestContext((CLPlatform.DeviceFeature[])new CLPlatform.DeviceFeature[]{CLPlatform.DeviceFeature.DoubleSupport, CLPlatform.DeviceFeature.GPU, CLPlatform.DeviceFeature.MaxComputeUnits}) : JavaCL.createBestContext((CLPlatform.DeviceFeature[])new CLPlatform.DeviceFeature[]{CLPlatform.DeviceFeature.GPU, CLPlatform.DeviceFeature.MaxComputeUnits});
        for (CLDevice device : devices = context.getDevices()) {
            if (doublePrecisionRequired) {
                LogContext.info("ComputeContext device (double precision support required): ", device);
                continue;
            }
            LogContext.info("ComputeContext device (double precision support not required): ", device);
        }
        return context;
    }

    private static ComputeContext.Program newInstance(Class<? extends ComputeContext.Program> programClass) {
        try {
            return programClass.newInstance();
        }
        catch (InstantiationException e) {
            LogContext.error(e);
            throw new InstantiationError(e.getMessage());
        }
        catch (IllegalAccessException e) {
            LogContext.error(e);
            throw new IllegalAccessError(e.getMessage());
        }
    }

    static {
        Logger.getLogger("org.bridj").setLevel(Level.WARNING);
        try {
            clContext = ComputeContextImpl.createContext();
            clQueue = clContext.createDefaultQueue(new CLDevice.QueueProperties[0]);
        }
        catch (Throwable error) {
            LogContext.warning("OpenCL drivers not installed; ComputeContext disabled!");
        }
    }

    class ProgramImpl {
        CLProgram clProgram;
        FastMap<String, CLKernel> kernels = new FastMap();

        ProgramImpl(String opencl) {
            CLKernel[] clKernels;
            this.clProgram = clContext.createProgram(new String[]{ComputeContextImpl.PRAGMA_DOUBLE_SUPPORT + opencl});
            for (CLKernel clKernel : clKernels = this.clProgram.createKernels()) {
                this.kernels.put(clKernel.getFunctionName(), clKernel);
            }
        }

        void release() {
            for (CLKernel kernel : this.kernels.values()) {
                kernel.release();
            }
            this.clProgram.release();
        }
    }

    class KernelImpl
    implements ComputeContext.Kernel {
        CLKernel clKernel;
        int[] globalWorkSize;
        int[] localWorkSize;
        FastTable<BufferImpl> updatedBuffers = new FastTable();
        FastTable<CLEvent> dependencies = new FastTable();

        KernelImpl(CLKernel clKernel) {
            this.clKernel = clKernel;
        }

        @Override
        public void execute() {
            CLEvent updateEvt = this.clKernel.enqueueNDRange(clQueue, this.globalWorkSize, this.localWorkSize, this.dependencies.toArray(new CLEvent[0]));
            for (BufferImpl buffer : this.updatedBuffers) {
                buffer.updateEvent = updateEvt;
            }
        }

        @Override
        public void setArguments(Object ... args) {
            int i = 0;
            for (Object arg : args) {
                if (arg instanceof ComputeContext.Buffer) {
                    BufferImpl buffer;
                    if (arg instanceof BufferImpl.ReadOnly) {
                        buffer = ((BufferImpl.ReadOnly)arg).buffer();
                    } else {
                        buffer = (BufferImpl)arg;
                        this.updatedBuffers.add(buffer);
                    }
                    if (buffer.updateEvent != null) {
                        this.dependencies.add(buffer.updateEvent);
                    }
                    buffer.copyToDevice();
                    this.clKernel.setArg(i++, buffer.clBuffer);
                    continue;
                }
                if (arg instanceof Boolean) {
                    this.clKernel.setArg(i++, ((Boolean)arg).booleanValue());
                    continue;
                }
                if (arg instanceof Byte) {
                    this.clKernel.setArg(i++, ((Byte)arg).byteValue());
                    continue;
                }
                if (arg instanceof Short) {
                    this.clKernel.setArg(i++, ((Short)arg).shortValue());
                    continue;
                }
                if (arg instanceof Integer) {
                    this.clKernel.setArg(i++, ((Integer)arg).intValue());
                    continue;
                }
                if (arg instanceof Long) {
                    this.clKernel.setArg(i++, ((Long)arg).longValue());
                    continue;
                }
                if (arg instanceof Float) {
                    this.clKernel.setArg(i++, ((Float)arg).floatValue());
                    continue;
                }
                if (arg instanceof Double) {
                    this.clKernel.setArg(i++, ((Double)arg).doubleValue());
                    continue;
                }
                throw new IllegalArgumentException("Argument " + arg + " is not a Buffer or a primitive type supported.");
            }
        }

        @Override
        public void setGlobalWorkSize(int ... gws) {
            this.globalWorkSize = gws;
        }

        @Override
        public void setLocalWorkSize(int ... lws) {
            this.localWorkSize = lws;
        }
    }

    class BufferImpl
    implements ComputeContext.Buffer {
        ByteBuffer byteBuffer;
        CLBuffer<Byte> clBuffer;
        CLEvent updateEvent;

        BufferImpl(Buffer init) {
            this.clBuffer = clContext.createByteBuffer(CLMem.Usage.InputOutput, init, true);
        }

        BufferImpl(long byteCount) {
            this.clBuffer = clContext.createByteBuffer(CLMem.Usage.InputOutput, byteCount);
        }

        @Override
        public ByteBuffer asByteBuffer() {
            this.export();
            return this.byteBuffer;
        }

        @Override
        public CharBuffer asCharBuffer() {
            return this.asByteBuffer().asCharBuffer();
        }

        @Override
        public DoubleBuffer asDoubleBuffer() {
            if (!ComputeContext.DOUBLE_PRECISION_REQUIRED.get().booleanValue()) {
                throw new UnsupportedOperationException("ComputeContext#DOUBLE_PRECISION_REQUIRED disabled");
            }
            return this.asByteBuffer().asDoubleBuffer();
        }

        @Override
        public FloatBuffer asFloatBuffer() {
            return this.asByteBuffer().asFloatBuffer();
        }

        @Override
        public IntBuffer asIntBuffer() {
            return this.asByteBuffer().asIntBuffer();
        }

        @Override
        public LongBuffer asLongBuffer() {
            return this.asByteBuffer().asLongBuffer();
        }

        @Override
        public ShortBuffer asShortBuffer() {
            return this.asByteBuffer().asShortBuffer();
        }

        void copyToDevice() {
            if (this.clBuffer != null) {
                return;
            }
            this.clBuffer = clContext.createByteBuffer(CLMem.Usage.InputOutput, (Buffer)this.byteBuffer, true);
        }

        @Override
        public void export() {
            if (this.byteBuffer != null) {
                return;
            }
            if (this.clBuffer == null) {
                throw new UnsupportedOperationException("The device buffer has already been released.");
            }
            if (this.getByteCount() > Integer.MAX_VALUE) {
                throw new UnsupportedOperationException("Buffer byte count exceeds java.nio.ByteBuffer maximum capacity");
            }
            this.byteBuffer = ByteBuffer.allocateDirect((int)this.getByteCount()).order(clQueue.getDevice().getByteOrder());
            this.clBuffer.read(clQueue, Pointer.pointerToBuffer((Buffer)this.byteBuffer), true, new CLEvent[]{this.updateEvent});
            this.release();
        }

        @Override
        public long getByteCount() {
            return this.clBuffer != null ? this.clBuffer.getByteCount() : (long)this.byteBuffer.capacity();
        }

        @Override
        public ComputeContext.Buffer readOnly() {
            return new ReadOnly();
        }

        void release() {
            if (this.clBuffer != null) {
                this.clBuffer.release();
            }
            this.clBuffer = null;
            if (this.updateEvent != null) {
                this.updateEvent.release();
            }
            this.updateEvent = null;
        }

        class ReadOnly
        implements ComputeContext.Buffer {
            ReadOnly() {
            }

            @Override
            public ByteBuffer asByteBuffer() {
                return BufferImpl.this.asByteBuffer().asReadOnlyBuffer();
            }

            @Override
            public CharBuffer asCharBuffer() {
                return this.asByteBuffer().asCharBuffer();
            }

            @Override
            public DoubleBuffer asDoubleBuffer() {
                if (!ComputeContext.DOUBLE_PRECISION_REQUIRED.get().booleanValue()) {
                    throw new UnsupportedOperationException("ComputeContext#DOUBLE_PRECISION_REQUIRED disabled");
                }
                return this.asByteBuffer().asDoubleBuffer();
            }

            @Override
            public FloatBuffer asFloatBuffer() {
                return this.asByteBuffer().asFloatBuffer();
            }

            @Override
            public IntBuffer asIntBuffer() {
                return this.asByteBuffer().asIntBuffer();
            }

            @Override
            public LongBuffer asLongBuffer() {
                return this.asByteBuffer().asLongBuffer();
            }

            @Override
            public ShortBuffer asShortBuffer() {
                return this.asByteBuffer().asShortBuffer();
            }

            BufferImpl buffer() {
                return BufferImpl.this;
            }

            @Override
            public void export() {
                this.buffer().export();
            }

            @Override
            public long getByteCount() {
                return this.buffer().getByteCount();
            }

            @Override
            public ComputeContext.Buffer readOnly() {
                return this;
            }
        }
    }
}

