/*
 * Decompiled with CFR 0.152.
 */
package javolution.util;

import java.util.Comparator;
import java.util.Map;
import java.util.SortedMap;
import javolution.lang.Realtime;
import javolution.util.FastMap;
import javolution.util.FastSortedSet;
import javolution.util.function.Equalities;
import javolution.util.function.Equality;
import javolution.util.internal.map.sorted.AtomicSortedMapImpl;
import javolution.util.internal.map.sorted.FastSortedMapImpl;
import javolution.util.internal.map.sorted.SharedSortedMapImpl;
import javolution.util.internal.map.sorted.UnmodifiableSortedMapImpl;
import javolution.util.service.SortedMapService;

public class FastSortedMap<K, V>
extends FastMap<K, V>
implements SortedMap<K, V> {
    private static final long serialVersionUID = 1536L;

    public static <K, V> FastSortedMap<K, V> of(Map<? extends K, ? extends V> that) {
        FastSortedMap<? extends K, ? extends V> map = new FastSortedMap<K, V>();
        map.putAll(that);
        return map;
    }

    public FastSortedMap() {
        this(Equalities.STANDARD);
    }

    public FastSortedMap(Equality<? super K> keyComparator) {
        this(keyComparator, Equalities.STANDARD);
    }

    public FastSortedMap(Equality<? super K> keyComparator, Equality<? super V> valueComparator) {
        super(new FastSortedMapImpl<K, V>(keyComparator, valueComparator));
    }

    protected FastSortedMap(SortedMapService<K, V> service) {
        super(service);
    }

    @Override
    public FastSortedMap<K, V> atomic() {
        return new FastSortedMap(new AtomicSortedMapImpl(this.service()));
    }

    @Override
    public FastSortedMap<K, V> shared() {
        return new FastSortedMap(new SharedSortedMapImpl(this.service()));
    }

    @Override
    public FastSortedMap<K, V> unmodifiable() {
        return new FastSortedMap(new UnmodifiableSortedMapImpl(this.service()));
    }

    @Override
    public FastSortedSet<Map.Entry<K, V>> entrySet() {
        return new FastSortedSet(this.service().entrySet());
    }

    @Override
    public FastSortedSet<K> keySet() {
        return new FastSortedSet(this.service().keySet());
    }

    @Override
    public FastSortedMap<K, V> subMap(K fromKey, K toKey) {
        return new FastSortedMap(this.service().subMap(fromKey, toKey));
    }

    @Override
    public FastSortedMap<K, V> headMap(K toKey) {
        return new FastSortedMap(this.service().subMap(this.firstKey(), toKey));
    }

    @Override
    public FastSortedMap<K, V> tailMap(K fromKey) {
        return new FastSortedMap(this.service().subMap(fromKey, this.lastKey()));
    }

    @Override
    @Realtime(limit=Realtime.Limit.LOG_N)
    public boolean containsKey(Object key) {
        return super.containsKey(key);
    }

    @Override
    @Realtime(limit=Realtime.Limit.LOG_N)
    public V get(Object key) {
        return super.get(key);
    }

    @Override
    @Realtime(limit=Realtime.Limit.LOG_N)
    public V put(K key, V value) {
        return super.put(key, value);
    }

    @Override
    @Realtime(limit=Realtime.Limit.LOG_N)
    public V remove(Object key) {
        return super.remove(key);
    }

    @Override
    @Realtime(limit=Realtime.Limit.LOG_N)
    public V putIfAbsent(K key, V value) {
        return super.putIfAbsent(key, value);
    }

    @Override
    @Realtime(limit=Realtime.Limit.LOG_N)
    public boolean remove(Object key, Object value) {
        return super.remove(key, value);
    }

    @Override
    @Realtime(limit=Realtime.Limit.LOG_N)
    public boolean replace(K key, V oldValue, V newValue) {
        return super.replace(key, oldValue, newValue);
    }

    @Override
    @Realtime(limit=Realtime.Limit.LOG_N)
    public V replace(K key, V value) {
        return super.replace(key, value);
    }

    @Override
    public K firstKey() {
        return this.service().firstKey();
    }

    @Override
    public K lastKey() {
        return this.service().lastKey();
    }

    @Override
    public Comparator<? super K> comparator() {
        return ((FastSortedSet)this.keySet()).comparator();
    }

    @Override
    public FastSortedMap<K, V> add(K key, V value) {
        return (FastSortedMap)super.add(key, value);
    }

    @Override
    protected SortedMapService<K, V> service() {
        return (SortedMapService)super.service();
    }
}

