/*
 * Decompiled with CFR 0.152.
 */
package javolution.util.internal.map.sorted;

import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import javolution.util.function.Equality;
import javolution.util.internal.map.sorted.SortedMapView;
import javolution.util.service.SortedMapService;

public class SubSortedMapImpl<K, V>
extends SortedMapView<K, V> {
    private static final long serialVersionUID = 1536L;
    private final K from;
    private final K to;

    public SubSortedMapImpl(SortedMapService<K, V> target, K from, K to) {
        super(target);
        if (from != null && to != null && this.keyComparator().compare(from, to) > 0) {
            throw new IllegalArgumentException("from: " + from + ", to: " + to);
        }
        this.from = from;
        this.to = to;
    }

    @Override
    public boolean containsKey(Object key) {
        Equality<K> cmp = this.keyComparator();
        if (this.from != null && cmp.compare(key, this.from) < 0) {
            return false;
        }
        if (this.to != null && cmp.compare(key, this.to) >= 0) {
            return false;
        }
        return this.target().containsKey(key);
    }

    @Override
    public K firstKey() {
        if (this.from == null) {
            return this.target().firstKey();
        }
        Iterator<Map.Entry<K, V>> it = this.iterator();
        if (!it.hasNext()) {
            throw new NoSuchElementException();
        }
        return it.next().getKey();
    }

    @Override
    public V get(Object key) {
        Equality<K> cmp = this.keyComparator();
        if (this.from != null && cmp.compare(key, this.from) < 0) {
            return null;
        }
        if (this.to != null && cmp.compare(key, this.to) >= 0) {
            return null;
        }
        return this.target().get(key);
    }

    @Override
    public Iterator<Map.Entry<K, V>> iterator() {
        return new IteratorImpl();
    }

    @Override
    public Equality<? super K> keyComparator() {
        return this.target().keyComparator();
    }

    @Override
    public K lastKey() {
        if (this.to == null) {
            return this.target().lastKey();
        }
        Iterator<Map.Entry<K, V>> it = this.iterator();
        if (!it.hasNext()) {
            throw new NoSuchElementException();
        }
        Map.Entry<K, V> last = it.next();
        while (it.hasNext()) {
            last = it.next();
        }
        return last.getKey();
    }

    @Override
    public V put(K key, V value) {
        Equality<K> cmp = this.keyComparator();
        if (this.from != null && cmp.compare(key, this.from) < 0) {
            throw new IllegalArgumentException("Key: " + key + " outside of this sub-map bounds");
        }
        if (this.to != null && cmp.compare(key, this.to) >= 0) {
            throw new IllegalArgumentException("Key: " + key + " outside of this sub-map bounds");
        }
        return this.target().put(key, value);
    }

    @Override
    public V remove(Object key) {
        Equality<K> cmp = this.keyComparator();
        if (this.from != null && cmp.compare(key, this.from) < 0) {
            return null;
        }
        if (this.to != null && cmp.compare(key, this.to) >= 0) {
            return null;
        }
        return this.target().remove(key);
    }

    @Override
    public Equality<? super V> valueComparator() {
        return this.target().valueComparator();
    }

    private class IteratorImpl
    implements Iterator<Map.Entry<K, V>> {
        private boolean ahead;
        private final Equality<? super K> cmp;
        private Map.Entry<K, V> next;
        private final Iterator<Map.Entry<K, V>> targetIterator;

        private IteratorImpl() {
            this.cmp = SubSortedMapImpl.this.keyComparator();
            this.targetIterator = SubSortedMapImpl.this.target().iterator();
        }

        @Override
        public boolean hasNext() {
            if (this.ahead) {
                return true;
            }
            while (this.targetIterator.hasNext()) {
                this.next = this.targetIterator.next();
                if (SubSortedMapImpl.this.from != null && this.cmp.compare(this.next.getKey(), SubSortedMapImpl.this.from) < 0) continue;
                if (SubSortedMapImpl.this.to != null && this.cmp.compare(this.next.getKey(), SubSortedMapImpl.this.to) >= 0) break;
                this.ahead = true;
                return true;
            }
            return false;
        }

        @Override
        public Map.Entry<K, V> next() {
            this.hasNext();
            this.ahead = false;
            return this.next;
        }

        @Override
        public void remove() {
            this.targetIterator.remove();
        }
    }
}

