/*
 * Decompiled with CFR 0.152.
 */
package javolution.util.internal.table;

import java.util.Collection;
import java.util.Iterator;
import java.util.ListIterator;
import javolution.util.internal.ReadWriteLockImpl;
import javolution.util.internal.collection.SharedCollectionImpl;
import javolution.util.internal.table.ReversedTableImpl;
import javolution.util.internal.table.SubTableImpl;
import javolution.util.internal.table.TableIteratorImpl;
import javolution.util.service.TableService;

public class SharedTableImpl<E>
extends SharedCollectionImpl<E>
implements TableService<E> {
    private static final long serialVersionUID = 1536L;

    public SharedTableImpl(TableService<E> target) {
        super(target);
    }

    public SharedTableImpl(TableService<E> target, ReadWriteLockImpl lock) {
        super(target, lock);
    }

    @Override
    public void add(int index, E element) {
        this.lock.writeLock.lock();
        try {
            this.target().add(index, element);
        }
        finally {
            this.lock.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        this.lock.writeLock.lock();
        try {
            boolean bl = this.target().addAll(index, c);
            return bl;
        }
        finally {
            this.lock.writeLock.unlock();
        }
    }

    @Override
    public void addFirst(E element) {
        this.lock.writeLock.lock();
        try {
            this.target().addFirst(element);
        }
        finally {
            this.lock.writeLock.unlock();
        }
    }

    @Override
    public void addLast(E element) {
        this.lock.writeLock.lock();
        try {
            this.target().addLast(element);
        }
        finally {
            this.lock.writeLock.unlock();
        }
    }

    @Override
    public Iterator<E> descendingIterator() {
        return new ReversedTableImpl(this).iterator();
    }

    @Override
    public E element() {
        return this.getFirst();
    }

    @Override
    public E get(int index) {
        this.lock.readLock.lock();
        try {
            Object e = this.target().get(index);
            return e;
        }
        finally {
            this.lock.readLock.unlock();
        }
    }

    @Override
    public E getFirst() {
        this.lock.readLock.lock();
        try {
            Object e = this.target().getFirst();
            return e;
        }
        finally {
            this.lock.readLock.unlock();
        }
    }

    @Override
    public E getLast() {
        this.lock.readLock.lock();
        try {
            Object e = this.target().getLast();
            return e;
        }
        finally {
            this.lock.readLock.unlock();
        }
    }

    @Override
    public int indexOf(Object element) {
        this.lock.readLock.lock();
        try {
            int n = this.target().indexOf(element);
            return n;
        }
        finally {
            this.lock.readLock.unlock();
        }
    }

    @Override
    public ListIterator<E> iterator() {
        return this.target().listIterator(0);
    }

    @Override
    public int lastIndexOf(Object element) {
        this.lock.readLock.lock();
        try {
            int n = this.target().lastIndexOf(element);
            return n;
        }
        finally {
            this.lock.readLock.unlock();
        }
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.target().listIterator(0);
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return new TableIteratorImpl(this, index);
    }

    @Override
    public boolean offer(E e) {
        return this.offerLast(e);
    }

    @Override
    public boolean offerFirst(E e) {
        this.lock.writeLock.lock();
        try {
            boolean bl = this.target().offerFirst(e);
            return bl;
        }
        finally {
            this.lock.writeLock.unlock();
        }
    }

    @Override
    public boolean offerLast(E e) {
        this.lock.writeLock.lock();
        try {
            boolean bl = this.target().offerLast(e);
            return bl;
        }
        finally {
            this.lock.writeLock.unlock();
        }
    }

    @Override
    public E peek() {
        return this.peekFirst();
    }

    @Override
    public E peekFirst() {
        this.lock.readLock.lock();
        try {
            Object e = this.target().peekFirst();
            return e;
        }
        finally {
            this.lock.readLock.unlock();
        }
    }

    @Override
    public E peekLast() {
        this.lock.readLock.lock();
        try {
            Object e = this.target().peekLast();
            return e;
        }
        finally {
            this.lock.readLock.unlock();
        }
    }

    @Override
    public E poll() {
        return this.pollFirst();
    }

    @Override
    public E pollFirst() {
        this.lock.writeLock.lock();
        try {
            Object e = this.target().pollFirst();
            return e;
        }
        finally {
            this.lock.writeLock.unlock();
        }
    }

    @Override
    public E pollLast() {
        this.lock.writeLock.lock();
        try {
            Object e = this.target().pollLast();
            return e;
        }
        finally {
            this.lock.writeLock.unlock();
        }
    }

    @Override
    public E pop() {
        return this.removeFirst();
    }

    @Override
    public void push(E e) {
        this.addFirst(e);
    }

    @Override
    public E remove() {
        return this.removeFirst();
    }

    @Override
    public E remove(int index) {
        this.lock.writeLock.lock();
        try {
            Object e = this.target().remove(index);
            return e;
        }
        finally {
            this.lock.writeLock.unlock();
        }
    }

    @Override
    public E removeFirst() {
        this.lock.writeLock.lock();
        try {
            Object e = this.target().removeFirst();
            return e;
        }
        finally {
            this.lock.writeLock.unlock();
        }
    }

    @Override
    public boolean removeFirstOccurrence(Object o) {
        this.lock.writeLock.lock();
        try {
            boolean bl = this.target().removeFirstOccurrence(o);
            return bl;
        }
        finally {
            this.lock.writeLock.unlock();
        }
    }

    @Override
    public E removeLast() {
        this.lock.writeLock.lock();
        try {
            Object e = this.target().removeLast();
            return e;
        }
        finally {
            this.lock.writeLock.unlock();
        }
    }

    @Override
    public boolean removeLastOccurrence(Object o) {
        this.lock.writeLock.lock();
        try {
            boolean bl = this.target().removeLastOccurrence(o);
            return bl;
        }
        finally {
            this.lock.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E set(int index, E element) {
        this.lock.writeLock.lock();
        try {
            E e = this.target().set(index, element);
            return e;
        }
        finally {
            this.lock.writeLock.unlock();
        }
    }

    @Override
    public TableService<E>[] split(int n, boolean updateable) {
        return SubTableImpl.splitOf(this, n, false);
    }

    @Override
    public TableService<E> subList(int fromIndex, int toIndex) {
        return new SubTableImpl(this, fromIndex, toIndex);
    }

    @Override
    protected TableService<E> target() {
        return (TableService)super.target();
    }
}

