/*
 * Decompiled with CFR 0.152.
 */
package javolution.xml;

import java.io.ObjectStreamException;
import javolution.lang.ValueType;
import javolution.text.CharArray;
import javolution.text.TextBuilder;
import javolution.util.FastMap;
import javolution.util.function.Equalities;
import javolution.xml.XMLSerializable;

public final class QName
implements XMLSerializable,
ValueType,
CharSequence {
    private final transient CharArray _localName;
    private final transient CharArray _namespaceURI;
    private final String _toString;
    private static final FastMap<CharSequence, QName> FULL_NAME_TO_QNAME = new FastMap(Equalities.LEXICAL);
    private static final long serialVersionUID = -6126031630693748647L;

    private QName(String namespaceURI, String localName, String toString) {
        this._namespaceURI = namespaceURI == null ? null : new CharArray(namespaceURI);
        this._localName = new CharArray(localName);
        this._toString = toString;
    }

    public static QName valueOf(CharSequence name) {
        QName qName = FULL_NAME_TO_QNAME.get(name);
        return qName != null ? qName : QName.createNoNamespace(name.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static QName createNoNamespace(String name) {
        String localName = name;
        String namespaceURI = null;
        if (name.length() > 0 && name.charAt(0) == '{') {
            int index = name.lastIndexOf(125);
            localName = name.substring(index + 1);
            namespaceURI = name.substring(1, index);
        }
        QName qName = new QName(namespaceURI, localName, name);
        FastMap<CharSequence, QName> fastMap = FULL_NAME_TO_QNAME;
        synchronized (fastMap) {
            QName tmp = FULL_NAME_TO_QNAME.putIfAbsent(name, qName);
            return tmp == null ? qName : tmp;
        }
    }

    public static QName valueOf(String name) {
        QName qName = FULL_NAME_TO_QNAME.get(name);
        return qName != null ? qName : QName.createNoNamespace(name);
    }

    public static QName valueOf(CharSequence namespaceURI, CharSequence localName) {
        if (namespaceURI == null) {
            return QName.valueOf(localName);
        }
        TextBuilder tmp = new TextBuilder();
        tmp.append('{');
        tmp.append(namespaceURI);
        tmp.append('}');
        tmp.append(localName);
        return QName.valueOf(tmp);
    }

    public CharSequence getLocalName() {
        return this._localName;
    }

    public CharSequence getNamespaceURI() {
        return this._namespaceURI;
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj;
    }

    @Override
    public String toString() {
        return this._toString;
    }

    @Override
    public int hashCode() {
        return this._toString.hashCode();
    }

    @Override
    public char charAt(int index) {
        return this._toString.charAt(index);
    }

    @Override
    public int length() {
        return this._toString.length();
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this._toString.substring(start, end);
    }

    private Object readResolve() throws ObjectStreamException {
        return QName.valueOf(this._toString);
    }
}

