/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.cli.enzymes;

import org.apache.commons.cli.Options;

public enum EnzymesCLIParams {
    IN("in", "An input file (.json).", false, true),
    LIST("l", "Lists all enzymes implemented. All other options than " + EnzymesCLIParams.IN.id + " will be ignored.", false, false),
    OUT("out", "The destination enzymes file (.json).", true, true),
    RM("rm", "The name of an enzyme to remove.", false, true),
    NAME("name", "The name of an enzyme to add.", false, true),
    RESTRICTION_BEFORE("restriction_before", "Comma separated list of amino acids forbidden before the cleavage site of the enzyme to add. e.g. \"S,T\"", false, true),
    RESTRICTION_AFTER("restriction_after", "Comma separated list of amino acids forbidden after the cleavage site of the enzyme to add. e.g. \"S,T\"", false, true),
    CLEAVE_BEFORE("cleave_before", "Comma separated list of amino acids present before the cleavage site of the enzyme to add. e.g. \"R,K\"", false, true),
    CLEAVE_AFTER("cleave_after", "Comma separated list of amino acids present afterthe cleavage site of the enzyme to add. e.g. \"R,K\"", false, true);

    public final String id;
    public final String description;
    public final boolean mandatory;
    public final boolean hasArgument;

    private EnzymesCLIParams(String id, String description, boolean mandatory, boolean hasArgument) {
        this.id = id;
        this.description = description;
        this.mandatory = mandatory;
        this.hasArgument = hasArgument;
    }

    public static void createOptionsCLI(Options aOptions) {
        for (EnzymesCLIParams option : EnzymesCLIParams.values()) {
            aOptions.addOption(option.id, option.hasArgument, option.description);
        }
    }

    public static String getOptionsAsString() {
        String output = "";
        output = output + "Input-Output:\n\n";
        output = output + "-" + String.format("%-35s", EnzymesCLIParams.IN.id) + " " + EnzymesCLIParams.IN.description + "\n";
        output = output + "-" + String.format("%-35s", EnzymesCLIParams.OUT.id) + " " + EnzymesCLIParams.OUT.description + "\n";
        output = output + "-" + String.format("%-35s", EnzymesCLIParams.LIST.id) + " " + EnzymesCLIParams.LIST.description + "\n";
        output = output + "\n\nRemove enzyme:\n";
        output = output + "-" + String.format("%-35s", EnzymesCLIParams.RM.id) + " " + EnzymesCLIParams.RM.description + "\n";
        output = output + "\n\nAdd enzyme:\n";
        output = output + "-" + String.format("%-35s", EnzymesCLIParams.NAME.id) + " " + EnzymesCLIParams.NAME.description + "\n";
        output = output + "-" + String.format("%-35s", EnzymesCLIParams.CLEAVE_BEFORE.id) + " " + EnzymesCLIParams.CLEAVE_BEFORE.description + "\n";
        output = output + "-" + String.format("%-35s", EnzymesCLIParams.CLEAVE_AFTER.id) + " " + EnzymesCLIParams.CLEAVE_AFTER.description + "\n";
        output = output + "-" + String.format("%-35s", EnzymesCLIParams.RESTRICTION_BEFORE.id) + " " + EnzymesCLIParams.RESTRICTION_BEFORE.description + "\n";
        output = output + "-" + String.format("%-35s", EnzymesCLIParams.RESTRICTION_AFTER.id) + " " + EnzymesCLIParams.RESTRICTION_AFTER.description + "\n";
        return output;
    }
}

