/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.software.autoupdater;

import com.compomics.software.autoupdater.FileDAO;
import com.compomics.software.autoupdater.GUIFileDAO;
import com.compomics.software.autoupdater.HeadlessFileDAO;
import com.compomics.software.autoupdater.MavenJarFile;
import com.compomics.software.autoupdater.WebDAO;
import com.compomics.util.Util;
import com.compomics.util.preferences.UtilitiesUserPreferences;
import com.compomics.util.waiting.WaitingHandler;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipFile;
import javax.swing.JOptionPane;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.io.FileUtils;

public class DownloadLatestZipFromRepo {
    private static boolean isFileBeingDownloaded = false;
    private static File downloadedFile;

    public static void downloadLatestZipFromRepo(URL jarPath, String toolName) throws IOException, XMLStreamException, URISyntaxException {
        DownloadLatestZipFromRepo.downloadLatestZipFromRepo(jarPath, toolName, true, true, true, null);
    }

    public static void downloadLatestZipFromRepo(URL jarPath, String toolName, boolean deleteOldFiles, boolean startDownloadedVersion, boolean addDesktopIcon, WaitingHandler waitingHandler) throws IOException, XMLStreamException, URISyntaxException {
        DownloadLatestZipFromRepo.downloadLatestZipFromRepo(jarPath, toolName, deleteOldFiles, new String[0], startDownloadedVersion, addDesktopIcon, waitingHandler);
    }

    public static void downloadLatestZipFromRepo(URL jarPath, String toolName, boolean deleteOldFiles, String[] args, boolean startDownloadedVersion, boolean addDesktopIcon, WaitingHandler waitingHandler) throws IOException, XMLStreamException, URISyntaxException {
        DownloadLatestZipFromRepo.downloadLatestZipFromRepo(jarPath, toolName, deleteOldFiles, null, args, new URL("http", "genesis.ugent.be", "/maven2/"), startDownloadedVersion, addDesktopIcon, waitingHandler);
    }

    public static void downloadLatestZipFromRepo(URL jarPath, String toolName, boolean deleteOldFiles, boolean addDesktopIcon, String[] args, URL jarRepository, WaitingHandler waitingHandler) throws IOException, XMLStreamException, URISyntaxException {
        DownloadLatestZipFromRepo.downloadLatestZipFromRepo(jarPath, toolName, deleteOldFiles, null, args, jarRepository, true, addDesktopIcon, waitingHandler);
    }

    public static void downloadLatestZipFromRepo(URL jarPath, String toolName, boolean deleteOldFiles, String iconName, String[] args, URL jarRepository, boolean startDownloadedVersion, boolean addDesktopIcon, WaitingHandler waitingHandler) throws IOException, XMLStreamException, URISyntaxException {
        if (GraphicsEnvironment.isHeadless()) {
            DownloadLatestZipFromRepo.downloadLatestZipFromRepo(jarPath, toolName, deleteOldFiles, iconName, args, jarRepository, startDownloadedVersion, addDesktopIcon, new HeadlessFileDAO(), waitingHandler);
        } else {
            DownloadLatestZipFromRepo.downloadLatestZipFromRepo(jarPath, toolName, deleteOldFiles, iconName, args, jarRepository, startDownloadedVersion, addDesktopIcon, new GUIFileDAO(), waitingHandler);
        }
    }

    public static void downloadLatestZipFromRepo(URL jarPath, String toolName, boolean deleteOldFiles, String iconName, String[] args, URL jarRepository, boolean startDownloadedVersion, boolean addDesktopIcon, FileDAO fileDAO, WaitingHandler waitingHandler) throws IOException, XMLStreamException, URISyntaxException {
        MavenJarFile oldMavenJarFile = new MavenJarFile(jarPath.toURI());
        if (WebDAO.newVersionReleased(oldMavenJarFile, jarRepository)) {
            int option;
            String artifactInRepoLocation = jarRepository.toExternalForm() + oldMavenJarFile.getGroupId().replaceAll("\\.", "/") + "/" + oldMavenJarFile.getArtifactId();
            String latestRemoteRelease = WebDAO.getLatestVersionNumberFromRemoteRepo(new URL(artifactInRepoLocation + "/maven-metadata.xml"));
            String latestArtifactLocation = artifactInRepoLocation + "/" + latestRemoteRelease;
            MavenJarFile downloadedJarFile = DownloadLatestZipFromRepo.downloadAndUnzipJar(oldMavenJarFile, toolName, new URL(latestArtifactLocation), fileDAO, true, waitingHandler, System.getProperty("os.name").toLowerCase(new Locale("en")).contains("win"));
            if (waitingHandler != null) {
                if (waitingHandler.isRunCanceled() || waitingHandler.isRunFinished()) {
                    return;
                }
                waitingHandler.setRunFinished();
            }
            final File jarParent = new File(jarPath.toURI()).getParentFile();
            if (deleteOldFiles && fileDAO instanceof GUIFileDAO && (option = JOptionPane.showConfirmDialog(null, "Remove the old version of " + toolName + "? This will delete the folder\n" + jarParent.getAbsolutePath(), "Remove Old " + toolName + " Version?", 0)) != 0) {
                deleteOldFiles = false;
            }
            if (addDesktopIcon && System.getProperty("os.name").toLowerCase(new Locale("en")).contains("win")) {
                fileDAO.createDesktopShortcut(downloadedJarFile, iconName, toolName, deleteOldFiles);
            }
            UtilitiesUserPreferences utilitiesUserPreferences = UtilitiesUserPreferences.loadUserPreferences();
            if (toolName.equalsIgnoreCase("PeptideShaker")) {
                utilitiesUserPreferences.setPeptideShakerPath(downloadedJarFile.getAbsoluteFilePath());
            } else if (toolName.equalsIgnoreCase("SearchGUI")) {
                utilitiesUserPreferences.setSearchGuiPath(downloadedJarFile.getAbsoluteFilePath());
            } else if (toolName.equalsIgnoreCase("Reporter")) {
                utilitiesUserPreferences.setReporterPath(downloadedJarFile.getAbsoluteFilePath());
            }
            UtilitiesUserPreferences.saveUserPreferences(utilitiesUserPreferences);
            String oldFolder = oldMavenJarFile.getAbsoluteFilePath();
            File pathFile = new File(oldFolder, "resources/conf/paths.txt");
            if (pathFile.exists()) {
                String downloadFolderPath = new File(downloadedJarFile.getAbsoluteFilePath()).getParent();
                File newPathFile = new File(downloadFolderPath, "resources/conf/paths.txt");
                Util.copyFile(pathFile, newPathFile);
            }
            try {
                oldMavenJarFile.close();
                Process launchedJar = null;
                if (startDownloadedVersion) {
                    launchedJar = DownloadLatestZipFromRepo.launchJar(downloadedJarFile, args);
                }
                if (deleteOldFiles) {
                    if (deleteOldFiles) {
                        Runtime.getRuntime().addShutdownHook(new Thread(){

                            @Override
                            public void run() {
                                try {
                                    if (jarParent.exists()) {
                                        FileUtils.deleteDirectory((File)jarParent);
                                    }
                                }
                                catch (IOException ex) {
                                    ex.printStackTrace();
                                }
                            }
                        });
                    }
                    if (launchedJar != null) {
                        launchedJar.waitFor();
                    }
                }
            }
            catch (InterruptedException ie) {
                throw new InterruptedIOException("JVM ended unexpectedly. Old files have not been deleted.");
            }
        }
    }

    public static void downloadLatestZipFromRepo(File downloadFolder, String toolName, String groupId, String artifactId, String iconName, String[] args, URL jarRepository, boolean startDownloadedVersion, boolean addDesktopIcon, FileDAO fileDAO, WaitingHandler waitingHandler) throws IOException, XMLStreamException, URISyntaxException {
        String artifactInRepoLocation = jarRepository.toExternalForm() + groupId.replaceAll("\\.", "/") + "/" + artifactId;
        String latestRemoteRelease = WebDAO.getLatestVersionNumberFromRemoteRepo(new URL(artifactInRepoLocation + "/maven-metadata.xml"));
        String latestArtifactLocation = artifactInRepoLocation + "/" + latestRemoteRelease;
        MavenJarFile downloadedJarFile = DownloadLatestZipFromRepo.downloadAndUnzipJar(downloadFolder, artifactId, toolName, new URL(latestArtifactLocation), fileDAO, true, waitingHandler, System.getProperty("os.name").toLowerCase(new Locale("en")).contains("win"), false);
        if (waitingHandler != null) {
            if (waitingHandler.isRunCanceled() || waitingHandler.isRunFinished()) {
                return;
            }
            waitingHandler.setRunFinished();
        }
        if (addDesktopIcon && System.getProperty("os.name").toLowerCase(new Locale("en")).contains("win")) {
            fileDAO.createDesktopShortcut(downloadedJarFile, iconName, toolName, false);
        }
        UtilitiesUserPreferences utilitiesUserPreferences = UtilitiesUserPreferences.loadUserPreferences();
        if (toolName.equalsIgnoreCase("PeptideShaker")) {
            utilitiesUserPreferences.setPeptideShakerPath(downloadedJarFile.getAbsoluteFilePath());
        } else if (toolName.equalsIgnoreCase("SearchGUI")) {
            utilitiesUserPreferences.setSearchGuiPath(downloadedJarFile.getAbsoluteFilePath());
        } else if (toolName.equalsIgnoreCase("Reporter")) {
            utilitiesUserPreferences.setReporterPath(downloadedJarFile.getAbsoluteFilePath());
        }
        UtilitiesUserPreferences.saveUserPreferences(utilitiesUserPreferences);
        if (startDownloadedVersion) {
            DownloadLatestZipFromRepo.launchJar(downloadedJarFile, args);
        }
    }

    private static Process launchJar(MavenJarFile downloadedFile, String[] args) throws NullPointerException, IOException {
        Process jar;
        ArrayList<String> processToRun = new ArrayList<String>();
        try {
            processToRun.add("java");
            processToRun.add("-jar");
            processToRun.add(downloadedFile.getAbsoluteFilePath());
            if (args != null) {
                processToRun.addAll(Arrays.asList(args));
            }
            ProcessBuilder p = new ProcessBuilder(processToRun);
            p.directory(new File(downloadedFile.getAbsoluteFilePath()).getParentFile());
            jar = p.start();
        }
        catch (NullPointerException npe) {
            throw new IOException("Could not start the jar file.");
        }
        return jar;
    }

    private static MavenJarFile downloadAndUnzipJar(MavenJarFile mavenJarFile, final String toolName, URL jarRepository, FileDAO fileDAO, boolean cleanupZipFile, final WaitingHandler waitingHandler, boolean isWindows) throws MalformedURLException, IOException, XMLStreamException {
        String folderName;
        URL archiveURL;
        if (isWindows) {
            archiveURL = WebDAO.getUrlOfZippedVersion(jarRepository, ".zip", false);
            folderName = archiveURL.getFile().substring(archiveURL.getFile().lastIndexOf("/"), archiveURL.getFile().lastIndexOf(".zip"));
        } else {
            archiveURL = WebDAO.getUrlOfZippedVersion(jarRepository, ".tar.gz", false);
            if (archiveURL != null) {
                folderName = archiveURL.getFile().substring(archiveURL.getFile().lastIndexOf("/"), archiveURL.getFile().lastIndexOf(".tar.gz"));
            } else {
                archiveURL = WebDAO.getUrlOfZippedVersion(jarRepository, ".zip", false);
                folderName = archiveURL.getFile().substring(archiveURL.getFile().lastIndexOf("/"), archiveURL.getFile().lastIndexOf(".zip"));
                isWindows = true;
            }
        }
        if (folderName.endsWith("-windows")) {
            folderName = folderName.substring(0, folderName.indexOf("-windows"));
        } else if (folderName.endsWith("-mac_and_linux")) {
            folderName = folderName.substring(0, folderName.indexOf("-mac_and_linux"));
        }
        File downloadFolder = isWindows ? new File(fileDAO.getLocationToDownloadOnDisk(new File(mavenJarFile.getAbsoluteFilePath()).getParent()), folderName) : fileDAO.getLocationToDownloadOnDisk(new File(mavenJarFile.getAbsoluteFilePath()).getParent());
        if (!downloadFolder.exists() && !downloadFolder.mkdirs()) {
            throw new IOException("Could not create the folder '" + downloadFolder.getAbsolutePath() + "' to download the file to.");
        }
        downloadedFile = new File(downloadFolder, archiveURL.getFile().substring(archiveURL.getFile().lastIndexOf("/")));
        isFileBeingDownloaded = true;
        if (waitingHandler != null) {
            waitingHandler.setWaitingText("Updating " + toolName + ". Please Wait...");
            URLConnection conn = archiveURL.openConnection();
            int tempLength = conn.getContentLength();
            final int currentUrlContentLength = isWindows ? tempLength : (tempLength != -1 ? conn.getContentLength() * 3 : tempLength);
            if (currentUrlContentLength != -1) {
                waitingHandler.resetPrimaryProgressCounter();
                waitingHandler.setPrimaryProgressCounterIndeterminate(false);
                waitingHandler.setMaxPrimaryProgressCounter(currentUrlContentLength);
                new Thread("DownloadMonitorThread"){

                    @Override
                    public void run() {
                        long start = System.currentTimeMillis();
                        while (isFileBeingDownloaded) {
                            if (waitingHandler.isRunCanceled()) {
                                waitingHandler.setRunFinished();
                                break;
                            }
                            long now = System.currentTimeMillis();
                            if (now - start <= 100L || downloadedFile == null) continue;
                            long length = downloadedFile.length();
                            if (currentUrlContentLength != -1) {
                                waitingHandler.setSecondaryProgressCounter((int)length);
                            } else {
                                waitingHandler.setWaitingText("Updating " + toolName + ". Please Wait... (" + length / 0x100000L + " MB)");
                            }
                            start = System.currentTimeMillis();
                        }
                    }
                }.start();
            } else {
                waitingHandler.setPrimaryProgressCounterIndeterminate(true);
            }
        }
        if (isWindows) {
            downloadedFile = fileDAO.writeStreamToDisk(archiveURL.openStream(), archiveURL.getFile().substring(archiveURL.getFile().lastIndexOf("/")), downloadFolder);
            if (waitingHandler != null) {
                waitingHandler.setSecondaryProgressCounterIndeterminate(true);
            }
            fileDAO.unzipFile(new ZipFile(downloadedFile), downloadFolder.getParentFile());
        } else {
            fileDAO.unGzipAndUntarFile(new GZIPInputStream(archiveURL.openStream()), downloadedFile, waitingHandler);
        }
        MavenJarFile newMavenJar = isWindows ? fileDAO.getMavenJarFileFromFolderWithArtifactId(downloadFolder, mavenJarFile.getArtifactId()) : fileDAO.getMavenJarFileFromFolderWithArtifactId(new File(downloadFolder, folderName), mavenJarFile.getArtifactId());
        isFileBeingDownloaded = false;
        if (cleanupZipFile && !downloadedFile.delete()) {
            throw new IOException("Could not delete the zip file '" + downloadedFile.getAbsolutePath() + "'");
        }
        return newMavenJar;
    }

    private static MavenJarFile downloadAndUnzipJar(File aDownloadFolder, String artifactId, final String toolName, URL jarRepository, FileDAO fileDAO, boolean cleanupZipFile, final WaitingHandler waitingHandler, boolean isWindows, final boolean update) throws MalformedURLException, IOException, XMLStreamException {
        String folderName;
        URL archiveURL;
        if (isWindows) {
            archiveURL = WebDAO.getUrlOfZippedVersion(jarRepository, ".zip", false);
            folderName = archiveURL.getFile().substring(archiveURL.getFile().lastIndexOf("/"), archiveURL.getFile().lastIndexOf(".zip"));
        } else {
            archiveURL = WebDAO.getUrlOfZippedVersion(jarRepository, ".tar.gz", false);
            if (archiveURL != null) {
                folderName = archiveURL.getFile().substring(archiveURL.getFile().lastIndexOf("/"), archiveURL.getFile().lastIndexOf(".tar.gz"));
            } else {
                archiveURL = WebDAO.getUrlOfZippedVersion(jarRepository, ".zip", false);
                folderName = archiveURL.getFile().substring(archiveURL.getFile().lastIndexOf("/"), archiveURL.getFile().lastIndexOf(".zip"));
                isWindows = true;
            }
        }
        if (folderName.endsWith("-windows")) {
            folderName = folderName.substring(0, folderName.indexOf("-windows"));
        } else if (folderName.endsWith("-mac_and_linux")) {
            folderName = folderName.substring(0, folderName.indexOf("-mac_and_linux"));
        }
        File downloadFolder = isWindows ? new File(aDownloadFolder, folderName) : aDownloadFolder;
        if (!downloadFolder.exists() && !downloadFolder.mkdirs()) {
            throw new IOException("Could not create the folder '" + downloadFolder.getAbsolutePath() + "' to download the file to.");
        }
        downloadedFile = new File(downloadFolder, archiveURL.getFile().substring(archiveURL.getFile().lastIndexOf("/")));
        isFileBeingDownloaded = true;
        if (waitingHandler != null) {
            if (update) {
                waitingHandler.setWaitingText("Updating " + toolName + ". Please Wait...");
            } else {
                waitingHandler.setWaitingText("Downloading " + toolName + ". Please Wait...");
            }
            URLConnection conn = archiveURL.openConnection();
            int tempLength = conn.getContentLength();
            final int currentUrlContentLength = isWindows ? tempLength : (tempLength != -1 ? conn.getContentLength() * 3 : tempLength);
            if (currentUrlContentLength != -1) {
                waitingHandler.resetPrimaryProgressCounter();
                waitingHandler.setPrimaryProgressCounterIndeterminate(false);
                waitingHandler.setMaxPrimaryProgressCounter(currentUrlContentLength);
                new Thread("DownloadMonitorThread"){

                    @Override
                    public void run() {
                        long start = System.currentTimeMillis();
                        while (isFileBeingDownloaded) {
                            if (waitingHandler.isRunCanceled()) {
                                waitingHandler.setRunFinished();
                                break;
                            }
                            long now = System.currentTimeMillis();
                            if (now - start <= 100L || downloadedFile == null) continue;
                            long length = downloadedFile.length();
                            if (currentUrlContentLength != -1) {
                                waitingHandler.setSecondaryProgressCounter((int)length);
                            } else if (update) {
                                waitingHandler.setWaitingText("Updating " + toolName + ". Please Wait... (" + length / 0x100000L + " MB)");
                            } else {
                                waitingHandler.setWaitingText("Downloading " + toolName + ". Please Wait... (" + length / 0x100000L + " MB)");
                            }
                            start = System.currentTimeMillis();
                        }
                    }
                }.start();
            } else {
                waitingHandler.setPrimaryProgressCounterIndeterminate(true);
            }
        }
        if (isWindows) {
            downloadedFile = fileDAO.writeStreamToDisk(archiveURL.openStream(), archiveURL.getFile().substring(archiveURL.getFile().lastIndexOf("/")), downloadFolder);
            if (waitingHandler != null) {
                waitingHandler.setSecondaryProgressCounterIndeterminate(true);
            }
            fileDAO.unzipFile(new ZipFile(downloadedFile), downloadFolder.getParentFile());
        } else {
            fileDAO.unGzipAndUntarFile(new GZIPInputStream(archiveURL.openStream()), downloadedFile, waitingHandler);
        }
        MavenJarFile newMavenJar = isWindows ? fileDAO.getMavenJarFileFromFolderWithArtifactId(downloadFolder, artifactId) : fileDAO.getMavenJarFileFromFolderWithArtifactId(new File(downloadFolder, folderName), artifactId);
        isFileBeingDownloaded = false;
        if (cleanupZipFile && !downloadedFile.delete()) {
            throw new IOException("Could not delete the zip file '" + downloadedFile.getAbsolutePath() + "'.");
        }
        return newMavenJar;
    }
}

