/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.software.cli;

import com.compomics.util.Util;
import com.compomics.util.preferences.SequenceMatchingPreferences;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class CommandParameter {
    public static boolean inIntegerRange(String argType, String arg, int minValue, int maxValue) {
        boolean valid = true;
        try {
            int value = new Integer(arg);
            if (value < minValue || value > maxValue) {
                System.out.println(System.getProperty("line.separator") + "Error parsing the " + argType + " option: Not in the range [" + minValue + " - " + maxValue + "]." + System.getProperty("line.separator"));
                valid = false;
            }
        }
        catch (NumberFormatException e) {
            System.out.println(System.getProperty("line.separator") + "Error parsing the " + argType + " option: Not an integer value!" + System.getProperty("line.separator"));
            valid = false;
        }
        catch (Exception e) {
            System.out.println(System.getProperty("line.separator") + "Error parsing the " + argType + " option: " + e.getLocalizedMessage() + System.getProperty("line.separator"));
            valid = false;
        }
        return valid;
    }

    public static boolean inDoubleRange(String argType, String arg, double minValue, double maxValue) {
        boolean valid = true;
        try {
            double value = new Double(arg);
            if (value < minValue || value > maxValue) {
                System.out.println(System.getProperty("line.separator") + "Error parsing the " + argType + " option: Not in the range [" + minValue + " - " + maxValue + "]." + System.getProperty("line.separator"));
                valid = false;
            }
        }
        catch (NumberFormatException e) {
            System.out.println(System.getProperty("line.separator") + "Error parsing the " + argType + " option: Not a floating value!" + System.getProperty("line.separator"));
            valid = false;
        }
        catch (Exception e) {
            System.out.println(System.getProperty("line.separator") + "Error parsing the " + argType + " option: " + e.getLocalizedMessage() + System.getProperty("line.separator"));
            valid = false;
        }
        return valid;
    }

    public static boolean isInList(String argType, String arg, List<String> supportedInput) {
        boolean valid = true;
        if (!supportedInput.contains(arg)) {
            valid = false;
            String errorMessage = System.getProperty("line.separator") + "Error parsing the " + argType + " option: Found " + arg + ". Supported input: [";
            for (int i = 0; i < supportedInput.size(); ++i) {
                if (i > 0) {
                    errorMessage = errorMessage + ", ";
                }
                errorMessage = errorMessage + supportedInput.get(i);
            }
            errorMessage = errorMessage + "]." + System.getProperty("line.separator");
            System.out.println(errorMessage);
        }
        return valid;
    }

    public static boolean isBooleanInput(String argType, String arg) {
        boolean valid = true;
        try {
            int value = new Integer(arg);
            if (value != 0 && value != 1) {
                System.out.println(System.getProperty("line.separator") + "Error parsing the " + argType + " option: Found " + value + " where 0 or 1 was expected." + System.getProperty("line.separator"));
                valid = false;
            }
        }
        catch (NumberFormatException e) {
            System.out.println(System.getProperty("line.separator") + "Error parsing the " + argType + " option: Found " + arg + " where 0 or 1 was expected." + System.getProperty("line.separator"));
            valid = false;
        }
        catch (Exception e) {
            System.out.println(System.getProperty("line.separator") + "Error parsing the " + argType + " option: " + e.getLocalizedMessage() + System.getProperty("line.separator"));
            valid = false;
        }
        return valid;
    }

    public static boolean isInteger(String argType, String arg) {
        boolean valid = true;
        try {
            new Integer(arg);
        }
        catch (NumberFormatException e) {
            System.out.println(System.getProperty("line.separator") + "Error parsing the " + argType + " option: Not an integer value!" + System.getProperty("line.separator"));
            valid = false;
        }
        catch (Exception e) {
            System.out.println(System.getProperty("line.separator") + "Error parsing the " + argType + " option: " + e.getLocalizedMessage() + System.getProperty("line.separator"));
            valid = false;
        }
        return valid;
    }

    public static boolean isSequenceMatchingType(String argType, String arg) {
        ArrayList<String> supportedInput = new ArrayList<String>(SequenceMatchingPreferences.MatchingType.values().length);
        for (SequenceMatchingPreferences.MatchingType tempMatchType : SequenceMatchingPreferences.MatchingType.values()) {
            supportedInput.add("" + tempMatchType.index);
        }
        return CommandParameter.isInList(argType, arg, supportedInput);
    }

    public static boolean isDouble(String argType, String arg) {
        boolean valid = true;
        try {
            new Double(arg);
        }
        catch (NumberFormatException e) {
            System.out.println(System.getProperty("line.separator") + "Error parsing the " + argType + " option: Not a floating value!" + System.getProperty("line.separator"));
            valid = false;
        }
        catch (Exception e) {
            System.out.println(System.getProperty("line.separator") + "Error parsing the " + argType + " option: " + e.getLocalizedMessage() + System.getProperty("line.separator"));
            valid = false;
        }
        return valid;
    }

    public static boolean isPositiveDouble(String argType, String arg, boolean allowZero) {
        boolean valid = true;
        try {
            double value = new Double(arg);
            if (allowZero) {
                if (value < 0.0) {
                    System.out.println(System.getProperty("line.separator") + "Error parsing the " + argType + " option: Negative value found." + System.getProperty("line.separator"));
                    valid = false;
                }
            } else if (value <= 0.0) {
                System.out.println(System.getProperty("line.separator") + "Error parsing the " + argType + " option: Negative or zero value found." + System.getProperty("line.separator"));
                valid = false;
            }
        }
        catch (NumberFormatException e) {
            System.out.println(System.getProperty("line.separator") + "Error parsing the " + argType + " option: Not a floating value!" + System.getProperty("line.separator"));
            valid = false;
        }
        catch (Exception e) {
            System.out.println(System.getProperty("line.separator") + "Error parsing the " + argType + " option: " + e.getLocalizedMessage() + System.getProperty("line.separator"));
            valid = false;
        }
        return valid;
    }

    public static boolean isPositiveInteger(String argType, String arg, boolean allowZero) {
        boolean valid = true;
        try {
            int value = new Integer(arg);
            if (allowZero) {
                if (value < 0) {
                    System.out.println(System.getProperty("line.separator") + "Error parsing the " + argType + " option: Negative value found." + System.getProperty("line.separator"));
                    valid = false;
                }
            } else if (value <= 0) {
                System.out.println(System.getProperty("line.separator") + "Error parsing the " + argType + " option: Negative or zero value found." + System.getProperty("line.separator"));
                valid = false;
            }
        }
        catch (NumberFormatException e) {
            System.out.println(System.getProperty("line.separator") + "Error parsing the " + argType + " option: Not an integer value!" + System.getProperty("line.separator"));
            valid = false;
        }
        catch (Exception e) {
            System.out.println(System.getProperty("line.separator") + "Error parsing the " + argType + " option: " + e.getLocalizedMessage() + System.getProperty("line.separator"));
            valid = false;
        }
        return valid;
    }

    public static boolean fileExists(String argType, String arg) {
        return CommandParameter.fileExists(argType, arg, null);
    }

    public static boolean fileExists(String argType, String arg, HashSet<String> formats) {
        String extension;
        if (arg == null || arg.length() == 0) {
            System.out.println(System.getProperty("line.separator") + "Error parsing the " + argType + " option: Null or empty path found." + System.getProperty("line.separator"));
            return false;
        }
        File input = new File(arg);
        if (!input.exists()) {
            System.out.println(System.getProperty("line.separator") + "Error parsing the " + argType + " option:" + input.getName() + "' not found." + System.getProperty("line.separator"));
            return false;
        }
        if (formats != null && !formats.contains(extension = Util.getExtension(input))) {
            ArrayList<String> sortedFormats = new ArrayList<String>(formats);
            Collections.sort(sortedFormats);
            StringBuilder supportedExtensions = new StringBuilder();
            for (String format : sortedFormats) {
                if (supportedExtensions.length() > 0) {
                    supportedExtensions.append(", ");
                }
                supportedExtensions.append(format);
            }
            System.out.println(System.getProperty("line.separator") + "Error parsing the " + argType + " option: Format '" + extension + "' not supported. Supported formats are: " + supportedExtensions + " (case sensitive)." + System.getProperty("line.separator"));
            return false;
        }
        return true;
    }
}

