/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.software.settings.gui;

import com.compomics.software.settings.PathKey;
import com.compomics.software.settings.UtilitiesPathPreferences;
import com.compomics.util.Util;
import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import no.uib.jsparklines.extra.TrueFalseIconRenderer;

public class PathSettingsDialog
extends JDialog {
    private boolean canceled = false;
    private HashMap<PathKey, String> originalKeyToPathMap = null;
    private HashMap<PathKey, String> keyToPathMap = null;
    private ArrayList<PathKey> keyList = null;
    private HashMap<String, PathKey> nameToKey = null;
    private String toolName;
    private ArrayList<String> pathsToolTips;
    private ArrayList<String> pathTableToolTips;
    private JButton cancelButton;
    private JMenuItem editPathMenuItem;
    private JLabel helpLabel;
    private JPanel informationPanel;
    private JScrollPane informationScrollPane;
    private JTextArea informationTxt;
    private JButton okButton;
    private JPanel pathSettingsJPanel;
    private JPopupMenu pathSettingsPopupMenu;
    private JTable pathTable;
    private JScrollPane pathTableScrollPane;
    private JMenuItem setDefaultPath;
    private JPanel tablePanel;

    public PathSettingsDialog(Frame parent, String toolName, HashMap<PathKey, String> keyToPathMap) {
        super(parent, true);
        this.toolName = toolName;
        this.originalKeyToPathMap = keyToPathMap;
        this.keyToPathMap = (HashMap)keyToPathMap.clone();
        this.nameToKey = new HashMap(keyToPathMap.size());
        for (PathKey key : keyToPathMap.keySet()) {
            this.nameToKey.put(key.getId(), key);
        }
        ArrayList<String> names = new ArrayList<String>(this.nameToKey.keySet());
        Collections.sort(names);
        this.keyList = new ArrayList(names.size());
        this.pathsToolTips = new ArrayList(names.size());
        for (String name : names) {
            PathKey pathKey = this.nameToKey.get(name);
            this.keyList.add(pathKey);
            this.pathsToolTips.add(pathKey.getDescription());
        }
        this.initComponents();
        this.setUpGUI(parent, toolName);
        this.setLocationRelativeTo(parent);
        this.setTitle("Resource Folders");
        this.setVisible(true);
    }

    public void setUpGUI(Frame parent, String toolName) {
        this.informationTxt.setText(toolName + " uses the following directories to store setting files.\n\nA warning sign indicates folders where " + toolName + " cannot write. Failing to save setting files can impair the tool functionality.");
        this.pathTable.getTableHeader().setReorderingAllowed(false);
        this.pathTable.getColumn(" ").setMaxWidth(30);
        this.pathTable.getColumn(" ").setMinWidth(30);
        this.pathTable.getColumn("  ").setMaxWidth(30);
        this.pathTable.getColumn("  ").setMinWidth(30);
        this.pathTable.getColumn("  ").setCellRenderer((TableCellRenderer)new TrueFalseIconRenderer(new ImageIcon(parent.getClass().getResource("/icons/accept.png")), new ImageIcon(parent.getClass().getResource("/icons/warning.png")), "OK", "Warning"));
        this.pathTableScrollPane.getViewport().setOpaque(false);
        this.pathTableToolTips = new ArrayList();
        this.pathTableToolTips.add(null);
        this.pathTableToolTips.add("Path Name");
        this.pathTableToolTips.add("Path");
        this.pathTableToolTips.add("Path Check");
    }

    private void initComponents() {
        this.pathSettingsPopupMenu = new JPopupMenu();
        this.editPathMenuItem = new JMenuItem();
        this.setDefaultPath = new JMenuItem();
        this.pathSettingsJPanel = new JPanel();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.tablePanel = new JPanel();
        this.pathTableScrollPane = new JScrollPane();
        this.pathTable = new JTable(){

            @Override
            protected JTableHeader createDefaultTableHeader() {
                return new JTableHeader(this.columnModel){

                    @Override
                    public String getToolTipText(MouseEvent e) {
                        Point p = e.getPoint();
                        int index = this.columnModel.getColumnIndexAtX(p.x);
                        int realIndex = this.columnModel.getColumn(index).getModelIndex();
                        String tip = (String)PathSettingsDialog.this.pathTableToolTips.get(realIndex);
                        return tip;
                    }
                };
            }
        };
        this.helpLabel = new JLabel();
        this.informationPanel = new JPanel();
        this.informationScrollPane = new JScrollPane();
        this.informationTxt = new JTextArea();
        this.editPathMenuItem.setText("Edit Path");
        this.editPathMenuItem.setToolTipText("Edit Selected Path");
        this.editPathMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PathSettingsDialog.this.editPathMenuItemActionPerformed(evt);
            }
        });
        this.pathSettingsPopupMenu.add(this.editPathMenuItem);
        this.setDefaultPath.setText("Set Default Path");
        this.setDefaultPath.setToolTipText("Set a path for all files");
        this.setDefaultPath.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PathSettingsDialog.this.setDefaultPathActionPerformed(evt);
            }
        });
        this.pathSettingsPopupMenu.add(this.setDefaultPath);
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                PathSettingsDialog.this.formWindowClosing(evt);
            }
        });
        this.pathSettingsJPanel.setBackground(new Color(230, 230, 230));
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PathSettingsDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PathSettingsDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.tablePanel.setBorder(BorderFactory.createTitledBorder("Path Settings"));
        this.tablePanel.setOpaque(false);
        this.pathTableScrollPane.setOpaque(false);
        this.pathTable.setModel(new PathsTableModel());
        this.pathTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                PathSettingsDialog.this.pathTableMouseReleased(evt);
            }
        });
        this.pathTableScrollPane.setViewportView(this.pathTable);
        GroupLayout tablePanelLayout = new GroupLayout(this.tablePanel);
        this.tablePanel.setLayout(tablePanelLayout);
        tablePanelLayout.setHorizontalGroup(tablePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(tablePanelLayout.createSequentialGroup().addContainerGap().addComponent(this.pathTableScrollPane, -1, 808, Short.MAX_VALUE).addContainerGap()));
        tablePanelLayout.setVerticalGroup(tablePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(tablePanelLayout.createSequentialGroup().addContainerGap().addComponent(this.pathTableScrollPane, -1, 211, Short.MAX_VALUE).addContainerGap()));
        this.helpLabel.setFont(new Font("Tahoma", 2, 11));
        this.helpLabel.setText("Right-click to edit the paths");
        this.informationPanel.setBorder(BorderFactory.createTitledBorder("Information"));
        this.informationPanel.setOpaque(false);
        this.informationTxt.setEditable(false);
        this.informationTxt.setColumns(20);
        this.informationTxt.setLineWrap(true);
        this.informationTxt.setRows(5);
        this.informationTxt.setWrapStyleWord(true);
        this.informationTxt.setOpaque(false);
        this.informationScrollPane.setViewportView(this.informationTxt);
        GroupLayout informationPanelLayout = new GroupLayout(this.informationPanel);
        this.informationPanel.setLayout(informationPanelLayout);
        informationPanelLayout.setHorizontalGroup(informationPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(informationPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.informationScrollPane).addContainerGap()));
        informationPanelLayout.setVerticalGroup(informationPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(informationPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.informationScrollPane, -2, -1, -2).addContainerGap()));
        GroupLayout pathSettingsJPanelLayout = new GroupLayout(this.pathSettingsJPanel);
        this.pathSettingsJPanel.setLayout(pathSettingsJPanelLayout);
        pathSettingsJPanelLayout.setHorizontalGroup(pathSettingsJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pathSettingsJPanelLayout.createSequentialGroup().addContainerGap().addGroup(pathSettingsJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pathSettingsJPanelLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.helpLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.okButton, -2, 65, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton)).addComponent(this.tablePanel, -1, -1, Short.MAX_VALUE).addComponent(this.informationPanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        pathSettingsJPanelLayout.setVerticalGroup(pathSettingsJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, pathSettingsJPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.informationPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tablePanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pathSettingsJPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.okButton).addComponent(this.helpLabel)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pathSettingsJPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pathSettingsJPanel, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void editPathMenuItemActionPerformed(ActionEvent evt) {
        this.editSelectedPath();
    }

    private void setDefaultPathActionPerformed(ActionEvent evt) {
        this.setDefaultPath();
    }

    private void pathTableMouseReleased(MouseEvent evt) {
        if (evt != null && this.pathTable.rowAtPoint(evt.getPoint()) != -1) {
            this.pathTable.setRowSelectionInterval(this.pathTable.rowAtPoint(evt.getPoint()), this.pathTable.rowAtPoint(evt.getPoint()));
        }
        if (evt != null && evt.getButton() == 3 && this.pathTable.getSelectedRow() != -1) {
            this.pathSettingsPopupMenu.show(this.pathTable, evt.getX(), evt.getY());
        }
        if (evt != null && evt.getButton() == 1 && evt.getClickCount() == 2) {
            this.editSelectedPath();
        }
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        boolean changed = false;
        for (PathKey pathKey : this.originalKeyToPathMap.keySet()) {
            String newPath = this.keyToPathMap.get(pathKey);
            String originalPath = this.originalKeyToPathMap.get(pathKey);
            if (!(newPath != null && originalPath == null || newPath == null && originalPath != null) && (newPath == null || originalPath == null || originalPath.equals(newPath))) continue;
            changed = true;
            break;
        }
        if (changed) {
            int outcome = JOptionPane.showConfirmDialog(this, this.toolName + " needs to restart in order to take the new settings into account. Restart now?", "Restart Requested", 1);
            if (outcome == 0) {
                this.dispose();
            } else if (outcome == 1) {
                this.canceled = true;
                this.dispose();
            }
        } else {
            this.canceled = true;
            this.dispose();
        }
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.canceled = true;
        this.dispose();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.canceled = true;
    }

    private void editSelectedPath() {
        int selectedRow = this.pathTable.getSelectedRow();
        String name = (String)this.pathTable.getValueAt(selectedRow, 1);
        PathKey pathKey = this.nameToKey.get(name);
        File selectedFile = Util.getUserSelectedFolder(this, "Select " + pathKey.getId() + " Folder", this.keyToPathMap.get(pathKey), pathKey.getId() + " Folder", "Select", false);
        if (selectedFile != null) {
            this.keyToPathMap.put(pathKey, selectedFile.getAbsolutePath());
            ((DefaultTableModel)this.pathTable.getModel()).fireTableDataChanged();
        }
    }

    private void setDefaultPath() {
        File selectedFile = Util.getUserSelectedFolder(this, "Select Default Folder", null, "Default Folder", "Select", false);
        if (selectedFile != null) {
            for (PathKey pathKey : this.keyToPathMap.keySet()) {
                this.keyToPathMap.put(pathKey, selectedFile.getAbsolutePath());
            }
            ((DefaultTableModel)this.pathTable.getModel()).fireTableDataChanged();
        }
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public HashMap<PathKey, String> getKeyToPathMap() {
        return this.keyToPathMap;
    }

    private class PathsTableModel
    extends DefaultTableModel {
        @Override
        public int getRowCount() {
            if (PathSettingsDialog.this.keyToPathMap == null) {
                return 0;
            }
            return PathSettingsDialog.this.keyToPathMap.size();
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return " ";
                }
                case 1: {
                    return "Name";
                }
                case 2: {
                    return "Path";
                }
                case 3: {
                    return "  ";
                }
            }
            return "";
        }

        @Override
        public Object getValueAt(int row, int column) {
            PathKey pathKey = (PathKey)PathSettingsDialog.this.keyList.get(row);
            switch (column) {
                case 0: {
                    return row + 1;
                }
                case 1: {
                    return pathKey.getId();
                }
                case 2: {
                    String path = (String)PathSettingsDialog.this.keyToPathMap.get(pathKey);
                    if (path != null) {
                        File file = new File(path);
                        return file.getAbsolutePath();
                    }
                    return "Default";
                }
                case 3: {
                    String folderPath = (String)PathSettingsDialog.this.keyToPathMap.get(pathKey);
                    if (folderPath != null) {
                        return UtilitiesPathPreferences.testPath(folderPath);
                    }
                    return true;
                }
            }
            return "";
        }

        public Class getColumnClass(int columnIndex) {
            for (int i = 0; i < this.getRowCount(); ++i) {
                if (this.getValueAt(i, columnIndex) == null) continue;
                return this.getValueAt(i, columnIndex).getClass();
            }
            return String.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }
    }
}

