/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util;

import com.compomics.util.FileAndFileFilter;
import com.compomics.util.gui.waiting.waitinghandlers.ProgressDialogX;
import com.compomics.util.waiting.WaitingHandler;
import java.awt.Color;
import java.awt.Component;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.codec.binary.Base64;

public class Util {
    public static final String[] forbiddenCharacters = new String[]{"!", ":", ";", "\\?", "/", "\\\\", "\\*", "<", ">", "\"", "\\|"};
    public static final String separator = "_cus_";

    public static String removeSubString(String string, String subString) {
        String result;
        String[] split = string.split(subString);
        if (split.length > 1) {
            StringBuilder stringBuilder = new StringBuilder(string.length());
            for (String splitPart : split) {
                stringBuilder.append(splitPart);
            }
            result = stringBuilder.toString();
        } else {
            result = string;
        }
        return result;
    }

    public static boolean sendGAUpdate(String UA, String action, String label) {
        boolean returnVal = true;
        String COLLECT_URL = "http://www.google-analytics.com/collect";
        String POST = "v=1&tid=" + UA + "&cid=35119a79-1a05-49d7-b876-bb88420f825b&uid=asuueffeqqss&t=event&ec=usage&ea=" + action + "&el=" + label;
        try {
            HttpURLConnection connection = (HttpURLConnection)new URL(COLLECT_URL).openConnection();
            connection.setRequestMethod("POST");
            connection.setConnectTimeout(3000);
            connection.setReadTimeout(1000);
            connection.setDoOutput(true);
            DataOutputStream wr = new DataOutputStream(connection.getOutputStream());
            wr.writeBytes(POST);
            connection.getResponseCode();
        }
        catch (IOException ex) {
            returnVal = false;
        }
        return returnVal;
    }

    public static String removeCharacters(String string, String[] forbiddenCharacters) {
        String result = string;
        for (String fc : forbiddenCharacters) {
            String[] split = result.split(fc);
            if (split.length <= 1) continue;
            StringBuilder stringBuilder = new StringBuilder(string.length());
            for (String splitPart : split) {
                stringBuilder.append(splitPart);
            }
            result = stringBuilder.toString();
        }
        return result;
    }

    public static String removeForbiddenCharacters(String string) {
        return Util.removeCharacters(string, forbiddenCharacters);
    }

    public static boolean containsForbiddenCharacter(String string) {
        for (String forbiddenCharacter : forbiddenCharacters) {
            if (!string.contains(forbiddenCharacter)) continue;
            return true;
        }
        return false;
    }

    public static double roundDouble(double d, int places) {
        return (double)Math.round(d * Math.pow(10.0, places)) / Math.pow(10.0, places);
    }

    public static double floorDouble(double d, int places) {
        return new BigDecimal(String.valueOf(d)).setScale(places, 3).doubleValue();
    }

    public static boolean emptyDir(File dir) {
        if (dir.isDirectory()) {
            for (File child : dir.listFiles()) {
                boolean success = Util.deleteDir(child);
                if (success) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean deleteDir(File dir) {
        boolean empty = Util.emptyDir(dir);
        if (!empty) {
            return false;
        }
        return dir.delete();
    }

    public static double getPpmError(double theoreticalMzValue, double massError) {
        double ppmValue = massError / theoreticalMzValue * 1000000.0;
        return ppmValue;
    }

    public static String color2Hex(Color color) {
        return Integer.toHexString(color.getRGB() & 0xFFFFFF);
    }

    public static String getFileName(String filePath) {
        int slash2;
        String tempFileName = filePath;
        int slash1 = tempFileName.lastIndexOf("/");
        int lastSlashIndex = Math.max(slash1, slash2 = tempFileName.lastIndexOf("\\"));
        if (lastSlashIndex != -1) {
            tempFileName = tempFileName.substring(lastSlashIndex + 1);
        }
        return tempFileName;
    }

    public static String getFileName(File file) {
        return Util.getFileName(file.getAbsolutePath());
    }

    public static String getExtension(File file) {
        String fileName = Util.getFileName(file.getAbsolutePath());
        return fileName.substring(fileName.lastIndexOf("."));
    }

    public static String appendSuffix(String fileName, String suffix) {
        String extension;
        String tempName;
        int extensionIndex = fileName.lastIndexOf(".");
        if (extensionIndex > -1) {
            tempName = fileName.substring(0, fileName.lastIndexOf("."));
            extension = fileName.substring(fileName.lastIndexOf("."));
        } else {
            tempName = fileName;
            extension = "";
        }
        return tempName + suffix + extension;
    }

    public static String removeExtension(String fileName) {
        int poinIndex = fileName.lastIndexOf(".");
        if (poinIndex > -1) {
            return fileName.substring(0, poinIndex);
        }
        return fileName;
    }

    public static File getUserSelectedFile(Component parent, String aFileEnding, String aFileFormatDescription, String aDialogTitle, String lastSelectedFolder, String aSuggestedFileName, boolean openDialog) {
        int returnVal;
        final String fileEnding = aFileEnding;
        final String fileFormatDescription = aFileFormatDescription;
        JFileChooser fileChooser = new JFileChooser(lastSelectedFolder);
        fileChooser.setDialogTitle(aDialogTitle);
        fileChooser.setMultiSelectionEnabled(false);
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File myFile) {
                return myFile.getName().toLowerCase().endsWith(fileEnding) || myFile.isDirectory();
            }

            @Override
            public String getDescription() {
                return fileFormatDescription;
            }
        };
        fileChooser.setFileFilter(filter);
        if (openDialog) {
            returnVal = fileChooser.showOpenDialog(parent);
        } else {
            if (aSuggestedFileName != null) {
                fileChooser.setSelectedFile(new File(lastSelectedFolder, aSuggestedFileName));
            }
            returnVal = fileChooser.showSaveDialog(parent);
        }
        if (returnVal == 0) {
            String selectedFile = fileChooser.getSelectedFile().getPath();
            if (!openDialog && !selectedFile.endsWith(fileEnding)) {
                selectedFile = selectedFile + fileEnding;
            }
            File newFile = new File(selectedFile);
            int outcome = 0;
            if (!openDialog && newFile.exists()) {
                outcome = JOptionPane.showConfirmDialog(parent, "Should " + selectedFile + " be overwritten?", "Selected File Already Exists", 0, 2);
            } else if (openDialog && !newFile.exists()) {
                JOptionPane.showMessageDialog(parent, "The file '" + newFile.getAbsolutePath() + "' does not exist!", "File Not Found.", 0);
                return null;
            }
            if (outcome != 0) {
                return null;
            }
            return newFile;
        }
        return null;
    }

    public static FileAndFileFilter getUserSelectedFile(Component parent, String[] fileEndings, String[] fileFormatDescriptions, String aDialogTitle, String lastSelectedFolder, String aSuggestedFileName, boolean openDialog, boolean formatSelectedByUser, boolean showAllFilesOption, int defaultFilterIndex) {
        int returnVal;
        JFileChooser fileChooser = new JFileChooser(lastSelectedFolder);
        fileChooser.setDialogTitle(aDialogTitle);
        fileChooser.setMultiSelectionEnabled(false);
        fileChooser.setAcceptAllFileFilterUsed(showAllFilesOption);
        if (formatSelectedByUser) {
            for (int i = 0; i < fileEndings.length; ++i) {
                final String fileEnding = fileEndings[i];
                String description = "";
                if (i < fileFormatDescriptions.length && fileFormatDescriptions[i] != null) {
                    description = fileFormatDescriptions[i];
                }
                final String filterDescription = description;
                FileFilter filter = new FileFilter(){

                    @Override
                    public boolean accept(File myFile) {
                        return myFile.getName().toLowerCase().endsWith(fileEnding) || myFile.isDirectory();
                    }

                    @Override
                    public String getDescription() {
                        return filterDescription;
                    }
                };
                fileChooser.addChoosableFileFilter(filter);
                if (i != defaultFilterIndex) continue;
                fileChooser.setFileFilter(filter);
            }
        } else {
            final String[] filterExtensionList = (String[])fileEndings.clone();
            String description = "";
            for (int i = 0; i < fileEndings.length; ++i) {
                if (i < fileFormatDescriptions.length && fileFormatDescriptions[i] != null) {
                    if (!description.equals("")) {
                        description = description + ", ";
                    }
                    description = description + fileFormatDescriptions[i];
                    continue;
                }
                if (!description.equals("")) {
                    description = description + ", ";
                }
                description = description + "Unkown";
            }
            final String filterDescription = description;
            FileFilter filter = new FileFilter(){

                @Override
                public boolean accept(File myFile) {
                    if (myFile.isDirectory()) {
                        return true;
                    }
                    for (String fileEnding : filterExtensionList) {
                        if (!myFile.getName().toLowerCase().endsWith(fileEnding)) continue;
                        return true;
                    }
                    return false;
                }

                @Override
                public String getDescription() {
                    return filterDescription;
                }
            };
            fileChooser.setFileFilter(filter);
        }
        if (openDialog) {
            returnVal = fileChooser.showOpenDialog(parent);
        } else {
            if (aSuggestedFileName != null) {
                fileChooser.setSelectedFile(new File(lastSelectedFolder, aSuggestedFileName));
            }
            returnVal = fileChooser.showSaveDialog(parent);
        }
        if (returnVal == 0) {
            String selectedFile = fileChooser.getSelectedFile().getPath();
            String fileFormatDescription = fileChooser.getFileFilter().getDescription();
            String wantedFileEnding = null;
            for (int i = 0; i < fileFormatDescriptions.length && wantedFileEnding == null; ++i) {
                if (!fileFormatDescriptions[i].equalsIgnoreCase(fileFormatDescription)) continue;
                wantedFileEnding = fileEndings[i];
            }
            if (!openDialog && !selectedFile.endsWith(wantedFileEnding)) {
                selectedFile = selectedFile + wantedFileEnding;
            }
            File newFile = new File(selectedFile);
            int outcome = 0;
            if (!openDialog && newFile.exists()) {
                outcome = JOptionPane.showConfirmDialog(parent, "Should " + selectedFile + " be overwritten?", "Selected File Already Exists", 0, 2);
            } else if (openDialog && !newFile.exists()) {
                JOptionPane.showMessageDialog(parent, "The file'" + newFile.getAbsolutePath() + "' does not exist!", "File Not Found.", 0);
                return null;
            }
            if (outcome != 0) {
                return null;
            }
            return new FileAndFileFilter(newFile, fileChooser.getFileFilter());
        }
        return null;
    }

    public static File getUserSelectedFolder(Component parent, String aDialogTitle, String lastSelectedFolder, String aFolderDescription, String approveButtonText, boolean openDialog) {
        JFileChooser fileChooser = new JFileChooser(lastSelectedFolder);
        final String folderDescription = aFolderDescription;
        fileChooser.setDialogTitle(aDialogTitle);
        fileChooser.setMultiSelectionEnabled(false);
        fileChooser.setFileSelectionMode(1);
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File myFile) {
                return myFile.isDirectory();
            }

            @Override
            public String getDescription() {
                return folderDescription;
            }
        };
        fileChooser.setFileFilter(filter);
        int returnVal = fileChooser.showDialog(parent, approveButtonText);
        if (returnVal == 0) {
            File selectedFolder = fileChooser.getSelectedFile();
            if (!selectedFolder.exists()) {
                if (openDialog) {
                    JOptionPane.showMessageDialog(parent, "The folder '" + selectedFolder.getAbsolutePath() + "' does not exist.\nPlease choose an existing folder.", "Folder Error", 0);
                    return null;
                }
                int value = JOptionPane.showConfirmDialog(parent, "The folder '" + selectedFolder.getAbsolutePath() + "' does not exist.\nDo you want to create it?", "Create Folder?", 0);
                if (value == 1) {
                    return null;
                }
                boolean success = selectedFolder.mkdir();
                if (!success) {
                    JOptionPane.showMessageDialog(parent, "Failed to create the folder. Please create it manually and then select it.", "File Error", 1);
                    return null;
                }
            }
            return selectedFolder;
        }
        return null;
    }

    public static String tableToText(JTable table, String separator, ProgressDialogX progressDialog, boolean removeHtml) {
        StringBuilder tableAsString = new StringBuilder();
        for (int i = 0; i < table.getColumnCount() && !progressDialog.isRunCanceled(); ++i) {
            tableAsString.append(table.getColumnName(i)).append(separator);
        }
        progressDialog.setPrimaryProgressCounterIndeterminate(false);
        progressDialog.setMaxPrimaryProgressCounter(table.getRowCount());
        String lineBreak = System.getProperty("line.separator");
        tableAsString.append(lineBreak);
        for (int i = 0; i < table.getRowCount() && !progressDialog.isRunCanceled(); ++i) {
            progressDialog.increasePrimaryProgressCounter();
            for (int j = 0; j < table.getColumnCount() && !progressDialog.isRunCanceled(); ++j) {
                if (table.getValueAt(i, j) != null) {
                    String tempValue = table.getValueAt(i, j).toString();
                    if (tempValue.contains("<html>") && removeHtml) {
                        tempValue = tempValue.replaceAll("\\<[^>]*>", "");
                    }
                    tableAsString.append(tempValue).append(separator);
                    continue;
                }
                tableAsString.append(separator);
            }
            tableAsString.append(lineBreak);
        }
        return tableAsString.toString();
    }

    public static void tableToFile(JTable table, String separator, ProgressDialogX progressDialog, boolean removeHtml, BufferedWriter writer) throws IOException {
        for (int i = 0; i < table.getColumnCount(); ++i) {
            writer.write(table.getColumnName(i) + separator);
        }
        if (progressDialog != null) {
            progressDialog.setPrimaryProgressCounterIndeterminate(false);
            progressDialog.setMaxPrimaryProgressCounter(table.getRowCount());
        }
        String lineBreak = System.getProperty("line.separator");
        writer.write(lineBreak);
        for (int i = 0; i < table.getRowCount(); ++i) {
            if (progressDialog != null) {
                if (progressDialog.isRunCanceled()) {
                    return;
                }
                progressDialog.increasePrimaryProgressCounter();
            }
            for (int j = 0; j < table.getColumnCount(); ++j) {
                if (progressDialog != null && progressDialog.isRunCanceled()) {
                    return;
                }
                if (table.getValueAt(i, j) != null) {
                    String tempValue = table.getValueAt(i, j).toString();
                    if (tempValue.contains("<html>") && removeHtml) {
                        tempValue = tempValue.replaceAll("\\<[^>]*>", "");
                    }
                    writer.write(tempValue + separator);
                    continue;
                }
                writer.write(separator);
            }
            writer.write(lineBreak);
        }
    }

    public static void copyFile(File in, File out) throws IOException {
        Util.copyFile(in, out, true);
    }

    public static void append(File in, File out) throws IOException {
        Util.copyFile(in, out, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File in, File out, boolean overwrite) throws IOException {
        long start = 0L;
        if (out.exists() && out.length() > 0L) {
            if (overwrite) {
                out.delete();
            } else {
                start = out.length();
            }
        }
        FileChannel inChannel = new FileInputStream(in).getChannel();
        FileChannel outChannel = new FileOutputStream(out).getChannel();
        try {
            inChannel.transferTo(start, inChannel.size(), outChannel);
        }
        finally {
            if (inChannel != null) {
                inChannel.close();
            }
            if (outChannel != null) {
                outChannel.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getNumberOfLines(File file) throws IOException {
        BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(file));
        try {
            int readChars;
            byte[] c = new byte[1024];
            int lineCount = 0;
            while ((readChars = ((InputStream)inputStream).read(c)) != -1) {
                for (int i = 0; i < readChars; ++i) {
                    if (c[i] != 10) continue;
                    ++lineCount;
                }
            }
            int n = lineCount;
            return n;
        }
        finally {
            ((InputStream)inputStream).close();
        }
    }

    public static boolean sameLists(ArrayList list1, ArrayList list2) {
        if (list1.size() != list2.size()) {
            return false;
        }
        HashSet set1 = new HashSet(list1);
        HashSet set2 = new HashSet(list2);
        return Util.sameSets(set1, set2);
    }

    public static boolean sameSets(HashSet set1, HashSet set2) {
        if (set1.size() != set2.size()) {
            return false;
        }
        for (Object object1 : set1) {
            if (set2.contains(object1)) continue;
            return false;
        }
        return true;
    }

    public static boolean sameListsFirstListSorted(ArrayList list1, ArrayList list2) {
        if (list1.size() != list2.size()) {
            return false;
        }
        ArrayList list2copy = new ArrayList(list2);
        Collections.sort(list2copy);
        for (int i = 0; i < list1.size(); ++i) {
            if (list1.get(i).equals(list2copy.get(i))) continue;
            return false;
        }
        return true;
    }

    public static int getOccurrence(String input, char character) {
        int result = 0;
        for (char aa : input.toCharArray()) {
            if (aa != character) continue;
            ++result;
        }
        return result;
    }

    public static ArrayList<Integer> getIndexes(String bigString, String smallString) {
        Pattern pattern = Pattern.compile(smallString);
        ArrayList<Integer> result = new ArrayList<Integer>();
        Matcher matcher = pattern.matcher(bigString);
        matcher.matches();
        int index = 0;
        while (matcher.find(index)) {
            index = matcher.start();
            result.add(++index);
        }
        return result;
    }

    public static double readDoubleAsString(String doubleAsString) throws NumberFormatException {
        BigDecimal temp;
        try {
            temp = new BigDecimal(doubleAsString);
        }
        catch (NumberFormatException e) {
            doubleAsString = doubleAsString.replaceAll("\\.", "");
            doubleAsString = doubleAsString.replaceAll(",", "\\.");
            try {
                temp = new BigDecimal(doubleAsString);
            }
            catch (NumberFormatException ex) {
                throw new NumberFormatException(doubleAsString + " cannot be read as a floating value!");
            }
        }
        return temp.doubleValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File saveUrl(File saveFile, String targetUrlAsString, int fileSizeInBytes, String userName, String password, WaitingHandler waitingHandler) throws MalformedURLException, IOException, FileNotFoundException {
        BufferedInputStream in = null;
        FileOutputStream fout = null;
        try {
            int count;
            int contentLength;
            boolean urlExists = Util.checkIfURLExists(targetUrlAsString, userName, password);
            if (!urlExists && targetUrlAsString.endsWith(".gz")) {
                targetUrlAsString = targetUrlAsString.substring(0, targetUrlAsString.length() - 3);
                saveFile = new File(saveFile.getAbsolutePath().substring(0, saveFile.getAbsolutePath().length() - 3));
            }
            URL targetUrl = new URL(targetUrlAsString);
            URLConnection urlConnection = targetUrl.openConnection();
            if (password != null) {
                String userpass = userName + ":" + password;
                String basicAuth = "Basic " + new String(new Base64().encode(userpass.getBytes()));
                urlConnection.setRequestProperty("Authorization", basicAuth);
            }
            if ((contentLength = urlConnection.getContentLength()) != -1) {
                waitingHandler.resetPrimaryProgressCounter();
                waitingHandler.setMaxPrimaryProgressCounter(contentLength);
            } else if (fileSizeInBytes != -1) {
                waitingHandler.resetPrimaryProgressCounter();
                contentLength = fileSizeInBytes;
                waitingHandler.setMaxPrimaryProgressCounter(contentLength);
            } else {
                waitingHandler.setPrimaryProgressCounterIndeterminate(true);
            }
            in = new BufferedInputStream(urlConnection.getInputStream());
            fout = new FileOutputStream(saveFile);
            long start = System.currentTimeMillis();
            byte[] data = new byte[1024];
            while ((count = in.read(data, 0, 1024)) != -1 && !waitingHandler.isRunCanceled()) {
                long now;
                fout.write(data, 0, count);
                if (contentLength == -1 || (now = System.currentTimeMillis()) - start <= 100L) continue;
                waitingHandler.setPrimaryProgressCounter((int)saveFile.length());
                start = System.currentTimeMillis();
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (fout != null) {
                fout.close();
            }
        }
        return saveFile;
    }

    public static boolean checkIfURLExists(String targetUrlAsString, String userName, String password) {
        try {
            URL targetUrl = new URL(targetUrlAsString);
            URLConnection urlConnection = targetUrl.openConnection();
            if (password != null) {
                String userpass = userName + ":" + password;
                String basicAuth = "Basic " + new String(new Base64().encode(userpass.getBytes()));
                urlConnection.setRequestProperty("Authorization", basicAuth);
            }
            InputStream inputStream = urlConnection.getInputStream();
            inputStream.close();
            return true;
        }
        catch (FileNotFoundException e) {
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getFileSize(URL url) {
        HttpURLConnection conn = null;
        try {
            conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("HEAD");
            conn.getInputStream();
            int n = conn.getContentLength();
            return n;
        }
        catch (IOException e) {
            int n = -1;
            return n;
        }
        finally {
            conn.disconnect();
        }
    }

    public static Integer convertBooleanToInteger(Boolean booleanToConvert) {
        return booleanToConvert != false ? 1 : 0;
    }

    public static char[] mergeCharArrays(char[] array1, char[] array2) {
        char[] result = new char[array1.length + array2.length];
        System.arraycopy(array1, 0, result, 0, array1.length);
        System.arraycopy(array2, 0, result, array1.length, array2.length);
        return result;
    }

    public static char[] makeUnique(char[] array) {
        char aa;
        char[] arrayUnique = new char[array.length];
        int index = 0;
        arrayUnique[index] = aa = array[index];
        for (int i = 1; i < array.length; ++i) {
            aa = array[i];
            boolean duplicate = false;
            for (int j = 0; j < i; ++j) {
                char aaTemp = array[j];
                if (aa != aaTemp) continue;
                duplicate = true;
                break;
            }
            if (duplicate) continue;
            arrayUnique[index] = aa;
        }
        System.arraycopy(arrayUnique, 0, arrayUnique, 0, index);
        return arrayUnique;
    }
}

