/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.exceptions.exception_handlers;

import com.compomics.util.exceptions.ExceptionHandler;
import com.compomics.util.gui.waiting.waitinghandlers.WaitingDialog;

public class WaitingDialogExceptionHandler
extends ExceptionHandler {
    private WaitingDialog waitingDialog;
    private String toolIssuesPage;

    public WaitingDialogExceptionHandler(WaitingDialog waitingDialog, String toolIssuesPage) {
        this.waitingDialog = waitingDialog;
        this.toolIssuesPage = toolIssuesPage;
    }

    public WaitingDialogExceptionHandler(WaitingDialog waitingDialog) {
        this(waitingDialog, null);
    }

    @Override
    protected void notifyUser(Exception e) {
        this.waitingDialog.appendReport("An error occurred: " + e.getLocalizedMessage(), true, true);
        if (WaitingDialogExceptionHandler.getExceptionType(e).equals("Protein not found")) {
            this.waitingDialog.appendReport("Please see the database help page (http://compomics.github.io/projects/searchgui/wiki/databasehelp.html).", true, true);
        } else if (this.toolIssuesPage != null) {
            this.waitingDialog.appendReport("Please contact the developers (" + this.toolIssuesPage + ").", true, true);
        } else {
            this.waitingDialog.appendReport("Please contact the developers.", true, true);
        }
    }
}

