/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.biology;

import com.compomics.util.experiment.biology.AminoAcid;
import com.compomics.util.experiment.biology.AtomChain;
import com.compomics.util.experiment.biology.NeutralLoss;
import com.compomics.util.experiment.biology.ions.ElementaryIon;
import com.compomics.util.experiment.biology.ions.Glycan;
import com.compomics.util.experiment.biology.ions.ImmoniumIon;
import com.compomics.util.experiment.biology.ions.PeptideFragmentIon;
import com.compomics.util.experiment.biology.ions.PrecursorIon;
import com.compomics.util.experiment.biology.ions.RelatedIon;
import com.compomics.util.experiment.biology.ions.ReporterIon;
import com.compomics.util.experiment.biology.ions.TagFragmentIon;
import com.compomics.util.experiment.personalization.ExperimentObject;
import com.compomics.util.pride.CvTerm;
import java.util.ArrayList;
import java.util.Collections;

public abstract class Ion
extends ExperimentObject {
    static final long serialVersionUID = -1505719074403886934L;
    private String neutralLossesAsString = null;
    protected IonType type = IonType.UNKNOWN;
    protected Double theoreticMass;
    protected double theoreticMass1;
    protected AtomChain atomChain;

    public abstract String getName();

    public abstract CvTerm getPrideCvTerm();

    public abstract CvTerm getPsiMsCvTerm();

    public abstract int getSubType();

    public abstract String getSubTypeAsString();

    public static ArrayList<Integer> getPossibleSubtypes(IonType ionType) {
        switch (ionType) {
            case ELEMENTARY_ION: {
                return ElementaryIon.getPossibleSubtypes();
            }
            case GLYCAN: {
                return Glycan.getPossibleSubtypes();
            }
            case IMMONIUM_ION: {
                return ImmoniumIon.getPossibleSubtypes();
            }
            case PEPTIDE_FRAGMENT_ION: {
                return PeptideFragmentIon.getPossibleSubtypes();
            }
            case TAG_FRAGMENT_ION: {
                return TagFragmentIon.getPossibleSubtypes();
            }
            case PRECURSOR_ION: {
                return PrecursorIon.getPossibleSubtypes();
            }
            case REPORTER_ION: {
                return ReporterIon.getPossibleSubtypes();
            }
            case RELATED_ION: {
                return RelatedIon.getPossibleSubtypes();
            }
        }
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public abstract NeutralLoss[] getNeutralLosses();

    public boolean hasNeutralLosses() {
        switch (this.type) {
            case PEPTIDE_FRAGMENT_ION: 
            case TAG_FRAGMENT_ION: 
            case PRECURSOR_ION: {
                NeutralLoss[] neutralLosses = this.getNeutralLosses();
                return neutralLosses != null && neutralLosses.length > 0;
            }
        }
        return false;
    }

    public abstract boolean isSameAs(Ion var1);

    public String getNeutralLossesAsString() {
        if (this.neutralLossesAsString == null) {
            this.neutralLossesAsString = Ion.getNeutralLossesAsString(this.getNeutralLosses());
        }
        return this.neutralLossesAsString;
    }

    public static String getNeutralLossesAsString(NeutralLoss[] neutralLosses) {
        if (neutralLosses == null) {
            return "";
        }
        ArrayList<String> names = new ArrayList<String>(neutralLosses.length);
        for (NeutralLoss neutralLoss : neutralLosses) {
            names.add(neutralLoss.name);
        }
        Collections.sort(names);
        StringBuilder result = new StringBuilder(4 * neutralLosses.length);
        for (String name : names) {
            result.append('-').append(name);
        }
        return result.toString();
    }

    public double getTheoreticMass() {
        if (this.atomChain != null) {
            return this.atomChain.getMass();
        }
        return this.theoreticMass1;
    }

    public double getTheoreticMz(Integer charge) {
        double protonMass = ElementaryIon.proton.getTheoreticMass();
        double mz = this.getTheoreticMass() + protonMass;
        if (charge > 1) {
            mz = (mz + (double)(charge - 1) * protonMass) / (double)charge.intValue();
        }
        return mz;
    }

    public AtomChain getAtomicComposition() {
        return this.atomChain;
    }

    public void setAtomicComposition(AtomChain atomChain) {
        this.atomChain = atomChain;
    }

    public void setTheoreticMass(double theoreticMass) {
        this.theoreticMass1 = theoreticMass;
    }

    public IonType getType() {
        return this.type;
    }

    public static ArrayList<IonType> getImplementedIonTypes() {
        ArrayList<IonType> result = new ArrayList<IonType>();
        result.add(IonType.ELEMENTARY_ION);
        result.add(IonType.GLYCAN);
        result.add(IonType.IMMONIUM_ION);
        result.add(IonType.PEPTIDE_FRAGMENT_ION);
        result.add(IonType.TAG_FRAGMENT_ION);
        result.add(IonType.PRECURSOR_ION);
        result.add(IonType.REPORTER_ION);
        result.add(IonType.RELATED_ION);
        return result;
    }

    public String getTypeAsString() {
        return Ion.getTypeAsString(this.type);
    }

    public static String getTypeAsString(IonType type) {
        switch (type) {
            case PEPTIDE_FRAGMENT_ION: {
                return "Peptide fragment ion";
            }
            case TAG_FRAGMENT_ION: {
                return "Tag fragment ion";
            }
            case PRECURSOR_ION: {
                return "Precursor ion";
            }
            case IMMONIUM_ION: {
                return "Immonium ion";
            }
            case REPORTER_ION: {
                return "Reporter ion";
            }
            case GLYCAN: {
                return "Glycan";
            }
            case ELEMENTARY_ION: {
                return "Elementary ion";
            }
            case RELATED_ION: {
                return "Related ion";
            }
            case UNKNOWN: {
                return "Unknown ion type";
            }
        }
        throw new UnsupportedOperationException("No name for ion type " + (Object)((Object)type) + ".");
    }

    public static Ion getGenericIon(IonType ionType, int subType, NeutralLoss[] neutralLosses) {
        switch (ionType) {
            case ELEMENTARY_ION: {
                return new ElementaryIon("new ElementaryIon", 0.0, subType);
            }
            case GLYCAN: {
                return new Glycan("new Glycan", "new Glycan");
            }
            case IMMONIUM_ION: {
                return ImmoniumIon.getImmoniumIon(subType);
            }
            case PEPTIDE_FRAGMENT_ION: {
                return new PeptideFragmentIon(subType, neutralLosses);
            }
            case TAG_FRAGMENT_ION: {
                return new TagFragmentIon(subType, neutralLosses);
            }
            case PRECURSOR_ION: {
                return new PrecursorIon(neutralLosses);
            }
            case REPORTER_ION: {
                return ReporterIon.getReporterIon(subType);
            }
            case RELATED_ION: {
                return new RelatedIon(AminoAcid.A, AtomChain.getAtomChain("H"), -1, false);
            }
        }
        throw new UnsupportedOperationException("No generic constructor for " + Ion.getTypeAsString(ionType) + ".");
    }

    public static Ion getGenericIon(IonType ionType, int subType) {
        switch (ionType) {
            case ELEMENTARY_ION: {
                return new ElementaryIon("new ElementaryIon", 0.0, subType);
            }
            case GLYCAN: {
                return new Glycan("new Glycon", "new Glycon");
            }
            case IMMONIUM_ION: {
                return ImmoniumIon.getImmoniumIon(subType);
            }
            case PEPTIDE_FRAGMENT_ION: {
                return new PeptideFragmentIon(subType);
            }
            case TAG_FRAGMENT_ION: {
                return new TagFragmentIon(subType);
            }
            case PRECURSOR_ION: {
                return new PrecursorIon();
            }
            case REPORTER_ION: {
                return ReporterIon.getReporterIon(subType);
            }
            case RELATED_ION: {
                return new RelatedIon(AminoAcid.A, AtomChain.getAtomChain("H"), -1, false);
            }
        }
        throw new UnsupportedOperationException("No generic constructor for " + Ion.getTypeAsString(ionType) + ".");
    }

    public static enum IonType {
        PEPTIDE_FRAGMENT_ION(0),
        TAG_FRAGMENT_ION(1),
        PRECURSOR_ION(2),
        IMMONIUM_ION(3),
        REPORTER_ION(4),
        GLYCAN(5),
        ELEMENTARY_ION(6),
        UNKNOWN(7),
        RELATED_ION(8);

        public final int index;

        private IonType(int index) {
            this.index = index;
        }
    }
}

