/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.biology.genes;

import com.compomics.util.Util;
import com.compomics.util.experiment.biology.genes.GeneMaps;
import com.compomics.util.experiment.biology.genes.ensembl.EnsemblVersion;
import com.compomics.util.experiment.biology.genes.ensembl.GeneMapping;
import com.compomics.util.experiment.biology.genes.go.GoMapping;
import com.compomics.util.experiment.biology.taxonomy.SpeciesFactory;
import com.compomics.util.experiment.biology.taxonomy.mappings.EnsemblGenomesSpecies;
import com.compomics.util.experiment.identification.protein_sequences.FastaIndex;
import com.compomics.util.experiment.identification.protein_sequences.SequenceFactory;
import com.compomics.util.gui.waiting.waitinghandlers.ProgressDialogX;
import com.compomics.util.preferences.GenePreferences;
import com.compomics.util.protein.Header;
import com.compomics.util.waiting.WaitingHandler;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.HashSet;

public class GeneFactory {
    private static GeneFactory instance = null;
    public static final String SEPARATOR = "\t";
    private static String GENE_MAPPING_FOLDER = System.getProperty("user.home") + "/.compomics/gene_mappings/";
    private static final String TOOL_GENE_MAPPING_SUBFOLDER = "resources/conf/gene_mappings/";
    private static final String ENSEMBL_VERSIONS = "ensembl_versions";
    private static final String GO_DOMAINS = "go_domains";
    public static final String GENE_MAPPING_FILE_SUFFIX = "_gene_mappings";
    public static final String GO_MAPPING_FILE_SUFFIX = "_go_mappings";
    private HashMap<String, String> ensemblVersionsMap;
    private final String PADDING = "    ";

    public static GeneFactory getInstance() {
        if (instance == null) {
            instance = new GeneFactory();
        }
        return instance;
    }

    private GeneFactory() {
    }

    public void initialize(String jarFilePath) throws IOException {
        File ensemblVersionsFile = GeneFactory.getEnsemblVersionsFile();
        if (ensemblVersionsFile.exists()) {
            this.loadEnsemblSpeciesVersions(ensemblVersionsFile);
        } else {
            this.ensemblVersionsMap = new HashMap();
        }
        this.createDefaultGeneMappingFiles(new File(jarFilePath, "resources/conf/gene_mappings/ensembl_versions"), new File(jarFilePath, "resources/conf/gene_mappings/go_domains"), new File(jarFilePath, "resources/conf/gene_mappings/hsapiens_gene_ensembl_go_mappings"), new File(jarFilePath, "resources/conf/gene_mappings/hsapiens_gene_ensembl_gene_mappings"), true);
    }

    public GeneMaps getGeneMaps(GenePreferences genePreferences, WaitingHandler waitingHandler) throws IOException, InterruptedException {
        SpeciesFactory speciesFactory = SpeciesFactory.getInstance();
        SequenceFactory sequenceFactory = SequenceFactory.getInstance();
        FastaIndex fastaIndex = sequenceFactory.getCurrentFastaIndex();
        HashMap<String, Integer> speciesOccurrence = fastaIndex.getSpecies();
        HashMap<String, GeneMapping> geneMappings = new HashMap<String, GeneMapping>(speciesOccurrence.size());
        HashMap<String, GoMapping> goMappings = new HashMap<String, GoMapping>(speciesOccurrence.size());
        for (String uniprotTaxonomy : speciesOccurrence.keySet()) {
            if (uniprotTaxonomy.equals("Unknown")) continue;
            try {
                Integer taxon = speciesFactory.getUniprotTaxonomy().getId(uniprotTaxonomy, true);
                if (taxon == null) continue;
                String speciesName = speciesFactory.getName(taxon);
                String ensemblDatasetName = speciesFactory.getEnsemblDataset(taxon);
                if (ensemblDatasetName != null) {
                    File geneMappingFile = GeneFactory.getGeneMappingFile(ensemblDatasetName);
                    File goMappingFile = GeneFactory.getGoMappingFile(ensemblDatasetName);
                    if (genePreferences.getAutoUpdate().booleanValue()) {
                        boolean success = true;
                        try {
                            if (!geneMappingFile.exists() || !goMappingFile.exists() || this.newVersionExists(taxon)) {
                                success = this.downloadMappings(waitingHandler, taxon);
                            }
                            if (waitingHandler != null && waitingHandler.isRunCanceled()) {
                                return null;
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            success = false;
                        }
                        if (!success) {
                            waitingHandler.appendReport("    Update of gene information for species " + speciesName + " failed. A previous version will be used if available.", true, true);
                        }
                    }
                    if (geneMappingFile.exists()) {
                        GeneMapping geneMapping = new GeneMapping();
                        try {
                            geneMapping.importFromFile(geneMappingFile, waitingHandler);
                            geneMappings.put(speciesName, geneMapping);
                        }
                        catch (Exception e) {
                            waitingHandler.appendReport("    Import of the gene mapping for " + speciesName + " failed. Gene information for this species will not be available.", true, true);
                        }
                    } else {
                        waitingHandler.appendReport("    Gene mapping for " + speciesName + " not available. Gene information for this species will not be available.", true, true);
                    }
                    if (goMappingFile.exists()) {
                        GoMapping goMapping = new GoMapping();
                        try {
                            goMapping.loadMappingsFromFile(goMappingFile, waitingHandler);
                            goMappings.put(speciesName, goMapping);
                        }
                        catch (Exception e) {
                            waitingHandler.appendReport("    Import of the GO mapping for " + speciesName + " failed. GO annotation for this species will not be available.", true, true);
                        }
                        continue;
                    }
                    waitingHandler.appendReport("    GO mapping for " + speciesName + " not available. GO annotation for this species will not be available.", true, true);
                    continue;
                }
                waitingHandler.appendReport("    " + speciesName + " not available in Ensembl. Gene and GO annotation for this species will not be available.", true, true);
            }
            catch (Exception e) {
                waitingHandler.appendReport("    No taxonomy found for " + uniprotTaxonomy + ". Gene annotation for this species will not be available.", true, true);
            }
        }
        GeneMaps geneMaps = new GeneMaps();
        if (this.ensemblVersionsMap == null) {
            this.ensemblVersionsMap = new HashMap();
        }
        HashMap<String, String> ensemblVersionsUsed = new HashMap<String, String>(this.ensemblVersionsMap);
        HashMap<String, String> geneNameToEnsemblIdMap = new HashMap<String, String>();
        HashMap<String, String> geneNameToChromosomeMap = new HashMap<String, String>();
        HashMap<String, HashSet<String>> proteinToGoMap = new HashMap<String, HashSet<String>>();
        HashMap<String, HashSet<String>> goToProteinMap = new HashMap<String, HashSet<String>>();
        HashMap<String, String> goNamesMap = new HashMap<String, String>();
        SequenceFactory.HeaderIterator it = sequenceFactory.getHeaderIterator(true);
        while (it.hasNext()) {
            Header header = it.getNext();
            String uniprotTaxonomy = header.getTaxonomy();
            if (uniprotTaxonomy == null || uniprotTaxonomy.equals("")) continue;
            try {
                HashSet<String> newTerms;
                GoMapping goMapping;
                GeneMapping geneMapping;
                Integer taxon = speciesFactory.getUniprotTaxonomy().getId(uniprotTaxonomy, false);
                if (taxon == null) continue;
                String speciesName = speciesFactory.getName(taxon);
                String geneName = header.getGeneName();
                if (geneName != null && (geneMapping = (GeneMapping)geneMappings.get(speciesName)) != null) {
                    String ensemblId;
                    String chromosome = geneMapping.getChromosome(geneName);
                    if (chromosome != null) {
                        geneNameToChromosomeMap.put(geneName, chromosome);
                    }
                    if ((ensemblId = geneMapping.getEnsemblAccession(geneName)) != null) {
                        geneNameToEnsemblIdMap.put(geneName, ensemblId);
                    }
                }
                if ((goMapping = (GoMapping)goMappings.get(speciesName)) == null) continue;
                String accession = header.getAccession();
                HashSet<String> goTerms = proteinToGoMap.get(accession);
                if (goTerms == null) {
                    goTerms = new HashSet();
                    proteinToGoMap.put(accession, goTerms);
                }
                if ((newTerms = goMapping.getGoAccessions(accession)) == null) continue;
                goTerms.addAll(newTerms);
                for (String goTerm : newTerms) {
                    HashSet<String> proteins;
                    String goName = goMapping.getTermName(goTerm);
                    if (goName != null) {
                        goNamesMap.put(goTerm, goName);
                    }
                    if ((proteins = goToProteinMap.get(goTerm)) == null) {
                        proteins = new HashSet();
                        goToProteinMap.put(goTerm, proteins);
                    }
                    proteins.add(accession);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        geneMaps.setEnsemblVersionsMap(ensemblVersionsUsed);
        geneMaps.setGeneNameToEnsemblIdMap(geneNameToEnsemblIdMap);
        geneMaps.setGeneNameToChromosomeMap(geneNameToChromosomeMap);
        geneMaps.setProteinToGoMap(proteinToGoMap);
        geneMaps.setGoAccessionToProteinMap(goToProteinMap);
        geneMaps.setGoNamesMap(goNamesMap);
        return geneMaps;
    }

    public boolean downloadGeneSequences(File destinationFile, String ensemblType, String ensemblSchemaName, String ensemblDbName, WaitingHandler waitingHandler) throws MalformedURLException, IOException {
        String requestXml = "query=<?xml version=\"1.0\" encoding=\"UTF-8\"?><!DOCTYPE Query><Query  virtualSchemaName = \"" + ensemblSchemaName + "\" formatter = \"FASTA\" header = \"0\" uniqueRows = \"1\" count = \"\" datasetConfigVersion = \"0.7\" ><Dataset name = \"" + ensemblDbName + "\" interface = \"default\" ><Attribute name = \"ensembl_gene_id\" />\n<Attribute name = \"coding\" /></Dataset>\n</Query></Query>";
        String waitingText = "Downloading gene sequences. Please Wait...";
        return this.queryEnsembl(requestXml, waitingText, destinationFile, ensemblType, waitingHandler);
    }

    public boolean downloadGoMappings(String ensemblType, String ensemblSchemaName, String ensemblDbName, boolean swissProtMapping, WaitingHandler waitingHandler) throws MalformedURLException, IOException {
        String accessionMapping = swissProtMapping ? "\"uniprotswissprot\"" : "\"uniprotsptrembl\"";
        String requestXml = "query=<?xml version=\"1.0\" encoding=\"UTF-8\"?><!DOCTYPE Query><Query  virtualSchemaName = \"" + ensemblSchemaName + "\" formatter = \"TSV\" header = \"0\" uniqueRows = \"1\" count = \"\" datasetConfigVersion = \"0.7\" ><Dataset name = \"" + ensemblDbName + "\" interface = \"default\" ><Attribute name = " + accessionMapping + " />";
        requestXml = requestXml + "<Attribute name = \"goslim_goa_accession\" /><Attribute name = \"goslim_goa_description\" />";
        requestXml = requestXml + "</Dataset></Query>";
        File tempFile = GeneFactory.getGoMappingFile(ensemblDbName);
        String waitingText = "Downloading GO Mappings. Please Wait...";
        return this.queryEnsembl(requestXml, waitingText, tempFile, ensemblType, waitingHandler);
    }

    public boolean queryEnsembl(String requestXml, File destinationFile, String ensemblType) throws MalformedURLException, IOException {
        return this.queryEnsembl(requestXml, destinationFile, ensemblType, null);
    }

    public boolean queryEnsembl(String requestXml, File destinationFile, String ensemblType, WaitingHandler waitingHandler) throws MalformedURLException, IOException {
        return this.queryEnsembl(requestXml, null, destinationFile, ensemblType, waitingHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean queryEnsembl(String requestXml, String waitingText, File destinationFile, String ensemblType, WaitingHandler waitingHandler) throws MalformedURLException, IOException {
        boolean success;
        block27: {
            if (waitingHandler != null && waitingHandler instanceof ProgressDialogX && waitingText == null) {
                waitingText = "Downloading from Ensembl. Please wait...";
            }
            success = true;
            int lastThousand = 0;
            if (waitingHandler == null || !waitingHandler.isRunCanceled()) {
                URL url = this.getEnsemblUrl(ensemblType);
                URLConnection conn = url.openConnection();
                conn.setDoOutput(true);
                OutputStreamWriter wr = new OutputStreamWriter(conn.getOutputStream());
                String lineBreak = System.getProperty("line.separator");
                try {
                    wr.write(requestXml);
                    wr.flush();
                    if (waitingHandler != null && waitingHandler.isRunCanceled()) break block27;
                    if (waitingHandler != null) {
                        waitingHandler.setWaitingText(waitingText);
                    } else {
                        System.out.println(waitingText);
                    }
                    int counter = 0;
                    boolean fileCreated = destinationFile.createNewFile();
                    if (fileCreated || destinationFile.exists()) {
                        BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                        try {
                            FileWriter w = new FileWriter(destinationFile);
                            try {
                                BufferedWriter bw = new BufferedWriter(w);
                                try {
                                    String rowLine = br.readLine();
                                    if (rowLine != null && rowLine.startsWith("Query ERROR")) {
                                        if (rowLine.lastIndexOf("Attribute goslim_goa_accession NOT FOUND") != -1) {
                                            success = false;
                                            break block27;
                                        }
                                        if (rowLine.lastIndexOf("Attribute uniprotswissprot_accession NOT FOUND") != -1) {
                                            success = false;
                                            break block27;
                                        }
                                        throw new IllegalArgumentException("Query error: " + rowLine);
                                    }
                                    while (rowLine != null && success) {
                                        int thousand;
                                        if (waitingHandler != null) {
                                            if (waitingHandler.isRunCanceled()) {
                                                break block27;
                                            }
                                            if (waitingHandler instanceof ProgressDialogX) {
                                                waitingHandler.setWaitingText(waitingText + " (" + counter++ + " rows downloaded)");
                                            }
                                        } else if ((thousand = ++counter / 10000) > lastThousand) {
                                            System.out.println(waitingText + " (" + counter + " rows downloaded)");
                                            lastThousand = thousand;
                                        }
                                        bw.write(rowLine + lineBreak);
                                        rowLine = br.readLine();
                                    }
                                    break block27;
                                }
                                finally {
                                    bw.close();
                                }
                            }
                            finally {
                                w.close();
                            }
                        }
                        finally {
                            br.close();
                        }
                    }
                    if (waitingHandler != null) {
                        waitingHandler.setRunCanceled();
                    }
                    throw new IllegalArgumentException("The mapping file could not be created.");
                }
                finally {
                    wr.close();
                }
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadGeneMappings(String ensemblType, String ensemblSchemaName, String ensemblDatasetName, String ensemblVersion, WaitingHandler waitingHandler) throws MalformedURLException, IOException, IllegalArgumentException {
        block17: {
            String requestXml = "query=<?xml version=\"1.0\" encoding=\"UTF-8\"?><!DOCTYPE Query><Query  virtualSchemaName = \"" + ensemblSchemaName + "\" formatter = \"TSV\" header = \"0\" uniqueRows = \"1\" count = \"\" datasetConfigVersion = \"0.7\" ><Dataset name = \"" + ensemblDatasetName + "\" interface = \"default\" ><Attribute name = \"ensembl_gene_id\" /><Attribute name = \"external_gene_name\" /><Attribute name = \"chromosome_name\" /></Dataset></Query>";
            if (!waitingHandler.isRunCanceled()) {
                URL url = this.getEnsemblUrl(ensemblType);
                URLConnection conn = url.openConnection();
                conn.setDoOutput(true);
                OutputStreamWriter wr = new OutputStreamWriter(conn.getOutputStream());
                String lineBreak = System.getProperty("line.separator");
                try {
                    wr.write(requestXml);
                    wr.flush();
                    if (waitingHandler.isRunCanceled()) break block17;
                    waitingHandler.setWaitingText("Downloading Gene Mappings. Please Wait...");
                    int counter = 0;
                    File tempFile = GeneFactory.getGeneMappingFile(ensemblDatasetName);
                    BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                    try {
                        FileWriter w = new FileWriter(tempFile);
                        try {
                            BufferedWriter bw = new BufferedWriter(w);
                            try {
                                String rowLine = br.readLine();
                                if (rowLine != null && rowLine.startsWith("Query ERROR")) {
                                    throw new IllegalArgumentException("Query error on line: " + rowLine);
                                }
                                while (rowLine != null && !waitingHandler.isRunCanceled()) {
                                    if (waitingHandler instanceof ProgressDialogX) {
                                        waitingHandler.setWaitingText("Downloading Gene Mappings. Please Wait... (" + counter++ + " rows downloaded)");
                                    }
                                    bw.write(rowLine + lineBreak);
                                    rowLine = br.readLine();
                                }
                            }
                            finally {
                                bw.close();
                            }
                        }
                        finally {
                            w.close();
                        }
                    }
                    finally {
                        br.close();
                    }
                    if (!waitingHandler.isRunCanceled()) {
                        this.updateEnsemblVersion(ensemblDatasetName, "Ensembl " + ensemblVersion);
                    }
                }
                finally {
                    wr.close();
                }
            }
        }
    }

    public static File getGeneMappingFolder() {
        return new File(GENE_MAPPING_FOLDER);
    }

    public static void setGeneMappingFolder(String geneMappingFolder) {
        GENE_MAPPING_FOLDER = geneMappingFolder;
    }

    public void createDefaultGeneMappingFiles(File aEnsemblVersionsFile, File aGoDomainsFile, File aDefaultSpeciesGoMappingsFile, File aDefaultSpeciesGeneMappingFile, boolean updateEqualVersion) {
        boolean fileCreated;
        boolean folderCreated;
        if (!GeneFactory.getGeneMappingFolder().exists() && !(folderCreated = GeneFactory.getGeneMappingFolder().mkdirs())) {
            throw new IllegalArgumentException("Could not create the gene mapping folder.");
        }
        File ensemblVersionsFile = GeneFactory.getEnsemblVersionsFile();
        File goDomainsFile = GeneFactory.getGoDomainsFile();
        File defaultSpeciesGoMappingsFile = new File(GeneFactory.getGeneMappingFolder(), aDefaultSpeciesGoMappingsFile.getName());
        File defaultSpeciesGeneMappingFile = new File(GeneFactory.getGeneMappingFolder(), aDefaultSpeciesGeneMappingFile.getName());
        boolean updateHumanEnsembl = false;
        try {
            if (!ensemblVersionsFile.exists()) {
                updateHumanEnsembl = true;
                fileCreated = ensemblVersionsFile.createNewFile();
                if (!fileCreated) {
                    throw new IllegalArgumentException("Could not create the Ensembl versions file.");
                }
                Util.copyFile(aEnsemblVersionsFile, ensemblVersionsFile);
            } else {
                Integer humanEnsemblVersionOld;
                Integer humanEnsemblVersionNew = this.getEnsemblVersionFromFile(aEnsemblVersionsFile, "hsapiens_gene_ensembl");
                if (humanEnsemblVersionNew != null && ((humanEnsemblVersionOld = this.getEnsemblVersionFromFile(ensemblVersionsFile, "hsapiens_gene_ensembl")) == null || humanEnsemblVersionOld.equals(humanEnsemblVersionNew) && updateEqualVersion || humanEnsemblVersionOld < humanEnsemblVersionNew)) {
                    updateHumanEnsembl = true;
                    this.updateEnsemblVersion("hsapiens_gene_ensembl", "Ensembl " + humanEnsemblVersionNew);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new IllegalArgumentException("Could not create or update the Ensembl versions file.");
        }
        try {
            if (!goDomainsFile.exists() && !(fileCreated = goDomainsFile.createNewFile())) {
                throw new IllegalArgumentException("Could not create the GO domains file.");
            }
            Util.copyFile(aGoDomainsFile, goDomainsFile);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new IllegalArgumentException("Could not create the GO domains file.");
        }
        if (updateHumanEnsembl) {
            try {
                if (!defaultSpeciesGoMappingsFile.exists() && !(fileCreated = defaultSpeciesGoMappingsFile.createNewFile())) {
                    throw new IllegalArgumentException("Could not create the default species GO mapping file.");
                }
                Util.copyFile(aDefaultSpeciesGoMappingsFile, defaultSpeciesGoMappingsFile);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new IllegalArgumentException("Could not create the default species GO mapping file.");
            }
            try {
                if (!defaultSpeciesGeneMappingFile.exists() && !(fileCreated = defaultSpeciesGeneMappingFile.createNewFile())) {
                    throw new IllegalArgumentException("Could not create the default species gene mapping file.");
                }
                Util.copyFile(aDefaultSpeciesGeneMappingFile, defaultSpeciesGeneMappingFile);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new IllegalArgumentException("Could not create the default species gene mapping file.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateEnsemblVersion(String ensemblDatasetName, String ensemblVersion) throws IOException {
        if (this.ensemblVersionsMap == null) {
            this.ensemblVersionsMap = new HashMap();
        }
        this.ensemblVersionsMap.put(ensemblDatasetName, ensemblVersion);
        FileWriter w = new FileWriter(GeneFactory.getEnsemblVersionsFile());
        try {
            BufferedWriter bw = new BufferedWriter(w);
            try {
                for (String key : this.ensemblVersionsMap.keySet()) {
                    bw.write(key + SEPARATOR + this.ensemblVersionsMap.get(key));
                    bw.newLine();
                }
            }
            finally {
                bw.close();
            }
        }
        finally {
            w.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getEnsemblVersionFromFile(File ensemblVersionsFile, String species) throws IOException {
        Integer version = null;
        FileReader r = new FileReader(ensemblVersionsFile);
        try {
            BufferedReader br = new BufferedReader(r);
            try {
                String line;
                while ((line = br.readLine()) != null) {
                    String[] splittedLine = line.split(SEPARATOR);
                    String speciesAtLine = splittedLine[0];
                    if (!speciesAtLine.equals(species)) continue;
                    String[] ensemblVersionSplit = splittedLine[1].split(" ");
                    version = new Integer(ensemblVersionSplit[1]);
                }
            }
            finally {
                br.close();
            }
        }
        finally {
            r.close();
        }
        return version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadEnsemblSpeciesVersions(File ensemblVersionsFile) throws FileNotFoundException, IOException {
        FileReader r = new FileReader(ensemblVersionsFile);
        try {
            BufferedReader br = new BufferedReader(r);
            try {
                this.ensemblVersionsMap = new HashMap();
                String line = br.readLine();
                while (line != null) {
                    String[] elements = line.split("\\t");
                    this.ensemblVersionsMap.put(elements[0], elements[1]);
                    line = br.readLine();
                }
            }
            finally {
                br.close();
            }
        }
        finally {
            r.close();
        }
    }

    private URL getEnsemblUrl(String ensemblType) throws MalformedURLException {
        if (ensemblType.equalsIgnoreCase("fungi")) {
            return new URL("http://fungi.ensembl.org/biomart/martservice/result");
        }
        if (ensemblType.equalsIgnoreCase("plants")) {
            return new URL("http://plants.ensembl.org/biomart/martservice/result");
        }
        if (ensemblType.equalsIgnoreCase("protists")) {
            return new URL("http://protists.ensembl.org/biomart/martservice/result");
        }
        if (ensemblType.equalsIgnoreCase("metazoa")) {
            return new URL("http://metazoa.ensembl.org/biomart/martservice/result");
        }
        return new URL("http://www.ensembl.org/biomart/martservice/result");
    }

    public boolean downloadMappings(WaitingHandler waitingHandler, Integer taxon) throws IOException {
        boolean canceled;
        String schemaName;
        SpeciesFactory speciesFactory = SpeciesFactory.getInstance();
        String latinName = speciesFactory.getLatinName(taxon);
        if (latinName == null) {
            latinName = taxon.toString();
        }
        if (waitingHandler.isReport()) {
            waitingHandler.appendReport("    Downloading GO and gene mappings for species " + latinName + ".", true, true);
        }
        EnsemblGenomesSpecies.EnsemblGenomeDivision ensemblGenomeDivision = speciesFactory.getEnsemblGenomesSpecies().getDivision(taxon);
        String ensemblType = "ensembl";
        if (ensemblGenomeDivision != null) {
            ensemblType = ensemblGenomeDivision.ensemblType;
        }
        if ((schemaName = EnsemblVersion.getEnsemblSchemaName(ensemblGenomeDivision)) == null) {
            return false;
        }
        String ensemblDatasetName = speciesFactory.getEnsemblDataset(taxon);
        if (ensemblDatasetName == null) {
            return false;
        }
        if (!waitingHandler.isRunCanceled()) {
            boolean goMappingsDownloaded = this.downloadGoMappings(ensemblType, schemaName, ensemblDatasetName, true, waitingHandler);
            if (!goMappingsDownloaded) {
                goMappingsDownloaded = this.downloadGoMappings(ensemblType, schemaName, ensemblDatasetName, false, waitingHandler);
            }
            if (!goMappingsDownloaded) {
                waitingHandler.appendReport("    Gene ontology mappings not available. Downloading gene mappings only.", true, true);
            } else if (waitingHandler.isReport()) {
                waitingHandler.appendReport("    GO mappings downloaded.", true, true);
            }
        }
        if (!waitingHandler.isRunCanceled()) {
            this.downloadGeneMappings(ensemblType, schemaName, ensemblDatasetName, EnsemblVersion.getCurrentEnsemblVersion(ensemblGenomeDivision).toString(), waitingHandler);
            if (!waitingHandler.isRunCanceled() && waitingHandler.isReport()) {
                waitingHandler.appendReport("    Gene mappings downloaded.", true, true);
            }
        }
        return !(canceled = waitingHandler.isRunCanceled());
    }

    public static File getGeneMappingFile(String ensemblDatasetName) {
        return new File(GeneFactory.getGeneMappingFolder(), ensemblDatasetName + GENE_MAPPING_FILE_SUFFIX);
    }

    public static File getGoMappingFile(String ensemblDatasetName) {
        return new File(GeneFactory.getGeneMappingFolder(), ensemblDatasetName + GO_MAPPING_FILE_SUFFIX);
    }

    public static File getEnsemblVersionsFile() {
        return new File(GeneFactory.getGeneMappingFolder(), ENSEMBL_VERSIONS);
    }

    public static File getGoDomainsFile() {
        return new File(GeneFactory.getGeneMappingFolder(), GO_DOMAINS);
    }

    public String getEnsemblVersion(Integer taxon) {
        SpeciesFactory speciesFactory = SpeciesFactory.getInstance();
        String ensemblDatasetName = speciesFactory.getEnsemblDataset(taxon);
        if (this.ensemblVersionsMap == null) {
            return null;
        }
        return this.ensemblVersionsMap.get(ensemblDatasetName);
    }

    public boolean newVersionExists(Integer taxon) {
        EnsemblGenomesSpecies.EnsemblGenomeDivision ensemblGenomeDivision = SpeciesFactory.getInstance().getEnsemblGenomesSpecies().getDivision(taxon);
        Integer latestEnsemblVersion = EnsemblVersion.getCurrentEnsemblVersion(ensemblGenomeDivision);
        String currentEnsemblVersionAsString = this.getEnsemblVersion(taxon);
        if (currentEnsemblVersionAsString != null) {
            Integer currentEnsemblVersion;
            currentEnsemblVersionAsString = currentEnsemblVersionAsString.substring(currentEnsemblVersionAsString.indexOf(" ") + 1);
            try {
                currentEnsemblVersion = new Integer(currentEnsemblVersionAsString);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                currentEnsemblVersion = latestEnsemblVersion;
            }
            return currentEnsemblVersion < latestEnsemblVersion;
        }
        return true;
    }
}

