/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.biology.mutations;

import com.compomics.util.experiment.biology.AminoAcid;

public class Mutation {
    private AminoAcid origin;
    private AminoAcid target;
    private double massShift;

    public Mutation(AminoAcid origin, AminoAcid target) {
        this.origin = origin;
        this.target = target;
        this.massShift = target.getMonoisotopicMass() - origin.getMonoisotopicMass();
    }

    public double getMassShift() {
        return this.massShift;
    }

    public int getRoundedMassShift() {
        return (int)Math.round(this.massShift);
    }

    public AminoAcid getOrigin() {
        return this.origin;
    }

    public AminoAcid getTarget() {
        return this.target;
    }

    public boolean equals(Mutation mutation) {
        return this.origin.singleLetterCode.equals(mutation.getOrigin().singleLetterCode) && this.target.singleLetterCode.equals(mutation.getTarget().singleLetterCode);
    }

    public String toString() {
        return this.origin.threeLetterCode + " => " + this.target.threeLetterCode;
    }
}

