/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.biology.mutations;

import com.compomics.util.experiment.biology.AminoAcid;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class MutationMatrix
implements Serializable {
    private String name;
    private String description;
    private final HashMap<Character, HashSet<Character>> mutations = new HashMap(26);
    private final HashMap<Character, HashMap<Double, HashSet<Character>>> mutationsMasses = new HashMap(26);
    private Double minDelta = null;
    private Double maxDelta = null;
    private final HashMap<Character, HashSet<Character>> mutationsReverse = new HashMap(26);
    public static final MutationMatrix singleBaseSubstitution = MutationMatrix.singleBaseSubstitution();
    public static final MutationMatrix transitionsSingleBaseSubstitution = MutationMatrix.transitionsSingleBaseSubstitution();
    public static final MutationMatrix transversalSingleBaseSubstitution = MutationMatrix.transversalSingleBaseSubstitution();
    public static final MutationMatrix synonymousMutation = MutationMatrix.synonymousMutation();
    public static final MutationMatrix[] defaultMutationMatrices = new MutationMatrix[]{singleBaseSubstitution, transitionsSingleBaseSubstitution, transversalSingleBaseSubstitution, synonymousMutation};

    public MutationMatrix(String name, String description) {
        this.name = name;
        this.description = description;
    }

    public void addMutation(Character originalAa, Character mutatedAa) {
        HashSet<Character> mutatedAas = this.mutations.get(originalAa);
        if (mutatedAas == null) {
            mutatedAas = new HashSet();
            this.mutations.put(originalAa, mutatedAas);
        }
        mutatedAas.add(mutatedAa);
        HashMap<Double, HashSet<Character>> deltaMasses = this.mutationsMasses.get(originalAa);
        if (deltaMasses == null) {
            deltaMasses = new HashMap(1);
            this.mutationsMasses.put(originalAa, deltaMasses);
        }
        double deltaMass = AminoAcid.getAminoAcid(mutatedAa.charValue()).getMonoisotopicMass() - AminoAcid.getAminoAcid(originalAa.charValue()).getMonoisotopicMass();
        if (this.minDelta == null || deltaMass < this.minDelta) {
            this.minDelta = deltaMass;
        }
        if (this.maxDelta == null || deltaMass > this.maxDelta) {
            this.maxDelta = deltaMass;
        }
        if ((mutatedAas = deltaMasses.get(deltaMass)) == null) {
            mutatedAas = new HashSet();
            deltaMasses.put(deltaMass, mutatedAas);
        }
        mutatedAas.add(mutatedAa);
        HashSet<Character> originalAas = this.mutationsReverse.get(originalAa);
        if (originalAas == null) {
            originalAas = new HashSet();
            this.mutationsReverse.put(mutatedAa, originalAas);
        }
        originalAas.add(originalAa);
    }

    public HashMap<Double, HashSet<Character>> getMutatedMasses(Character originalAminoAcid) {
        return this.mutationsMasses.get(originalAminoAcid);
    }

    public HashSet<Character> getMutatedAminoAcids(Character originalAminoAcid) {
        return this.mutations.get(originalAminoAcid);
    }

    public HashSet<Character> getOriginalAminoAcids(Character mutatedAminoAcid) {
        return this.mutationsReverse.get(mutatedAminoAcid);
    }

    public Set<Character> getOriginalAminoAcids() {
        return this.mutations.keySet();
    }

    public Set<Character> getMutatedAminoAcids() {
        return this.mutations.keySet();
    }

    public void add(MutationMatrix otherMatrix) {
        for (Character originalAa : otherMatrix.getOriginalAminoAcids()) {
            for (Character mutatedAa : otherMatrix.getMutatedAminoAcids(originalAa)) {
                this.addMutation(originalAa, mutatedAa);
            }
        }
    }

    private static MutationMatrix singleBaseSubstitution() {
        MutationMatrix result = new MutationMatrix("Single Base Mutation", "Single base substitutions");
        char[] bases = new char[]{'A', 'T', 'G', 'C'};
        for (char originalAa : AminoAcid.getAminoAcids()) {
            if (originalAa == 'X') continue;
            AminoAcid aminoAcid = AminoAcid.getAminoAcid(originalAa);
            for (String geneCode : aminoAcid.getStandardGeneticCode()) {
                StringBuilder geneCodeStringBuilder = new StringBuilder(geneCode);
                for (int i = 0; i < geneCode.length(); ++i) {
                    char originalBase = geneCode.charAt(i);
                    for (char base : bases) {
                        char mutatedAa;
                        geneCodeStringBuilder.setCharAt(i, base);
                        String newCode = geneCodeStringBuilder.toString();
                        AminoAcid mutatedAminoAcid = AminoAcid.getAminoAcidFromGeneticCode(newCode);
                        if (mutatedAminoAcid == null || originalAa == (mutatedAa = mutatedAminoAcid.getSingleLetterCodeAsChar())) continue;
                        result.addMutation(Character.valueOf(originalAa), Character.valueOf(mutatedAa));
                    }
                    geneCodeStringBuilder.setCharAt(i, originalBase);
                }
            }
        }
        return result;
    }

    private static MutationMatrix transitionsSingleBaseSubstitution() {
        MutationMatrix result = new MutationMatrix("Transition Mutation", "Single base transitions substitutions.");
        char[] purines = new char[]{'A', 'G'};
        char[] pyrimidines = new char[]{'T', 'C'};
        for (char originalAa : AminoAcid.getAminoAcids()) {
            if (originalAa == 'X') continue;
            AminoAcid aminoAcid = AminoAcid.getAminoAcid(originalAa);
            for (String geneCode : aminoAcid.getStandardGeneticCode()) {
                StringBuilder geneCodeStringBuilder = new StringBuilder(geneCode);
                for (int i = 0; i < geneCode.length(); ++i) {
                    char[] bases;
                    char originalBase = geneCode.charAt(i);
                    if (originalBase == purines[0] || originalBase == purines[1]) {
                        bases = purines;
                    } else if (originalBase == pyrimidines[0] || originalBase == pyrimidines[1]) {
                        bases = pyrimidines;
                    } else {
                        throw new IllegalArgumentException(originalBase + " not recognized for transitions substitution.");
                    }
                    for (char base : bases) {
                        char mutatedAa;
                        geneCodeStringBuilder.setCharAt(i, base);
                        String newCode = geneCodeStringBuilder.toString();
                        AminoAcid mutatedAminoAcid = AminoAcid.getAminoAcidFromGeneticCode(newCode);
                        if (mutatedAminoAcid == null || originalAa == (mutatedAa = mutatedAminoAcid.getSingleLetterCodeAsChar())) continue;
                        result.addMutation(Character.valueOf(originalAa), Character.valueOf(mutatedAa));
                    }
                    geneCodeStringBuilder.setCharAt(i, originalBase);
                }
            }
        }
        return result;
    }

    private static MutationMatrix transversalSingleBaseSubstitution() {
        MutationMatrix result = new MutationMatrix("Transversion Mutation", "Single base transversion substitutions.");
        char[] purines = new char[]{'A', 'G'};
        char[] pyrimidines = new char[]{'T', 'C'};
        for (char originalAa : AminoAcid.getAminoAcids()) {
            if (originalAa == 'X') continue;
            AminoAcid aminoAcid = AminoAcid.getAminoAcid(originalAa);
            for (String geneCode : aminoAcid.getStandardGeneticCode()) {
                StringBuilder geneCodeStringBuilder = new StringBuilder(geneCode);
                for (int i = 0; i < geneCode.length(); ++i) {
                    char[] bases;
                    char originalBase = geneCode.charAt(i);
                    if (originalBase == purines[0] || originalBase == purines[1]) {
                        bases = pyrimidines;
                    } else if (originalBase == pyrimidines[0] || originalBase == pyrimidines[1]) {
                        bases = purines;
                    } else {
                        throw new IllegalArgumentException(originalBase + " not recognized for transversion substitutions.");
                    }
                    for (char base : bases) {
                        char mutatedAa;
                        geneCodeStringBuilder.setCharAt(i, base);
                        String newCode = geneCodeStringBuilder.toString();
                        AminoAcid mutatedAminoAcid = AminoAcid.getAminoAcidFromGeneticCode(newCode);
                        if (mutatedAminoAcid == null || originalAa == (mutatedAa = mutatedAminoAcid.getSingleLetterCodeAsChar())) continue;
                        result.addMutation(Character.valueOf(originalAa), Character.valueOf(mutatedAa));
                    }
                    geneCodeStringBuilder.setCharAt(i, originalBase);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private static MutationMatrix synonymousMutation() {
        char[] cArray;
        char[] basic;
        char[] polarNeutral;
        void var5_9;
        char[] aromatic;
        char[] nonPolarAliphatic;
        MutationMatrix result = new MutationMatrix("Synonymous Mutation", "Mutations keeping amino acid properties.");
        for (char c : nonPolarAliphatic = new char[]{'G', 'A', 'V', 'L', 'M', 'I'}) {
            for (char c2 : nonPolarAliphatic) {
                if (c == c2) continue;
                result.addMutation(Character.valueOf(c), Character.valueOf(c2));
            }
            result.addMutation(Character.valueOf('J'), Character.valueOf(c));
        }
        char[] cArray2 = aromatic = new char[]{'F', 'Y', 'W'};
        int n = cArray2.length;
        boolean bl = false;
        while (var5_9 < n) {
            char originalAminoAcid = cArray2[var5_9];
            for (char mutatedAminoAcid : aromatic) {
                if (originalAminoAcid == mutatedAminoAcid) continue;
                result.addMutation(Character.valueOf(originalAminoAcid), Character.valueOf(mutatedAminoAcid));
            }
            ++var5_9;
        }
        for (char originalAminoAcid : polarNeutral = new char[]{'S', 'T', 'C', 'P', 'N', 'Q'}) {
            for (char mutatedAminoAcid : polarNeutral) {
                if (originalAminoAcid == mutatedAminoAcid) continue;
                result.addMutation(Character.valueOf(originalAminoAcid), Character.valueOf(mutatedAminoAcid));
            }
            result.addMutation(Character.valueOf('B'), Character.valueOf(originalAminoAcid));
            result.addMutation(Character.valueOf('Z'), Character.valueOf(originalAminoAcid));
        }
        for (char originalAminoAcid : basic = new char[]{'K', 'R', 'H'}) {
            for (char mutatedAminoAcid : basic) {
                if (originalAminoAcid == mutatedAminoAcid) continue;
                result.addMutation(Character.valueOf(originalAminoAcid), Character.valueOf(mutatedAminoAcid));
            }
        }
        for (char c : cArray = new char[]{'D', 'E'}) {
            for (char mutatedAminoAcid : cArray) {
                if (c == mutatedAminoAcid) continue;
                result.addMutation(Character.valueOf(c), Character.valueOf(mutatedAminoAcid));
            }
            result.addMutation(Character.valueOf('B'), Character.valueOf(c));
            result.addMutation(Character.valueOf('Z'), Character.valueOf(c));
        }
        return result;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Double getMinDelta() {
        return this.minDelta;
    }

    public Double getMaxDelta() {
        return this.maxDelta;
    }

    public boolean isSameAs(MutationMatrix mutationMatrix) {
        if (this.equals(mutationMatrix)) {
            return true;
        }
        if (!this.name.equals(mutationMatrix.getName())) {
            return false;
        }
        if (!this.description.equals(mutationMatrix.getDescription())) {
            return false;
        }
        for (Character aa : this.mutations.keySet()) {
            HashSet<Character> aaMutations = this.mutations.get(aa);
            HashSet<Character> otherMutations = mutationMatrix.getMutatedAminoAcids(aa);
            if (otherMutations == null || aaMutations.size() != otherMutations.size()) {
                return false;
            }
            for (Character mutatedAa : aaMutations) {
                if (otherMutations.contains(mutatedAa)) continue;
                return false;
            }
        }
        return true;
    }
}

