/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification;

import com.compomics.util.db.ObjectsCache;
import com.compomics.util.db.ObjectsDB;
import com.compomics.util.experiment.identification.IdentificationMatch;
import com.compomics.util.experiment.identification.SpectrumIdentificationAssumption;
import com.compomics.util.experiment.identification.matches.PeptideMatch;
import com.compomics.util.experiment.identification.matches.ProteinMatch;
import com.compomics.util.experiment.identification.matches.SpectrumMatch;
import com.compomics.util.experiment.massspectrometry.Spectrum;
import com.compomics.util.experiment.personalization.UrParameter;
import com.compomics.util.waiting.WaitingHandler;
import java.io.IOException;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

public class IdentificationDB
implements Serializable {
    static final long serialVersionUID = 691986038787590646L;
    public String dbName;
    private static String proteinTableName = "proteins";
    private static String proteinParametersTableSuffix = "_protein_parameters";
    private static String peptideTableName = "peptides";
    private static String peptideParametersTableSuffix = "_peptide_parameters";
    private static String psmTableSuffix = "_psms";
    private static String assumptionsTableSuffix = "_assumptions";
    private static String rawAssumptionsTableSuffix = "_raw_assumptions";
    private static String psmParametersTableSuffix = "_psm_parameters";
    private ArrayList<String> rawAssumptionsTables = new ArrayList();
    private ArrayList<String> assumptionsTables = new ArrayList();
    private ArrayList<String> psmTables = new ArrayList();
    private ArrayList<String> psmParametersTables = new ArrayList();
    private ArrayList<String> peptideParametersTables = new ArrayList();
    private ArrayList<String> proteinParametersTables = new ArrayList();
    private ObjectsDB objectsDB;

    public IdentificationDB(String folder, String name, boolean deleteOldDatabase, ObjectsCache objectCache) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        this.dbName = name;
        this.objectsDB = new ObjectsDB(folder, this.dbName, deleteOldDatabase, objectCache);
        if (deleteOldDatabase) {
            this.objectsDB.addTable(proteinTableName);
            this.objectsDB.addTable(peptideTableName);
        }
    }

    public boolean spectrumMatchLoaded(String spectrumKey) throws SQLException, InterruptedException {
        String tableName = this.getSpectrumMatchTable(spectrumKey);
        return this.objectsDB.inDB(tableName, spectrumKey, true);
    }

    public boolean peptideMatchLoaded(String peptideKey) throws SQLException, InterruptedException {
        return this.objectsDB.inDB(peptideTableName, peptideKey, true);
    }

    public boolean proteinMatchLoaded(String proteinKey) throws SQLException, InterruptedException {
        return this.objectsDB.inDB(proteinTableName, proteinKey, true);
    }

    public void updateProteinMatch(ProteinMatch proteinMatch) throws SQLException, IOException, InterruptedException {
        this.objectsDB.updateObject(proteinTableName, proteinMatch.getKey(), proteinMatch);
    }

    public void updatePeptideMatch(PeptideMatch peptideMatch) throws SQLException, IOException, InterruptedException {
        this.objectsDB.updateObject(peptideTableName, peptideMatch.getKey(), peptideMatch);
    }

    public void updateSpectrumMatch(SpectrumMatch spectrumMatch) throws SQLException, IOException, InterruptedException {
        String key = spectrumMatch.getKey();
        String tableName = this.getSpectrumMatchTable(key);
        this.objectsDB.updateObject(tableName, key, spectrumMatch);
    }

    public void updateAssumptions(String spectrumKey, HashMap<Integer, HashMap<Double, ArrayList<SpectrumIdentificationAssumption>>> assumptionsMap) throws SQLException, IOException, InterruptedException {
        String tableName = this.getAssumptionTable(spectrumKey);
        this.objectsDB.updateObject(tableName, spectrumKey, assumptionsMap);
    }

    public void updateRawAssumptions(String spectrumKey, HashMap<Integer, HashMap<Double, ArrayList<SpectrumIdentificationAssumption>>> rawAssumptionsMap) throws SQLException, IOException, InterruptedException {
        String tableName = this.getRawAssumptionTable(spectrumKey);
        this.objectsDB.updateObject(tableName, spectrumKey, rawAssumptionsMap);
    }

    public void updateMatch(IdentificationMatch match) throws SQLException, IOException, InterruptedException {
        switch (match.getType()) {
            case Spectrum: {
                this.updateSpectrumMatch((SpectrumMatch)match);
                return;
            }
            case Peptide: {
                this.updatePeptideMatch((PeptideMatch)match);
                return;
            }
            case Protein: {
                this.updateProteinMatch((ProteinMatch)match);
            }
        }
    }

    public void updateProteinParameter(String key, UrParameter urParameter) throws SQLException, IOException, InterruptedException {
        String tableName = this.getProteinParameterTable(urParameter);
        this.objectsDB.updateObject(tableName, key, urParameter);
    }

    public void updatePeptideParameter(String key, UrParameter urParameter) throws SQLException, IOException, InterruptedException {
        String tableName = this.getPeptideParameterTable(urParameter);
        this.objectsDB.updateObject(tableName, key, urParameter);
    }

    public void updateSpectrumParameter(String key, UrParameter urParameter) throws SQLException, IOException, InterruptedException {
        String tableName = this.getSpectrumParameterTable(key, urParameter);
        this.objectsDB.updateObject(tableName, key, urParameter);
    }

    public void removeProteinMatch(String key) throws SQLException, IOException, InterruptedException {
        this.objectsDB.deleteObject(proteinTableName, key);
        for (String proteinParameterTable : this.proteinParametersTables) {
            this.objectsDB.deleteObject(proteinParameterTable, key);
        }
    }

    public void removePeptideMatch(String key) throws SQLException, IOException, InterruptedException {
        this.objectsDB.deleteObject(peptideTableName, key);
        for (String peptideParameterTable : this.peptideParametersTables) {
            this.objectsDB.deleteObject(peptideParameterTable, key);
        }
    }

    public void removeSpectrumMatch(String key) throws SQLException, IOException, InterruptedException {
        for (String psmTable : this.psmTables) {
            this.objectsDB.deleteObject(psmTable, key);
        }
        for (String psmParameterTable : this.psmParametersTables) {
            this.objectsDB.deleteObject(psmParameterTable, key);
        }
    }

    public void removeAssumptions(String key) throws SQLException, IOException, InterruptedException {
        for (String table : this.assumptionsTables) {
            this.objectsDB.deleteObject(table, key);
        }
    }

    public void removeRawAssumptions(String key) throws SQLException, IOException, InterruptedException {
        for (String table : this.rawAssumptionsTables) {
            this.objectsDB.deleteObject(table, key);
        }
    }

    public ArrayList<String> getPeptideParametersTables() {
        return this.peptideParametersTables;
    }

    public HashMap<Integer, HashMap<Double, ArrayList<SpectrumIdentificationAssumption>>> getAssumptions(String key, boolean useDB) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        String tableName = this.getAssumptionTable(key);
        this.checkTable(this.assumptionsTables, tableName);
        return (HashMap)this.objectsDB.retrieveObject(tableName, key, useDB);
    }

    public void addAssumptions(String spectrumKey, HashMap<Integer, HashMap<Double, ArrayList<SpectrumIdentificationAssumption>>> assumptions) throws SQLException, IOException, InterruptedException {
        String tableName = this.getAssumptionTable(spectrumKey);
        this.checkTable(this.assumptionsTables, tableName);
        this.objectsDB.insertObject(tableName, spectrumKey, assumptions, true);
    }

    public HashMap<Integer, HashMap<Double, ArrayList<SpectrumIdentificationAssumption>>> getRawAssumptions(String key, boolean useDB) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        String tableName = this.getRawAssumptionTable(key);
        this.checkTable(this.rawAssumptionsTables, tableName);
        return (HashMap)this.objectsDB.retrieveObject(tableName, key, useDB);
    }

    public void addRawAssumptions(String spectrumKey, HashMap<Integer, HashMap<Double, ArrayList<SpectrumIdentificationAssumption>>> assumptions) throws SQLException, IOException, InterruptedException {
        String tableName = this.getRawAssumptionTable(spectrumKey);
        this.checkTable(this.rawAssumptionsTables, tableName);
        this.objectsDB.insertObject(tableName, spectrumKey, assumptions, true);
    }

    public SpectrumMatch getSpectrumMatch(String key, boolean useDB) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        String tableName = this.getSpectrumMatchTable(key);
        return (SpectrumMatch)this.objectsDB.retrieveObject(tableName, key, useDB);
    }

    public void addSpectrumMatch(SpectrumMatch spectrumMatch) throws SQLException, IOException, InterruptedException {
        String key = spectrumMatch.getKey();
        String tableName = this.getSpectrumMatchTable(key);
        this.checkTable(this.psmTables, tableName);
        this.objectsDB.insertObject(tableName, key, spectrumMatch, true);
    }

    public boolean spectrumMatchTableCreated(String spectrumMatchKey) {
        String tableName = this.getSpectrumMatchTable(spectrumMatchKey);
        return this.psmTables.contains(tableName);
    }

    public PeptideMatch getPeptideMatch(String key, boolean useDB) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        return (PeptideMatch)this.objectsDB.retrieveObject(peptideTableName, key, useDB);
    }

    public void addPeptideMatch(PeptideMatch peptideMatch) throws SQLException, IOException, InterruptedException {
        this.objectsDB.insertObject(peptideTableName, peptideMatch.getKey(), peptideMatch, true);
    }

    public ProteinMatch getProteinMatch(String key, boolean useDB) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        return (ProteinMatch)this.objectsDB.retrieveObject(proteinTableName, key, useDB);
    }

    public void addProteinMatch(ProteinMatch proteinMatch) throws SQLException, IOException, InterruptedException {
        this.objectsDB.insertObject(proteinTableName, proteinMatch.getKey(), proteinMatch, true);
    }

    public void addMatch(IdentificationMatch match) throws SQLException, IOException, InterruptedException {
        switch (match.getType()) {
            case Spectrum: {
                this.addSpectrumMatch((SpectrumMatch)match);
                return;
            }
            case Peptide: {
                this.addPeptideMatch((PeptideMatch)match);
                return;
            }
            case Protein: {
                this.addProteinMatch((ProteinMatch)match);
            }
        }
    }

    public void loadAssumptions(String fileName, WaitingHandler waitingHandler, boolean displayProgress) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        String testKey = Spectrum.getSpectrumKey(fileName, "test");
        String tableName = this.getAssumptionTable(testKey);
        this.objectsDB.loadObjects(tableName, waitingHandler, displayProgress);
    }

    public void loadAssumptions(ArrayList<String> spectrumKeys, WaitingHandler waitingHandler, boolean displayProgress) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        if (waitingHandler != null && displayProgress) {
            waitingHandler.setSecondaryProgressCounterIndeterminate(false);
            waitingHandler.setSecondaryProgressCounter(0);
            waitingHandler.setMaxSecondaryProgressCounter(2 * spectrumKeys.size());
        }
        HashMap sortedKeys = new HashMap();
        for (String spectrumKey : spectrumKeys) {
            String tableName = this.getAssumptionTable(spectrumKey);
            if (!sortedKeys.containsKey(tableName)) {
                sortedKeys.put(tableName, new ArrayList());
            }
            ((ArrayList)sortedKeys.get(tableName)).add(spectrumKey);
            if (waitingHandler == null) continue;
            if (displayProgress) {
                waitingHandler.increaseSecondaryProgressCounter();
            }
            if (!waitingHandler.isRunCanceled()) continue;
            break;
        }
        for (String tableName : sortedKeys.keySet()) {
            if (!this.objectsDB.hasTable(tableName)) continue;
            this.objectsDB.loadObjects(tableName, (ArrayList)sortedKeys.get(tableName), waitingHandler, displayProgress);
        }
    }

    public void loadRawAssumptions(String fileName, WaitingHandler waitingHandler, boolean displayProgress) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        String testKey = Spectrum.getSpectrumKey(fileName, "test");
        String tableName = this.getRawAssumptionTable(testKey);
        this.objectsDB.loadObjects(tableName, waitingHandler, displayProgress);
    }

    public void loadRawAssumptions(ArrayList<String> spectrumKeys, WaitingHandler waitingHandler, boolean displayProgress) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        if (waitingHandler != null && displayProgress) {
            waitingHandler.setSecondaryProgressCounterIndeterminate(false);
            waitingHandler.setSecondaryProgressCounter(0);
            waitingHandler.setMaxSecondaryProgressCounter(2 * spectrumKeys.size());
        }
        HashMap sortedKeys = new HashMap();
        for (String spectrumKey : spectrumKeys) {
            String tableName = this.getRawAssumptionTable(spectrumKey);
            if (!sortedKeys.containsKey(tableName)) {
                sortedKeys.put(tableName, new ArrayList());
            }
            ((ArrayList)sortedKeys.get(tableName)).add(spectrumKey);
            if (waitingHandler == null) continue;
            if (displayProgress) {
                waitingHandler.increaseSecondaryProgressCounter();
            }
            if (!waitingHandler.isRunCanceled()) continue;
            break;
        }
        for (String tableName : sortedKeys.keySet()) {
            if (!this.objectsDB.hasTable(tableName)) continue;
            this.objectsDB.loadObjects(tableName, (ArrayList)sortedKeys.get(tableName), waitingHandler, displayProgress);
        }
    }

    public void loadSpectrumMatches(String fileName, WaitingHandler waitingHandler, boolean displayProgress) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        String testKey = Spectrum.getSpectrumKey(fileName, "test");
        String tableName = this.getSpectrumMatchTable(testKey);
        this.objectsDB.loadObjects(tableName, waitingHandler, displayProgress);
    }

    public void loadSpectrumMatches(ArrayList<String> spectrumKeys, WaitingHandler waitingHandler, boolean displayProgress) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        if (waitingHandler != null && displayProgress) {
            waitingHandler.setSecondaryProgressCounterIndeterminate(false);
            waitingHandler.setSecondaryProgressCounter(0);
            waitingHandler.setMaxSecondaryProgressCounter(2 * spectrumKeys.size());
        }
        HashMap sortedKeys = new HashMap();
        for (String spectrumKey : spectrumKeys) {
            String tableName = this.getSpectrumMatchTable(spectrumKey);
            if (!sortedKeys.containsKey(tableName)) {
                sortedKeys.put(tableName, new ArrayList());
            }
            ((ArrayList)sortedKeys.get(tableName)).add(spectrumKey);
            if (waitingHandler == null) continue;
            if (displayProgress) {
                waitingHandler.increaseSecondaryProgressCounter();
            }
            if (!waitingHandler.isRunCanceled()) continue;
            break;
        }
        for (String tableName : sortedKeys.keySet()) {
            this.objectsDB.loadObjects(tableName, (ArrayList)sortedKeys.get(tableName), waitingHandler, displayProgress);
        }
    }

    public void loadSpectrumMatchParameters(String fileName, UrParameter urParameter, WaitingHandler waitingHandler, boolean displayProgress) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        String testKey = Spectrum.getSpectrumKey(fileName, "test");
        String tableName = this.getSpectrumParameterTable(testKey, urParameter);
        this.objectsDB.loadObjects(tableName, waitingHandler, displayProgress);
    }

    public void loadSpectrumMatchParameters(ArrayList<String> spectrumKeys, UrParameter urParameter, WaitingHandler waitingHandler, boolean displayProgress) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        if (waitingHandler != null && displayProgress) {
            waitingHandler.setSecondaryProgressCounterIndeterminate(false);
            waitingHandler.setSecondaryProgressCounter(0);
            waitingHandler.setMaxSecondaryProgressCounter(2 * spectrumKeys.size());
        }
        HashMap sortedKeys = new HashMap();
        for (String spectrumKey : spectrumKeys) {
            String tableName = this.getSpectrumParameterTable(spectrumKey, urParameter);
            if (!sortedKeys.containsKey(tableName)) {
                sortedKeys.put(tableName, new ArrayList());
            }
            ((ArrayList)sortedKeys.get(tableName)).add(spectrumKey);
            if (waitingHandler == null) continue;
            if (displayProgress) {
                waitingHandler.increaseSecondaryProgressCounter();
            }
            if (!waitingHandler.isRunCanceled()) continue;
            break;
        }
        for (String tableName : sortedKeys.keySet()) {
            this.objectsDB.loadObjects(tableName, (ArrayList)sortedKeys.get(tableName), waitingHandler, displayProgress);
        }
    }

    public void loadPeptideMatches(WaitingHandler waitingHandler, boolean displayProgress) throws SQLException, IOException, ClassNotFoundException, InterruptedException, InterruptedException {
        this.objectsDB.loadObjects(peptideTableName, waitingHandler, displayProgress);
    }

    public void loadPeptideMatches(ArrayList<String> peptideKeys, WaitingHandler waitingHandler, boolean displayProgress) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        if (waitingHandler != null && displayProgress) {
            waitingHandler.setSecondaryProgressCounterIndeterminate(false);
            waitingHandler.setSecondaryProgressCounter(0);
            waitingHandler.setMaxSecondaryProgressCounter(peptideKeys.size());
        }
        this.objectsDB.loadObjects(peptideTableName, peptideKeys, waitingHandler, displayProgress);
    }

    public void loadPeptideMatchParameters(UrParameter urParameter, WaitingHandler waitingHandler, boolean displayProgress) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        String tableName = this.getPeptideParameterTable(urParameter);
        this.objectsDB.loadObjects(tableName, waitingHandler, displayProgress);
    }

    public void loadPeptideMatchParameters(ArrayList<String> peptideKeys, UrParameter urParameter, WaitingHandler waitingHandler, boolean displayProgress) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        if (waitingHandler != null && displayProgress) {
            waitingHandler.setSecondaryProgressCounterIndeterminate(false);
            waitingHandler.setSecondaryProgressCounter(0);
            waitingHandler.setMaxSecondaryProgressCounter(peptideKeys.size());
        }
        String tableName = this.getPeptideParameterTable(urParameter);
        this.objectsDB.loadObjects(tableName, peptideKeys, waitingHandler, displayProgress);
    }

    public void loadProteinMatches(WaitingHandler waitingHandler, boolean displayProgress) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        this.objectsDB.loadObjects(proteinTableName, waitingHandler, displayProgress);
    }

    public void loadProteinMatches(ArrayList<String> proteinKeys, WaitingHandler waitingHandler, boolean displayProgress) throws SQLException, IOException, ClassNotFoundException, InterruptedException, InterruptedException {
        if (waitingHandler != null && displayProgress) {
            waitingHandler.setSecondaryProgressCounterIndeterminate(false);
            waitingHandler.setSecondaryProgressCounter(0);
            waitingHandler.setMaxSecondaryProgressCounter(proteinKeys.size());
        }
        this.objectsDB.loadObjects(proteinTableName, proteinKeys, waitingHandler, displayProgress);
    }

    public void loadProteinMatchParameters(UrParameter urParameter, WaitingHandler waitingHandler, boolean displayProgress) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        String tableName = this.getProteinParameterTable(urParameter);
        this.objectsDB.loadObjects(tableName, waitingHandler, displayProgress);
    }

    public void loadProteinMatchParameters(ArrayList<String> proteinKeys, UrParameter urParameter, WaitingHandler waitingHandler, boolean displayProgress) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        if (waitingHandler != null && displayProgress) {
            waitingHandler.setSecondaryProgressCounterIndeterminate(false);
            waitingHandler.setSecondaryProgressCounter(0);
            waitingHandler.setMaxSecondaryProgressCounter(proteinKeys.size());
        }
        String tableName = this.getProteinParameterTable(urParameter);
        this.objectsDB.loadObjects(tableName, proteinKeys, waitingHandler, displayProgress);
    }

    public UrParameter getSpectrumMatchParameter(String key, UrParameter urParameter, boolean useDB) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        String tableName = this.getSpectrumParameterTable(key, urParameter);
        return (UrParameter)this.objectsDB.retrieveObject(tableName, key, useDB);
    }

    public void addSpectrumMatchParameter(String key, UrParameter urParameter) throws SQLException, IOException, InterruptedException {
        String tableName = this.getSpectrumParameterTable(key, urParameter);
        this.checkTable(this.psmParametersTables, tableName);
        this.objectsDB.insertObject(tableName, key, urParameter, true);
    }

    public UrParameter getPeptideMatchParameter(String key, UrParameter urParameter, boolean useDB) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        String tableName = this.getPeptideParameterTable(urParameter);
        return (UrParameter)this.objectsDB.retrieveObject(tableName, key, useDB);
    }

    public void addPeptideMatchParameter(String key, UrParameter urParameter) throws SQLException, IOException, InterruptedException {
        String tableName = this.getPeptideParameterTable(urParameter);
        this.checkTable(this.peptideParametersTables, tableName);
        this.objectsDB.insertObject(tableName, key, urParameter, true);
    }

    public UrParameter getProteinMatchParameter(String key, UrParameter urParameter, boolean useDB) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        String tableName = this.getProteinParameterTable(urParameter);
        return (UrParameter)this.objectsDB.retrieveObject(tableName, key, useDB);
    }

    public void addProteinMatchParameter(String key, UrParameter urParameter) throws SQLException, IOException, InterruptedException {
        String tableName = this.getProteinParameterTable(urParameter);
        this.checkTable(this.proteinParametersTables, tableName);
        this.objectsDB.insertObject(tableName, key, urParameter, true);
    }

    public synchronized void checkTable(Collection<String> tableList, String tableName) throws SQLException, IOException, InterruptedException {
        if (!tableList.contains(tableName)) {
            this.objectsDB.addTable(tableName);
            tableList.add(tableName);
        }
    }

    public Object getObject(String table, String objectKey, boolean useDB) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        return this.objectsDB.retrieveObject(table, objectKey, true);
    }

    public String getAssumptionTable(String spectrumKey) {
        String tableName = Spectrum.getSpectrumFile(spectrumKey) + assumptionsTableSuffix;
        tableName = this.objectsDB.correctTableName(tableName);
        return tableName;
    }

    public String getRawAssumptionTable(String spectrumKey) {
        String tableName = Spectrum.getSpectrumFile(spectrumKey) + rawAssumptionsTableSuffix;
        tableName = this.objectsDB.correctTableName(tableName);
        return tableName;
    }

    public String getSpectrumMatchTable(String spectrumKey) {
        String tableName = Spectrum.getSpectrumFile(spectrumKey) + psmTableSuffix;
        tableName = this.objectsDB.correctTableName(tableName);
        return tableName;
    }

    public String getSpectrumParameterTable(String spectrumKey, UrParameter urParameter) {
        String fileName = Spectrum.getSpectrumFile(spectrumKey);
        String tableName = urParameter.getParameterKey() + "_" + fileName + psmParametersTableSuffix;
        tableName = this.objectsDB.correctTableName(tableName);
        return tableName;
    }

    public String getPeptideParameterTable(UrParameter urParameter) {
        String tableName = urParameter.getParameterKey() + peptideParametersTableSuffix;
        tableName = this.objectsDB.correctTableName(tableName);
        return tableName;
    }

    public String getProteinParameterTable(UrParameter urParameter) {
        String tableName = urParameter.getParameterKey() + proteinParametersTableSuffix;
        tableName = this.objectsDB.correctTableName(tableName);
        return tableName;
    }

    public void restoreConnection(String dbFolder, boolean deleteOldDatabase, ObjectsCache objectsCache) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        this.objectsDB.establishConnection(dbFolder, deleteOldDatabase, objectsCache);
        objectsCache.addDb(this.objectsDB);
    }

    public boolean isConnectionActive() {
        return this.objectsDB.isConnectionActive();
    }

    public ObjectsDB getObjectsDB() {
        return this.objectsDB;
    }

    public void close() throws SQLException, InterruptedException {
        this.objectsDB.close();
    }
}

