/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.identification_parameters.tool_specific;

import com.compomics.util.experiment.identification.Advocate;
import com.compomics.util.experiment.identification.identification_parameters.IdentificationAlgorithmParameter;
import java.util.HashMap;

public class NovorParameters
implements IdentificationAlgorithmParameter {
    static final long serialVersionUID = -1685402448885208852L;
    private String fragmentationMethod = "HCD";
    private String massAnalyzer = "FT";
    private HashMap<String, String> novorPtmMap;

    @Override
    public Advocate getAlgorithm() {
        return Advocate.novor;
    }

    @Override
    public boolean equals(IdentificationAlgorithmParameter identificationAlgorithmParameter) {
        if (identificationAlgorithmParameter instanceof NovorParameters) {
            NovorParameters novorParameters = (NovorParameters)identificationAlgorithmParameter;
            if (!this.fragmentationMethod.equalsIgnoreCase(novorParameters.getFragmentationMethod())) {
                return false;
            }
            if (!this.massAnalyzer.equalsIgnoreCase(novorParameters.getMassAnalyzer())) {
                return false;
            }
        }
        return true;
    }

    @Override
    public String toString(boolean html) {
        String newLine = System.getProperty("line.separator");
        if (html) {
            newLine = "<br>";
        }
        StringBuilder output = new StringBuilder();
        Advocate advocate = this.getAlgorithm();
        output.append("# ------------------------------------------------------------------");
        output.append(newLine);
        output.append("# ").append(advocate.getName()).append(" Specific Parameters");
        output.append(newLine);
        output.append("# ------------------------------------------------------------------");
        output.append(newLine);
        output.append(newLine);
        output.append("FRAGMENTATION=");
        output.append(this.fragmentationMethod);
        output.append(newLine);
        output.append("MASS_ANALYZER=");
        output.append(this.massAnalyzer);
        output.append(newLine);
        return output.toString();
    }

    public String getFragmentationMethod() {
        return this.fragmentationMethod;
    }

    public void setFragmentationMethod(String fragmentationMethod) {
        this.fragmentationMethod = fragmentationMethod;
    }

    public String getMassAnalyzer() {
        return this.massAnalyzer;
    }

    public void setMassAnalyzer(String massAnalyzer) {
        this.massAnalyzer = massAnalyzer;
    }

    public HashMap<String, String> getNovorPtmMap() {
        return this.novorPtmMap;
    }

    public void setNovorPtmMap(HashMap<String, String> novorPtmMap) {
        this.novorPtmMap = novorPtmMap;
    }

    public String getUtilitiesPtmName(String novorPtmShortName) {
        if (this.novorPtmMap == null) {
            return null;
        }
        return this.novorPtmMap.get(novorPtmShortName);
    }
}

