/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.protein_inference.fm_index;

import com.compomics.util.experiment.biology.AminoAcid;
import com.compomics.util.experiment.biology.AminoAcidPattern;
import com.compomics.util.experiment.biology.AminoAcidSequence;
import com.compomics.util.experiment.biology.MassGap;
import com.compomics.util.experiment.biology.PTM;
import com.compomics.util.experiment.biology.PTMFactory;
import com.compomics.util.experiment.biology.Protein;
import com.compomics.util.experiment.biology.variants.AaSubstitutionMatrix;
import com.compomics.util.experiment.biology.variants.amino_acids.Deletion;
import com.compomics.util.experiment.biology.variants.amino_acids.Insertion;
import com.compomics.util.experiment.biology.variants.amino_acids.Substitution;
import com.compomics.util.experiment.identification.amino_acid_tags.Tag;
import com.compomics.util.experiment.identification.amino_acid_tags.matchers.TagMatcher;
import com.compomics.util.experiment.identification.identification_parameters.PtmSettings;
import com.compomics.util.experiment.identification.identification_parameters.SearchParameters;
import com.compomics.util.experiment.identification.matches.ModificationMatch;
import com.compomics.util.experiment.identification.matches.VariantMatch;
import com.compomics.util.experiment.identification.protein_inference.PeptideMapper;
import com.compomics.util.experiment.identification.protein_inference.PeptideProteinMapping;
import com.compomics.util.experiment.identification.protein_inference.fm_index.MatrixContent;
import com.compomics.util.experiment.identification.protein_inference.fm_index.WaveletTree;
import com.compomics.util.experiment.identification.protein_sequences.SequenceFactory;
import com.compomics.util.preferences.PeptideVariantsPreferences;
import com.compomics.util.preferences.SequenceMatchingPreferences;
import com.compomics.util.waiting.WaitingHandler;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Semaphore;
import org.jsuffixarrays.DivSufSort;

public class FMIndex
implements PeptideMapper {
    static Semaphore cacheMutex = new Semaphore(1);
    private int indexParts = 0;
    private final int indexChunkSize = 0x6400000;
    private final ArrayList<int[]> suffixArraysPrimary = new ArrayList();
    public ArrayList<WaveletTree> occurrenceTablesPrimary = new ArrayList();
    public ArrayList<WaveletTree> occurrenceTablesReversed = new ArrayList();
    public ArrayList<int[]> lessTablesPrimary = new ArrayList();
    public ArrayList<int[]> lessTablesReversed = new ArrayList();
    public ArrayList<Integer> indexStringLengths = new ArrayList();
    private final int samplingShift = 3;
    private final int samplingMask = 7;
    private final int sampling = 8;
    private final ArrayList<int[]> boundaries = new ArrayList();
    private final ArrayList<String[]> accessions = new ArrayList();
    private double[] aaMasses = null;
    private int[] aaMassIndexes = null;
    private int numMasses = 0;
    private String[] modifictationLabels = null;
    private boolean[] modificationFlags = null;
    private boolean withVariableModifications = false;
    private int[] BSubstitutions = new int[]{68, 78};
    private int[] JSubstitutions = new int[]{73, 76};
    private int[] ZSubstitutions = new int[]{69, 81};
    private ArrayList<String> fmodc = null;
    private ArrayList<Double> fmodcMass = null;
    private ArrayList<String>[] fmodcaa = null;
    private ArrayList<Double>[] fmodcaaMass = null;
    private ArrayList<String> fmodn = null;
    private ArrayList<Double> fmodnMass = null;
    private ArrayList<String>[] fmodnaa = null;
    private ArrayList<Double>[] fmodnaaMass = null;
    private ArrayList<String> fmodcp = null;
    private ArrayList<Double> fmodcpMass = null;
    private ArrayList<String>[] fmodcpaa = null;
    private ArrayList<Double>[] fmodcpaaMass = null;
    private ArrayList<String> fmodnp = null;
    private ArrayList<Double> fmodnpMass = null;
    private ArrayList<String>[] fmodnpaa = null;
    private ArrayList<Double>[] fmodnpaaMass = null;
    private ArrayList<String> vmodc = null;
    private ArrayList<Double> vmodcMass = null;
    private ArrayList<String>[] vmodcaa = null;
    private ArrayList<Double>[] vmodcaaMass = null;
    private ArrayList<String> vmodn = null;
    private ArrayList<Double> vmodnMass = null;
    private ArrayList<String>[] vmodnaa = null;
    private ArrayList<Double>[] vmodnaaMass = null;
    private ArrayList<String> vmodcp = null;
    private ArrayList<Double> vmodcpMass = null;
    private ArrayList<String>[] vmodcpaa = null;
    private ArrayList<Double>[] vmodcpaaMass = null;
    private ArrayList<String> vmodnp = null;
    private ArrayList<Double> vmodnpMass = null;
    private ArrayList<String>[] vmodnpaa = null;
    private ArrayList<Double>[] vmodnpaaMass = null;
    private boolean hasCTermDirectionPTM = false;
    private boolean hasNTermDirectionPTM = false;
    private boolean hasPTMatTerminus = false;
    private boolean hasFixedPTM_CatTerminus = false;
    private boolean hasFixedPTM_NatTerminus = false;
    double negativePTMMass = 0.0;
    boolean genericVariantMatching = true;
    int maxNumberVariants = 0;
    int maxNumberInsertions = 0;
    int maxNumberDeletions = 0;
    int maxNumberSubstitutions = 0;
    boolean[][] substitutionMatrix = null;
    double lookupMultiplier = 10000.0;
    SearchParameters.MassAccuracyType massAccuracyType = SearchParameters.MassAccuracyType.DA;
    double massTolerance = 0.02;
    double lookupMaxMass = 800.0;
    long[] lookupMasses = null;
    int maxXPerTag = 4;
    long[][] Xlookup = null;
    ArrayList<Long[]> PTMPatterns = new ArrayList();
    HashMap<String, Integer[]> PTMPatternNames = new HashMap();
    int longestPTMpattern = 0;
    int[][][] allPermutations = new int[][][]{new int[][]{{-1}}, new int[][]{{0}}, new int[][]{{0, 1}, {1, 0}}, new int[][]{{0, 1, 2}, {0, 2, 1}, {1, 0, 2}, {1, 2, 0}, {2, 0, 1}, {2, 1, 0}}, new int[][]{{0, 1, 2, 3}, {0, 1, 3, 2}, {0, 2, 1, 3}, {0, 2, 3, 1}, {0, 3, 1, 2}, {0, 3, 2, 1}, {1, 0, 2, 3}, {1, 0, 3, 2}, {1, 2, 0, 3}, {1, 2, 3, 0}, {1, 3, 0, 2}, {1, 3, 2, 0}, {2, 0, 1, 3}, {2, 0, 3, 1}, {2, 1, 0, 3}, {2, 1, 3, 0}, {2, 3, 0, 1}, {2, 3, 1, 0}, {3, 0, 1, 2}, {3, 0, 2, 1}, {3, 1, 0, 2}, {3, 1, 2, 0}, {3, 2, 0, 1}, {3, 2, 1, 0}}};
    ArrayList<MassIndexMap> massIndexMaps = null;
    private HashMap<String, CacheElement>[] cache = null;

    private static int binarySearch(int[] array, int key) {
        int low = 0;
        int mid = 0;
        int high = array.length - 1;
        while (low <= high) {
            mid = low + high >> 1;
            if (array[mid] <= key) {
                low = mid + 1;
                continue;
            }
            high = mid - 1;
        }
        if (mid > 0 && key < array[mid]) {
            --mid;
        }
        return mid;
    }

    public double computeMassValue(double currentMass, double refMass) {
        if (this.massAccuracyType == SearchParameters.MassAccuracyType.DA) {
            return currentMass;
        }
        return Math.abs(currentMass - refMass) / refMass * 1000000.0;
    }

    public double computeInverseMassValue(double currentMass, double refMass) {
        if (this.massAccuracyType == SearchParameters.MassAccuracyType.DA) {
            return currentMass;
        }
        return currentMass / 1000000.0 * refMass;
    }

    public void addPTMPattern(PTM ptm) {
        AminoAcidPattern aap = ptm.getPattern();
        HashMap<Integer, ArrayList<Character>> aaTargered = aap.getAaTargeted();
        Set<Integer> keySet = aaTargered.keySet();
        int startPos = Collections.min(keySet);
        int endPos = Collections.max(keySet);
        int patternLength = endPos - startPos + 1;
        if (patternLength > 62) {
            throw new UnsupportedOperationException("Pattern contains more than 64 sites, not supported");
        }
        long preMask = (1 << patternLength) - 1;
        for (int key : keySet) {
            preMask &= 1L << key - startPos ^ 0xFFFFFFFFFFFFFFFFL;
        }
        Long[] masks = new Long[128];
        for (int i = 0; i < 128; ++i) {
            masks[i] = preMask;
        }
        for (int key : keySet) {
            for (char c : aaTargered.get(key)) {
                Long[] longArray = masks;
                char c2 = c;
                Long.valueOf(longArray[c2] | 1L << key - startPos);
            }
        }
        this.PTMPatternNames.put(ptm.getName(), new Integer[]{this.PTMPatterns.size(), startPos, patternLength});
        this.PTMPatterns.add(masks);
        this.longestPTMpattern = Math.max(this.longestPTMpattern, patternLength);
    }

    public boolean checkPTMPattern(PeptideProteinMapping peptideProteinMapping) {
        if (this.PTMPatterns.isEmpty()) {
            return true;
        }
        String searchText = peptideProteinMapping.getPeptideSequence();
        for (ModificationMatch modificationMatch : peptideProteinMapping.getModificationMatches()) {
            if (!this.PTMPatternNames.containsKey(modificationMatch.getTheoreticPtm())) continue;
            Integer[] PTMPatternData = this.PTMPatternNames.get(modificationMatch.getTheoreticPtm());
            Long[] masks = this.PTMPatterns.get(PTMPatternData[0]);
            int textPos = modificationMatch.getModificationSite() - 1;
            if (textPos + PTMPatternData[1] < 0) {
                return false;
            }
            if (textPos + PTMPatternData[1] + PTMPatternData[2] > searchText.length()) {
                return false;
            }
            long pattern = 1L;
            int i = textPos + PTMPatternData[1];
            for (int j = 0; j < PTMPatternData[2] && pattern != 0L; ++j) {
                pattern = (pattern & masks[searchText.charAt(i)]) << 1;
                ++i;
            }
            return (1L << PTMPatternData[2] & pattern) > 0L;
        }
        return true;
    }

    public int[] computeMappingRanges(double mass) {
        int[] ranges = new int[]{0, -1};
        int low = 0;
        int mid = 0;
        int high = this.massIndexMaps.size() - 1;
        while (low <= high) {
            mid = low + high >> 1;
            if (this.massIndexMaps.get((int)mid).mass <= mass - this.computeInverseMassValue(this.massTolerance, this.massIndexMaps.get((int)mid).mass)) {
                low = mid + 1;
                continue;
            }
            high = mid - 1;
        }
        ranges[0] = Math.max(mid, 0);
        while (ranges[0] < this.massIndexMaps.size() - 1 && this.massIndexMaps.get((int)ranges[0]).mass < mass - this.computeInverseMassValue(this.massTolerance, this.massIndexMaps.get((int)ranges[0]).mass)) {
            ranges[0] = ranges[0] + 1;
        }
        if (this.massAccuracyType == SearchParameters.MassAccuracyType.DA && Math.abs(this.massIndexMaps.get((int)ranges[0]).mass - mass) > this.massTolerance) {
            return ranges;
        }
        if (this.massAccuracyType == SearchParameters.MassAccuracyType.PPM && this.computeMassValue(mass, this.massIndexMaps.get((int)ranges[0]).mass) > this.massTolerance) {
            return ranges;
        }
        low = ranges[0];
        high = this.massIndexMaps.size() - 1;
        while (low <= high) {
            mid = low + high >> 1;
            if (this.massIndexMaps.get((int)mid).mass < mass + this.computeInverseMassValue(this.massTolerance, this.massIndexMaps.get((int)mid).mass)) {
                low = mid + 1;
                continue;
            }
            high = mid - 1;
        }
        ranges[1] = Math.min(mid, this.massIndexMaps.size());
        while (0 < ranges[1] && this.massIndexMaps.get((int)ranges[1]).mass > mass + this.computeInverseMassValue(this.massTolerance, this.massIndexMaps.get((int)ranges[1]).mass)) {
            ranges[1] = ranges[1] - 1;
        }
        return ranges;
    }

    public long getAllocatedBytes() {
        long bytes = 0L;
        for (int indexPart = 0; indexPart < this.indexParts; ++indexPart) {
            bytes += (long)(this.occurrenceTablesPrimary.get(indexPart).getAllocatedBytes() + this.occurrenceTablesReversed.get(indexPart).getAllocatedBytes() + this.suffixArraysPrimary.get(indexPart).length * 4);
        }
        return bytes;
    }

    public FMIndex(WaitingHandler waitingHandler, boolean displayProgress, PeptideVariantsPreferences peptideVariantsPreferences, SearchParameters searchParameters) {
        this.massTolerance = searchParameters.getFragmentIonAccuracy();
        this.massAccuracyType = searchParameters.getFragmentAccuracyType();
        this.init(waitingHandler, displayProgress, searchParameters.getPtmSettings(), peptideVariantsPreferences);
    }

    public FMIndex(WaitingHandler waitingHandler, boolean displayProgress, PtmSettings ptmSettings, PeptideVariantsPreferences peptideVariantsPreferences) {
        this.init(waitingHandler, displayProgress, ptmSettings, peptideVariantsPreferences);
    }

    /*
     * WARNING - void declaration
     */
    private void init(WaitingHandler waitingHandler, boolean displayProgress, PtmSettings ptmSettings, PeptideVariantsPreferences peptideVariantsPreferences) {
        void var17_86;
        void var17_84;
        void var17_82;
        this.maxNumberVariants = peptideVariantsPreferences.getnVariants();
        this.genericVariantMatching = peptideVariantsPreferences.getUseSpecificCount() == false;
        this.maxNumberInsertions = peptideVariantsPreferences.getnAaInsertions();
        this.maxNumberDeletions = peptideVariantsPreferences.getnAaDeletions();
        this.maxNumberSubstitutions = peptideVariantsPreferences.getnAaSubstitutions();
        TreeSet<Character> aaGroups = new TreeSet<Character>();
        aaGroups.add(Character.valueOf('B'));
        aaGroups.add(Character.valueOf('J'));
        aaGroups.add(Character.valueOf('X'));
        aaGroups.add(Character.valueOf('Z'));
        this.substitutionMatrix = new boolean[128][128];
        for (int i3 = 0; i3 < 128; ++i3) {
            for (int j = 0; j < 128; ++j) {
                this.substitutionMatrix[i3][j] = false;
            }
        }
        AaSubstitutionMatrix aaSubstitutionMatrix = peptideVariantsPreferences.getAaSubstitutionMatrix();
        for (int aa = 65; aa <= 90; ++aa) {
            HashSet<Character> substitutions;
            if (!aaSubstitutionMatrix.getOriginalAminoAcids().contains(Character.valueOf((char)aa)) || (substitutions = aaSubstitutionMatrix.getSubstitutionAminoAcids(Character.valueOf((char)aa))).isEmpty()) continue;
            for (char subAA : substitutions) {
                this.substitutionMatrix[aa][subAA] = true;
            }
        }
        if (ptmSettings != null) {
            ArrayList<Character> targets;
            PTM ptm;
            int[] modificationCounts = new int[128];
            for (int i4 = 0; i4 < modificationCounts.length; ++i4) {
                modificationCounts[i4] = 0;
            }
            ArrayList<String> variableModifications = ptmSettings.getVariableModifications();
            ArrayList<String> fixedModifications = ptmSettings.getFixedModifications();
            PTMFactory ptmFactory = PTMFactory.getInstance();
            int hasVariableModification = 0;
            for (String modification : variableModifications) {
                PTM ptm2 = ptmFactory.getPTM(modification);
                switch (ptm2.getType()) {
                    case 0: {
                        if (ptm2.getPattern().length() > 1) {
                            this.addPTMPattern(ptm2);
                        }
                        ArrayList<Character> targets2 = ptm2.getPattern().getAminoAcidsAtTarget();
                        for (Character c : targets2) {
                            char c2 = c.charValue();
                            modificationCounts[c2] = modificationCounts[c2] + 1;
                            hasVariableModification = Math.max(hasVariableModification, modificationCounts[c.charValue()]);
                        }
                        this.withVariableModifications = true;
                        break;
                    }
                    case 3: {
                        if (this.vmodc == null) {
                            this.vmodc = new ArrayList();
                            this.vmodcMass = new ArrayList();
                            this.hasCTermDirectionPTM = true;
                            this.hasPTMatTerminus = true;
                        }
                        this.vmodc.add(modification);
                        this.vmodcMass.add(ptm2.getMass());
                        this.negativePTMMass = Math.min(this.negativePTMMass, ptm2.getMass());
                        break;
                    }
                    case 4: {
                        if (this.vmodcaa == null) {
                            this.vmodcaa = new ArrayList[128];
                            for (int i5 = 0; i5 < 128; ++i5) {
                                this.vmodcaa[i5] = new ArrayList();
                            }
                            this.vmodcaaMass = new ArrayList[128];
                            for (int i = 0; i < 128; ++i) {
                                this.vmodcaaMass[i] = new ArrayList();
                            }
                            this.hasCTermDirectionPTM = true;
                            this.hasPTMatTerminus = true;
                        }
                        if (ptm2.getPattern().length() > 1) {
                            this.addPTMPattern(ptm2);
                        }
                        ArrayList<Character> targets2 = ptm2.getPattern().getAminoAcidsAtTarget();
                        for (Character c : targets2) {
                            this.vmodcaa[c.charValue()].add(modification);
                            this.vmodcaaMass[c.charValue()].add(ptm2.getMass());
                        }
                        this.negativePTMMass = Math.min(this.negativePTMMass, ptm2.getMass());
                        break;
                    }
                    case 7: {
                        if (this.vmodcp == null) {
                            this.vmodcp = new ArrayList();
                            this.vmodcpMass = new ArrayList();
                            this.hasCTermDirectionPTM = true;
                        }
                        this.vmodcp.add(modification);
                        this.vmodcpMass.add(ptm2.getMass());
                        this.negativePTMMass = Math.min(this.negativePTMMass, ptm2.getMass());
                        break;
                    }
                    case 8: {
                        if (this.vmodcpaa == null) {
                            this.vmodcpaa = new ArrayList[128];
                            for (int i6 = 0; i6 < 128; ++i6) {
                                this.vmodcpaa[i6] = new ArrayList();
                            }
                            this.vmodcpaaMass = new ArrayList[128];
                            for (int i = 0; i < 128; ++i) {
                                this.vmodcpaaMass[i] = new ArrayList();
                            }
                            this.hasCTermDirectionPTM = true;
                        }
                        if (ptm2.getPattern().length() > 1) {
                            this.addPTMPattern(ptm2);
                        }
                        ArrayList<Character> targets2 = ptm2.getPattern().getAminoAcidsAtTarget();
                        for (Character c : targets2) {
                            this.vmodcpaa[c.charValue()].add(modification);
                            this.vmodcpaaMass[c.charValue()].add(ptm2.getMass());
                        }
                        this.negativePTMMass = Math.min(this.negativePTMMass, ptm2.getMass());
                        break;
                    }
                    case 1: {
                        if (this.vmodn == null) {
                            this.vmodn = new ArrayList();
                            this.vmodnMass = new ArrayList();
                            this.hasNTermDirectionPTM = true;
                            this.hasPTMatTerminus = true;
                        }
                        this.vmodn.add(modification);
                        this.vmodnMass.add(ptm2.getMass());
                        this.negativePTMMass = Math.min(this.negativePTMMass, ptm2.getMass());
                        break;
                    }
                    case 2: {
                        if (this.vmodnaa == null) {
                            this.vmodnaa = new ArrayList[128];
                            for (int i7 = 0; i7 < 128; ++i7) {
                                this.vmodnaa[i7] = new ArrayList();
                            }
                            this.vmodnaaMass = new ArrayList[128];
                            for (int i = 0; i < 128; ++i) {
                                this.vmodnaaMass[i] = new ArrayList();
                            }
                            this.hasNTermDirectionPTM = true;
                            this.hasPTMatTerminus = true;
                        }
                        if (ptm2.getPattern().length() > 1) {
                            this.addPTMPattern(ptm2);
                        }
                        ArrayList<Character> targets2 = ptm2.getPattern().getAminoAcidsAtTarget();
                        for (Character c : targets2) {
                            this.vmodnaa[c.charValue()].add(modification);
                            this.vmodnaaMass[c.charValue()].add(ptm2.getMass());
                        }
                        this.negativePTMMass = Math.min(this.negativePTMMass, ptm2.getMass());
                        break;
                    }
                    case 5: {
                        if (this.vmodnp == null) {
                            this.vmodnp = new ArrayList();
                            this.vmodnpMass = new ArrayList();
                            this.hasNTermDirectionPTM = true;
                        }
                        this.vmodnp.add(modification);
                        this.vmodnpMass.add(ptm2.getMass());
                        this.negativePTMMass = Math.min(this.negativePTMMass, ptm2.getMass());
                        break;
                    }
                    case 6: {
                        if (this.vmodnpaa == null) {
                            this.vmodnpaa = new ArrayList[128];
                            for (int i8 = 0; i8 < 128; ++i8) {
                                this.vmodnpaa[i8] = new ArrayList();
                            }
                            this.vmodnpaaMass = new ArrayList[128];
                            for (int i = 0; i < 128; ++i) {
                                this.vmodnpaaMass[i] = new ArrayList();
                            }
                            this.hasNTermDirectionPTM = true;
                        }
                        if (ptm2.getPattern().length() > 1) {
                            this.addPTMPattern(ptm2);
                        }
                        ArrayList<Character> targets2 = ptm2.getPattern().getAminoAcidsAtTarget();
                        for (Character c : targets2) {
                            this.vmodnpaa[c.charValue()].add(modification);
                            this.vmodnpaaMass[c.charValue()].add(ptm2.getMass());
                        }
                        this.negativePTMMass = Math.min(this.negativePTMMass, ptm2.getMass());
                    }
                }
            }
            this.aaMasses = new double[128 * (1 + hasVariableModification)];
            this.modifictationLabels = new String[128 * (1 + hasVariableModification)];
            this.modificationFlags = new boolean[128 * (1 + hasVariableModification)];
            for (int i9 = 0; i9 < this.aaMasses.length; ++i9) {
                this.aaMasses[i9] = -1.0;
                this.modifictationLabels[i9] = null;
                this.modificationFlags[i9] = false;
            }
            char[] aminoAcids = AminoAcid.getAminoAcids();
            for (int i10 = 0; i10 < aminoAcids.length; ++i10) {
                if (aaGroups.contains(Character.valueOf(aminoAcids[i10]))) continue;
                this.aaMasses[aminoAcids[i10]] = AminoAcid.getAminoAcid(aminoAcids[i10]).getMonoisotopicMass();
            }
            block47: for (String modification : fixedModifications) {
                ptm = ptmFactory.getPTM(modification);
                switch (ptm.getType()) {
                    case 0: {
                        if (ptm.getPattern().length() > 1) {
                            this.addPTMPattern(ptm);
                        }
                        targets = ptm.getPattern().getAminoAcidsAtTarget();
                        for (Character c : targets) {
                            char c3 = c.charValue();
                            this.aaMasses[c3] = this.aaMasses[c3] + ptm.getMass();
                            this.negativePTMMass = Math.min(this.negativePTMMass, ptm.getMass());
                            this.modifictationLabels[c.charValue()] = modification;
                            this.modificationFlags[c.charValue()] = true;
                        }
                        continue block47;
                    }
                    case 3: {
                        if (this.fmodc == null) {
                            this.fmodc = new ArrayList();
                            this.fmodcMass = new ArrayList();
                            this.hasCTermDirectionPTM = true;
                            this.hasPTMatTerminus = true;
                            this.hasFixedPTM_CatTerminus = true;
                        }
                        this.fmodc.add(modification);
                        this.fmodcMass.add(ptm.getMass());
                        this.negativePTMMass = Math.min(this.negativePTMMass, ptm.getMass());
                        break;
                    }
                    case 4: {
                        if (this.fmodcaa == null) {
                            void var17_58;
                            void var17_56;
                            this.fmodcaa = new ArrayList[128];
                            boolean bl = false;
                            while (var17_56 < 128) {
                                this.fmodcaa[var17_56] = new ArrayList();
                                ++var17_56;
                            }
                            this.fmodcaaMass = new ArrayList[128];
                            boolean bl2 = false;
                            while (var17_58 < 128) {
                                this.fmodcaaMass[var17_58] = new ArrayList();
                                ++var17_58;
                            }
                            this.hasCTermDirectionPTM = true;
                            this.hasPTMatTerminus = true;
                            this.hasFixedPTM_CatTerminus = true;
                        }
                        if (ptm.getPattern().length() > 1) {
                            this.addPTMPattern(ptm);
                        }
                        targets = ptm.getPattern().getAminoAcidsAtTarget();
                        for (Character c : targets) {
                            this.fmodcaa[c.charValue()].add(modification);
                            this.fmodcaaMass[c.charValue()].add(ptm.getMass());
                        }
                        this.negativePTMMass = Math.min(this.negativePTMMass, ptm.getMass());
                        break;
                    }
                    case 7: {
                        if (this.fmodcp == null) {
                            this.fmodcp = new ArrayList();
                            this.fmodcpMass = new ArrayList();
                            this.hasCTermDirectionPTM = true;
                        }
                        this.fmodcp.add(modification);
                        this.fmodcpMass.add(ptm.getMass());
                        this.negativePTMMass = Math.min(this.negativePTMMass, ptm.getMass());
                        break;
                    }
                    case 8: {
                        if (this.fmodcpaa == null) {
                            void var17_63;
                            void var17_61;
                            this.fmodcpaa = new ArrayList[128];
                            boolean bl = false;
                            while (var17_61 < 128) {
                                this.fmodcpaa[var17_61] = new ArrayList();
                                ++var17_61;
                            }
                            this.fmodcpaaMass = new ArrayList[128];
                            boolean bl3 = false;
                            while (var17_63 < 128) {
                                this.fmodcpaaMass[var17_63] = new ArrayList();
                                ++var17_63;
                            }
                            this.hasCTermDirectionPTM = true;
                        }
                        if (ptm.getPattern().length() > 1) {
                            this.addPTMPattern(ptm);
                        }
                        targets = ptm.getPattern().getAminoAcidsAtTarget();
                        for (Character c : targets) {
                            this.fmodcpaa[c.charValue()].add(modification);
                            this.fmodcpaaMass[c.charValue()].add(ptm.getMass());
                        }
                        this.negativePTMMass = Math.min(this.negativePTMMass, ptm.getMass());
                        break;
                    }
                    case 1: {
                        if (this.fmodn == null) {
                            this.fmodn = new ArrayList();
                            this.fmodnMass = new ArrayList();
                            this.hasNTermDirectionPTM = true;
                            this.hasPTMatTerminus = true;
                            this.hasFixedPTM_NatTerminus = true;
                        }
                        this.fmodn.add(modification);
                        this.fmodnMass.add(ptm.getMass());
                        this.negativePTMMass = Math.min(this.negativePTMMass, ptm.getMass());
                        break;
                    }
                    case 2: {
                        if (this.fmodnaa == null) {
                            void var17_68;
                            void var17_66;
                            this.fmodnaa = new ArrayList[128];
                            boolean bl = false;
                            while (var17_66 < 128) {
                                this.fmodnaa[var17_66] = new ArrayList();
                                ++var17_66;
                            }
                            this.fmodnaaMass = new ArrayList[128];
                            boolean bl4 = false;
                            while (var17_68 < 128) {
                                this.fmodnaaMass[var17_68] = new ArrayList();
                                ++var17_68;
                            }
                            this.hasNTermDirectionPTM = true;
                            this.hasPTMatTerminus = true;
                            this.hasFixedPTM_NatTerminus = true;
                        }
                        if (ptm.getPattern().length() > 1) {
                            this.addPTMPattern(ptm);
                        }
                        targets = ptm.getPattern().getAminoAcidsAtTarget();
                        for (Character c : targets) {
                            this.fmodnaa[c.charValue()].add(modification);
                            this.fmodnaaMass[c.charValue()].add(ptm.getMass());
                        }
                        this.negativePTMMass = Math.min(this.negativePTMMass, ptm.getMass());
                        break;
                    }
                    case 5: {
                        if (this.fmodnp == null) {
                            this.fmodnp = new ArrayList();
                            this.fmodnpMass = new ArrayList();
                            this.hasNTermDirectionPTM = true;
                        }
                        this.fmodnp.add(modification);
                        this.fmodnpMass.add(ptm.getMass());
                        this.negativePTMMass = Math.min(this.negativePTMMass, ptm.getMass());
                        break;
                    }
                    case 6: {
                        if (this.fmodnpaa == null) {
                            void var17_73;
                            void var17_71;
                            this.fmodnpaa = new ArrayList[128];
                            boolean bl = false;
                            while (var17_71 < 128) {
                                this.fmodnpaa[var17_71] = new ArrayList();
                                ++var17_71;
                            }
                            this.fmodnpaaMass = new ArrayList[128];
                            boolean bl5 = false;
                            while (var17_73 < 128) {
                                this.fmodnpaaMass[var17_73] = new ArrayList();
                                ++var17_73;
                            }
                            this.hasNTermDirectionPTM = true;
                        }
                        if (ptm.getPattern().length() > 1) {
                            this.addPTMPattern(ptm);
                        }
                        targets = ptm.getPattern().getAminoAcidsAtTarget();
                        for (Character c : targets) {
                            this.fmodnpaa[c.charValue()].add(modification);
                            this.fmodnpaaMass[c.charValue()].add(ptm.getMass());
                        }
                        this.negativePTMMass = Math.min(this.negativePTMMass, ptm.getMass());
                    }
                }
            }
            for (int i15 = 0; i15 < modificationCounts.length; ++i15) {
                modificationCounts[i15] = 0;
            }
            for (String modification : variableModifications) {
                ptm = ptmFactory.getPTM(modification);
                if (ptm.getType() != 0) continue;
                targets = ptm.getPattern().getAminoAcidsAtTarget();
                for (Character c : targets) {
                    this.aaMasses[128 * (1 + modificationCounts[c.charValue()]) + c.charValue()] = this.aaMasses[c.charValue()] + ptm.getMass();
                    this.modifictationLabels[128 * (1 + modificationCounts[c.charValue()]) + c.charValue()] = modification;
                    this.modificationFlags[128 * (1 + modificationCounts[c.charValue()]) + c.charValue()] = true;
                    char c4 = c.charValue();
                    modificationCounts[c4] = modificationCounts[c4] + 1;
                }
            }
        } else {
            this.aaMasses = new double[128];
            for (int i16 = 0; i16 < this.aaMasses.length; ++i16) {
                this.aaMasses[i16] = -1.0;
            }
            char[] aminoAcids = AminoAcid.getAminoAcids();
            for (int i17 = 0; i17 < aminoAcids.length; ++i17) {
                if (aaGroups.contains(Character.valueOf(aminoAcids[i17]))) continue;
                this.aaMasses[aminoAcids[i17]] = AminoAcid.getAminoAcid(aminoAcids[i17]).getMonoisotopicMass();
            }
        }
        ArrayList<Integer> aaMassVector = new ArrayList<Integer>();
        for (int i2 = 0; i2 < this.aaMasses.length; ++i2) {
            if (!(this.aaMasses[i2] > 0.0)) continue;
            aaMassVector.add(i2);
        }
        this.aaMassIndexes = new int[aaMassVector.size()];
        for (int i = 0; i < aaMassVector.size(); ++i) {
            this.aaMassIndexes[i] = (Integer)aaMassVector.get(i);
        }
        this.numMasses = aaMassVector.size() + 1;
        SequenceFactory sf = SequenceFactory.getInstance();
        char[] sortedAas = new char[AminoAcid.getAminoAcids().length + 2];
        System.arraycopy(AminoAcid.getAminoAcids(), 0, sortedAas, 0, AminoAcid.getAminoAcids().length);
        sortedAas[AminoAcid.getAminoAcids().length] = 36;
        sortedAas[AminoAcid.getAminoAcids().length + 1] = 47;
        Arrays.sort(sortedAas);
        long[] alphabet = new long[]{0L, 0L};
        for (int i18 = 0; i18 < sortedAas.length; ++i18) {
            int n = sortedAas[i18] >> 6;
            alphabet[n] = alphabet[n] | 1L << (sortedAas[i18] & 0x3F);
        }
        ArrayList<Integer> tmpLengths = new ArrayList<Integer>();
        ArrayList<Integer> tmpProteins = new ArrayList<Integer>();
        long ticker = 0x6400000L;
        try {
            int indexStringLength = 1;
            int numProteins = 0;
            SequenceFactory.ProteinIterator proteinIterator = sf.getProteinIterator(false);
            while (proteinIterator.hasNext()) {
                if (waitingHandler != null && waitingHandler.isRunCanceled()) {
                    return;
                }
                Protein currentProtein = proteinIterator.getNextProtein();
                int proteinLen = currentProtein.getLength();
                ++numProteins;
                if ((long)(indexStringLength += proteinLen) <= ticker) continue;
                tmpLengths.add(indexStringLength);
                tmpProteins.add(numProteins);
                indexStringLength = 1;
                numProteins = 0;
            }
            tmpLengths.add(indexStringLength);
            tmpProteins.add(numProteins);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
        int maxProgressBar = 10 * tmpLengths.size();
        if (waitingHandler != null && displayProgress && !waitingHandler.isRunCanceled()) {
            waitingHandler.setSecondaryProgressCounterIndeterminate(false);
            waitingHandler.setMaxSecondaryProgressCounter(maxProgressBar);
            waitingHandler.setSecondaryProgressCounter(0);
        }
        try {
            void var17_80;
            SequenceFactory.ProteinIterator pi = sf.getProteinIterator(false);
            boolean bl = false;
            while (var17_80 < tmpLengths.size()) {
                this.addDataToIndex(pi, (Integer)tmpLengths.get((int)var17_80), (Integer)tmpProteins.get((int)var17_80), alphabet, waitingHandler, displayProgress);
                ++var17_80;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int lookupLength = (int)((this.lookupMaxMass + this.computeInverseMassValue(this.massTolerance, this.lookupMaxMass)) * this.lookupMultiplier);
        this.lookupMasses = new long[(lookupLength >>> 6) + 3];
        boolean bl = false;
        while (var17_82 < this.lookupMasses.length) {
            this.lookupMasses[var17_82] = 0L;
            ++var17_82;
        }
        this.Xlookup = new long[this.maxXPerTag + 1][];
        boolean bl6 = true;
        while (var17_84 <= this.maxXPerTag) {
            this.Xlookup[var17_84] = new long[(lookupLength >>> 6) + 3];
            for (int j = 0; j < this.Xlookup[var17_84].length; ++j) {
                this.Xlookup[var17_84][j] = 0L;
            }
            ++var17_84;
        }
        this.massIndexMaps = new ArrayList(1000000);
        this.recursiveMassFilling(0.0, 0, 0, null);
        Collections.sort(this.massIndexMaps, new Comparator<MassIndexMap>(){

            @Override
            public int compare(MassIndexMap m1, MassIndexMap m2) {
                return (int)((m1.mass - m2.mass) * 1000000.0);
            }
        });
        this.cache = new HashMap[this.indexParts];
        boolean bl7 = false;
        while (var17_86 < this.indexParts) {
            this.cache[var17_86] = new HashMap();
            ++var17_86;
        }
    }

    void addDataToIndex(SequenceFactory.ProteinIterator pi, int indexStringLength, int numProteins, long[] alphabet, WaitingHandler waitingHandler, boolean displayProgress) {
        int i;
        ++this.indexParts;
        this.indexStringLengths.add(indexStringLength += numProteins + 1);
        if (displayProgress && waitingHandler != null && !waitingHandler.isRunCanceled()) {
            waitingHandler.increaseSecondaryProgressCounter();
        }
        byte[] T = new byte[indexStringLength];
        T[0] = 47;
        T[indexStringLength - 2] = 47;
        T[indexStringLength - 1] = 36;
        int[] bndaries = new int[numProteins + 1];
        this.boundaries.add(bndaries);
        String[] accssions = new String[numProteins];
        this.accessions.add(accssions);
        this.boundaries.get((int)0)[0] = 1;
        int tmpN = 0;
        int tmpNumProtein = 0;
        try {
            for (int i2 = 0; i2 < numProteins; ++i2) {
                if (waitingHandler != null && waitingHandler.isRunCanceled()) {
                    return;
                }
                if (!pi.hasNext()) {
                    throw new Exception("More sequences from database requested than contained.");
                }
                Protein currentProtein = pi.getNextProtein();
                int proteinLen = currentProtein.getLength();
                T[tmpN++] = 47;
                System.arraycopy(currentProtein.getSequence().toUpperCase().getBytes(), 0, T, tmpN, proteinLen);
                accssions[tmpNumProtein++] = currentProtein.getAccession();
                bndaries[tmpNumProtein] = (tmpN += proteinLen) + 1;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (displayProgress && waitingHandler != null && !waitingHandler.isRunCanceled()) {
            waitingHandler.increaseSecondaryProgressCounter();
        }
        int[] T_int = new int[indexStringLength];
        for (int i3 = 0; i3 < indexStringLength; ++i3) {
            T_int[i3] = T[i3];
        }
        int[] suffixArrayPrimary = new DivSufSort().buildSuffixArray(T_int, 0, indexStringLength);
        if (displayProgress && waitingHandler != null && !waitingHandler.isRunCanceled()) {
            waitingHandler.increaseSecondaryProgressCounter();
        }
        T_int = null;
        byte[] bwt = new byte[indexStringLength];
        for (int i4 = 0; i4 < indexStringLength; ++i4) {
            bwt[i4] = suffixArrayPrimary[i4] != 0 ? T[suffixArrayPrimary[i4] - 1] : T[indexStringLength - 1];
        }
        if (displayProgress && waitingHandler != null && !waitingHandler.isRunCanceled()) {
            waitingHandler.increaseSecondaryProgressCounter();
        }
        int[] sampledSuffixArray = new int[(indexStringLength + 1 >> 3) + 1];
        int sampledIndex = 0;
        for (int i5 = 0; i5 < indexStringLength; i5 += 8) {
            if (waitingHandler != null && waitingHandler.isRunCanceled()) {
                return;
            }
            sampledSuffixArray[sampledIndex++] = suffixArrayPrimary[i5];
        }
        this.suffixArraysPrimary.add(sampledSuffixArray);
        if (displayProgress && waitingHandler != null && !waitingHandler.isRunCanceled()) {
            waitingHandler.increaseSecondaryProgressCounter();
        }
        WaveletTree occurrenceTablePrimary = new WaveletTree(bwt, alphabet, waitingHandler, this.numMasses, this.hasPTMatTerminus);
        int[] lessTablePrimary = occurrenceTablePrimary.createLessTable();
        if (displayProgress && waitingHandler != null && !waitingHandler.isRunCanceled()) {
            waitingHandler.increaseSecondaryProgressCounter();
        }
        bwt = null;
        byte[] TReversed = new byte[indexStringLength];
        for (i = 0; i < indexStringLength - 1; ++i) {
            TReversed[indexStringLength - 2 - i] = T[i];
        }
        TReversed[indexStringLength - 1] = 36;
        if (displayProgress && waitingHandler != null && !waitingHandler.isRunCanceled()) {
            waitingHandler.increaseSecondaryProgressCounter();
        }
        T_int = new int[indexStringLength];
        for (i = 0; i < indexStringLength; ++i) {
            T_int[i] = TReversed[i];
        }
        int[] suffixArrayReversed = new DivSufSort().buildSuffixArray(T_int, 0, indexStringLength);
        if (displayProgress && waitingHandler != null && !waitingHandler.isRunCanceled()) {
            waitingHandler.increaseSecondaryProgressCounter();
        }
        bwt = new byte[indexStringLength];
        for (int i6 = 0; i6 < indexStringLength; ++i6) {
            bwt[i6] = suffixArrayReversed[i6] != 0 ? TReversed[suffixArrayReversed[i6] - 1] : TReversed[indexStringLength - 1];
        }
        if (displayProgress && waitingHandler != null && !waitingHandler.isRunCanceled()) {
            waitingHandler.increaseSecondaryProgressCounter();
        }
        WaveletTree occurrenceTableReversed = new WaveletTree(bwt, alphabet, waitingHandler, this.numMasses, this.hasPTMatTerminus);
        int[] lessTableReversed = occurrenceTableReversed.createLessTable();
        if (displayProgress && waitingHandler != null && !waitingHandler.isRunCanceled()) {
            waitingHandler.increaseSecondaryProgressCounter();
        }
        this.occurrenceTablesPrimary.add(occurrenceTablePrimary);
        this.occurrenceTablesReversed.add(occurrenceTableReversed);
        this.lessTablesPrimary.add(lessTablePrimary);
        this.lessTablesReversed.add(lessTableReversed);
    }

    void recursiveMassFilling(double mass, int pos, int loop, int[] massIndexes) {
        if (mass >= this.lookupMaxMass) {
            return;
        }
        double transformedMass = this.computeInverseMassValue(this.massTolerance, mass);
        if (mass > transformedMass) {
            int p;
            int startMass = (int)((mass - transformedMass) * this.lookupMultiplier);
            int endMass = (int)((mass + transformedMass) * this.lookupMultiplier + 1.0);
            int n = startMass >>> 6;
            this.lookupMasses[n] = this.lookupMasses[n] | -1L << (startMass & 0x3F);
            for (p = (startMass >>> 6) + 1; p < endMass >>> 6; ++p) {
                this.lookupMasses[p] = -1L;
            }
            int n2 = endMass >>> 6;
            this.lookupMasses[n2] = this.lookupMasses[n2] | -1L >>> 64 - (endMass & 0x3F);
            if (loop <= this.maxXPerTag) {
                long[] lArray = this.Xlookup[loop];
                int n3 = startMass >>> 6;
                lArray[n3] = lArray[n3] | -1L << (startMass & 0x3F);
                for (p = (startMass >>> 6) + 1; p < endMass >>> 6; ++p) {
                    this.Xlookup[loop][p] = -1L;
                }
                long[] lArray2 = this.Xlookup[loop];
                int n4 = endMass >>> 6;
                lArray2[n4] = lArray2[n4] | -1L >>> 64 - (endMass & 0x3F);
                this.massIndexMaps.add(new MassIndexMap(mass, massIndexes));
            }
        }
        for (int i = pos; i < this.aaMassIndexes.length; ++i) {
            int[] massIndexesNew = new int[massIndexes != null ? massIndexes.length + 1 : 1];
            if (massIndexes != null) {
                for (int j = 0; j < massIndexes.length; ++j) {
                    massIndexesNew[j] = massIndexes[j];
                }
            }
            massIndexesNew[massIndexesNew.length - 1] = this.aaMassIndexes[i];
            this.recursiveMassFilling(mass + this.aaMasses[this.aaMassIndexes[i]], i, loop + 1, massIndexesNew);
        }
    }

    private ArrayList<String> createPeptideCombinations(String peptide, SequenceMatchingPreferences seqMatchPref) {
        ArrayList<String> combinations;
        block11: {
            SequenceMatchingPreferences.MatchingType sequenceMatchingType;
            block10: {
                combinations = new ArrayList<String>();
                sequenceMatchingType = seqMatchPref.getSequenceMatchingType();
                if (sequenceMatchingType != SequenceMatchingPreferences.MatchingType.string) break block10;
                for (int i = 0; i < peptide.length(); ++i) {
                    combinations.add(peptide.substring(i, i + 1));
                }
                break block11;
            }
            if (sequenceMatchingType != SequenceMatchingPreferences.MatchingType.aminoAcid && sequenceMatchingType != SequenceMatchingPreferences.MatchingType.indistiguishableAminoAcids) break block11;
            boolean indistinghuishable = sequenceMatchingType == SequenceMatchingPreferences.MatchingType.indistiguishableAminoAcids;
            for (int i = 0; i < peptide.length(); ++i) {
                int j;
                String chars = peptide.substring(i, i + 1);
                char[] aaCombinations = AminoAcid.getAminoAcid(peptide.charAt(i)).getCombinations();
                for (j = 0; j < aaCombinations.length; ++j) {
                    chars = chars + aaCombinations[j];
                }
                if (peptide.charAt(i) == 'B' || peptide.charAt(i) == 'J' || peptide.charAt(i) == 'Z') {
                    aaCombinations = AminoAcid.getAminoAcid(peptide.charAt(i)).getSubAminoAcids(false);
                    for (j = 0; j < aaCombinations.length; ++j) {
                        chars = chars + aaCombinations[j];
                    }
                }
                if (indistinghuishable && (peptide.charAt(i) == 'I' || peptide.charAt(i) == 'L')) {
                    switch (peptide.charAt(i)) {
                        case 'I': {
                            chars = chars + "L";
                            break;
                        }
                        case 'L': {
                            chars = chars + "I";
                        }
                    }
                }
                combinations.add(chars);
            }
        }
        return combinations;
    }

    private TagElement[] createPeptideCombinations(TagElement[] tagComponents, SequenceMatchingPreferences seqMatchPref) {
        TagElement[] combinations;
        block17: {
            SequenceMatchingPreferences.MatchingType sequenceMatchingType;
            block16: {
                int numElements = 0;
                for (int i = 0; i < tagComponents.length; ++i) {
                    if (tagComponents[i].isMass) {
                        ++numElements;
                        continue;
                    }
                    numElements += tagComponents[i].sequence.length();
                }
                combinations = new TagElement[numElements];
                int combinationPosition = 0;
                sequenceMatchingType = seqMatchPref.getSequenceMatchingType();
                if (sequenceMatchingType != SequenceMatchingPreferences.MatchingType.string) break block16;
                for (TagElement tagElement : tagComponents) {
                    if (tagElement.isMass) {
                        combinations[combinationPosition++] = new TagElement(true, "", tagElement.mass, tagElement.xNumLimit);
                        continue;
                    }
                    for (int j = 0; j < tagElement.sequence.length(); ++j) {
                        combinations[combinationPosition++] = new TagElement(false, tagElement.sequence.substring(j, j + 1), tagElement.mass, tagElement.xNumLimit);
                    }
                }
                break block17;
            }
            if (sequenceMatchingType != SequenceMatchingPreferences.MatchingType.aminoAcid && sequenceMatchingType != SequenceMatchingPreferences.MatchingType.indistiguishableAminoAcids) break block17;
            boolean indistinghuishable = sequenceMatchingType == SequenceMatchingPreferences.MatchingType.indistiguishableAminoAcids;
            for (TagElement tagElement : tagComponents) {
                if (!tagElement.isMass) {
                    String subSequence = tagElement.sequence;
                    for (int s = 0; s < subSequence.length(); ++s) {
                        int j;
                        char amino = subSequence.charAt(s);
                        String chars = String.valueOf(amino);
                        char[] aaCombinations = AminoAcid.getAminoAcid(amino).getCombinations();
                        for (j = 0; j < aaCombinations.length; ++j) {
                            chars = chars + aaCombinations[j];
                        }
                        if (amino == 'B' || amino == 'J' || amino == 'Z') {
                            aaCombinations = AminoAcid.getAminoAcid(amino).getSubAminoAcids(false);
                            for (j = 0; j < aaCombinations.length; ++j) {
                                chars = chars + aaCombinations[j];
                            }
                        }
                        if (indistinghuishable && (amino == 'I' || amino == 'L')) {
                            switch (amino) {
                                case 'I': {
                                    chars = chars + "L";
                                    break;
                                }
                                case 'L': {
                                    chars = chars + "I";
                                }
                            }
                        }
                        combinations[combinationPosition++] = new TagElement(false, chars, tagElement.mass, tagElement.xNumLimit);
                    }
                    continue;
                }
                combinations[combinationPosition++] = new TagElement(true, "", tagElement.mass, tagElement.xNumLimit);
            }
        }
        return combinations;
    }

    private int getTextPosition(int index, int indexPart) {
        int[] suffixArrayPrimary = this.suffixArraysPrimary.get(indexPart);
        int[] lessTablePrimary = this.lessTablesPrimary.get(indexPart);
        WaveletTree occurrenceTablePrimary = this.occurrenceTablesPrimary.get(indexPart);
        int indexStringLength = this.indexStringLengths.get(indexPart);
        int numIterations = 0;
        while ((index & 7) != 0 && index != 0) {
            int[] aminoInfo = occurrenceTablePrimary.getCharacterInfo(index);
            index = lessTablePrimary[aminoInfo[0]] + aminoInfo[1];
            ++numIterations;
        }
        int pos = suffixArrayPrimary[index >> 3] + numIterations;
        return pos < indexStringLength ? pos : pos - indexStringLength;
    }

    @Override
    public ArrayList<PeptideProteinMapping> getProteinMapping(String peptide, SequenceMatchingPreferences seqMatchPref) {
        ArrayList<PeptideProteinMapping> peptideProteinMapping = new ArrayList<PeptideProteinMapping>();
        if (this.maxNumberVariants > 0 || this.maxNumberDeletions > 0 || this.maxNumberInsertions > 0 || this.maxNumberSubstitutions > 0) {
            if (this.genericVariantMatching) {
                for (int i = 0; i < this.indexParts; ++i) {
                    peptideProteinMapping.addAll(this.getProteinMappingWithVariantsGeneric(peptide, seqMatchPref, i));
                }
                return peptideProteinMapping;
            }
            for (int i = 0; i < this.indexParts; ++i) {
                peptideProteinMapping.addAll(this.getProteinMappingWithVariantsSpecific(peptide, seqMatchPref, i));
            }
            return peptideProteinMapping;
        }
        for (int i = 0; i < this.indexParts; ++i) {
            peptideProteinMapping.addAll(this.getProteinMappingWithoutVariants(peptide, seqMatchPref, i));
        }
        return peptideProteinMapping;
    }

    public ArrayList<PeptideProteinMapping> getProteinMappingWithoutVariants(String peptide, SequenceMatchingPreferences seqMatchPref, int indexPart) {
        int[] lessTablePrimary = this.lessTablesPrimary.get(indexPart);
        WaveletTree occurrenceTablePrimary = this.occurrenceTablesPrimary.get(indexPart);
        ArrayList<PeptideProteinMapping> allMatches = new ArrayList<PeptideProteinMapping>();
        String pep_rev = new StringBuilder(peptide).reverse().toString();
        int lenPeptide = peptide.length();
        ArrayList<String> combinations = this.createPeptideCombinations(pep_rev, seqMatchPref);
        int maxX = (int)((seqMatchPref.getLimitX() != null ? seqMatchPref.getLimitX() : 1.0) * (double)lenPeptide);
        ArrayList[] backwardList = new ArrayList[lenPeptide + 1];
        int countX = 0;
        for (int i = 0; i <= lenPeptide; ++i) {
            backwardList[i] = new ArrayList(10);
            if (i >= lenPeptide || pep_rev.charAt(i) != 'X') continue;
            ++countX;
        }
        if (countX <= maxX) {
            backwardList[0].add(new MatrixContent(this.indexStringLengths.get(indexPart) - 1));
            for (int j = 0; j < lenPeptide; ++j) {
                String combinationSequence = combinations.get(j);
                ArrayList cell = backwardList[j];
                for (MatrixContent content : cell) {
                    int leftIndexOld = content.left;
                    int rightIndexOld = content.right;
                    int numX = content.numX;
                    for (int c = 0; c < combinationSequence.length(); ++c) {
                        int newNumX;
                        int rightIndex;
                        int[] range;
                        char aminoAcid = combinationSequence.charAt(c);
                        int lessValue = lessTablePrimary[aminoAcid];
                        int leftIndex = lessValue + (range = occurrenceTablePrimary.singleRangeQuery(leftIndexOld - 1, rightIndexOld, aminoAcid))[0];
                        if (leftIndex > (rightIndex = lessValue + range[1] - 1) || (newNumX = numX + (aminoAcid == 'X' ? 1 : 0)) > maxX) continue;
                        backwardList[j + 1].add(new MatrixContent(leftIndex, rightIndex, aminoAcid, content, newNumX));
                    }
                }
            }
            Iterator iterator = backwardList[lenPeptide].iterator();
            while (iterator.hasNext()) {
                MatrixContent content;
                MatrixContent currentContent = content = (MatrixContent)iterator.next();
                String currentPeptide = "";
                while (currentContent.previousContent != null) {
                    currentPeptide = currentPeptide + (char)currentContent.character;
                    currentContent = currentContent.previousContent;
                }
                int leftIndex = content.left;
                int rightIndex = content.right;
                for (int j = leftIndex; j <= rightIndex; ++j) {
                    int pos = this.getTextPosition(j, indexPart);
                    int index = FMIndex.binarySearch(this.boundaries.get(indexPart), pos);
                    String accession = this.accessions.get(indexPart)[index];
                    PeptideProteinMapping peptideProteinMapping = new PeptideProteinMapping(accession, currentPeptide, pos - this.boundaries.get(indexPart)[index]);
                    allMatches.add(peptideProteinMapping);
                }
            }
        }
        return allMatches;
    }

    public ArrayList<PeptideProteinMapping> getProteinMappingWithVariantsGeneric(String peptide, SequenceMatchingPreferences seqMatchPref, int indexPart) {
        int j;
        int[] lessTablePrimary = this.lessTablesPrimary.get(indexPart);
        WaveletTree occurrenceTablePrimary = this.occurrenceTablesPrimary.get(indexPart);
        ArrayList<PeptideProteinMapping> allMatches = new ArrayList<PeptideProteinMapping>();
        String pep_rev = new StringBuilder(peptide).reverse().toString();
        int lenPeptide = peptide.length();
        ArrayList<String> combinations = this.createPeptideCombinations(pep_rev, seqMatchPref);
        int xNumLimit = (int)((seqMatchPref.getLimitX() != null ? seqMatchPref.getLimitX() : 1.0) * (double)lenPeptide);
        ArrayList[][] backwardMatrix = new ArrayList[this.maxNumberVariants + 1][lenPeptide + 1];
        for (int k = 0; k <= this.maxNumberVariants; ++k) {
            for (j = 0; j <= lenPeptide; ++j) {
                backwardMatrix[k][j] = new ArrayList(10);
            }
        }
        int countX = 0;
        for (j = 0; j <= lenPeptide; ++j) {
            if (j >= lenPeptide || pep_rev.charAt(j) != 'X') continue;
            ++countX;
        }
        if (countX <= xNumLimit) {
            backwardMatrix[0][0].add(new MatrixContent(this.indexStringLengths.get(indexPart) - 1));
            for (int k = 0; k <= this.maxNumberVariants; ++k) {
                ArrayList[] backwardList = backwardMatrix[k];
                for (int j2 = 0; j2 < lenPeptide; ++j2) {
                    String combinationSequence = combinations.get(j2);
                    ArrayList cell = backwardList[j2];
                    for (int i = 0; i < cell.size(); ++i) {
                        MatrixContent content = (MatrixContent)cell.get(i);
                        int leftIndexOld = content.left;
                        int rightIndexOld = content.right;
                        int numX = content.numX;
                        int numVariants = content.numVariants;
                        int length = content.length;
                        for (int c = 0; c < combinationSequence.length(); ++c) {
                            char aminoAcid = combinationSequence.charAt(c);
                            int lessValue = lessTablePrimary[aminoAcid];
                            int[] range = occurrenceTablePrimary.singleRangeQuery(leftIndexOld - 1, rightIndexOld, aminoAcid);
                            int leftIndex = lessValue + range[0];
                            int rightIndex = lessValue + range[1] - 1;
                            int newNumX = numX + (aminoAcid == 'X' ? 1 : 0);
                            if (leftIndex <= rightIndex) {
                                if (newNumX > xNumLimit) continue;
                                backwardList[j2 + 1].add(new MatrixContent(leftIndex, rightIndex, (int)aminoAcid, content, newNumX, length + 1, numVariants, '-'));
                            }
                            if (numVariants >= this.maxNumberVariants || c != 0) continue;
                            if (numVariants < this.maxNumberVariants) {
                                backwardMatrix[k + 1][j2 + 1].add(new MatrixContent(leftIndexOld, rightIndexOld, (int)aminoAcid, content, newNumX, length + 1, numVariants + 1, '*'));
                            }
                            int[][] setCharacter = occurrenceTablePrimary.rangeQuery(leftIndexOld - 1, rightIndexOld);
                            for (int b = 0; b < setCharacter[this.numMasses][0]; ++b) {
                                int[] borders = setCharacter[b];
                                int errorAminoAcid = borders[0];
                                int errorNewNumX = newNumX + (errorAminoAcid == 88 ? 1 : 0);
                                int errorLessValue = lessTablePrimary[errorAminoAcid];
                                int errorLeftIndex = errorLessValue + borders[1];
                                int errorRightIndex = errorLessValue + borders[2] - 1;
                                if (errorNewNumX > xNumLimit) continue;
                                backwardMatrix[k + 1][j2].add(new MatrixContent(errorLeftIndex, errorRightIndex, 42, content, errorNewNumX, length, numVariants + 1, Character.toChars(errorAminoAcid + 32)[0]));
                                if (aminoAcid == errorAminoAcid) continue;
                                backwardMatrix[k + 1][j2 + 1].add(new MatrixContent(errorLeftIndex, errorRightIndex, (int)aminoAcid, content, errorNewNumX, length + 1, numVariants + 1, (char)errorAminoAcid));
                            }
                        }
                    }
                }
            }
            for (ArrayList[] backwardList : backwardMatrix) {
                Iterator iterator = backwardList[lenPeptide].iterator();
                while (iterator.hasNext()) {
                    MatrixContent content;
                    MatrixContent currentContent = content = (MatrixContent)iterator.next();
                    String currentPeptide = "";
                    String allVariants = "";
                    while (currentContent.previousContent != null) {
                        currentPeptide = currentPeptide + (char)currentContent.character;
                        allVariants = allVariants + currentContent.variant;
                        currentContent = currentContent.previousContent;
                    }
                    int leftIndex = content.left;
                    int rightIndex = content.right;
                    String cleanPeptide = currentPeptide.replace("*", "");
                    for (int j3 = leftIndex; j3 <= rightIndex; ++j3) {
                        int pos = this.getTextPosition(j3, indexPart);
                        int index = FMIndex.binarySearch(this.boundaries.get(indexPart), pos);
                        String accession = this.accessions.get(indexPart)[index];
                        int startPosition = pos - this.boundaries.get(indexPart)[index];
                        boolean newPeptide = true;
                        for (PeptideProteinMapping ppm : allMatches) {
                            if (!ppm.getProteinAccession().equals(accession) || !ppm.getPeptideSequence().equals(cleanPeptide) || Math.abs(ppm.getIndex() - startPosition) > this.maxNumberVariants) continue;
                            newPeptide = false;
                            break;
                        }
                        if (!newPeptide) continue;
                        ArrayList<VariantMatch> variants = new ArrayList<VariantMatch>();
                        int length = 0;
                        for (int l = 0; l < allVariants.length(); ++l) {
                            char edit = allVariants.charAt(l);
                            ++length;
                            if (edit == '-') continue;
                            if (edit == '*') {
                                variants.add(new VariantMatch(new Insertion(peptide.charAt(length - 1)), "-", length));
                                continue;
                            }
                            if ('A' <= edit && edit <= 'Z') {
                                variants.add(new VariantMatch(new Substitution(edit, peptide.charAt(length - 1)), "-", length));
                                continue;
                            }
                            if ('a' > edit || edit > 'z') continue;
                            variants.add(new VariantMatch(new Deletion((char)(edit - 32)), "-", length));
                            --length;
                        }
                        PeptideProteinMapping peptideProteinMapping = new PeptideProteinMapping(accession, cleanPeptide, startPosition, null, variants);
                        allMatches.add(peptideProteinMapping);
                    }
                }
            }
        }
        return allMatches;
    }

    public ArrayList<PeptideProteinMapping> getProteinMappingWithVariantsSpecific(String peptide, SequenceMatchingPreferences seqMatchPref, int indexPart) {
        int j;
        int[] lessTablePrimary = this.lessTablesPrimary.get(indexPart);
        WaveletTree occurrenceTablePrimary = this.occurrenceTablesPrimary.get(indexPart);
        ArrayList<PeptideProteinMapping> allMatches = new ArrayList<PeptideProteinMapping>();
        String pep_rev = new StringBuilder(peptide).reverse().toString();
        int lenPeptide = peptide.length();
        ArrayList<String> combinations = this.createPeptideCombinations(pep_rev, seqMatchPref);
        int xNumLimit = (int)((seqMatchPref.getLimitX() != null ? seqMatchPref.getLimitX() : 1.0) * (double)lenPeptide);
        int numErrors = this.maxNumberDeletions + this.maxNumberInsertions + this.maxNumberSubstitutions;
        LinkedList[][] backwardMatrix = new LinkedList[numErrors + 1][lenPeptide + 1];
        for (int k = 0; k <= numErrors; ++k) {
            for (j = 0; j <= lenPeptide; ++j) {
                backwardMatrix[k][j] = new LinkedList();
            }
        }
        int countX = 0;
        for (j = 0; j <= lenPeptide; ++j) {
            if (j >= lenPeptide || pep_rev.charAt(j) != 'X') continue;
            ++countX;
        }
        if (countX <= xNumLimit) {
            MatrixContent content;
            backwardMatrix[0][0].add(new MatrixContent(this.indexStringLengths.get(indexPart) - 1));
            for (int k = 0; k <= numErrors; ++k) {
                LinkedList[] backwardList = backwardMatrix[k];
                for (int j2 = 0; j2 < lenPeptide; ++j2) {
                    String combinationSequence = combinations.get(j2);
                    LinkedList cell = backwardList[j2];
                    while (!cell.isEmpty()) {
                        content = (MatrixContent)cell.pop();
                        int leftIndexOld = content.left;
                        int rightIndexOld = content.right;
                        int numX = content.numX;
                        int length = content.length;
                        int numDeletions = content.numSpecificVariants[0];
                        int numInsertions = content.numSpecificVariants[1];
                        int numSubstitutions = content.numSpecificVariants[2];
                        for (int c = 0; c < combinationSequence.length(); ++c) {
                            char aminoAcid = combinationSequence.charAt(c);
                            int lessValue = lessTablePrimary[aminoAcid];
                            int[] range = occurrenceTablePrimary.singleRangeQuery(leftIndexOld - 1, rightIndexOld, aminoAcid);
                            int leftIndex = lessValue + range[0];
                            int rightIndex = lessValue + range[1] - 1;
                            int newNumX = numX + (aminoAcid == 'X' ? 1 : 0);
                            if (leftIndex <= rightIndex) {
                                if (newNumX > xNumLimit) continue;
                                backwardList[j2 + 1].add(new MatrixContent(leftIndex, rightIndex, (int)aminoAcid, content, newNumX, length + 1, new int[]{numDeletions, numInsertions, numSubstitutions}, '-'));
                            }
                            if (c != 0) continue;
                            if (numInsertions < this.maxNumberInsertions) {
                                backwardMatrix[k + 1][j2 + 1].add(new MatrixContent(leftIndexOld, rightIndexOld, (int)aminoAcid, content, newNumX, length + 1, new int[]{numDeletions, numInsertions + 1, numSubstitutions}, '*'));
                            }
                            int[][] setCharacter = occurrenceTablePrimary.rangeQuery(leftIndexOld - 1, rightIndexOld);
                            for (int b = 0; b < setCharacter[this.numMasses][0]; ++b) {
                                int[] borders = setCharacter[b];
                                int errorAminoAcid = borders[0];
                                int errorNewNumX = newNumX + (errorAminoAcid == 88 ? 1 : 0);
                                int errorLessValue = lessTablePrimary[errorAminoAcid];
                                int errorLeftIndex = errorLessValue + borders[1];
                                int errorRightIndex = errorLessValue + borders[2] - 1;
                                if (errorNewNumX > xNumLimit) continue;
                                if (numDeletions < this.maxNumberDeletions) {
                                    backwardMatrix[k + 1][j2].add(new MatrixContent(errorLeftIndex, errorRightIndex, 42, content, errorNewNumX, length, new int[]{numDeletions + 1, numInsertions, numSubstitutions}, Character.toChars(errorAminoAcid + 32)[0]));
                                }
                                if (aminoAcid == errorAminoAcid || numSubstitutions >= this.maxNumberSubstitutions || !this.substitutionMatrix[errorAminoAcid][aminoAcid]) continue;
                                backwardMatrix[k + 1][j2 + 1].add(new MatrixContent(errorLeftIndex, errorRightIndex, (int)aminoAcid, content, errorNewNumX, length + 1, new int[]{numDeletions, numInsertions, numSubstitutions + 1}, (char)errorAminoAcid));
                            }
                        }
                    }
                }
            }
            for (LinkedList[] backwardList : backwardMatrix) {
                Iterator iterator = backwardList[lenPeptide].iterator();
                while (iterator.hasNext()) {
                    MatrixContent currentContent = content = (MatrixContent)iterator.next();
                    String currentPeptide = "";
                    String allVariants = "";
                    while (currentContent.previousContent != null) {
                        currentPeptide = currentPeptide + (char)currentContent.character;
                        allVariants = allVariants + currentContent.variant;
                        currentContent = currentContent.previousContent;
                    }
                    int leftIndex = content.left;
                    int rightIndex = content.right;
                    String cleanPeptide = currentPeptide.replace("*", "");
                    for (int j3 = leftIndex; j3 <= rightIndex; ++j3) {
                        int pos = this.getTextPosition(j3, indexPart);
                        int index = FMIndex.binarySearch(this.boundaries.get(indexPart), pos);
                        String accession = this.accessions.get(indexPart)[index];
                        int startPosition = pos - this.boundaries.get(indexPart)[index];
                        boolean newPeptide = true;
                        for (PeptideProteinMapping ppm : allMatches) {
                            if (!ppm.getProteinAccession().equals(accession) || !ppm.getPeptideSequence().equals(cleanPeptide) || Math.abs(ppm.getIndex() - startPosition) > numErrors) continue;
                            newPeptide = false;
                            break;
                        }
                        if (!newPeptide) continue;
                        ArrayList<VariantMatch> variants = new ArrayList<VariantMatch>();
                        int length = 0;
                        for (int l = 0; l < allVariants.length(); ++l) {
                            char edit = allVariants.charAt(l);
                            ++length;
                            if (edit == '-') continue;
                            if (edit == '*') {
                                variants.add(new VariantMatch(new Insertion(peptide.charAt(length - 1)), "-", length));
                                continue;
                            }
                            if ('A' <= edit && edit <= 'Z') {
                                variants.add(new VariantMatch(new Substitution(edit, peptide.charAt(length - 1)), "-", length));
                                continue;
                            }
                            if ('a' > edit || edit > 'z') continue;
                            variants.add(new VariantMatch(new Deletion((char)(edit - 32)), "-", length));
                            --length;
                        }
                        PeptideProteinMapping peptideProteinMapping = new PeptideProteinMapping(accession, cleanPeptide, startPosition, null, variants);
                        allMatches.add(peptideProteinMapping);
                    }
                }
            }
        }
        return allMatches;
    }

    @Override
    public void emptyCache() {
    }

    @Override
    public void close() throws IOException, SQLException {
    }

    private void addModifications(int[][] setCharacter) {
        int maxNum = setCharacter[this.numMasses][0];
        for (int i = 0; i < maxNum; ++i) {
            for (int pos = 128 + setCharacter[i][0]; pos < this.aaMasses.length && this.aaMasses[pos] != -1.0; pos += 128) {
                int[] nArray = setCharacter[this.numMasses];
                int n = nArray[0];
                nArray[0] = n + 1;
                setCharacter[n] = new int[]{setCharacter[i][0], setCharacter[i][1], setCharacter[i][2], pos, setCharacter[i][4]};
            }
        }
    }

    private void addAmbiguous(int[][] setCharacter) {
        int c;
        int i;
        long[] foundChars = new long[]{0L, 0L};
        int maxNum = setCharacter[this.numMasses][0];
        int[] BValues = null;
        int[] JValues = null;
        int[] ZValues = null;
        for (i = 0; i < maxNum; ++i) {
            if (setCharacter[i][0] == 66 || setCharacter[i][0] == 74 || setCharacter[i][0] == 90) {
                switch (setCharacter[i][0]) {
                    case 66: {
                        BValues = setCharacter[i];
                        break;
                    }
                    case 74: {
                        JValues = setCharacter[i];
                        break;
                    }
                    case 90: {
                        ZValues = setCharacter[i];
                    }
                }
                if (i != maxNum - 1) {
                    setCharacter[i] = setCharacter[maxNum - 1];
                    --i;
                }
                int[] nArray = setCharacter[this.numMasses];
                nArray[0] = nArray[0] - 1;
                --maxNum;
                continue;
            }
            c = setCharacter[i][0];
            int n = c >>> 6;
            foundChars[n] = foundChars[n] | 1L << (c & 0x3F);
        }
        if (BValues != null) {
            for (i = 0; i < this.BSubstitutions.length; ++i) {
                c = this.BSubstitutions[i];
                if ((foundChars[c >>> 6] >>> (c & 0x3F) & 1L) != 0L) continue;
                int[] nArray = setCharacter[this.numMasses];
                int n = nArray[0];
                nArray[0] = n + 1;
                setCharacter[n] = new int[]{c, BValues[1], BValues[2], c, 66};
            }
        }
        if (JValues != null) {
            for (i = 0; i < this.JSubstitutions.length; ++i) {
                c = this.JSubstitutions[i];
                if ((foundChars[c >>> 6] >>> (c & 0x3F) & 1L) != 0L) continue;
                int[] nArray = setCharacter[this.numMasses];
                int n = nArray[0];
                nArray[0] = n + 1;
                setCharacter[n] = new int[]{c, JValues[1], JValues[2], c, 74};
            }
        }
        if (ZValues != null) {
            for (i = 0; i < this.ZSubstitutions.length; ++i) {
                c = this.ZSubstitutions[i];
                if ((foundChars[c >>> 6] >>> (c & 0x3F) & 1L) != 0L) continue;
                int[] nArray = setCharacter[this.numMasses];
                int n = nArray[0];
                nArray[0] = n + 1;
                setCharacter[n] = new int[]{c, ZValues[1], ZValues[2], c, 90};
            }
        }
    }

    private boolean massNotValid(double mass) {
        int intMass = (int)(mass * this.lookupMultiplier);
        return mass > this.massTolerance && mass < this.lookupMaxMass && (this.lookupMasses[intMass >>> 6] >>> (intMass & 0x3F) & 1L) == 0L;
    }

    private void mappingSequenceAndMassesDA(TagElement[] combinations, LinkedList<MatrixContent>[] matrix, int[] less, WaveletTree occurrence) {
        for (int j = 0; j < combinations.length; ++j) {
            LinkedList<MatrixContent> content = matrix[j];
            TagElement combination = combinations[j];
            while (!content.isEmpty()) {
                MatrixContent cell = content.removeFirst();
                int length = cell.length;
                int leftIndexOld = cell.left;
                int rightIndexOld = cell.right;
                int numX = cell.numX;
                if (combination.isMass) {
                    double combinationMass = combination.mass;
                    double oldMass = cell.mass;
                    int[][] setCharacter = occurrence.rangeQuery(leftIndexOld - 1, rightIndexOld);
                    this.addAmbiguous(setCharacter);
                    if (this.withVariableModifications) {
                        this.addModifications(setCharacter);
                    }
                    for (int b = 0; b < setCharacter[this.numMasses][0]; ++b) {
                        boolean withinMass;
                        double newMass;
                        int newNumX;
                        int[] borders = setCharacter[b];
                        int aminoAcid = borders[0];
                        if (aminoAcid == 47 || (newNumX = numX + (aminoAcid == 88 ? 1 : 0)) > combination.xNumLimit || !((newMass = oldMass + (aminoAcid != 88 ? this.aaMasses[borders[3]] : 0.0)) - this.massTolerance <= combinationMass)) continue;
                        int aminoAcidSearch = borders[4] == -1 ? aminoAcid : borders[4];
                        int lessValue = less[aminoAcidSearch];
                        int leftIndex = lessValue + borders[1];
                        int rightIndex = lessValue + borders[2] - 1;
                        double massDiff = Math.abs(combinationMass - newMass);
                        if (this.massNotValid(massDiff)) continue;
                        int offset = (massDiff <= this.massTolerance ? 1 : 0) | ((withinMass = this.withinMassTolerance(massDiff, newNumX)) ? 1 : 0);
                        if (offset > 0) {
                            newNumX = 0;
                        }
                        matrix[j + offset].add(new MatrixContent(leftIndex, rightIndex, aminoAcid, cell, newMass, length + 1, newNumX, borders[3], borders[4], j));
                        if (!withinMass) continue;
                        matrix[j + offset].getLast().XMassDiff = massDiff;
                    }
                    continue;
                }
                String combinationSequence = combination.sequence;
                int xNumLimit = combination.xNumLimit;
                char aminoAcid = combinationSequence.charAt(0);
                for (int i = 0; i < combinationSequence.length(); ++i) {
                    char aminoAcidSearch = combinationSequence.charAt(i);
                    int lessValue = less[aminoAcidSearch];
                    int[] range = occurrence.singleRangeQuery(leftIndexOld - 1, rightIndexOld, aminoAcidSearch);
                    int leftIndex = lessValue + range[0];
                    int rightIndex = lessValue + range[1] - 1;
                    int newNumX = numX + (aminoAcidSearch == 'X' ? 1 : 0);
                    if (leftIndex > rightIndex || newNumX > xNumLimit) continue;
                    if (j < combinations.length - 1 && combinations[j].isMass != combinations[j + 1].isMass) {
                        newNumX = 0;
                    }
                    matrix[j + 1].add(new MatrixContent(leftIndex, rightIndex, aminoAcid, cell, 0.0, length + 1, newNumX, -1, aminoAcidSearch, j));
                }
            }
        }
    }

    private void mappingSequenceAndMassesPPM(TagElement[] combinations, LinkedList<MatrixContent>[] matrix, int[] less, WaveletTree occurrence) {
        for (int j = 0; j < combinations.length; ++j) {
            LinkedList<MatrixContent> content = matrix[j];
            TagElement combination = combinations[j];
            while (!content.isEmpty()) {
                MatrixContent cell = content.removeFirst();
                int length = cell.length;
                int leftIndexOld = cell.left;
                int rightIndexOld = cell.right;
                int numX = cell.numX;
                if (combination.isMass) {
                    double combinationMass = combination.mass;
                    double oldMass = cell.mass;
                    int[][] setCharacter = occurrence.rangeQuery(leftIndexOld - 1, rightIndexOld);
                    this.addAmbiguous(setCharacter);
                    if (this.withVariableModifications) {
                        this.addModifications(setCharacter);
                    }
                    for (int b = 0; b < setCharacter[this.numMasses][0]; ++b) {
                        double newMass;
                        int newNumX;
                        int[] borders = setCharacter[b];
                        int aminoAcid = borders[0];
                        if (aminoAcid == 47 || (newNumX = numX + (aminoAcid == 88 ? 1 : 0)) > combination.xNumLimit || !((newMass = oldMass + (aminoAcid != 88 ? this.aaMasses[borders[3]] : 0.0)) - this.computeInverseMassValue(this.massTolerance, combinationMass) <= combinationMass)) continue;
                        int aminoAcidSearch = borders[4] == -1 ? aminoAcid : borders[4];
                        int lessValue = less[aminoAcidSearch];
                        int leftIndex = lessValue + borders[1];
                        int rightIndex = lessValue + borders[2] - 1;
                        double massDiff = Math.abs(combinationMass - newMass);
                        if (this.massNotValid(massDiff)) continue;
                        boolean withinMass = this.withinMassTolerance(massDiff, newNumX);
                        int offset = (this.computeMassValue(newMass, combinationMass) <= this.massTolerance ? 1 : 0) | (withinMass ? 1 : 0);
                        if (offset > 0) {
                            newNumX = 0;
                        }
                        matrix[j + offset].add(new MatrixContent(leftIndex, rightIndex, aminoAcid, cell, newMass, length + 1, newNumX, borders[3], borders[4], j));
                        if (!withinMass) continue;
                        matrix[j + offset].getLast().XMassDiff = massDiff;
                    }
                    continue;
                }
                String combinationSequence = combination.sequence;
                int xNumLimit = combination.xNumLimit;
                char aminoAcid = combinationSequence.charAt(0);
                for (int i = 0; i < combinationSequence.length(); ++i) {
                    char aminoAcidSearch = combinationSequence.charAt(i);
                    int lessValue = less[aminoAcidSearch];
                    int[] range = occurrence.singleRangeQuery(leftIndexOld - 1, rightIndexOld, aminoAcidSearch);
                    int leftIndex = lessValue + range[0];
                    int rightIndex = lessValue + range[1] - 1;
                    int newNumX = numX + (aminoAcidSearch == 'X' ? 1 : 0);
                    if (leftIndex > rightIndex || newNumX > xNumLimit) continue;
                    if (j < combinations.length - 1 && combinations[j].isMass != combinations[j + 1].isMass) {
                        newNumX = 0;
                    }
                    matrix[j + 1].add(new MatrixContent(leftIndex, rightIndex, aminoAcid, cell, 0.0, length + 1, newNumX, -1, aminoAcidSearch, j));
                }
            }
        }
    }

    private void mappingSequenceAndMassesWithVariantsGeneric(TagElement[] combinations, LinkedList<MatrixContent>[][] matrix, int[] less, WaveletTree occurrence) {
        int lenCombinations = combinations.length;
        for (int k = 0; k <= this.maxNumberVariants; ++k) {
            LinkedList<MatrixContent>[] row = matrix[k];
            for (int j = 0; j < lenCombinations; ++j) {
                TagElement combination = combinations[j];
                LinkedList<MatrixContent> cell = row[j];
                while (!cell.isEmpty()) {
                    MatrixContent content = cell.removeFirst();
                    int leftIndexOld = content.left;
                    int length = content.length;
                    int rightIndexOld = content.right;
                    int numVariants = content.numVariants;
                    int numX = content.numX;
                    if (combination.isMass) {
                        double combinationMass = combination.mass;
                        double oldMass = content.mass;
                        int[][] setCharacter = occurrence.rangeQuery(leftIndexOld - 1, rightIndexOld);
                        if (this.withVariableModifications) {
                            this.addModifications(setCharacter);
                        }
                        for (int b = 0; b < setCharacter[this.numMasses][0]; ++b) {
                            int offset;
                            int[] borders = setCharacter[b];
                            int aminoAcid = borders[0];
                            if (aminoAcid == 47) continue;
                            double newMass = oldMass + this.aaMasses[borders[3]];
                            int lessValue = less[aminoAcid];
                            int leftIndex = lessValue + borders[1];
                            int rightIndex = lessValue + borders[2] - 1;
                            int n = offset = Math.abs(combinationMass - newMass) <= this.massTolerance ? 1 : 0;
                            if (newMass - this.massTolerance <= combinationMass) {
                                boolean add = true;
                                double massDiff = combinationMass - newMass;
                                int intMass = (int)(massDiff * this.lookupMultiplier);
                                if (massDiff > this.massTolerance && massDiff < this.lookupMaxMass && (this.lookupMasses[intMass >>> 6] >>> (intMass & 0x3F) & 1L) == 0L) {
                                    add = false;
                                }
                                if (add) {
                                    row[j + offset].add(new MatrixContent(leftIndex, rightIndex, aminoAcid, content, newMass, length + 1, numX, borders[3], numVariants, '-', null));
                                }
                            }
                            if (numVariants >= this.maxNumberVariants) continue;
                            matrix[k + 1][j].add(new MatrixContent(leftIndex, rightIndex, 42, content, oldMass, length, numX, -1, numVariants + 1, Character.toChars(aminoAcid + 32)[0], null));
                            for (int index : this.aaMassIndexes) {
                                double aminoMass = oldMass + this.aaMasses[index];
                                int offsetSub = Math.abs(combinationMass - aminoMass) <= this.massTolerance ? 1 : 0;
                                int amino = index & 0x7F;
                                if (amino == aminoAcid || !(aminoMass < combinationMass + this.massTolerance)) continue;
                                boolean add = true;
                                double massDiff = combinationMass - aminoMass;
                                int intMass = (int)(massDiff * this.lookupMultiplier);
                                if (massDiff > this.massTolerance && massDiff < this.lookupMaxMass && (this.lookupMasses[intMass >>> 6] >>> (intMass & 0x3F) & 1L) == 0L) {
                                    add = false;
                                }
                                if (!add) continue;
                                matrix[k + 1][j + offsetSub].add(new MatrixContent(leftIndex, rightIndex, amino, content, aminoMass, length + 1, numX, index, numVariants + 1, (char)aminoAcid, null));
                            }
                        }
                        if (numVariants >= this.maxNumberVariants) continue;
                        for (int index : this.aaMassIndexes) {
                            double aminoMass = oldMass + this.aaMasses[index];
                            int offsetDel = Math.abs(combinationMass - aminoMass) <= this.massTolerance ? 1 : 0;
                            int amino = index & 0x7F;
                            if (!(aminoMass < combinationMass + this.massTolerance)) continue;
                            boolean add = true;
                            double massDiff = combinationMass - aminoMass;
                            int intMass = (int)(massDiff * this.lookupMultiplier);
                            if (massDiff > this.massTolerance && massDiff < this.lookupMaxMass && (this.lookupMasses[intMass >>> 6] >>> (intMass & 0x3F) & 1L) == 0L) {
                                add = false;
                            }
                            if (!add) continue;
                            matrix[k + 1][j + offsetDel].add(new MatrixContent(leftIndexOld, rightIndexOld, amino, content, aminoMass, length + 1, numX, index, numVariants + 1, '*', null));
                        }
                        continue;
                    }
                    String combinationSequence = combination.sequence;
                    int xNumLimit = combination.xNumLimit;
                    for (int c = 0; c < combinationSequence.length(); ++c) {
                        int rightIndex;
                        char aminoAcid = combinationSequence.charAt(c);
                        int newNumX = numX + (aminoAcid == 'X' ? 1 : 0);
                        if (newNumX > xNumLimit) continue;
                        int lessValue = less[aminoAcid];
                        int[] range = occurrence.singleRangeQuery(leftIndexOld - 1, rightIndexOld, aminoAcid);
                        int leftIndex = lessValue + range[0];
                        if (leftIndex <= (rightIndex = lessValue + range[1] - 1)) {
                            row[j + 1].add(new MatrixContent(leftIndex, rightIndex, (int)aminoAcid, content, newNumX, length + 1, numVariants, '-'));
                        }
                        if (numVariants >= this.maxNumberVariants || c != 0) continue;
                        if (numVariants < this.maxNumberVariants) {
                            matrix[k + 1][j + 1].add(new MatrixContent(leftIndexOld, rightIndexOld, (int)aminoAcid, content, newNumX, length + 1, numVariants + 1, '*'));
                        }
                        int[][] setCharacterSeq = occurrence.rangeQuery(leftIndexOld - 1, rightIndexOld);
                        for (int b = 0; b < setCharacterSeq[this.numMasses][0]; ++b) {
                            int[] borders = setCharacterSeq[b];
                            int errorAminoAcid = borders[0];
                            int errorNewNumX = newNumX + (errorAminoAcid != 88 ? 0 : 1);
                            if (errorNewNumX > xNumLimit) continue;
                            int errorLessValue = less[errorAminoAcid];
                            int errorLeftIndex = errorLessValue + borders[1];
                            int errorRightIndex = errorLessValue + borders[2] - 1;
                            matrix[k + 1][j].add(new MatrixContent(errorLeftIndex, errorRightIndex, 42, content, errorNewNumX, length, numVariants + 1, Character.toChars(errorAminoAcid + 32)[0]));
                            if (aminoAcid == errorAminoAcid) continue;
                            matrix[k + 1][j + 1].add(new MatrixContent(errorLeftIndex, errorRightIndex, (int)aminoAcid, content, errorNewNumX, length + 1, numVariants + 1, (char)errorAminoAcid));
                        }
                    }
                }
            }
        }
    }

    private void mappingSequenceAndMassesWithVariantsSpecific(TagElement[] combinations, LinkedList<MatrixContent>[][] matrix, int[] less, WaveletTree occurrence) {
        int lenCombinations = combinations.length;
        int maxNumberSpecificVariants = this.maxNumberDeletions + this.maxNumberInsertions + this.maxNumberSubstitutions;
        for (int k = 0; k <= maxNumberSpecificVariants; ++k) {
            LinkedList<MatrixContent>[] row = matrix[k];
            for (int j = 0; j < lenCombinations; ++j) {
                TagElement combination = combinations[j];
                LinkedList<MatrixContent> cell = row[j];
                while (!cell.isEmpty()) {
                    MatrixContent content = cell.removeFirst();
                    int leftIndexOld = content.left;
                    int rightIndexOld = content.right;
                    int length = content.length;
                    int numDeletions = content.numSpecificVariants[0];
                    int numInsertions = content.numSpecificVariants[1];
                    int numSubstitutions = content.numSpecificVariants[2];
                    int numX = content.numX;
                    if (combination.isMass) {
                        double combinationMass = combination.mass;
                        double oldMass = content.mass;
                        int[][] setCharacter = occurrence.rangeQuery(leftIndexOld - 1, rightIndexOld);
                        if (this.withVariableModifications) {
                            this.addModifications(setCharacter);
                        }
                        for (int b = 0; b < setCharacter[this.numMasses][0]; ++b) {
                            int offset;
                            int[] borders = setCharacter[b];
                            int aminoAcid = borders[0];
                            if (aminoAcid == 47) continue;
                            double newMass = oldMass + this.aaMasses[borders[3]];
                            int lessValue = less[aminoAcid];
                            int leftIndex = lessValue + borders[1];
                            int rightIndex = lessValue + borders[2] - 1;
                            int n = offset = Math.abs(combinationMass - newMass) <= this.massTolerance ? 1 : 0;
                            if (newMass - this.massTolerance <= combinationMass) {
                                boolean add = true;
                                double massDiff = combinationMass - newMass;
                                int intMass = (int)(massDiff * this.lookupMultiplier);
                                if (massDiff > this.massTolerance && massDiff < this.lookupMaxMass && (this.lookupMasses[intMass >>> 6] >>> (intMass & 0x3F) & 1L) == 0L) {
                                    add = false;
                                }
                                if (add) {
                                    row[j + offset].add(new MatrixContent(leftIndex, rightIndex, aminoAcid, content, newMass, length + 1, numX, borders[3], new int[]{numDeletions, numInsertions, numSubstitutions}, '-', null));
                                }
                            }
                            if (numDeletions < this.maxNumberDeletions) {
                                matrix[k + 1][j].add(new MatrixContent(leftIndex, rightIndex, 42, content, oldMass, length, numX, -1, new int[]{numDeletions + 1, numInsertions, numSubstitutions}, Character.toChars(aminoAcid + 32)[0], null));
                            }
                            if (numSubstitutions >= this.maxNumberSubstitutions) continue;
                            for (int index : this.aaMassIndexes) {
                                int offsetSub;
                                int amino = index & 0x7F;
                                if (!this.substitutionMatrix[amino][aminoAcid]) continue;
                                double aminoMass = oldMass + this.aaMasses[index];
                                int n2 = offsetSub = Math.abs(combinationMass - aminoMass) <= this.massTolerance ? 1 : 0;
                                if (amino == aminoAcid || !(aminoMass < combinationMass + this.massTolerance)) continue;
                                boolean add = true;
                                double massDiff = combinationMass - aminoMass;
                                int intMass = (int)(massDiff * this.lookupMultiplier);
                                if (massDiff > this.massTolerance && massDiff < this.lookupMaxMass && (this.lookupMasses[intMass >>> 6] >>> (intMass & 0x3F) & 1L) == 0L) {
                                    add = false;
                                }
                                if (!add) continue;
                                matrix[k + 1][j + offsetSub].add(new MatrixContent(leftIndex, rightIndex, amino, content, aminoMass, length + 1, numX, index, new int[]{numDeletions, numInsertions, numSubstitutions + 1}, (char)aminoAcid, null));
                            }
                        }
                        if (numInsertions >= this.maxNumberInsertions) continue;
                        for (int index : this.aaMassIndexes) {
                            double aminoMass = oldMass + this.aaMasses[index];
                            int offsetDel = Math.abs(combinationMass - aminoMass) <= this.massTolerance ? 1 : 0;
                            int amino = index & 0x7F;
                            if (!(aminoMass < combinationMass + this.massTolerance)) continue;
                            boolean add = true;
                            double massDiff = combinationMass - aminoMass;
                            int intMass = (int)(massDiff * this.lookupMultiplier);
                            if (massDiff > this.massTolerance && massDiff < this.lookupMaxMass && (this.lookupMasses[intMass >>> 6] >>> (intMass & 0x3F) & 1L) == 0L) {
                                add = false;
                            }
                            if (!add) continue;
                            matrix[k + 1][j + offsetDel].add(new MatrixContent(leftIndexOld, rightIndexOld, amino, content, aminoMass, length + 1, numX, index, new int[]{numDeletions, numInsertions + 1, numSubstitutions}, '*', null));
                        }
                        continue;
                    }
                    String combinationSequence = combination.sequence;
                    int xNumLimit = combination.xNumLimit;
                    for (int c = 0; c < combinationSequence.length(); ++c) {
                        int rightIndex;
                        char aminoAcid = combinationSequence.charAt(c);
                        int newNumX = numX + (aminoAcid == 'X' ? 1 : 0);
                        if (newNumX > xNumLimit) continue;
                        int lessValue = less[aminoAcid];
                        int[] range = occurrence.singleRangeQuery(leftIndexOld - 1, rightIndexOld, aminoAcid);
                        int leftIndex = lessValue + range[0];
                        if (leftIndex <= (rightIndex = lessValue + range[1] - 1)) {
                            row[j + 1].add(new MatrixContent(leftIndex, rightIndex, (int)aminoAcid, content, newNumX, length + 1, new int[]{numDeletions, numInsertions, numSubstitutions}, '-'));
                        }
                        if (c != 0) continue;
                        if (numInsertions < this.maxNumberInsertions) {
                            matrix[k + 1][j + 1].add(new MatrixContent(leftIndexOld, rightIndexOld, (int)aminoAcid, content, newNumX, length + 1, new int[]{numDeletions, numInsertions + 1, numSubstitutions}, '*'));
                        }
                        if (numDeletions >= this.maxNumberDeletions && numSubstitutions >= this.maxNumberSubstitutions) continue;
                        int[][] setCharacterSeq = occurrence.rangeQuery(leftIndexOld - 1, rightIndexOld);
                        for (int b = 0; b < setCharacterSeq[this.numMasses][0]; ++b) {
                            int[] borders = setCharacterSeq[b];
                            int errorAminoAcid = borders[0];
                            int errorNewNumX = newNumX + (errorAminoAcid != 88 ? 0 : 1);
                            if (errorNewNumX > xNumLimit) continue;
                            int errorLessValue = less[errorAminoAcid];
                            int errorLeftIndex = errorLessValue + borders[1];
                            int errorRightIndex = errorLessValue + borders[2] - 1;
                            if (numDeletions < this.maxNumberDeletions) {
                                matrix[k + 1][j].add(new MatrixContent(errorLeftIndex, errorRightIndex, 42, content, errorNewNumX, length, new int[]{numDeletions + 1, numInsertions, numSubstitutions}, Character.toChars(errorAminoAcid + 32)[0]));
                            }
                            if (numSubstitutions >= this.maxNumberSubstitutions || aminoAcid == errorAminoAcid || !this.substitutionMatrix[errorAminoAcid][aminoAcid]) continue;
                            matrix[k + 1][j + 1].add(new MatrixContent(errorLeftIndex, errorRightIndex, (int)aminoAcid, content, errorNewNumX, length + 1, new int[]{numDeletions, numInsertions, numSubstitutions + 1}, (char)errorAminoAcid));
                        }
                    }
                }
            }
        }
    }

    public double pepMass(String peptide) {
        double mass = 0.0;
        for (int i = 0; i < peptide.length(); ++i) {
            mass += this.aaMasses[peptide.charAt(i)];
        }
        return mass;
    }

    public boolean withinMassTolerance(double mass, int numX) {
        if (mass + this.computeInverseMassValue(this.massTolerance, mass) < this.negativePTMMass) {
            return false;
        }
        int intMass = (int)(mass * this.lookupMultiplier);
        return 0 < numX && numX <= this.maxXPerTag && mass < this.lookupMaxMass && (this.Xlookup[numX][intMass >>> 6] >>> (intMass & 0x3F) & 1L) == 1L;
    }

    private void mappingSequenceAndMassesPPM(TagElement[] combinations, LinkedList<MatrixContent>[] matrix, int[] less, WaveletTree occurrence, boolean CTermDirection) {
        int lenCombinations = combinations.length;
        for (int k = 0; k < lenCombinations; ++k) {
            TagElement combination = combinations[k];
            LinkedList<MatrixContent> content = matrix[k];
            while (!content.isEmpty()) {
                MatrixContent cell = content.removeFirst();
                int length = cell.length;
                int leftIndexOld = cell.left;
                int rightIndexOld = cell.right;
                if (combination.isMass) {
                    int aminoAcid;
                    int[] borders;
                    int b;
                    double combinationMass = combination.mass;
                    double oldMass = cell.mass;
                    int[][] setCharacter = occurrence.rangeQuery(leftIndexOld - 1, rightIndexOld);
                    this.addAmbiguous(setCharacter);
                    if (this.withVariableModifications) {
                        this.addModifications(setCharacter);
                    }
                    if (k == lenCombinations - 1) {
                        for (b = 0; b < setCharacter[this.numMasses][0]; ++b) {
                            boolean hasFixedPep;
                            boolean wmtV;
                            double massDiffDiffV;
                            boolean wmtV2;
                            boolean wmt;
                            double massDiffDiffAbs;
                            int i;
                            borders = setCharacter[b];
                            aminoAcid = borders[0];
                            int newNumX = cell.numX + (aminoAcid == 88 ? 1 : 0);
                            if (newNumX > combination.xNumLimit) continue;
                            if (aminoAcid != 47) {
                                boolean wmtV3;
                                double massDiffDiffV2;
                                int j;
                                boolean wmt2;
                                double massDiffDiffAbs2;
                                double massDiffDiff;
                                int i2;
                                int aminoAcidSearch = borders[4] == -1 ? aminoAcid : borders[4];
                                double newMass = oldMass + (aminoAcid != 88 ? this.aaMasses[borders[3]] : 0.0);
                                double massDiff = combinationMass - newMass;
                                int lastAcid = aminoAcid;
                                int lessValue = less[aminoAcidSearch];
                                int leftIndex = lessValue + borders[1];
                                int rightIndex = lessValue + borders[2] - 1;
                                MatrixContent newCell = new MatrixContent(leftIndex, rightIndex, aminoAcid, cell, newMass, length + 1, newNumX, borders[3], borders[4], k);
                                ModificationMatch modificationMatchEnd = null;
                                ModificationMatch modificationMatchEndEnd = null;
                                ArrayList<String> fmodp = this.fmodcp;
                                ArrayList<Double> fmodpMass = this.fmodcpMass;
                                ArrayList<String>[] fmodpaa = this.fmodcpaa;
                                ArrayList<Double>[] fmodpaaMass = this.fmodcpaaMass;
                                ArrayList<String> vmodp = this.vmodcp;
                                ArrayList<Double> vmodpMass = this.vmodcpMass;
                                ArrayList<String>[] vmodpaa = this.vmodcpaa;
                                ArrayList<Double>[] vmodpaaMass = this.vmodcpaaMass;
                                boolean hasFixedPTM_atTerminus = this.hasFixedPTM_CatTerminus;
                                if (!CTermDirection) {
                                    fmodp = this.fmodnp;
                                    fmodpMass = this.fmodnpMass;
                                    fmodpaa = this.fmodnpaa;
                                    fmodpaaMass = this.fmodnpaaMass;
                                    vmodp = this.vmodnp;
                                    vmodpMass = this.vmodnpMass;
                                    vmodpaa = this.vmodnpaa;
                                    vmodpaaMass = this.vmodnpaaMass;
                                    hasFixedPTM_atTerminus = this.hasFixedPTM_NatTerminus;
                                }
                                boolean hasFixed = false;
                                boolean withinMass = false;
                                double XmassDiff = -1.0 - this.massTolerance;
                                if (fmodpaa != null && lastAcid > 0 && fmodpaaMass[lastAcid].size() > 0) {
                                    hasFixed = true;
                                    for (i2 = 0; i2 < fmodpaaMass[lastAcid].size(); ++i2) {
                                        massDiffDiff = massDiff - fmodpaaMass[lastAcid].get(i2);
                                        massDiffDiffAbs2 = Math.abs(massDiffDiff);
                                        wmt2 = this.withinMassTolerance(massDiffDiffAbs2, newNumX);
                                        if (this.computeMassValue(fmodpaaMass[lastAcid].get(i2) + newMass, combinationMass) < this.massTolerance || wmt2) {
                                            withinMass |= wmt2;
                                            XmassDiff = massDiffDiffAbs2;
                                            modificationMatchEnd = new ModificationMatch(fmodpaa[lastAcid].get(i2), false, length + 1);
                                        }
                                        if (XmassDiff < -this.massTolerance && vmodpaa != null && lastAcid > 0 && vmodpaaMass[lastAcid].size() > 0) {
                                            for (j = 0; j < vmodpaaMass[lastAcid].size(); ++j) {
                                                massDiffDiffV2 = Math.abs(massDiffDiff - vmodpaaMass[lastAcid].get(j));
                                                wmtV3 = this.withinMassTolerance(massDiffDiffV2, newNumX);
                                                if (!(this.computeMassValue(fmodpaaMass[lastAcid].get(i2) + newMass + vmodpaaMass[lastAcid].get(j), combinationMass) < this.massTolerance) && !wmtV3) continue;
                                                withinMass |= wmtV3;
                                                XmassDiff = massDiffDiffV2;
                                                modificationMatchEnd = new ModificationMatch(fmodpaa[lastAcid].get(i2), false, length + 1);
                                                modificationMatchEndEnd = new ModificationMatch(vmodpaa[lastAcid].get(j), true, length + 1);
                                            }
                                        }
                                        if (!(XmassDiff < -this.massTolerance) || vmodp == null) continue;
                                        for (j = 0; j < vmodp.size(); ++j) {
                                            massDiffDiffV2 = Math.abs(massDiffDiff - vmodpMass.get(j));
                                            wmtV3 = this.withinMassTolerance(massDiffDiffV2, newNumX);
                                            if (!(this.computeMassValue(fmodpaaMass[lastAcid].get(i2) + vmodpMass.get(j) + newMass, combinationMass) < this.massTolerance) && !wmtV3) continue;
                                            withinMass |= wmtV3;
                                            XmassDiff = massDiffDiffV2;
                                            modificationMatchEnd = new ModificationMatch(fmodpaa[lastAcid].get(i2), false, length + 1);
                                            modificationMatchEndEnd = new ModificationMatch(vmodp.get(j), false, length + 1);
                                        }
                                    }
                                }
                                if (fmodp != null && XmassDiff < -this.massTolerance) {
                                    hasFixed = true;
                                    for (i2 = 0; i2 < fmodp.size(); ++i2) {
                                        massDiffDiff = massDiff - fmodpMass.get(i2);
                                        massDiffDiffAbs2 = Math.abs(massDiffDiff);
                                        wmt2 = this.withinMassTolerance(massDiffDiffAbs2, newNumX);
                                        if (this.computeMassValue(fmodpMass.get(i2) + newMass, combinationMass) < this.massTolerance || wmt2) {
                                            withinMass |= wmt2;
                                            XmassDiff = massDiffDiffAbs2;
                                            modificationMatchEnd = new ModificationMatch(fmodp.get(i2), false, length + 1);
                                        }
                                        if (XmassDiff < -this.massTolerance && vmodpaa != null && lastAcid > 0 && vmodpaaMass[lastAcid].size() > 0) {
                                            for (j = 0; j < vmodpaaMass[lastAcid].size(); ++j) {
                                                massDiffDiffV2 = Math.abs(massDiffDiff - vmodpaaMass[lastAcid].get(j));
                                                wmtV3 = this.withinMassTolerance(massDiffDiffV2, newNumX);
                                                if (!(this.computeMassValue(fmodpMass.get(i2) + newMass + vmodpaaMass[lastAcid].get(j), combinationMass) < this.massTolerance) && !wmtV3) continue;
                                                withinMass |= wmtV3;
                                                XmassDiff = massDiffDiffV2;
                                                modificationMatchEnd = new ModificationMatch(fmodp.get(i2), false, length + 1);
                                                modificationMatchEndEnd = new ModificationMatch(vmodpaa[lastAcid].get(j), true, length + 1);
                                            }
                                        }
                                        if (!(XmassDiff < -this.massTolerance) || vmodp == null) continue;
                                        for (j = 0; j < vmodp.size(); ++j) {
                                            massDiffDiffV2 = Math.abs(massDiffDiff - vmodpMass.get(j));
                                            wmtV3 = this.withinMassTolerance(massDiffDiffV2, newNumX);
                                            if (!(this.computeMassValue(fmodpMass.get(i2) + newMass + vmodpMass.get(j), combinationMass) < this.massTolerance) && !wmtV3) continue;
                                            withinMass |= wmtV3;
                                            XmassDiff = massDiffDiffV2;
                                            modificationMatchEnd = new ModificationMatch(fmodp.get(i2), false, length + 1);
                                            modificationMatchEndEnd = new ModificationMatch(vmodp.get(j), false, length + 1);
                                        }
                                    }
                                }
                                if (!hasFixedPTM_atTerminus && !hasFixed && XmassDiff < -this.massTolerance) {
                                    boolean wmtV4;
                                    double massDiffV;
                                    double massDiffF = Math.abs(massDiff);
                                    boolean wmt3 = this.withinMassTolerance(massDiffF, newNumX);
                                    if (this.computeMassValue(newMass, combinationMass) < this.massTolerance || wmt3) {
                                        withinMass |= wmt3;
                                        XmassDiff = massDiffF;
                                    }
                                    if (XmassDiff < -this.massTolerance && vmodpaa != null && lastAcid > 0 && vmodpaaMass[lastAcid].size() > 0) {
                                        for (int i3 = 0; i3 < vmodpaaMass[lastAcid].size(); ++i3) {
                                            massDiffV = Math.abs(massDiff - vmodpaaMass[lastAcid].get(i3));
                                            wmtV4 = this.withinMassTolerance(massDiffV, newNumX);
                                            if (!(this.computeMassValue(vmodpaaMass[lastAcid].get(i3) + newMass, combinationMass) < this.massTolerance) && !wmtV4) continue;
                                            withinMass |= wmtV4;
                                            XmassDiff = massDiffV;
                                            modificationMatchEnd = new ModificationMatch(vmodpaa[lastAcid].get(i3), true, length + 1);
                                        }
                                    }
                                    if (XmassDiff < -this.massTolerance && vmodp != null) {
                                        for (int i4 = 0; i4 < vmodp.size(); ++i4) {
                                            massDiffV = Math.abs(massDiff - vmodpMass.get(i4));
                                            wmtV4 = this.withinMassTolerance(massDiffV, newNumX);
                                            if (!(this.computeMassValue(vmodpMass.get(i4) + newMass, combinationMass) < this.massTolerance) && !wmtV4) continue;
                                            withinMass |= wmtV4;
                                            XmassDiff = massDiffV;
                                            modificationMatchEnd = new ModificationMatch(vmodp.get(i4), false, length + 1);
                                        }
                                    }
                                }
                                if (XmassDiff < -this.massTolerance) {
                                    if (!(newMass - this.computeInverseMassValue(this.massTolerance, combinationMass) + this.negativePTMMass <= combinationMass)) continue;
                                    content.add(newCell);
                                    continue;
                                }
                                if (modificationMatchEnd != null) {
                                    if (newNumX > 0 && !withinMass) continue;
                                    MatrixContent newEndCell = new MatrixContent(leftIndex, rightIndex, 0, newCell, 0.0, null, null, length + 1, 0, k, modificationMatchEnd, null, -1);
                                    if (modificationMatchEndEnd == null) {
                                        matrix[k + 1].add(newEndCell);
                                    } else {
                                        MatrixContent newEndEndCell = new MatrixContent(leftIndex, rightIndex, 0, newEndCell, 0.0, null, null, length + 1, 0, k, modificationMatchEndEnd, null, -1);
                                        matrix[k + 1].add(newEndEndCell);
                                    }
                                    if (withinMass) {
                                        matrix[k + 1].getLast().XMassDiff = XmassDiff;
                                    }
                                    matrix[k + 1].getLast().numX = 0;
                                    continue;
                                }
                                if (newNumX > 0 && !withinMass) continue;
                                matrix[k + 1].add(newCell);
                                matrix[k + 1].getLast().numX = 0;
                                if (!withinMass) continue;
                                matrix[k + 1].getLast().XMassDiff = XmassDiff;
                                continue;
                            }
                            if (length <= 1) continue;
                            int lastAcid = cell.character;
                            double massDiff = combinationMass - oldMass;
                            ModificationMatch modificationMatchEnd = null;
                            ModificationMatch modificationMatchEndEnd = null;
                            boolean withinMass = false;
                            double XmassDiff = -1.0;
                            ArrayList<String> fmod = this.fmodc;
                            ArrayList<Double> fmodMass = this.fmodcMass;
                            ArrayList<String>[] fmodaa = this.fmodcaa;
                            ArrayList<Double>[] fmodaaMass = this.fmodcaaMass;
                            ArrayList<String> vmod = this.vmodc;
                            ArrayList<Double> vmodMass = this.vmodcMass;
                            ArrayList<String>[] vmodaa = this.vmodcaa;
                            ArrayList<Double>[] vmodaaMass = this.vmodcaaMass;
                            ArrayList<String> fmodp = this.fmodcp;
                            ArrayList<Double> fmodpMass = this.fmodcpMass;
                            ArrayList<String>[] fmodpaa = this.fmodcpaa;
                            ArrayList<Double>[] fmodpaaMass = this.fmodcpaaMass;
                            ArrayList<String> vmodp = this.vmodcp;
                            ArrayList<Double> vmodpMass = this.vmodcpMass;
                            ArrayList<String>[] vmodpaa = this.vmodcpaa;
                            ArrayList<Double>[] vmodpaaMass = this.vmodcpaaMass;
                            if (!CTermDirection) {
                                fmod = this.fmodn;
                                fmodMass = this.fmodnMass;
                                fmodaa = this.fmodnaa;
                                fmodaaMass = this.fmodnaaMass;
                                vmod = this.vmodn;
                                vmodMass = this.vmodnMass;
                                vmodaa = this.vmodnaa;
                                vmodaaMass = this.vmodnaaMass;
                                fmodp = this.fmodnp;
                                fmodpMass = this.fmodnpMass;
                                fmodpaa = this.fmodnpaa;
                                fmodpaaMass = this.fmodnpaaMass;
                                vmodp = this.vmodnp;
                                vmodpMass = this.vmodnpMass;
                                vmodpaa = this.vmodnpaa;
                                vmodpaaMass = this.vmodnpaaMass;
                            }
                            if (fmodaa != null && lastAcid > 0 && fmodaaMass[lastAcid].size() > 0) {
                                for (i = 0; i < fmodaaMass[lastAcid].size(); ++i) {
                                    double massDiffDiffV3;
                                    int j;
                                    double massDiffDiff = massDiff - fmodaaMass[lastAcid].get(i);
                                    double mDD = oldMass + fmodaaMass[lastAcid].get(i);
                                    massDiffDiffAbs = Math.abs(massDiffDiff);
                                    wmt = this.withinMassTolerance(massDiffDiffAbs, newNumX);
                                    if (this.computeMassValue(mDD, combinationMass) < this.massTolerance || wmt) {
                                        withinMass |= wmt;
                                        XmassDiff = massDiffDiffAbs;
                                        modificationMatchEnd = new ModificationMatch(fmodaa[lastAcid].get(i), false, length);
                                    }
                                    if (vmodaa != null && lastAcid > 0 && vmodaaMass[lastAcid].size() > 0) {
                                        for (j = 0; j < vmodaaMass[lastAcid].size(); ++j) {
                                            massDiffDiffV3 = Math.abs(massDiffDiff - vmodaaMass[lastAcid].get(j));
                                            wmtV2 = this.withinMassTolerance(massDiffDiffV3, newNumX);
                                            if (!(this.computeMassValue(mDD + vmodaaMass[lastAcid].get(j), combinationMass) < this.massTolerance) && !wmtV2) continue;
                                            withinMass |= wmtV2;
                                            XmassDiff = massDiffDiffV3;
                                            modificationMatchEnd = new ModificationMatch(fmodaa[lastAcid].get(i), false, length);
                                            modificationMatchEndEnd = new ModificationMatch(vmodaa[lastAcid].get(j), true, length);
                                        }
                                    }
                                    if (vmod != null && modificationMatchEnd == null) {
                                        for (j = 0; j < vmod.size(); ++j) {
                                            massDiffDiffV3 = Math.abs(massDiffDiff - vmodMass.get(j));
                                            wmtV2 = this.withinMassTolerance(massDiffDiffV3, newNumX);
                                            if (!(this.computeMassValue(mDD + vmodMass.get(j), combinationMass) < this.massTolerance) && !wmtV2) continue;
                                            withinMass |= wmtV2;
                                            XmassDiff = massDiffDiffV3;
                                            modificationMatchEnd = new ModificationMatch(fmodaa[lastAcid].get(i), false, length);
                                            modificationMatchEndEnd = new ModificationMatch(vmod.get(j), false, length);
                                        }
                                    }
                                    boolean hasFixedPep2 = false;
                                    if (fmodpaa != null && lastAcid > 0 && fmodpaaMass[lastAcid].size() > 0) {
                                        for (int j2 = 0; j2 < fmodpaaMass[lastAcid].size(); ++j2) {
                                            massDiffDiffV = Math.abs(massDiffDiff - fmodpaaMass[lastAcid].get(j2));
                                            wmtV = this.withinMassTolerance(massDiffDiffV, newNumX);
                                            if (!(this.computeMassValue(mDD + fmodpaaMass[lastAcid].get(j2), combinationMass) < this.massTolerance) && !wmtV) continue;
                                            hasFixedPep2 = true;
                                            withinMass |= wmtV;
                                            XmassDiff = massDiffDiffV;
                                            modificationMatchEnd = new ModificationMatch(fmodaa[lastAcid].get(i), false, length);
                                            modificationMatchEndEnd = new ModificationMatch(fmodpaa[lastAcid].get(j2), false, length);
                                        }
                                    }
                                    if (fmodp != null) {
                                        for (int j3 = 0; j3 < fmodp.size(); ++j3) {
                                            massDiffDiffV = Math.abs(massDiffDiff - fmodpMass.get(j3));
                                            wmtV = this.withinMassTolerance(massDiffDiffV, newNumX);
                                            if (!(this.computeMassValue(mDD + fmodpMass.get(j3), combinationMass) < this.massTolerance) && !wmtV) continue;
                                            hasFixedPep2 = true;
                                            withinMass |= wmtV;
                                            XmassDiff = massDiffDiffV;
                                            modificationMatchEnd = new ModificationMatch(fmodaa[lastAcid].get(i), false, length);
                                            modificationMatchEndEnd = new ModificationMatch(fmodp.get(j3), false, length);
                                        }
                                    }
                                    if (hasFixedPep2) continue;
                                    if (vmodpaa != null && lastAcid > 0 && vmodpaaMass[lastAcid].size() > 0) {
                                        for (int j4 = 0; j4 < vmodpaaMass[lastAcid].size(); ++j4) {
                                            massDiffDiffV = Math.abs(massDiffDiff - vmodpaaMass[lastAcid].get(j4));
                                            wmtV = this.withinMassTolerance(massDiffDiffV, newNumX);
                                            if (!(this.computeMassValue(mDD + vmodpaaMass[lastAcid].get(j4), combinationMass) < this.massTolerance) && !wmtV) continue;
                                            withinMass |= wmtV;
                                            XmassDiff = massDiffDiffV;
                                            modificationMatchEnd = new ModificationMatch(fmodaa[lastAcid].get(i), true, length);
                                            modificationMatchEndEnd = new ModificationMatch(vmodpaa[lastAcid].get(j4), true, length);
                                        }
                                    }
                                    if (vmodp == null) continue;
                                    for (int j5 = 0; j5 < vmodp.size(); ++j5) {
                                        massDiffDiffV = Math.abs(massDiffDiff - vmodpMass.get(j5));
                                        wmtV = this.withinMassTolerance(massDiffDiffV, newNumX);
                                        if (!(this.computeMassValue(mDD + vmodpMass.get(j5), combinationMass) < this.massTolerance) && !wmtV) continue;
                                        withinMass |= wmtV;
                                        XmassDiff = massDiffDiffV;
                                        modificationMatchEnd = new ModificationMatch(fmodaa[lastAcid].get(i), true, length);
                                        modificationMatchEndEnd = new ModificationMatch(vmodp.get(j5), true, length);
                                    }
                                }
                            }
                            if (fmod != null && modificationMatchEnd == null) {
                                for (i = 0; i < fmod.size(); ++i) {
                                    int j;
                                    double massDiffDiff = massDiff - fmodMass.get(i);
                                    double mDD = oldMass + fmodMass.get(i);
                                    massDiffDiffAbs = Math.abs(massDiffDiff);
                                    wmt = this.withinMassTolerance(massDiffDiffAbs, newNumX);
                                    if (this.computeMassValue(mDD, combinationMass) < this.massTolerance || wmt) {
                                        withinMass |= wmt;
                                        XmassDiff = massDiffDiffAbs;
                                        modificationMatchEnd = new ModificationMatch(fmod.get(i), false, length);
                                    }
                                    if (vmodaa != null && lastAcid > 0 && vmodaaMass[lastAcid].size() > 0) {
                                        for (j = 0; j < vmodaaMass[lastAcid].size(); ++j) {
                                            double massDiffV = Math.abs(massDiff - vmodaaMass[lastAcid].get(j));
                                            wmtV2 = this.withinMassTolerance(massDiffV, newNumX);
                                            if (!(this.computeMassValue(vmodaaMass[lastAcid].get(j) + oldMass, combinationMass) < this.massTolerance) && !wmtV2) continue;
                                            withinMass |= wmtV2;
                                            XmassDiff = massDiffV;
                                            modificationMatchEnd = new ModificationMatch(fmod.get(i), false, length);
                                            modificationMatchEndEnd = new ModificationMatch(vmodaa[lastAcid].get(j), true, length);
                                        }
                                    }
                                    if (vmod != null && modificationMatchEnd == null) {
                                        for (j = 0; j < vmod.size(); ++j) {
                                            double massDiffV = Math.abs(massDiff - vmodMass.get(j));
                                            wmtV2 = this.withinMassTolerance(massDiffV, newNumX);
                                            if (!(this.computeMassValue(vmodMass.get(j) + oldMass, combinationMass) < this.massTolerance) && !wmtV2) continue;
                                            withinMass |= wmtV2;
                                            XmassDiff = massDiffV;
                                            modificationMatchEnd = new ModificationMatch(fmod.get(i), false, length);
                                            modificationMatchEndEnd = new ModificationMatch(vmod.get(j), false, length);
                                        }
                                    }
                                    hasFixedPep = false;
                                    if (fmodpaa != null && lastAcid > 0 && fmodpaaMass[lastAcid].size() > 0) {
                                        for (int j6 = 0; j6 < fmodpaaMass[lastAcid].size(); ++j6) {
                                            massDiffDiffV = Math.abs(massDiffDiff - fmodpaaMass[lastAcid].get(j6));
                                            wmtV = this.withinMassTolerance(massDiffDiffV, newNumX);
                                            if (!(this.computeMassValue(mDD + fmodpaaMass[lastAcid].get(j6), combinationMass) < this.massTolerance) && !wmtV) continue;
                                            hasFixedPep = true;
                                            withinMass |= wmtV;
                                            XmassDiff = massDiffDiffV;
                                            modificationMatchEnd = new ModificationMatch(fmod.get(i), false, length);
                                            modificationMatchEndEnd = new ModificationMatch(fmodpaa[lastAcid].get(j6), false, length);
                                        }
                                    }
                                    if (fmodp != null) {
                                        for (int j7 = 0; j7 < fmodp.size(); ++j7) {
                                            massDiffDiffV = Math.abs(massDiffDiff - fmodpMass.get(j7));
                                            wmtV = this.withinMassTolerance(massDiffDiffV, newNumX);
                                            if (!(this.computeMassValue(mDD + fmodpMass.get(j7), combinationMass) < this.massTolerance) && !wmtV) continue;
                                            hasFixedPep = true;
                                            withinMass |= wmtV;
                                            XmassDiff = massDiffDiffV;
                                            modificationMatchEnd = new ModificationMatch(fmod.get(i), false, length);
                                            modificationMatchEndEnd = new ModificationMatch(fmodp.get(j7), false, length);
                                        }
                                    }
                                    if (hasFixedPep) continue;
                                    if (vmodpaa != null && lastAcid > 0 && vmodpaaMass[lastAcid].size() > 0) {
                                        for (int j8 = 0; j8 < vmodpaaMass[lastAcid].size(); ++j8) {
                                            massDiffDiffV = Math.abs(massDiffDiff - vmodpaaMass[lastAcid].get(j8));
                                            wmtV = this.withinMassTolerance(massDiffDiffV, newNumX);
                                            if (!(this.computeMassValue(mDD + vmodpaaMass[lastAcid].get(j8), combinationMass) < this.massTolerance) && !wmtV) continue;
                                            withinMass |= wmtV;
                                            XmassDiff = massDiffDiffV;
                                            modificationMatchEnd = new ModificationMatch(fmod.get(i), false, length);
                                            modificationMatchEndEnd = new ModificationMatch(vmodpaa[lastAcid].get(j8), true, length);
                                        }
                                    }
                                    if (vmodp == null) continue;
                                    for (int j9 = 0; j9 < vmodp.size(); ++j9) {
                                        massDiffDiffV = Math.abs(massDiffDiff - vmodpMass.get(j9));
                                        wmtV = this.withinMassTolerance(massDiffDiffV, newNumX);
                                        if (!(this.computeMassValue(mDD + vmodpMass.get(j9), combinationMass) < this.massTolerance) && !wmtV) continue;
                                        withinMass |= wmtV;
                                        XmassDiff = massDiffDiffV;
                                        modificationMatchEnd = new ModificationMatch(fmod.get(i), false, length);
                                        modificationMatchEndEnd = new ModificationMatch(vmodp.get(j9), true, length);
                                    }
                                }
                            }
                            if (modificationMatchEnd == null) {
                                if (vmodaa != null && lastAcid > 0 && vmodaaMass[lastAcid].size() > 0) {
                                    for (i = 0; i < vmodaaMass[lastAcid].size(); ++i) {
                                        int j;
                                        double massDiffDiff = massDiff - vmodaaMass[lastAcid].get(i);
                                        double mDD = oldMass + vmodaaMass[lastAcid].get(i);
                                        massDiffDiffAbs = Math.abs(massDiffDiff);
                                        wmt = this.withinMassTolerance(massDiffDiffAbs, newNumX);
                                        if (this.computeMassValue(mDD, combinationMass) < this.massTolerance || wmt) {
                                            withinMass |= wmt;
                                            XmassDiff = massDiffDiffAbs;
                                            modificationMatchEnd = new ModificationMatch(vmodaa[lastAcid].get(i), true, length);
                                        }
                                        hasFixedPep = false;
                                        if (fmodpaa != null && lastAcid > 0 && fmodpaaMass[lastAcid].size() > 0) {
                                            for (j = 0; j < fmodpaaMass[lastAcid].size(); ++j) {
                                                massDiffDiffV = Math.abs(massDiffDiff - fmodpaaMass[lastAcid].get(j));
                                                wmtV = this.withinMassTolerance(massDiffDiffV, newNumX);
                                                if (!(this.computeMassValue(mDD + fmodpaaMass[lastAcid].get(j), combinationMass) < this.massTolerance) && !wmtV) continue;
                                                hasFixedPep = true;
                                                withinMass |= wmtV;
                                                XmassDiff = massDiffDiffV;
                                                modificationMatchEnd = new ModificationMatch(vmodaa[lastAcid].get(i), true, length);
                                                modificationMatchEndEnd = new ModificationMatch(fmodpaa[lastAcid].get(j), false, length);
                                            }
                                        }
                                        if (fmodp != null) {
                                            for (j = 0; j < fmodp.size(); ++j) {
                                                massDiffDiffV = Math.abs(massDiffDiff - fmodpMass.get(j));
                                                wmtV = this.withinMassTolerance(massDiffDiffV, newNumX);
                                                if (!(this.computeMassValue(mDD + fmodpMass.get(j), combinationMass) < this.massTolerance) && !wmtV) continue;
                                                hasFixedPep = true;
                                                withinMass |= wmtV;
                                                XmassDiff = massDiffDiffV;
                                                modificationMatchEnd = new ModificationMatch(vmodaa[lastAcid].get(i), true, length);
                                                modificationMatchEndEnd = new ModificationMatch(fmodp.get(j), false, length);
                                            }
                                        }
                                        if (hasFixedPep) continue;
                                        if (vmodpaa != null && lastAcid > 0 && vmodpaaMass[lastAcid].size() > 0) {
                                            for (j = 0; j < vmodpaaMass[lastAcid].size(); ++j) {
                                                massDiffDiffV = Math.abs(massDiffDiff - vmodpaaMass[lastAcid].get(j));
                                                wmtV = this.withinMassTolerance(massDiffDiffV, newNumX);
                                                if (!(this.computeMassValue(mDD + vmodpaaMass[lastAcid].get(j), combinationMass) < this.massTolerance) && !wmtV) continue;
                                                withinMass |= wmtV;
                                                XmassDiff = massDiffDiffV;
                                                modificationMatchEnd = new ModificationMatch(vmodaa[lastAcid].get(i), true, length);
                                                modificationMatchEndEnd = new ModificationMatch(vmodpaa[lastAcid].get(j), true, length);
                                            }
                                        }
                                        if (vmodp == null) continue;
                                        for (j = 0; j < vmodp.size(); ++j) {
                                            massDiffDiffV = Math.abs(massDiffDiff - vmodpMass.get(j));
                                            wmtV = this.withinMassTolerance(massDiffDiffV, newNumX);
                                            if (!(this.computeMassValue(mDD + vmodpMass.get(j), combinationMass) < this.massTolerance) && !wmtV) continue;
                                            withinMass |= wmtV;
                                            XmassDiff = massDiffDiffV;
                                            modificationMatchEnd = new ModificationMatch(vmodaa[lastAcid].get(i), true, length);
                                            modificationMatchEndEnd = new ModificationMatch(vmodp.get(j), true, length);
                                        }
                                    }
                                }
                                if (vmod != null && modificationMatchEnd == null) {
                                    for (i = 0; i < vmod.size(); ++i) {
                                        int j;
                                        double massDiffDiff = massDiff - vmodMass.get(i);
                                        double mDD = oldMass + vmodMass.get(i);
                                        massDiffDiffAbs = Math.abs(massDiffDiff);
                                        wmt = this.withinMassTolerance(massDiffDiffAbs, newNumX);
                                        if (this.computeMassValue(mDD, combinationMass) < this.massTolerance || wmt) {
                                            withinMass |= wmt;
                                            XmassDiff = massDiffDiffAbs;
                                            modificationMatchEnd = new ModificationMatch(vmod.get(i), false, length);
                                        }
                                        hasFixedPep = false;
                                        if (fmodpaa != null && lastAcid > 0 && fmodpaaMass[lastAcid].size() > 0) {
                                            for (j = 0; j < fmodpaaMass[lastAcid].size(); ++j) {
                                                massDiffDiffV = Math.abs(massDiffDiff - fmodpaaMass[lastAcid].get(j));
                                                wmtV = this.withinMassTolerance(massDiffDiffV, newNumX);
                                                if (!(this.computeMassValue(mDD + fmodpaaMass[lastAcid].get(j), combinationMass) < this.massTolerance) && !wmtV) continue;
                                                hasFixedPep = true;
                                                withinMass |= wmtV;
                                                XmassDiff = massDiffDiffV;
                                                modificationMatchEnd = new ModificationMatch(vmod.get(i), false, length);
                                                modificationMatchEndEnd = new ModificationMatch(fmodpaa[lastAcid].get(j), false, length);
                                            }
                                        }
                                        if (fmodp != null) {
                                            for (j = 0; j < fmodp.size(); ++j) {
                                                massDiffDiffV = Math.abs(massDiffDiff - fmodpMass.get(j));
                                                wmtV = this.withinMassTolerance(massDiffDiffV, newNumX);
                                                if (!(this.computeMassValue(mDD + fmodpMass.get(j), combinationMass) < this.massTolerance) && !wmtV) continue;
                                                hasFixedPep = true;
                                                withinMass |= wmtV;
                                                XmassDiff = massDiffDiffV;
                                                modificationMatchEnd = new ModificationMatch(vmod.get(i), false, length);
                                                modificationMatchEndEnd = new ModificationMatch(fmodp.get(j), false, length);
                                            }
                                        }
                                        if (hasFixedPep) continue;
                                        if (vmodpaa != null && lastAcid > 0 && vmodpaaMass[lastAcid].size() > 0) {
                                            for (j = 0; j < vmodpaaMass[lastAcid].size(); ++j) {
                                                massDiffDiffV = Math.abs(massDiffDiff - vmodpaaMass[lastAcid].get(j));
                                                wmtV = this.withinMassTolerance(massDiffDiffV, newNumX);
                                                if (!(this.computeMassValue(mDD + vmodpaaMass[lastAcid].get(j), combinationMass) < this.massTolerance) && !wmtV) continue;
                                                withinMass |= wmtV;
                                                XmassDiff = massDiffDiffV;
                                                modificationMatchEnd = new ModificationMatch(vmod.get(i), false, length);
                                                modificationMatchEndEnd = new ModificationMatch(vmodpaa[lastAcid].get(j), true, length);
                                            }
                                        }
                                        if (vmodp == null) continue;
                                        for (j = 0; j < vmodp.size(); ++j) {
                                            massDiffDiffV = Math.abs(massDiffDiff - vmodpMass.get(j));
                                            wmtV = this.withinMassTolerance(massDiffDiffV, newNumX);
                                            if (!(this.computeMassValue(mDD + vmodpMass.get(j), combinationMass) < this.massTolerance) && !wmtV) continue;
                                            withinMass |= wmtV;
                                            XmassDiff = massDiffDiffV;
                                            modificationMatchEnd = new ModificationMatch(vmod.get(i), false, length);
                                            modificationMatchEndEnd = new ModificationMatch(vmodp.get(j), true, length);
                                        }
                                    }
                                }
                            }
                            if (modificationMatchEnd == null) continue;
                            MatrixContent newEndCell = new MatrixContent(leftIndexOld, rightIndexOld, 0, cell, 0.0, null, null, length, 0, k, modificationMatchEnd, null, -1);
                            if (modificationMatchEndEnd == null) {
                                matrix[k + 1].add(newEndCell);
                            } else {
                                MatrixContent newEndEndCell = new MatrixContent(leftIndexOld, rightIndexOld, 0, newEndCell, 0.0, null, null, length, 0, k, modificationMatchEndEnd, null, -1);
                                matrix[k + 1].add(newEndEndCell);
                            }
                            if (withinMass) {
                                matrix[k + 1].getLast().XMassDiff = XmassDiff;
                            }
                            matrix[k + 1].getLast().numX = 0;
                        }
                        continue;
                    }
                    for (b = 0; b < setCharacter[this.numMasses][0]; ++b) {
                        double newMass;
                        borders = setCharacter[b];
                        aminoAcid = borders[0];
                        if (aminoAcid == 47 || !((newMass = oldMass + (aminoAcid != 88 ? this.aaMasses[borders[3]] : 0.0)) - this.massTolerance <= combinationMass)) continue;
                        int aminoAcidSearch = borders[4] == -1 ? aminoAcid : borders[4];
                        int lessValue = less[aminoAcidSearch];
                        int leftIndex = lessValue + borders[1];
                        int rightIndex = lessValue + borders[2] - 1;
                        int newNumX = cell.numX + (aminoAcid == 88 ? 1 : 0);
                        if (newNumX > combination.xNumLimit) continue;
                        double massDiff = Math.abs(combinationMass - newMass);
                        int intMass = (int)(massDiff * this.lookupMultiplier);
                        if (massDiff > this.massTolerance && massDiff < this.lookupMaxMass && (this.lookupMasses[intMass >>> 6] >>> (intMass & 0x3F) & 1L) == 0L) continue;
                        boolean withinMass = this.withinMassTolerance(massDiff, newNumX);
                        int offset = (this.computeMassValue(newMass, combinationMass) <= this.massTolerance ? 1 : 0) | (withinMass ? 1 : 0);
                        if (offset > 0) {
                            newNumX = 0;
                        }
                        matrix[k + offset].add(new MatrixContent(leftIndex, rightIndex, aminoAcid, cell, newMass, length + 1, newNumX, borders[3], borders[4], k));
                        if (!withinMass) continue;
                        matrix[k + offset].getLast().XMassDiff = massDiff;
                    }
                    continue;
                }
                String combinationSequence = combination.sequence;
                int xNumLimit = combination.xNumLimit;
                char aminoAcid = combinationSequence.charAt(0);
                for (int i = 0; i < combinationSequence.length(); ++i) {
                    char aminoAcidSearch = combinationSequence.charAt(i);
                    int lessValue = less[aminoAcidSearch];
                    int[] range = occurrence.singleRangeQuery(leftIndexOld - 1, rightIndexOld, aminoAcidSearch);
                    int leftIndex = lessValue + range[0];
                    int rightIndex = lessValue + range[1] - 1;
                    int newNumX = cell.numX + (aminoAcidSearch == 'X' ? 1 : 0);
                    if (leftIndex > rightIndex || newNumX > xNumLimit) continue;
                    if (k < combinations.length - 1 && combinations[k].isMass != combinations[k + 1].isMass) {
                        newNumX = 0;
                    }
                    matrix[k + 1].add(new MatrixContent(leftIndex, rightIndex, aminoAcid, cell, 0.0, length + 1, newNumX, -1, aminoAcidSearch, k));
                }
            }
        }
    }

    private void mappingSequenceAndMassesDA(TagElement[] combinations, LinkedList<MatrixContent>[] matrix, int[] less, WaveletTree occurrence, boolean CTermDirection) {
        int lenCombinations = combinations.length;
        for (int k = 0; k < lenCombinations; ++k) {
            TagElement combination = combinations[k];
            LinkedList<MatrixContent> content = matrix[k];
            while (!content.isEmpty()) {
                MatrixContent cell = content.removeFirst();
                int length = cell.length;
                int leftIndexOld = cell.left;
                int rightIndexOld = cell.right;
                if (combination.isMass) {
                    int aminoAcid;
                    int[] borders;
                    int b;
                    double combinationMass = combination.mass;
                    double oldMass = cell.mass;
                    int[][] setCharacter = occurrence.rangeQuery(leftIndexOld - 1, rightIndexOld);
                    this.addAmbiguous(setCharacter);
                    if (this.withVariableModifications) {
                        this.addModifications(setCharacter);
                    }
                    if (k == lenCombinations - 1) {
                        for (b = 0; b < setCharacter[this.numMasses][0]; ++b) {
                            boolean hasFixedPep;
                            boolean wmtV;
                            int j;
                            boolean wmt;
                            int i;
                            boolean wmtV2;
                            double massDiffDiffV;
                            borders = setCharacter[b];
                            aminoAcid = borders[0];
                            int newNumX = cell.numX + (aminoAcid == 88 ? 1 : 0);
                            if (newNumX > combination.xNumLimit) continue;
                            if (aminoAcid != 47) {
                                int j2;
                                boolean wmt2;
                                double massDiffDiffAbs;
                                double massDiffDiff;
                                int i2;
                                int aminoAcidSearch = borders[4] == -1 ? aminoAcid : borders[4];
                                double newMass = oldMass + (aminoAcid != 88 ? this.aaMasses[borders[3]] : 0.0);
                                double massDiff = combinationMass - newMass;
                                int lastAcid = aminoAcid;
                                int lessValue = less[aminoAcidSearch];
                                int leftIndex = lessValue + borders[1];
                                int rightIndex = lessValue + borders[2] - 1;
                                MatrixContent newCell = new MatrixContent(leftIndex, rightIndex, aminoAcid, cell, newMass, length + 1, newNumX, borders[3], borders[4], k);
                                ModificationMatch modificationMatchEnd = null;
                                ModificationMatch modificationMatchEndEnd = null;
                                ArrayList<String> fmodp = this.fmodcp;
                                ArrayList<Double> fmodpMass = this.fmodcpMass;
                                ArrayList<String>[] fmodpaa = this.fmodcpaa;
                                ArrayList<Double>[] fmodpaaMass = this.fmodcpaaMass;
                                ArrayList<String> vmodp = this.vmodcp;
                                ArrayList<Double> vmodpMass = this.vmodcpMass;
                                ArrayList<String>[] vmodpaa = this.vmodcpaa;
                                ArrayList<Double>[] vmodpaaMass = this.vmodcpaaMass;
                                boolean hasFixedPTM_atTerminus = this.hasFixedPTM_CatTerminus;
                                if (!CTermDirection) {
                                    fmodp = this.fmodnp;
                                    fmodpMass = this.fmodnpMass;
                                    fmodpaa = this.fmodnpaa;
                                    fmodpaaMass = this.fmodnpaaMass;
                                    vmodp = this.vmodnp;
                                    vmodpMass = this.vmodnpMass;
                                    vmodpaa = this.vmodnpaa;
                                    vmodpaaMass = this.vmodnpaaMass;
                                    hasFixedPTM_atTerminus = this.hasFixedPTM_NatTerminus;
                                }
                                boolean hasFixed = false;
                                boolean withinMass = false;
                                double XmassDiff = -1.0 - this.massTolerance;
                                if (fmodpaa != null && lastAcid > 0 && fmodpaaMass[lastAcid].size() > 0) {
                                    hasFixed = true;
                                    for (i2 = 0; i2 < fmodpaaMass[lastAcid].size(); ++i2) {
                                        massDiffDiff = Math.abs(massDiff - fmodpaaMass[lastAcid].get(i2));
                                        massDiffDiffAbs = Math.abs(massDiffDiff);
                                        wmt2 = this.withinMassTolerance(massDiffDiffAbs, newNumX);
                                        if (massDiffDiffAbs < this.massTolerance || wmt2) {
                                            withinMass |= wmt2;
                                            XmassDiff = massDiffDiffAbs;
                                            modificationMatchEnd = new ModificationMatch(fmodpaa[lastAcid].get(i2), false, length + 1);
                                        }
                                        if (XmassDiff < -this.massTolerance && vmodpaa != null && lastAcid > 0 && vmodpaaMass[lastAcid].size() > 0) {
                                            for (j2 = 0; j2 < vmodpaaMass[lastAcid].size(); ++j2) {
                                                massDiffDiffV = Math.abs(massDiffDiff - vmodpaaMass[lastAcid].get(j2));
                                                wmtV2 = this.withinMassTolerance(massDiffDiffV, newNumX);
                                                if (!(massDiffDiffV < this.massTolerance) && !wmtV2) continue;
                                                withinMass |= wmtV2;
                                                XmassDiff = massDiffDiffV;
                                                modificationMatchEnd = new ModificationMatch(fmodpaa[lastAcid].get(i2), false, length + 1);
                                                modificationMatchEndEnd = new ModificationMatch(vmodpaa[lastAcid].get(j2), true, length + 1);
                                            }
                                        }
                                        if (!(XmassDiff < -this.massTolerance) || vmodp == null) continue;
                                        for (j2 = 0; j2 < vmodp.size(); ++j2) {
                                            massDiffDiffV = Math.abs(massDiffDiff - vmodpMass.get(j2));
                                            wmtV2 = this.withinMassTolerance(massDiffDiffV, newNumX);
                                            if (!(massDiffDiffV < this.massTolerance) && !wmtV2) continue;
                                            withinMass |= wmtV2;
                                            XmassDiff = massDiffDiffV;
                                            modificationMatchEnd = new ModificationMatch(fmodpaa[lastAcid].get(i2), false, length + 1);
                                            modificationMatchEndEnd = new ModificationMatch(vmodp.get(j2), false, length + 1);
                                        }
                                    }
                                }
                                if (fmodp != null && XmassDiff < -this.massTolerance) {
                                    hasFixed = true;
                                    for (i2 = 0; i2 < fmodp.size(); ++i2) {
                                        massDiffDiff = massDiff - fmodpMass.get(i2);
                                        massDiffDiffAbs = Math.abs(massDiffDiff);
                                        wmt2 = this.withinMassTolerance(massDiffDiffAbs, newNumX);
                                        if (massDiffDiffAbs < this.massTolerance || wmt2) {
                                            withinMass |= wmt2;
                                            XmassDiff = massDiffDiffAbs;
                                            modificationMatchEnd = new ModificationMatch(fmodp.get(i2), false, length + 1);
                                        }
                                        if (XmassDiff < -this.massTolerance && vmodpaa != null && lastAcid > 0 && vmodpaaMass[lastAcid].size() > 0) {
                                            for (j2 = 0; j2 < vmodpaaMass[lastAcid].size(); ++j2) {
                                                massDiffDiffV = Math.abs(massDiffDiff - vmodpaaMass[lastAcid].get(j2));
                                                wmtV2 = this.withinMassTolerance(massDiffDiffV, newNumX);
                                                if (!(massDiffDiffV < this.massTolerance) && !wmtV2) continue;
                                                withinMass |= wmtV2;
                                                XmassDiff = massDiffDiffV;
                                                modificationMatchEnd = new ModificationMatch(fmodp.get(i2), false, length + 1);
                                                modificationMatchEndEnd = new ModificationMatch(vmodpaa[lastAcid].get(j2), true, length + 1);
                                            }
                                        }
                                        if (!(XmassDiff < -this.massTolerance) || vmodp == null) continue;
                                        for (j2 = 0; j2 < vmodp.size(); ++j2) {
                                            massDiffDiffV = Math.abs(massDiffDiff - vmodpMass.get(j2));
                                            wmtV2 = this.withinMassTolerance(massDiffDiffV, newNumX);
                                            if (!(massDiffDiffV < this.massTolerance) && !wmtV2) continue;
                                            withinMass |= wmtV2;
                                            XmassDiff = massDiffDiffV;
                                            modificationMatchEnd = new ModificationMatch(fmodp.get(i2), false, length + 1);
                                            modificationMatchEndEnd = new ModificationMatch(vmodp.get(j2), false, length + 1);
                                        }
                                    }
                                }
                                if (!hasFixedPTM_atTerminus && !hasFixed && XmassDiff < -this.massTolerance) {
                                    boolean wmtV3;
                                    double massDiffV;
                                    double massDiffF = Math.abs(massDiff);
                                    boolean wmt3 = this.withinMassTolerance(massDiffF, newNumX);
                                    if (massDiffF < this.massTolerance || wmt3) {
                                        withinMass |= wmt3;
                                        XmassDiff = massDiffF;
                                    }
                                    if (XmassDiff < -this.massTolerance && vmodpaa != null && lastAcid > 0 && vmodpaaMass[lastAcid].size() > 0) {
                                        for (int i3 = 0; i3 < vmodpaaMass[lastAcid].size(); ++i3) {
                                            massDiffV = Math.abs(massDiff - vmodpaaMass[lastAcid].get(i3));
                                            wmtV3 = this.withinMassTolerance(massDiffV, newNumX);
                                            if (!(massDiffV < this.massTolerance) && !wmtV3) continue;
                                            withinMass |= wmtV3;
                                            XmassDiff = massDiffV;
                                            modificationMatchEnd = new ModificationMatch(vmodpaa[lastAcid].get(i3), true, length + 1);
                                        }
                                    }
                                    if (XmassDiff < -this.massTolerance && vmodp != null) {
                                        for (int i4 = 0; i4 < vmodp.size(); ++i4) {
                                            massDiffV = Math.abs(massDiff - vmodpMass.get(i4));
                                            wmtV3 = this.withinMassTolerance(massDiffV, newNumX);
                                            if (!(massDiffV < this.massTolerance) && !wmtV3) continue;
                                            withinMass |= wmtV3;
                                            XmassDiff = massDiffV;
                                            modificationMatchEnd = new ModificationMatch(vmodp.get(i4), false, length + 1);
                                        }
                                    }
                                }
                                if (XmassDiff < -this.massTolerance) {
                                    if (!(newMass - this.massTolerance + this.negativePTMMass <= combinationMass)) continue;
                                    content.add(newCell);
                                    continue;
                                }
                                if (modificationMatchEnd != null) {
                                    if (newNumX > 0 && !withinMass) continue;
                                    MatrixContent newEndCell = new MatrixContent(leftIndex, rightIndex, 0, newCell, 0.0, null, null, length + 1, 0, k, modificationMatchEnd, null, -1);
                                    if (modificationMatchEndEnd == null) {
                                        matrix[k + 1].add(newEndCell);
                                    } else {
                                        MatrixContent newEndEndCell = new MatrixContent(leftIndex, rightIndex, 0, newEndCell, 0.0, null, null, length + 1, 0, k, modificationMatchEndEnd, null, -1);
                                        matrix[k + 1].add(newEndEndCell);
                                    }
                                    if (withinMass) {
                                        matrix[k + 1].getLast().XMassDiff = XmassDiff;
                                    }
                                    matrix[k + 1].getLast().numX = 0;
                                    continue;
                                }
                                if (newNumX > 0 && !withinMass) continue;
                                matrix[k + 1].add(newCell);
                                matrix[k + 1].getLast().numX = 0;
                                if (!withinMass) continue;
                                matrix[k + 1].getLast().XMassDiff = XmassDiff;
                                continue;
                            }
                            if (length <= 1) continue;
                            int lastAcid = cell.character;
                            double massDiff = combinationMass - oldMass;
                            ModificationMatch modificationMatchEnd = null;
                            ModificationMatch modificationMatchEndEnd = null;
                            boolean withinMass = false;
                            double XmassDiff = -1.0;
                            ArrayList<String> fmod = this.fmodc;
                            ArrayList<Double> fmodMass = this.fmodcMass;
                            ArrayList<String>[] fmodaa = this.fmodcaa;
                            ArrayList<Double>[] fmodaaMass = this.fmodcaaMass;
                            ArrayList<String> vmod = this.vmodc;
                            ArrayList<Double> vmodMass = this.vmodcMass;
                            ArrayList<String>[] vmodaa = this.vmodcaa;
                            ArrayList<Double>[] vmodaaMass = this.vmodcaaMass;
                            ArrayList<String> fmodp = this.fmodcp;
                            ArrayList<Double> fmodpMass = this.fmodcpMass;
                            ArrayList<String>[] fmodpaa = this.fmodcpaa;
                            ArrayList<Double>[] fmodpaaMass = this.fmodcpaaMass;
                            ArrayList<String> vmodp = this.vmodcp;
                            ArrayList<Double> vmodpMass = this.vmodcpMass;
                            ArrayList<String>[] vmodpaa = this.vmodcpaa;
                            ArrayList<Double>[] vmodpaaMass = this.vmodcpaaMass;
                            if (!CTermDirection) {
                                fmod = this.fmodn;
                                fmodMass = this.fmodnMass;
                                fmodaa = this.fmodnaa;
                                fmodaaMass = this.fmodnaaMass;
                                vmod = this.vmodn;
                                vmodMass = this.vmodnMass;
                                vmodaa = this.vmodnaa;
                                vmodaaMass = this.vmodnaaMass;
                                fmodp = this.fmodnp;
                                fmodpMass = this.fmodnpMass;
                                fmodpaa = this.fmodnpaa;
                                fmodpaaMass = this.fmodnpaaMass;
                                vmodp = this.vmodnp;
                                vmodpMass = this.vmodnpMass;
                                vmodpaa = this.vmodnpaa;
                                vmodpaaMass = this.vmodnpaaMass;
                            }
                            if (fmodaa != null && lastAcid > 0 && fmodaaMass[lastAcid].size() > 0) {
                                for (i = 0; i < fmodaaMass[lastAcid].size(); ++i) {
                                    double massDiffDiff = massDiff - fmodaaMass[lastAcid].get(i);
                                    double massDiffDiffAbs = Math.abs(massDiffDiff);
                                    wmt = this.withinMassTolerance(massDiffDiffAbs, newNumX);
                                    if (massDiffDiffAbs < this.massTolerance || wmt) {
                                        withinMass |= wmt;
                                        XmassDiff = massDiffDiffAbs;
                                        modificationMatchEnd = new ModificationMatch(fmodaa[lastAcid].get(i), false, length);
                                    }
                                    if (vmodaa != null && lastAcid > 0 && vmodaaMass[lastAcid].size() > 0) {
                                        for (j = 0; j < vmodaaMass[lastAcid].size(); ++j) {
                                            double massDiffDiffV2 = Math.abs(massDiffDiff - vmodaaMass[lastAcid].get(j));
                                            wmtV = this.withinMassTolerance(massDiffDiffV2, newNumX);
                                            if (!(massDiffDiffV2 < this.massTolerance) && !wmtV) continue;
                                            withinMass |= wmtV;
                                            XmassDiff = massDiffDiffV2;
                                            modificationMatchEnd = new ModificationMatch(fmodaa[lastAcid].get(i), false, length);
                                            modificationMatchEndEnd = new ModificationMatch(vmodaa[lastAcid].get(j), true, length);
                                        }
                                    }
                                    if (vmod != null && modificationMatchEnd == null) {
                                        for (j = 0; j < vmod.size(); ++j) {
                                            double massDiffDiffV3 = Math.abs(massDiffDiff - vmodMass.get(j));
                                            wmtV = this.withinMassTolerance(massDiffDiffV3, newNumX);
                                            if (!(massDiffDiffV3 < this.massTolerance) && !wmtV) continue;
                                            withinMass |= wmtV;
                                            XmassDiff = massDiffDiffV3;
                                            modificationMatchEnd = new ModificationMatch(fmodaa[lastAcid].get(i), false, length);
                                            modificationMatchEndEnd = new ModificationMatch(vmod.get(j), false, length);
                                        }
                                    }
                                    hasFixedPep = false;
                                    if (fmodpaa != null && lastAcid > 0 && fmodpaaMass[lastAcid].size() > 0) {
                                        for (int j3 = 0; j3 < fmodpaaMass[lastAcid].size(); ++j3) {
                                            massDiffDiffV = Math.abs(massDiffDiff - fmodpaaMass[lastAcid].get(j3));
                                            wmtV2 = this.withinMassTolerance(massDiffDiffV, newNumX);
                                            if (!(massDiffDiffV < this.massTolerance) && !wmtV2) continue;
                                            hasFixedPep = true;
                                            withinMass |= wmtV2;
                                            XmassDiff = massDiffDiffV;
                                            modificationMatchEnd = new ModificationMatch(fmodaa[lastAcid].get(i), false, length);
                                            modificationMatchEndEnd = new ModificationMatch(fmodpaa[lastAcid].get(j3), false, length);
                                        }
                                    }
                                    if (fmodp != null) {
                                        for (int j4 = 0; j4 < fmodp.size(); ++j4) {
                                            massDiffDiffV = Math.abs(massDiffDiff - fmodpMass.get(j4));
                                            wmtV2 = this.withinMassTolerance(massDiffDiffV, newNumX);
                                            if (!(massDiffDiffV < this.massTolerance) && !wmtV2) continue;
                                            hasFixedPep = true;
                                            withinMass |= wmtV2;
                                            XmassDiff = massDiffDiffV;
                                            modificationMatchEnd = new ModificationMatch(fmodaa[lastAcid].get(i), false, length);
                                            modificationMatchEndEnd = new ModificationMatch(fmodp.get(j4), false, length);
                                        }
                                    }
                                    if (hasFixedPep) continue;
                                    if (vmodpaa != null && lastAcid > 0 && vmodpaaMass[lastAcid].size() > 0) {
                                        for (int j5 = 0; j5 < vmodpaaMass[lastAcid].size(); ++j5) {
                                            massDiffDiffV = Math.abs(massDiffDiff - vmodpaaMass[lastAcid].get(j5));
                                            wmtV2 = this.withinMassTolerance(massDiffDiffV, newNumX);
                                            if (!(massDiffDiffV < this.massTolerance) && !wmtV2) continue;
                                            withinMass |= wmtV2;
                                            XmassDiff = massDiffDiffV;
                                            modificationMatchEnd = new ModificationMatch(fmodaa[lastAcid].get(i), true, length);
                                            modificationMatchEndEnd = new ModificationMatch(vmodpaa[lastAcid].get(j5), true, length);
                                        }
                                    }
                                    if (vmodp == null) continue;
                                    for (int j6 = 0; j6 < vmodp.size(); ++j6) {
                                        massDiffDiffV = Math.abs(massDiffDiff - vmodpMass.get(j6));
                                        wmtV2 = this.withinMassTolerance(massDiffDiffV, newNumX);
                                        if (!(massDiffDiffV < this.massTolerance) && !wmtV2) continue;
                                        withinMass |= wmtV2;
                                        XmassDiff = massDiffDiffV;
                                        modificationMatchEnd = new ModificationMatch(fmodaa[lastAcid].get(i), true, length);
                                        modificationMatchEndEnd = new ModificationMatch(vmodp.get(j6), true, length);
                                    }
                                }
                            }
                            if (fmod != null && modificationMatchEnd == null) {
                                for (i = 0; i < fmod.size(); ++i) {
                                    double massDiffDiff = massDiff - fmodMass.get(i);
                                    double massDiffDiffAbs = Math.abs(massDiffDiff);
                                    wmt = this.withinMassTolerance(massDiffDiffAbs, newNumX);
                                    if (massDiffDiffAbs < this.massTolerance || wmt) {
                                        withinMass |= wmt;
                                        XmassDiff = massDiffDiffAbs;
                                        modificationMatchEnd = new ModificationMatch(fmod.get(i), false, length);
                                    }
                                    if (vmodaa != null && lastAcid > 0 && vmodaaMass[lastAcid].size() > 0) {
                                        for (j = 0; j < vmodaaMass[lastAcid].size(); ++j) {
                                            double massDiffV = Math.abs(massDiff - vmodaaMass[lastAcid].get(j));
                                            wmtV = this.withinMassTolerance(massDiffV, newNumX);
                                            if (!(massDiffV < this.massTolerance) && !wmtV) continue;
                                            withinMass |= wmtV;
                                            XmassDiff = massDiffV;
                                            modificationMatchEnd = new ModificationMatch(fmod.get(i), false, length);
                                            modificationMatchEndEnd = new ModificationMatch(vmodaa[lastAcid].get(j), true, length);
                                        }
                                    }
                                    if (vmod != null && modificationMatchEnd == null) {
                                        for (j = 0; j < vmod.size(); ++j) {
                                            double massDiffV = Math.abs(massDiff - vmodMass.get(j));
                                            wmtV = this.withinMassTolerance(massDiffV, newNumX);
                                            if (!(massDiffV < this.massTolerance) && !wmtV) continue;
                                            withinMass |= wmtV;
                                            XmassDiff = massDiffV;
                                            modificationMatchEnd = new ModificationMatch(fmod.get(i), false, length);
                                            modificationMatchEndEnd = new ModificationMatch(vmod.get(j), false, length);
                                        }
                                    }
                                    hasFixedPep = false;
                                    if (fmodpaa != null && lastAcid > 0 && fmodpaaMass[lastAcid].size() > 0) {
                                        for (int j7 = 0; j7 < fmodpaaMass[lastAcid].size(); ++j7) {
                                            massDiffDiffV = Math.abs(massDiffDiff - fmodpaaMass[lastAcid].get(j7));
                                            wmtV2 = this.withinMassTolerance(massDiffDiffV, newNumX);
                                            if (!(massDiffDiffV < this.massTolerance) && !wmtV2) continue;
                                            hasFixedPep = true;
                                            withinMass |= wmtV2;
                                            XmassDiff = massDiffDiffV;
                                            modificationMatchEnd = new ModificationMatch(fmod.get(i), false, length);
                                            modificationMatchEndEnd = new ModificationMatch(fmodpaa[lastAcid].get(j7), false, length);
                                        }
                                    }
                                    if (fmodp != null) {
                                        for (int j8 = 0; j8 < fmodp.size(); ++j8) {
                                            massDiffDiffV = Math.abs(massDiffDiff - fmodpMass.get(j8));
                                            wmtV2 = this.withinMassTolerance(massDiffDiffV, newNumX);
                                            if (!(massDiffDiffV < this.massTolerance) && !wmtV2) continue;
                                            hasFixedPep = true;
                                            withinMass |= wmtV2;
                                            XmassDiff = massDiffDiffV;
                                            modificationMatchEnd = new ModificationMatch(fmod.get(i), false, length);
                                            modificationMatchEndEnd = new ModificationMatch(fmodp.get(j8), false, length);
                                        }
                                    }
                                    if (hasFixedPep) continue;
                                    if (vmodpaa != null && lastAcid > 0 && vmodpaaMass[lastAcid].size() > 0) {
                                        for (int j9 = 0; j9 < vmodpaaMass[lastAcid].size(); ++j9) {
                                            massDiffDiffV = Math.abs(massDiffDiff - vmodpaaMass[lastAcid].get(j9));
                                            wmtV2 = this.withinMassTolerance(massDiffDiffV, newNumX);
                                            if (!(massDiffDiffV < this.massTolerance) && !wmtV2) continue;
                                            withinMass |= wmtV2;
                                            XmassDiff = massDiffDiffV;
                                            modificationMatchEnd = new ModificationMatch(fmod.get(i), false, length);
                                            modificationMatchEndEnd = new ModificationMatch(vmodpaa[lastAcid].get(j9), true, length);
                                        }
                                    }
                                    if (vmodp == null) continue;
                                    for (int j10 = 0; j10 < vmodp.size(); ++j10) {
                                        massDiffDiffV = Math.abs(massDiffDiff - vmodpMass.get(j10));
                                        wmtV2 = this.withinMassTolerance(massDiffDiffV, newNumX);
                                        if (!(massDiffDiffV < this.massTolerance) && !wmtV2) continue;
                                        withinMass |= wmtV2;
                                        XmassDiff = massDiffDiffV;
                                        modificationMatchEnd = new ModificationMatch(fmod.get(i), false, length);
                                        modificationMatchEndEnd = new ModificationMatch(vmodp.get(j10), true, length);
                                    }
                                }
                            }
                            if (modificationMatchEnd == null) {
                                if (vmodaa != null && lastAcid > 0 && vmodaaMass[lastAcid].size() > 0) {
                                    for (i = 0; i < vmodaaMass[lastAcid].size(); ++i) {
                                        int j11;
                                        double massDiffDiff = massDiff - vmodaaMass[lastAcid].get(i);
                                        double massDiffDiffAbs = Math.abs(massDiffDiff);
                                        wmt = this.withinMassTolerance(massDiffDiffAbs, newNumX);
                                        if (massDiffDiffAbs < this.massTolerance || wmt) {
                                            withinMass |= wmt;
                                            XmassDiff = massDiffDiffAbs;
                                            modificationMatchEnd = new ModificationMatch(vmodaa[lastAcid].get(i), true, length);
                                        }
                                        hasFixedPep = false;
                                        if (fmodpaa != null && lastAcid > 0 && fmodpaaMass[lastAcid].size() > 0) {
                                            for (j11 = 0; j11 < fmodpaaMass[lastAcid].size(); ++j11) {
                                                massDiffDiffV = Math.abs(massDiffDiff - fmodpaaMass[lastAcid].get(j11));
                                                wmtV2 = this.withinMassTolerance(massDiffDiffV, newNumX);
                                                if (!(massDiffDiffV < this.massTolerance) && !wmtV2) continue;
                                                hasFixedPep = true;
                                                withinMass |= wmtV2;
                                                XmassDiff = massDiffDiffV;
                                                modificationMatchEnd = new ModificationMatch(vmodaa[lastAcid].get(i), true, length);
                                                modificationMatchEndEnd = new ModificationMatch(fmodpaa[lastAcid].get(j11), false, length);
                                            }
                                        }
                                        if (fmodp != null) {
                                            for (j11 = 0; j11 < fmodp.size(); ++j11) {
                                                massDiffDiffV = Math.abs(massDiffDiff - fmodpMass.get(j11));
                                                wmtV2 = this.withinMassTolerance(massDiffDiffV, newNumX);
                                                if (!(massDiffDiffV < this.massTolerance) && !wmtV2) continue;
                                                hasFixedPep = true;
                                                withinMass |= wmtV2;
                                                XmassDiff = massDiffDiffV;
                                                modificationMatchEnd = new ModificationMatch(vmodaa[lastAcid].get(i), true, length);
                                                modificationMatchEndEnd = new ModificationMatch(fmodp.get(j11), false, length);
                                            }
                                        }
                                        if (hasFixedPep) continue;
                                        if (vmodpaa != null && lastAcid > 0 && vmodpaaMass[lastAcid].size() > 0) {
                                            for (j11 = 0; j11 < vmodpaaMass[lastAcid].size(); ++j11) {
                                                massDiffDiffV = Math.abs(massDiffDiff - vmodpaaMass[lastAcid].get(j11));
                                                wmtV2 = this.withinMassTolerance(massDiffDiffV, newNumX);
                                                if (!(massDiffDiffV < this.massTolerance) && !wmtV2) continue;
                                                withinMass |= wmtV2;
                                                XmassDiff = massDiffDiffV;
                                                modificationMatchEnd = new ModificationMatch(vmodaa[lastAcid].get(i), true, length);
                                                modificationMatchEndEnd = new ModificationMatch(vmodpaa[lastAcid].get(j11), true, length);
                                            }
                                        }
                                        if (vmodp == null) continue;
                                        for (j11 = 0; j11 < vmodp.size(); ++j11) {
                                            massDiffDiffV = Math.abs(massDiffDiff - vmodpMass.get(j11));
                                            wmtV2 = this.withinMassTolerance(massDiffDiffV, newNumX);
                                            if (!(massDiffDiffV < this.massTolerance) && !wmtV2) continue;
                                            withinMass |= wmtV2;
                                            XmassDiff = massDiffDiffV;
                                            modificationMatchEnd = new ModificationMatch(vmodaa[lastAcid].get(i), true, length);
                                            modificationMatchEndEnd = new ModificationMatch(vmodp.get(j11), true, length);
                                        }
                                    }
                                }
                                if (vmod != null && modificationMatchEnd == null) {
                                    for (i = 0; i < vmod.size(); ++i) {
                                        int j12;
                                        double massDiffDiff = massDiff - vmodMass.get(i);
                                        double massDiffDiffAbs = Math.abs(massDiffDiff);
                                        wmt = this.withinMassTolerance(massDiffDiffAbs, newNumX);
                                        if (massDiffDiffAbs < this.massTolerance || wmt) {
                                            withinMass |= wmt;
                                            XmassDiff = massDiffDiffAbs;
                                            modificationMatchEnd = new ModificationMatch(vmod.get(i), false, length);
                                        }
                                        hasFixedPep = false;
                                        if (fmodpaa != null && lastAcid > 0 && fmodpaaMass[lastAcid].size() > 0) {
                                            for (j12 = 0; j12 < fmodpaaMass[lastAcid].size(); ++j12) {
                                                massDiffDiffV = Math.abs(massDiffDiff - fmodpaaMass[lastAcid].get(j12));
                                                wmtV2 = this.withinMassTolerance(massDiffDiffV, newNumX);
                                                if (!(massDiffDiffV < this.massTolerance) && !wmtV2) continue;
                                                hasFixedPep = true;
                                                withinMass |= wmtV2;
                                                XmassDiff = massDiffDiffV;
                                                modificationMatchEnd = new ModificationMatch(vmod.get(i), false, length);
                                                modificationMatchEndEnd = new ModificationMatch(fmodpaa[lastAcid].get(j12), false, length);
                                            }
                                        }
                                        if (fmodp != null) {
                                            for (j12 = 0; j12 < fmodp.size(); ++j12) {
                                                massDiffDiffV = Math.abs(massDiffDiff - fmodpMass.get(j12));
                                                wmtV2 = this.withinMassTolerance(massDiffDiffV, newNumX);
                                                if (!(massDiffDiffV < this.massTolerance) && !wmtV2) continue;
                                                hasFixedPep = true;
                                                withinMass |= wmtV2;
                                                XmassDiff = massDiffDiffV;
                                                modificationMatchEnd = new ModificationMatch(vmod.get(i), false, length);
                                                modificationMatchEndEnd = new ModificationMatch(fmodp.get(j12), false, length);
                                            }
                                        }
                                        if (hasFixedPep) continue;
                                        if (vmodpaa != null && lastAcid > 0 && vmodpaaMass[lastAcid].size() > 0) {
                                            for (j12 = 0; j12 < vmodpaaMass[lastAcid].size(); ++j12) {
                                                massDiffDiffV = Math.abs(massDiffDiff - vmodpaaMass[lastAcid].get(j12));
                                                wmtV2 = this.withinMassTolerance(massDiffDiffV, newNumX);
                                                if (!(massDiffDiffV < this.massTolerance) && !wmtV2) continue;
                                                withinMass |= wmtV2;
                                                XmassDiff = massDiffDiffV;
                                                modificationMatchEnd = new ModificationMatch(vmod.get(i), false, length);
                                                modificationMatchEndEnd = new ModificationMatch(vmodpaa[lastAcid].get(j12), true, length);
                                            }
                                        }
                                        if (vmodp == null) continue;
                                        for (j12 = 0; j12 < vmodp.size(); ++j12) {
                                            massDiffDiffV = Math.abs(massDiffDiff - vmodpMass.get(j12));
                                            wmtV2 = this.withinMassTolerance(massDiffDiffV, newNumX);
                                            if (!(massDiffDiffV < this.massTolerance) && !wmtV2) continue;
                                            withinMass |= wmtV2;
                                            XmassDiff = massDiffDiffV;
                                            modificationMatchEnd = new ModificationMatch(vmod.get(i), false, length);
                                            modificationMatchEndEnd = new ModificationMatch(vmodp.get(j12), true, length);
                                        }
                                    }
                                }
                            }
                            if (modificationMatchEnd == null) continue;
                            MatrixContent newEndCell = new MatrixContent(leftIndexOld, rightIndexOld, 0, cell, 0.0, null, null, length, 0, k, modificationMatchEnd, null, -1);
                            if (modificationMatchEndEnd == null) {
                                matrix[k + 1].add(newEndCell);
                            } else {
                                MatrixContent newEndEndCell = new MatrixContent(leftIndexOld, rightIndexOld, 0, newEndCell, 0.0, null, null, length, 0, k, modificationMatchEndEnd, null, -1);
                                matrix[k + 1].add(newEndEndCell);
                            }
                            if (withinMass) {
                                matrix[k + 1].getLast().XMassDiff = XmassDiff;
                            }
                            matrix[k + 1].getLast().numX = 0;
                        }
                        continue;
                    }
                    for (b = 0; b < setCharacter[this.numMasses][0]; ++b) {
                        boolean withinMass;
                        double newMass;
                        borders = setCharacter[b];
                        aminoAcid = borders[0];
                        if (aminoAcid == 47 || !((newMass = oldMass + (aminoAcid != 88 ? this.aaMasses[borders[3]] : 0.0)) - this.massTolerance <= combinationMass)) continue;
                        int aminoAcidSearch = borders[4] == -1 ? aminoAcid : borders[4];
                        int lessValue = less[aminoAcidSearch];
                        int leftIndex = lessValue + borders[1];
                        int rightIndex = lessValue + borders[2] - 1;
                        int newNumX = cell.numX + (aminoAcid == 88 ? 1 : 0);
                        if (newNumX > combination.xNumLimit) continue;
                        double massDiff = Math.abs(combinationMass - newMass);
                        int intMass = (int)(massDiff * this.lookupMultiplier);
                        if (massDiff > this.massTolerance && massDiff < this.lookupMaxMass && (this.lookupMasses[intMass >>> 6] >>> (intMass & 0x3F) & 1L) == 0L) continue;
                        int offset = (massDiff <= this.massTolerance ? 1 : 0) | ((withinMass = this.withinMassTolerance(massDiff, newNumX)) ? 1 : 0);
                        if (offset > 0) {
                            newNumX = 0;
                        }
                        matrix[k + offset].add(new MatrixContent(leftIndex, rightIndex, aminoAcid, cell, newMass, length + 1, newNumX, borders[3], borders[4], k));
                        if (!withinMass) continue;
                        matrix[k + offset].getLast().XMassDiff = massDiff;
                    }
                    continue;
                }
                String combinationSequence = combination.sequence;
                int xNumLimit = combination.xNumLimit;
                char aminoAcid = combinationSequence.charAt(0);
                for (int i = 0; i < combinationSequence.length(); ++i) {
                    char aminoAcidSearch = combinationSequence.charAt(i);
                    int lessValue = less[aminoAcidSearch];
                    int[] range = occurrence.singleRangeQuery(leftIndexOld - 1, rightIndexOld, aminoAcidSearch);
                    int leftIndex = lessValue + range[0];
                    int rightIndex = lessValue + range[1] - 1;
                    int newNumX = cell.numX + (aminoAcidSearch == 'X' ? 1 : 0);
                    if (leftIndex > rightIndex || newNumX > xNumLimit) continue;
                    if (k < combinations.length - 1 && combinations[k].isMass != combinations[k + 1].isMass) {
                        newNumX = 0;
                    }
                    matrix[k + 1].add(new MatrixContent(leftIndex, rightIndex, aminoAcid, cell, 0.0, length + 1, newNumX, -1, aminoAcidSearch, k));
                }
            }
        }
    }

    @Override
    public ArrayList<PeptideProteinMapping> getProteinMapping(Tag tag, TagMatcher tagMatcher, SequenceMatchingPreferences sequenceMatchingPreferences, Double massTolerance) throws IOException, InterruptedException, ClassNotFoundException, SQLException {
        return this.getProteinMapping(tag, tagMatcher, sequenceMatchingPreferences);
    }

    @Override
    public ArrayList<PeptideProteinMapping> getProteinMapping(Tag tag, TagMatcher tagMatcher, SequenceMatchingPreferences sequenceMatchingPreferences) throws IOException, InterruptedException, ClassNotFoundException, SQLException {
        ArrayList<PeptideProteinMapping> allMatches = new ArrayList<PeptideProteinMapping>();
        if (this.maxNumberVariants > 0 || this.maxNumberDeletions > 0 || this.maxNumberInsertions > 0 || this.maxNumberSubstitutions > 0) {
            for (int i = 0; i < this.indexParts; ++i) {
                allMatches.addAll(this.getProteinMappingWithVariants(tag, tagMatcher, sequenceMatchingPreferences, i));
            }
            return allMatches;
        }
        for (int i = 0; i < this.indexParts; ++i) {
            allMatches.addAll(this.getProteinMappingWithoutVariants(tag, tagMatcher, sequenceMatchingPreferences, i));
        }
        return allMatches;
    }

    public ArrayList<PeptideProteinMapping> getProteinMappingWithoutVariants(Tag tag, TagMatcher tagMatcher, SequenceMatchingPreferences sequenceMatchingPreferences, int indexPart) throws IOException, InterruptedException, ClassNotFoundException, SQLException {
        String currentPeptideSearch;
        String currentPeptide;
        MatrixContent currentContent;
        MatrixContent content;
        int i;
        int[] lessTablePrimary = this.lessTablesPrimary.get(indexPart);
        WaveletTree occurrenceTablePrimary = this.occurrenceTablesPrimary.get(indexPart);
        int[] lessTableReversed = this.lessTablesReversed.get(indexPart);
        WaveletTree occurrenceTableReversed = this.occurrenceTablesReversed.get(indexPart);
        ArrayList<PeptideProteinMapping> allMatches = new ArrayList<PeptideProteinMapping>();
        double xLimit = sequenceMatchingPreferences.getLimitX() != null ? sequenceMatchingPreferences.getLimitX() : 1.0;
        int maxSequencePosition = -1;
        TagElement[] tagElements = new TagElement[tag.getContent().size()];
        for (int i2 = 0; i2 < tag.getContent().size(); ++i2) {
            if (tag.getContent().get(i2) instanceof MassGap) {
                tagElements[i2] = new TagElement(true, "", tag.getContent().get(i2).getMass(), (int)Math.round(tag.getContent().get(i2).getMass() / 120.0 * xLimit));
                continue;
            }
            if (tag.getContent().get(i2) instanceof AminoAcidSequence) {
                tagElements[i2] = new TagElement(false, tag.getContent().get(i2).asSequence(), 0.0, (int)((double)tag.getContent().get(i2).asSequence().length() * xLimit));
                if (maxSequencePosition != -1 && tagElements[i2].sequence.length() >= tagElements[i2].sequence.length()) continue;
                maxSequencePosition = i2;
                continue;
            }
            throw new UnsupportedOperationException("Unsupported tag in tag mapping for FM-Index.");
        }
        boolean turned = tagElements.length == 3 && tagElements[0].isMass && !tagElements[1].isMass && tagElements[2].isMass && tagElements[0].mass < tagElements[2].mass;
        TagElement[] refTagContent = null;
        int[] lessPrimary = null;
        int[] lessReversed = null;
        WaveletTree occurrencePrimary = null;
        WaveletTree occurrenceReversed = null;
        boolean hasCTermDirection = this.hasCTermDirectionPTM;
        boolean hasNTermDirection = this.hasNTermDirectionPTM;
        boolean towardsC = true;
        if (turned) {
            refTagContent = new TagElement[tagElements.length];
            int i3 = tagElements.length - 1;
            int j = 0;
            while (i3 >= 0) {
                String sequenceReversed = new StringBuilder(tagElements[i3].sequence).reverse().toString();
                refTagContent[j] = new TagElement(tagElements[i3].isMass, sequenceReversed, tagElements[i3].mass, tagElements[i3].xNumLimit);
                --i3;
                ++j;
            }
            lessReversed = lessTablePrimary;
            lessPrimary = lessTableReversed;
            occurrenceReversed = occurrenceTablePrimary;
            occurrencePrimary = occurrenceTableReversed;
            hasCTermDirection = this.hasNTermDirectionPTM;
            hasNTermDirection = this.hasCTermDirectionPTM;
            towardsC = false;
        } else {
            refTagContent = tagElements;
            lessPrimary = lessTablePrimary;
            lessReversed = lessTableReversed;
            occurrencePrimary = occurrenceTablePrimary;
            occurrenceReversed = occurrenceTableReversed;
        }
        ArrayList<MatrixContent> cached = this.isCached(refTagContent, indexPart);
        if (cached != null && cached.isEmpty()) {
            return allMatches;
        }
        TagElement[] tagComponents = new TagElement[maxSequencePosition];
        int i4 = maxSequencePosition - 1;
        int j = 0;
        while (i4 >= 0) {
            String sequenceReversed = new StringBuilder(refTagContent[i4].sequence).reverse().toString();
            tagComponents[j] = new TagElement(refTagContent[i4].isMass, sequenceReversed, refTagContent[i4].mass, refTagContent[i4].xNumLimit);
            --i4;
            ++j;
        }
        TagElement[] tagComponentsReverse = new TagElement[tagElements.length - maxSequencePosition];
        int i5 = maxSequencePosition;
        int j2 = 0;
        while (i5 < refTagContent.length) {
            tagComponentsReverse[j2] = refTagContent[i5];
            ++i5;
            ++j2;
        }
        TagElement[] combinations = this.createPeptideCombinations(tagComponents, sequenceMatchingPreferences);
        TagElement[] combinationsReversed = this.createPeptideCombinations(tagComponentsReverse, sequenceMatchingPreferences);
        LinkedList[] matrixReversed = new LinkedList[combinationsReversed.length + 1];
        LinkedList[] matrix = new LinkedList[combinations.length + 1];
        ArrayList<MatrixContent> cachePrimary = new ArrayList<MatrixContent>();
        for (i = 0; i <= combinationsReversed.length; ++i) {
            matrixReversed[i] = new LinkedList();
        }
        for (i = 0; i <= combinations.length; ++i) {
            matrix[i] = new LinkedList();
        }
        if (cached != null) {
            for (MatrixContent matrixContent : cached) {
                matrix[0].add(matrixContent);
            }
        } else {
            matrixReversed[0].add(new MatrixContent(this.indexStringLengths.get(indexPart) - 1));
        }
        if (cached == null) {
            if (!hasCTermDirection) {
                if (this.massAccuracyType == SearchParameters.MassAccuracyType.DA) {
                    this.mappingSequenceAndMassesDA(combinationsReversed, matrixReversed, lessReversed, occurrenceReversed);
                } else {
                    this.mappingSequenceAndMassesPPM(combinationsReversed, matrixReversed, lessReversed, occurrenceReversed);
                }
            } else if (this.massAccuracyType == SearchParameters.MassAccuracyType.DA) {
                this.mappingSequenceAndMassesDA(combinationsReversed, matrixReversed, lessReversed, occurrenceReversed, towardsC);
            } else {
                this.mappingSequenceAndMassesPPM(combinationsReversed, matrixReversed, lessReversed, occurrenceReversed, towardsC);
            }
            Iterator iterator = matrixReversed[combinationsReversed.length].iterator();
            while (iterator.hasNext()) {
                currentContent = content = (MatrixContent)iterator.next();
                currentPeptide = "";
                currentPeptideSearch = "";
                int leftIndexFront = 0;
                int rightIndexFront = this.indexStringLengths.get(indexPart) - 1;
                ArrayList<ModificationMatch> modifications = new ArrayList<ModificationMatch>();
                ArrayList<int[]> Xcomponents = new ArrayList<int[]>();
                HashMap<Integer, Double> XmassDiffs = new HashMap<Integer, Double>();
                while (currentContent.previousContent != null) {
                    int aminoAcid = currentContent.character;
                    if (aminoAcid > 0) {
                        int c;
                        currentPeptide = currentPeptide + (char)currentContent.character;
                        int n = c = currentContent.ambiguousChar == -1 ? aminoAcid : currentContent.ambiguousChar;
                        if (currentContent.character == 88) {
                            Xcomponents.add(new int[]{0, currentContent.tagComponent, currentContent.length});
                            ((int[])Xcomponents.get((int)(Xcomponents.size() - 1)))[2] = currentContent.length;
                        }
                        currentPeptideSearch = currentPeptideSearch + (char)c;
                        int lessValue = lessPrimary[c];
                        int[] range = occurrencePrimary.singleRangeQuery(leftIndexFront - 1, rightIndexFront, c);
                        leftIndexFront = lessValue + range[0];
                        rightIndexFront = lessValue + range[1] - 1;
                    }
                    if (currentContent.XMassDiff > -1.0) {
                        XmassDiffs.put(currentContent.tagComponent, currentContent.XMassDiff);
                    }
                    if (currentContent.modification != null || currentContent.modificationPos >= 0) {
                        if (currentContent.modificationPos >= 0) {
                            if (this.modificationFlags[currentContent.modificationPos]) {
                                modifications.add(new ModificationMatch(this.modifictationLabels[currentContent.modificationPos], currentContent.modificationPos >= 128, currentContent.length));
                            }
                        } else {
                            modifications.add(currentContent.modification);
                        }
                    }
                    currentContent = currentContent.previousContent;
                }
                String reversePeptide = new StringBuilder(currentPeptide).reverse().toString();
                String reversePeptideSearch = new StringBuilder(currentPeptideSearch).reverse().toString();
                MatrixContent cell = new MatrixContent(leftIndexFront, rightIndexFront, (int)reversePeptide.charAt(0), null, 0.0, reversePeptide, reversePeptideSearch, content.length, 0, 0, null, modifications, -1);
                cell.allXcomponents = Xcomponents;
                cell.allXMassDiffs = XmassDiffs;
                cachePrimary.add(cell);
            }
            for (MatrixContent matrixContent : cachePrimary) {
                matrix[0].add(matrixContent);
            }
            this.cacheIt(refTagContent, cachePrimary, indexPart);
        }
        if (!matrix[0].isEmpty()) {
            if (!hasNTermDirection) {
                if (this.massAccuracyType == SearchParameters.MassAccuracyType.DA) {
                    this.mappingSequenceAndMassesDA(combinations, matrix, lessPrimary, occurrencePrimary);
                } else {
                    this.mappingSequenceAndMassesPPM(combinations, matrix, lessPrimary, occurrencePrimary);
                }
            } else if (this.massAccuracyType == SearchParameters.MassAccuracyType.DA) {
                this.mappingSequenceAndMassesDA(combinations, matrix, lessPrimary, occurrencePrimary, !towardsC);
            } else {
                this.mappingSequenceAndMassesPPM(combinations, matrix, lessPrimary, occurrencePrimary, !towardsC);
            }
        }
        Iterator iterator = matrix[combinations.length].iterator();
        while (iterator.hasNext()) {
            currentContent = content = (MatrixContent)iterator.next();
            currentPeptide = "";
            currentPeptideSearch = "";
            ArrayList<ModificationMatch> modifications = new ArrayList<ModificationMatch>();
            ArrayList<int[]> Xcomponents = new ArrayList<int[]>();
            HashMap<Integer, Double> XmassDiffs = new HashMap<Integer, Double>();
            while (currentContent.previousContent != null) {
                if (currentContent.character != 0) {
                    currentPeptide = currentPeptide + (char)currentContent.character;
                    currentPeptideSearch = currentPeptideSearch + (char)(currentContent.ambiguousChar == -1 ? currentContent.character : currentContent.ambiguousChar);
                    if (currentContent.character == 88) {
                        Xcomponents.add(new int[]{1, currentContent.tagComponent, content.length - currentContent.length + 1});
                    }
                }
                if (currentContent.XMassDiff > -1.0) {
                    XmassDiffs.put(currentContent.tagComponent + 1024, currentContent.XMassDiff);
                }
                if (currentContent.modification != null || currentContent.modificationPos >= 0) {
                    if (currentContent.modificationPos >= 0) {
                        if (this.modificationFlags[currentContent.modificationPos]) {
                            modifications.add(new ModificationMatch(this.modifictationLabels[currentContent.modificationPos], currentContent.modificationPos >= 128, content.length - currentContent.length + 1));
                        }
                    } else {
                        modifications.add(new ModificationMatch(currentContent.modification.getTheoreticPtm(), currentContent.modification.isVariable(), content.length - currentContent.modification.getModificationSite() + 1));
                    }
                }
                currentContent = currentContent.previousContent;
            }
            int leftIndex = content.left;
            int rightIndex = content.right;
            for (int[] Xcomponent : currentContent.allXcomponents) {
                Xcomponents.add(new int[]{Xcomponent[0], Xcomponent[1], Xcomponent[2] + content.length - currentContent.length});
            }
            for (Integer key : currentContent.allXMassDiffs.keySet()) {
                XmassDiffs.put(key, currentContent.allXMassDiffs.get(key));
            }
            for (ModificationMatch modificationMatch : currentContent.modifications) {
                modifications.add(new ModificationMatch(modificationMatch.getTheoreticPtm(), modificationMatch.isVariable(), modificationMatch.getModificationSite() + content.length - currentContent.length));
            }
            String peptide = currentPeptide + currentContent.peptideSequence;
            String peptideSearch = currentPeptideSearch + currentContent.peptideSequenceSearch;
            if (turned) {
                leftIndex = 0;
                rightIndex = this.indexStringLengths.get(indexPart) - 1;
                for (int p = 0; p < peptideSearch.length(); ++p) {
                    char aminoAcid = peptideSearch.charAt(p);
                    int lessValue = lessReversed[aminoAcid];
                    int[] range = occurrenceReversed.singleRangeQuery(leftIndex - 1, rightIndex, aminoAcid);
                    leftIndex = lessValue + range[0];
                    rightIndex = lessValue + range[1] - 1;
                }
                for (ModificationMatch modificationMatch : modifications) {
                    modificationMatch.setModificationSite(peptide.length() - modificationMatch.getModificationSite() + 1);
                }
                for (int[] Xcomponent : Xcomponents) {
                    Xcomponent[2] = peptide.length() - Xcomponent[2] + 1;
                }
                peptide = new StringBuilder(peptide).reverse().toString();
            }
            if (Xcomponents.isEmpty()) {
                for (int j3 = leftIndex; j3 <= rightIndex; ++j3) {
                    int pos = this.getTextPosition(j3, indexPart);
                    int index = FMIndex.binarySearch(this.boundaries.get(indexPart), pos);
                    String accession = this.accessions.get(indexPart)[index];
                    PeptideProteinMapping peptideProteinMapping = new PeptideProteinMapping(accession, peptide, pos - this.boundaries.get(indexPart)[index] + 1, modifications);
                    if (!this.checkPTMPattern(peptideProteinMapping)) continue;
                    allMatches.add(peptideProteinMapping);
                }
                continue;
            }
            ArrayList Xsets = new ArrayList();
            ArrayList<int[]> Xorigins = new ArrayList<int[]>();
            int nTag = -1;
            int nComponent = -1;
            for (int i6 = 0; i6 < Xcomponents.size(); ++i6) {
                if (nTag != ((int[])Xcomponents.get(i6))[0] || nComponent != ((int[])Xcomponents.get(i6))[1]) {
                    Xorigins.add(new int[]{((int[])Xcomponents.get(i6))[0], ((int[])Xcomponents.get(i6))[1]});
                    Xsets.add(new ArrayList());
                    nTag = ((int[])Xcomponents.get(i6))[0];
                    nComponent = ((int[])Xcomponents.get(i6))[1];
                }
                ((ArrayList)Xsets.get(Xsets.size() - 1)).add(((int[])Xcomponents.get(i6))[2]);
            }
            LinkedList<String> substitutedPeptides = new LinkedList<String>();
            LinkedList<String> substitutedPeptidesTmp = new LinkedList<String>();
            substitutedPeptides.add(peptide);
            LinkedList<ArrayList<ModificationMatch>> substitutedModifications = new LinkedList<ArrayList<ModificationMatch>>();
            LinkedList substitutedModificationsTmp = new LinkedList();
            substitutedModifications.add(modifications);
            for (int k = 0; k < Xsets.size(); ++k) {
                ArrayList Xpositions = (ArrayList)Xsets.get(k);
                int len = Xpositions.size();
                HashMap<String, int[][]> uniqueSubstitutions = new HashMap<String, int[][]>();
                int[] Xranges = this.computeMappingRanges((Double)XmassDiffs.get(((int[])Xorigins.get(k))[0] * 1024 + ((int[])Xorigins.get(k))[1]));
                ArrayList<int[]> possibleAAs = new ArrayList<int[]>();
                for (int i7 = Xranges[0]; i7 <= Xranges[1]; ++i7) {
                    if (this.massIndexMaps.get((int)i7).indexes.length != len) continue;
                    possibleAAs.add(this.massIndexMaps.get((int)i7).indexes);
                }
                int[][] permutations = this.allPermutations[len];
                for (int j4 = 0; j4 < possibleAAs.size(); ++j4) {
                    for (int i8 = 0; i8 < permutations.length; ++i8) {
                        String key = "";
                        for (int index : permutations[i8]) {
                            key = key + "-" + ((int[])possibleAAs.get(j4))[index];
                        }
                        int[][] zipped = new int[][]{permutations[i8], (int[])possibleAAs.get(j4)};
                        uniqueSubstitutions.put(key, zipped);
                    }
                }
                while (!substitutedPeptides.isEmpty()) {
                    String pep = (String)substitutedPeptides.removeLast();
                    ArrayList currentModifications = (ArrayList)substitutedModifications.removeLast();
                    char[] pepChars = pep.toCharArray();
                    Object object = uniqueSubstitutions.values().iterator();
                    while (object.hasNext()) {
                        int[][] uniquePermutations = (int[][])object.next();
                        ArrayList<ModificationMatch> newModifications = new ArrayList<ModificationMatch>();
                        for (ModificationMatch m : currentModifications) {
                            newModifications.add(new ModificationMatch(m.getTheoreticPtm(), m.isVariable(), m.getModificationSite()));
                        }
                        for (int i9 = 0; i9 < uniquePermutations[0].length; ++i9) {
                            int pos = uniquePermutations[1][uniquePermutations[0][i9]];
                            pepChars[((Integer)Xpositions.get((int)i9)).intValue() - 1] = (char)(pos & 0x7F);
                            if (!this.modificationFlags[pos]) continue;
                            newModifications.add(new ModificationMatch(this.modifictationLabels[pos], pos >= 128, (Integer)Xpositions.get(i9)));
                        }
                        substitutedPeptidesTmp.add(String.valueOf(pepChars));
                        substitutedModificationsTmp.add(newModifications);
                    }
                }
                while (!substitutedPeptidesTmp.isEmpty()) {
                    substitutedPeptides.add((String)substitutedPeptidesTmp.removeLast());
                    substitutedModifications.add((ArrayList<ModificationMatch>)substitutedModificationsTmp.removeLast());
                }
            }
            for (int i10 = 0; i10 < substitutedPeptides.size(); ++i10) {
                for (int j5 = leftIndex; j5 <= rightIndex; ++j5) {
                    int pos = this.getTextPosition(j5, indexPart);
                    int index = FMIndex.binarySearch(this.boundaries.get(indexPart), pos);
                    String accession = this.accessions.get(indexPart)[index];
                    PeptideProteinMapping peptideProteinMapping = new PeptideProteinMapping(accession, (String)substitutedPeptides.get(i10), pos - this.boundaries.get(indexPart)[index] + 1, (ArrayList)substitutedModifications.get(i10));
                    if (!this.checkPTMPattern(peptideProteinMapping)) continue;
                    allMatches.add(peptideProteinMapping);
                }
            }
        }
        return allMatches;
    }

    public ArrayList<PeptideProteinMapping> getProteinMappingWithVariants(Tag tag, TagMatcher tagMatcher, SequenceMatchingPreferences sequenceMatchingPreferences, int indexPart) throws IOException, InterruptedException, ClassNotFoundException, SQLException {
        boolean update;
        String currentPeptide;
        MatrixContent currentContent;
        int[] lessTablePrimary = this.lessTablesPrimary.get(indexPart);
        WaveletTree occurrenceTablePrimary = this.occurrenceTablesPrimary.get(indexPart);
        int[] lessTableReversed = this.lessTablesReversed.get(indexPart);
        WaveletTree occurrenceTableReversed = this.occurrenceTablesReversed.get(indexPart);
        ArrayList<PeptideProteinMapping> allMatches = new ArrayList<PeptideProteinMapping>();
        double xLimit = sequenceMatchingPreferences.getLimitX() != null ? sequenceMatchingPreferences.getLimitX() : 1.0;
        int maxSequencePosition = -1;
        TagElement[] tagElements = new TagElement[tag.getContent().size()];
        for (int i = 0; i < tag.getContent().size(); ++i) {
            if (tag.getContent().get(i) instanceof MassGap) {
                tagElements[i] = new TagElement(true, "", tag.getContent().get(i).getMass(), 0);
                continue;
            }
            if (tag.getContent().get(i) instanceof AminoAcidSequence) {
                tagElements[i] = new TagElement(false, tag.getContent().get(i).asSequence(), 0.0, (int)(xLimit * (double)tag.getContent().get(i).asSequence().length()));
                if (maxSequencePosition != -1 && tagElements[i].sequence.length() >= tagElements[i].sequence.length()) continue;
                maxSequencePosition = i;
                continue;
            }
            throw new UnsupportedOperationException("Unsupported tag in tag mapping for FM-Index.");
        }
        boolean turned = tagElements.length == 3 && tagElements[0].isMass && !tagElements[1].isMass && tagElements[2].isMass && tagElements[0].mass < tagElements[2].mass;
        TagElement[] refTagContent = null;
        int[] lessPrimary = null;
        int[] lessReversed = null;
        WaveletTree occurrencePrimary = null;
        WaveletTree occurrenceReversed = null;
        if (turned) {
            refTagContent = new TagElement[tagElements.length];
            int i = tagElements.length - 1;
            int j = 0;
            while (i >= 0) {
                String sequenceReversed = new StringBuilder(tagElements[i].sequence).reverse().toString();
                refTagContent[j] = new TagElement(tagElements[i].isMass, sequenceReversed, tagElements[i].mass, tagElements[i].xNumLimit);
                --i;
                ++j;
            }
            lessReversed = lessTablePrimary;
            lessPrimary = lessTableReversed;
            occurrenceReversed = occurrenceTablePrimary;
            occurrencePrimary = occurrenceTableReversed;
        } else {
            refTagContent = tagElements;
            lessPrimary = lessTablePrimary;
            lessReversed = lessTableReversed;
            occurrencePrimary = occurrenceTablePrimary;
            occurrenceReversed = occurrenceTableReversed;
        }
        ArrayList<MatrixContent> cached = this.isCached(refTagContent, indexPart);
        if (cached != null && cached.isEmpty()) {
            return allMatches;
        }
        TagElement[] tagComponents = new TagElement[maxSequencePosition];
        int i = maxSequencePosition - 1;
        int j = 0;
        while (i >= 0) {
            String sequenceReversed = new StringBuilder(refTagContent[i].sequence).reverse().toString();
            tagComponents[j] = new TagElement(refTagContent[i].isMass, sequenceReversed, refTagContent[i].mass, refTagContent[i].xNumLimit);
            --i;
            ++j;
        }
        TagElement[] tagComponentsReverse = new TagElement[tagElements.length - maxSequencePosition];
        int i2 = maxSequencePosition;
        int j2 = 0;
        while (i2 < refTagContent.length) {
            tagComponentsReverse[j2] = refTagContent[i2];
            ++i2;
            ++j2;
        }
        TagElement[] combinations = this.createPeptideCombinations(tagComponents, sequenceMatchingPreferences);
        TagElement[] combinationsReversed = this.createPeptideCombinations(tagComponentsReverse, sequenceMatchingPreferences);
        int numErrors = 1 + (this.genericVariantMatching ? this.maxNumberVariants : this.maxNumberDeletions + this.maxNumberInsertions + this.maxNumberSubstitutions);
        LinkedList[][] matrixReversed = new LinkedList[numErrors][combinationsReversed.length + 1];
        LinkedList[][] matrix = new LinkedList[numErrors][combinations.length + 1];
        ArrayList<MatrixContent> cachePrimary = new ArrayList<MatrixContent>();
        for (int k = 0; k < numErrors; ++k) {
            int j3;
            for (j3 = 0; j3 <= combinationsReversed.length; ++j3) {
                matrixReversed[k][j3] = new LinkedList();
            }
            for (j3 = 0; j3 <= combinations.length; ++j3) {
                matrix[k][j3] = new LinkedList();
            }
        }
        if (cached != null) {
            for (MatrixContent matrixContent : cached) {
                int error = this.genericVariantMatching ? matrixContent.numVariants : matrixContent.numSpecificVariants[0] + matrixContent.numSpecificVariants[1] + matrixContent.numSpecificVariants[2];
                matrix[error][0].add(matrixContent);
            }
        } else {
            matrixReversed[0][0].add(new MatrixContent(this.indexStringLengths.get(indexPart) - 1));
        }
        if (cached == null) {
            if (this.genericVariantMatching) {
                this.mappingSequenceAndMassesWithVariantsGeneric(combinationsReversed, matrixReversed, lessReversed, occurrenceReversed);
            } else {
                this.mappingSequenceAndMassesWithVariantsSpecific(combinationsReversed, matrixReversed, lessReversed, occurrenceReversed);
            }
            for (int k = 0; k < numErrors; ++k) {
                Iterator matrixContent = matrixReversed[k][combinationsReversed.length].iterator();
                while (matrixContent.hasNext()) {
                    MatrixContent content;
                    currentContent = content = (MatrixContent)matrixContent.next();
                    currentPeptide = "";
                    int leftIndexFront = 0;
                    int rightIndexFront = this.indexStringLengths.get(indexPart) - 1;
                    ArrayList<ModificationMatch> modifications = new ArrayList<ModificationMatch>();
                    String allVariants = "";
                    while (currentContent.previousContent != null) {
                        int aminoAcidPep = currentContent.character;
                        int aminoAcidProt = currentContent.character;
                        char edit = currentContent.variant;
                        update = true;
                        if (edit != '-') {
                            if (edit == '*') {
                                update = false;
                            } else if ('A' <= edit && edit <= 'Z') {
                                aminoAcidProt = edit;
                            } else if ('a' <= edit && edit <= 'z') {
                                aminoAcidProt = edit - 32;
                            }
                        }
                        if (aminoAcidPep > 0) {
                            currentPeptide = currentPeptide + (char)aminoAcidPep;
                            allVariants = allVariants + (char)edit;
                            if (update) {
                                int lessValue = lessPrimary[aminoAcidProt];
                                int[] range = occurrencePrimary.singleRangeQuery(leftIndexFront - 1, rightIndexFront, aminoAcidProt);
                                leftIndexFront = lessValue + range[0];
                                rightIndexFront = lessValue + range[1] - 1;
                            }
                        }
                        if (currentContent.modification != null || currentContent.modificationPos >= 0) {
                            if (currentContent.modificationPos >= 0) {
                                if (this.modificationFlags[currentContent.modificationPos]) {
                                    modifications.add(new ModificationMatch(this.modifictationLabels[currentContent.modificationPos], currentContent.modificationPos >= 128, currentContent.length));
                                }
                            } else {
                                modifications.add(currentContent.modification);
                            }
                        }
                        currentContent = currentContent.previousContent;
                    }
                    String reversePeptide = new StringBuilder(currentPeptide).reverse().toString();
                    allVariants = new StringBuilder(allVariants).reverse().toString();
                    if (this.genericVariantMatching) {
                        cachePrimary.add(new MatrixContent(leftIndexFront, rightIndexFront, (int)reversePeptide.charAt(0), null, 0.0, reversePeptide, content.length, 0, null, modifications, -1, k, '\u0000', allVariants));
                        continue;
                    }
                    cachePrimary.add(new MatrixContent(leftIndexFront, rightIndexFront, (int)reversePeptide.charAt(0), null, 0.0, reversePeptide, content.length, 0, null, modifications, -1, new int[]{content.numSpecificVariants[0], content.numSpecificVariants[1], content.numSpecificVariants[2]}, '\u0000', allVariants));
                }
            }
            for (MatrixContent matrixContent : cachePrimary) {
                int error = this.genericVariantMatching ? matrixContent.numVariants : matrixContent.numSpecificVariants[0] + matrixContent.numSpecificVariants[1] + matrixContent.numSpecificVariants[2];
                matrix[error][0].add(matrixContent);
            }
            this.cacheIt(refTagContent, cachePrimary, indexPart);
        }
        if (this.genericVariantMatching) {
            this.mappingSequenceAndMassesWithVariantsGeneric(combinations, matrix, lessPrimary, occurrencePrimary);
        } else {
            this.mappingSequenceAndMassesWithVariantsSpecific(combinations, matrix, lessPrimary, occurrencePrimary);
        }
        for (int k = 0; k < numErrors; ++k) {
            Iterator iterator = matrix[k][combinations.length].iterator();
            while (iterator.hasNext()) {
                MatrixContent content;
                currentContent = content = (MatrixContent)iterator.next();
                currentPeptide = "";
                ArrayList<ModificationMatch> modifications = new ArrayList<ModificationMatch>();
                String allVariants = "";
                while (currentContent.previousContent != null) {
                    int aminoAcid = currentContent.character;
                    if (aminoAcid > 0) {
                        currentPeptide = currentPeptide + (char)aminoAcid;
                        allVariants = allVariants + currentContent.variant;
                    }
                    if (currentContent.modification != null || currentContent.modificationPos >= 0) {
                        if (currentContent.modificationPos >= 0) {
                            if (this.modificationFlags[currentContent.modificationPos]) {
                                modifications.add(new ModificationMatch(this.modifictationLabels[currentContent.modificationPos], currentContent.modificationPos >= 128, content.length - currentContent.length + 1));
                            }
                        } else {
                            modifications.add(new ModificationMatch(currentContent.modification.getTheoreticPtm(), currentContent.modification.isVariable(), currentContent.modification.getModificationSite() + content.length - currentContent.length + 1));
                        }
                    }
                    currentContent = currentContent.previousContent;
                }
                int leftIndex = content.left;
                int rightIndex = content.right;
                for (ModificationMatch modificationMatch : currentContent.modifications) {
                    modifications.add(new ModificationMatch(modificationMatch.getTheoreticPtm(), modificationMatch.isVariable(), modificationMatch.getModificationSite() + content.length - currentContent.length));
                }
                String peptide = currentPeptide + currentContent.peptideSequence;
                allVariants = allVariants + currentContent.allVariants;
                ArrayList<VariantMatch> variants = new ArrayList<VariantMatch>();
                if (turned) {
                    leftIndex = 0;
                    rightIndex = this.indexStringLengths.get(indexPart) - 1;
                    for (int p = 0; p < peptide.length(); ++p) {
                        update = true;
                        int aminoAcid = peptide.charAt(p);
                        int edit = allVariants.charAt(p);
                        if (edit != 45) {
                            if (edit == 42) {
                                update = false;
                            } else if (65 <= edit && edit <= 90) {
                                aminoAcid = edit;
                            } else if (97 <= edit && edit <= 122) {
                                aminoAcid = edit - 32;
                            }
                        }
                        if (!update) continue;
                        int lessValue = lessReversed[aminoAcid];
                        int[] range = occurrenceReversed.singleRangeQuery(leftIndex - 1, rightIndex, aminoAcid);
                        leftIndex = lessValue + range[0];
                        rightIndex = lessValue + range[1] - 1;
                    }
                    for (ModificationMatch modificationMatch : modifications) {
                        modificationMatch.setModificationSite(peptide.length() - modificationMatch.getModificationSite() + 1);
                    }
                    allVariants = new StringBuilder(allVariants).reverse().toString();
                    peptide = new StringBuilder(peptide).reverse().toString();
                }
                int length = 0;
                for (int i3 = 0; i3 < allVariants.length(); ++i3) {
                    char edit = allVariants.charAt(i3);
                    ++length;
                    if (edit == '-') continue;
                    if (edit == '*') {
                        variants.add(new VariantMatch(new Insertion(peptide.charAt(length - 1)), "-", length));
                        continue;
                    }
                    if ('A' <= edit && edit <= 'Z') {
                        variants.add(new VariantMatch(new Substitution(edit, peptide.charAt(length - 1)), "-", length));
                        continue;
                    }
                    if ('a' > edit || edit > 'z') continue;
                    variants.add(new VariantMatch(new Deletion((char)(edit - 32)), "-", length));
                    --length;
                }
                String cleanPeptide = peptide.replace("*", "");
                for (int j4 = leftIndex; j4 <= rightIndex; ++j4) {
                    PeptideProteinMapping peptideProteinMapping;
                    int pos = this.getTextPosition(j4, indexPart);
                    int index = FMIndex.binarySearch(this.boundaries.get(indexPart), pos);
                    String accession = this.accessions.get(indexPart)[index];
                    int startPosition = pos - this.boundaries.get(indexPart)[index];
                    boolean newPeptide = true;
                    for (PeptideProteinMapping ppm : allMatches) {
                        if (!ppm.getProteinAccession().equals(accession) || !ppm.getPeptideSequence().equals(cleanPeptide) || Math.abs(ppm.getIndex() - startPosition) > numErrors) continue;
                        newPeptide = false;
                        break;
                    }
                    if (!newPeptide || !this.checkPTMPattern(peptideProteinMapping = new PeptideProteinMapping(accession, cleanPeptide, startPosition + 1, modifications, variants))) continue;
                    allMatches.add(peptideProteinMapping);
                }
            }
        }
        return allMatches;
    }

    private ArrayList<MatrixContent> isCached(TagElement[] tagComponents, int indexPart) {
        if (tagComponents.length != 3 || !tagComponents[0].isMass || tagComponents[1].isMass || !tagComponents[2].isMass) {
            return null;
        }
        ArrayList<MatrixContent> cached = null;
        try {
            cacheMutex.acquire();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String key = tagComponents[1].sequence + String.format("%.5f", tagComponents[2].mass);
        CacheElement cacheElement = this.cache[indexPart].get(key);
        if (cacheElement != null) {
            cached = cacheElement.cachedPrimary;
        }
        cacheMutex.release();
        return cached;
    }

    private void cacheIt(TagElement[] tagComponents, ArrayList<MatrixContent> cachedPrimary, int indexPart) {
        if (tagComponents.length != 3 || !tagComponents[0].isMass || tagComponents[1].isMass || !tagComponents[2].isMass) {
            return;
        }
        try {
            cacheMutex.acquire();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ArrayList<MatrixContent> cacheContentPrimary = new ArrayList<MatrixContent>();
        for (MatrixContent matrixContent : cachedPrimary) {
            cacheContentPrimary.add(new MatrixContent(matrixContent));
        }
        String key = tagComponents[1].sequence + String.format("%.5f", tagComponents[2].mass);
        CacheElement cacheElement = new CacheElement(tagComponents[0].mass, tagComponents[1].sequence, tagComponents[2].mass, cacheContentPrimary);
        if (!this.cache[indexPart].containsKey(key)) {
            this.cache[indexPart].put(key, cacheElement);
        }
        cacheMutex.release();
    }

    private class CacheElement {
        Double massFirst;
        String sequence;
        Double massSecond;
        ArrayList<MatrixContent> cachedPrimary;

        public CacheElement(Double massFirst, String sequence, Double massSecond, ArrayList<MatrixContent> cachedPrimary) {
            this.sequence = sequence;
            this.massFirst = massFirst;
            this.massSecond = massSecond;
            this.cachedPrimary = cachedPrimary;
        }
    }

    private class TagElement {
        boolean isMass;
        String sequence;
        double mass;
        int xNumLimit;

        TagElement(boolean isMass, String sequence, double mass, int xNumLimit) {
            this.isMass = isMass;
            this.sequence = sequence;
            this.mass = mass;
            this.xNumLimit = xNumLimit;
        }

        TagElement(boolean isMass, String sequence, double mass) {
            this.isMass = isMass;
            this.sequence = sequence;
            this.mass = mass;
            this.xNumLimit = 0;
        }

        public String toString() {
            String output = this.isMass ? String.format("%.5f", this.mass) : this.sequence;
            return output;
        }
    }

    public class MassIndexMap {
        public double mass;
        public int[] indexes;

        public MassIndexMap(double mass, int[] indexes) {
            this.mass = mass;
            this.indexes = indexes;
        }
    }
}

