/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.protein_inference.proteintree;

import com.compomics.util.Util;
import com.compomics.util.db.DerbyUtil;
import com.compomics.util.db.ObjectsCache;
import com.compomics.util.db.ObjectsDB;
import com.compomics.util.experiment.identification.protein_inference.proteintree.Node;
import com.compomics.util.experiment.identification.protein_sequences.SequenceFactory;
import com.compomics.util.preferences.UtilitiesUserPreferences;
import com.compomics.util.waiting.WaitingHandler;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

public class ProteinTreeComponentsFactory {
    private SequenceFactory sequenceFactory = SequenceFactory.getInstance();
    private static ProteinTreeComponentsFactory instance = null;
    private static String defaultDbFolderPath = System.getProperty("user.home") + "/.compomics/proteins/indexes/";
    private ObjectsDB objectsDB;
    private ObjectsCache objectsCache = new ObjectsCache();
    public static final String folderSeparator = "_cus_";
    public static final String dbName = "proteinTree";
    private static final String nodeTable = "nodes";
    private static final String parametersTable = "parameters";
    private HashSet<String> tagsInTree = null;

    private ProteinTreeComponentsFactory() throws IOException {
        this.objectsCache.setAutomatedMemoryManagement(false);
        this.objectsCache.setCacheSize(1000);
        this.objectsCache.setBatchSize(100);
    }

    public static ProteinTreeComponentsFactory getInstance() throws IOException {
        if (instance == null) {
            instance = new ProteinTreeComponentsFactory();
        }
        return instance;
    }

    public boolean initiate() throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        File dbFolder = this.getDbFolder();
        boolean exists = true;
        if (!dbFolder.exists()) {
            exists = false;
            if (!dbFolder.mkdir()) {
                throw new IOException("Impossible to create database folder " + dbFolder.getAbsolutePath() + ".");
            }
        }
        this.objectsDB = new ObjectsDB(dbFolder.getAbsolutePath(), dbName, false, this.objectsCache);
        if (!exists) {
            this.objectsDB.addTable(nodeTable);
            this.objectsDB.addTable(parametersTable);
        }
        return exists;
    }

    public boolean delete() throws IOException, SQLException, InterruptedException {
        try {
            if (!this.isCorrupted()) {
                this.setCorrupted(true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            DerbyUtil.closeConnection();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        File dbFolder = this.getDbFolder();
        boolean success = Util.deleteDir(dbFolder);
        return success;
    }

    public void close() throws IOException, SQLException, InterruptedException {
        if (this.objectsDB != null) {
            this.objectsDB.close();
            this.objectsCache = new ObjectsCache();
        }
    }

    public String getDbFolderName() {
        return this.sequenceFactory.getFileName() + folderSeparator + this.sequenceFactory.getCurrentFastaIndex().getLastModified();
    }

    public File getDbFolder() throws IOException {
        boolean success;
        UtilitiesUserPreferences utilitiesUserPreferences = UtilitiesUserPreferences.loadUserPreferences();
        File folder = utilitiesUserPreferences.getProteinTreeFolder();
        if (!folder.exists() && !(success = folder.mkdirs())) {
            throw new IOException("Unable to create database folder " + folder + ".");
        }
        return new File(folder, this.getDbFolderName());
    }

    public void saveNode(String tag, Node node) throws SQLException, IOException, InterruptedException {
        this.objectsDB.insertObject(nodeTable, tag, node, false);
    }

    public void saveNodes(HashMap<String, Object> nodes, WaitingHandler waitingHandler) throws SQLException, IOException, InterruptedException {
        this.objectsDB.insertObjects(nodeTable, nodes, waitingHandler);
    }

    public Node getNode(String tag) throws SQLException, ClassNotFoundException, IOException, InterruptedException {
        if (this.tagsInTree != null && !this.tagsInTree.contains(tag)) {
            return null;
        }
        Node result = (Node)this.objectsDB.retrieveObject(nodeTable, tag, true, false);
        if (this.tagsInTree != null && result == null) {
            throw new IllegalArgumentException(tag + " not found in database.");
        }
        return result;
    }

    public void loadNodes(ArrayList<String> tags, WaitingHandler waitingHandler) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        this.objectsDB.loadObjects(nodeTable, tags, waitingHandler, false);
    }

    public void saveInitialSize(int size) throws SQLException, IOException, InterruptedException {
        this.objectsDB.insertObject(parametersTable, "initialSize", size, false);
    }

    public Integer getInitialSize() throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        return (Integer)this.objectsDB.retrieveObject(parametersTable, "initialSize", true);
    }

    public void loadParameters() throws SQLException, ClassNotFoundException, IOException, InterruptedException {
        this.objectsDB.loadObjects(parametersTable, null, false);
    }

    public void setImportComplete(boolean completed) throws SQLException, IOException, InterruptedException {
        this.objectsDB.insertObject(parametersTable, "importComplete", completed, false);
    }

    public boolean importComplete() throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        Boolean result = (Boolean)this.objectsDB.retrieveObject(parametersTable, "importComplete", true);
        if (result == null) {
            return false;
        }
        return result;
    }

    public void setCorrupted(boolean corrupted) throws SQLException, IOException, InterruptedException {
        this.objectsDB.insertObject(parametersTable, "corrupted", corrupted, false);
    }

    public boolean isCorrupted() throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        Boolean result = (Boolean)this.objectsDB.retrieveObject(parametersTable, "corrupted", true);
        if (result == null) {
            return false;
        }
        return result;
    }

    public void setVersion(String version) throws SQLException, IOException, InterruptedException {
        this.objectsDB.insertObject(parametersTable, "version", version, false);
    }

    public static String getVersion(ObjectsDB objectsDB) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        return (String)objectsDB.retrieveObject(parametersTable, "version", true);
    }

    public String getVersion() throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        return ProteinTreeComponentsFactory.getVersion(this.objectsDB);
    }

    public void setFastaFilePath(String fastaFilePath) throws SQLException, IOException, InterruptedException {
        this.objectsDB.insertObject(parametersTable, "fastaFile", fastaFilePath, false);
    }

    public String getFastaFilePath() throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        return ProteinTreeComponentsFactory.getFastaFilePath(this.objectsDB);
    }

    public static String getFastaFilePath(ObjectsDB objectsDB) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        return (String)objectsDB.retrieveObject(parametersTable, "fastaFile", true);
    }

    public void loadTags() throws SQLException, InterruptedException {
        this.tagsInTree = this.objectsDB.getTableContent(nodeTable);
    }

    public static String getDefaultDbFolderPath() {
        return defaultDbFolderPath;
    }

    public static void setDefaultDbFolderPath(String defaultDbFolderPath) {
        ProteinTreeComponentsFactory.defaultDbFolderPath = defaultDbFolderPath;
    }

    public ObjectsCache getCache() {
        return this.objectsCache;
    }

    public static void deletOutdatedTrees() throws IOException {
        UtilitiesUserPreferences utilitiesUserPreferences = UtilitiesUserPreferences.loadUserPreferences();
        File folder = utilitiesUserPreferences.getProteinTreeFolder();
        if (folder.exists()) {
            for (File dbFolder : folder.listFiles()) {
                if (!dbFolder.isDirectory() || !dbFolder.getName().contains(folderSeparator)) continue;
                try {
                    ObjectsCache tempCache = new ObjectsCache();
                    ObjectsDB objectsDB = new ObjectsDB(dbFolder.getAbsolutePath(), dbName, false, tempCache);
                    boolean upToDate = true;
                    try {
                        String version = ProteinTreeComponentsFactory.getVersion(objectsDB);
                        if (version != null && version.equals("1.1.2")) {
                            String fastaFilePath = ProteinTreeComponentsFactory.getFastaFilePath(objectsDB);
                            if (fastaFilePath != null) {
                                File fastaFile = new File(fastaFilePath);
                                if (!fastaFile.exists()) {
                                    upToDate = false;
                                }
                            } else {
                                upToDate = false;
                            }
                        } else {
                            upToDate = false;
                        }
                    }
                    catch (Exception e) {
                        upToDate = false;
                    }
                    objectsDB.close();
                    if (upToDate) continue;
                    DerbyUtil.closeConnection();
                    Util.deleteDir(folder);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

