/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.psm_scoring;

public enum PsmScore {
    native_score(-1, "Native", false, "The algorithm native score"),
    precursor_accuracy(0, "Precursor accuracy", false, "Precursor accuracy score"),
    hyperScore(1, "Hyperscore", true, "Hyperscore as variation of the score implemented in X!Tandem."),
    ms2_mz_fidelity(2, "Fragment ion mz fildelity", false, "Fragment ion m/z fidelity score"),
    aa_ms2_mz_fidelity(3, "AA fragment ion mz fildelity", false, "Fragment ion m/z fidelity score per amino acid"),
    intensity(4, "Intensity", true, "Intensity score"),
    aa_intensity(5, "AA intensity", false, "Intensity score per amino acid"),
    complementarity(6, "Complementarity", true, "Ion complementarity score");

    public final Integer index;
    public final String name;
    public final boolean increasing;
    public final String description;

    private PsmScore(int index, String name, boolean increasing, String description) {
        this.index = index;
        this.name = name;
        this.increasing = increasing;
        this.description = description;
    }

    public static PsmScore getScore(int scoreIndex) {
        for (PsmScore psmScore : PsmScore.values()) {
            if (psmScore.index != scoreIndex) continue;
            return psmScore;
        }
        return null;
    }

    public static PsmScore getScore(String scoreName) {
        for (PsmScore psmScore : PsmScore.values()) {
            if (!psmScore.name.equals(scoreName)) continue;
            return psmScore;
        }
        return null;
    }
}

