/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.psm_scoring;

import com.compomics.util.experiment.biology.Peptide;
import com.compomics.util.experiment.identification.peptide_fragmentation.PeptideFragmentationModel;
import com.compomics.util.experiment.identification.psm_scoring.PsmScore;
import com.compomics.util.experiment.identification.psm_scoring.psm_scores.AAIntensityRankScore;
import com.compomics.util.experiment.identification.psm_scoring.psm_scores.AAMS2MzFidelityScore;
import com.compomics.util.experiment.identification.psm_scoring.psm_scores.ComplementarityScore;
import com.compomics.util.experiment.identification.psm_scoring.psm_scores.HyperScore;
import com.compomics.util.experiment.identification.psm_scoring.psm_scores.IntensityRankScore;
import com.compomics.util.experiment.identification.psm_scoring.psm_scores.MS2MzFidelityScore;
import com.compomics.util.experiment.identification.psm_scoring.psm_scores.PrecursorAccuracy;
import com.compomics.util.experiment.identification.spectrum_annotation.SpecificAnnotationSettings;
import com.compomics.util.experiment.identification.spectrum_annotation.spectrum_annotators.PeptideSpectrumAnnotator;
import com.compomics.util.experiment.massspectrometry.MSnSpectrum;
import com.compomics.util.preferences.IdentificationParameters;
import org.apache.commons.math.MathException;

public class PsmScoresEstimator {
    private PeptideFragmentationModel peptideFragmentationModel;
    private AAIntensityRankScore aaIntensityRankScore;
    private AAMS2MzFidelityScore aaMS2MzFidelityScore;
    private ComplementarityScore complementarityScore;
    private HyperScore crossCorrelation;
    private IntensityRankScore intensityRankScore;
    private MS2MzFidelityScore ms2MzFidelityScore;
    private PrecursorAccuracy precursorAccuracy;

    public PsmScoresEstimator(PeptideFragmentationModel peptideFragmentationModel) {
        this.peptideFragmentationModel = peptideFragmentationModel;
        this.instantiateScores();
    }

    private void instantiateScores() {
        this.aaIntensityRankScore = new AAIntensityRankScore();
        this.aaMS2MzFidelityScore = new AAMS2MzFidelityScore();
        this.complementarityScore = new ComplementarityScore();
        this.crossCorrelation = new HyperScore(this.peptideFragmentationModel);
        this.intensityRankScore = new IntensityRankScore();
        this.ms2MzFidelityScore = new MS2MzFidelityScore();
        this.precursorAccuracy = new PrecursorAccuracy();
    }

    public PsmScoresEstimator() {
        this(PeptideFragmentationModel.uniform);
    }

    public double getDecreasingScore(Peptide peptide, Integer peptideCharge, MSnSpectrum spectrum, IdentificationParameters identificationParameters, SpecificAnnotationSettings specificAnnotationPreferences, PeptideSpectrumAnnotator peptideSpectrumAnnotator, int scoreIndex) throws InterruptedException, MathException {
        PsmScore psmScore = PsmScore.getScore(scoreIndex);
        double score = this.getScore(peptide, peptideCharge, spectrum, identificationParameters, specificAnnotationPreferences, peptideSpectrumAnnotator, psmScore);
        if (psmScore.increasing) {
            return -score;
        }
        return score;
    }

    public double getScore(Peptide peptide, Integer peptideCharge, MSnSpectrum spectrum, IdentificationParameters identificationParameters, SpecificAnnotationSettings specificAnnotationPreferences, PeptideSpectrumAnnotator peptideSpectrumAnnotator, int scoreIndex) throws InterruptedException, MathException {
        PsmScore psmScore = PsmScore.getScore(scoreIndex);
        return this.getScore(peptide, peptideCharge, spectrum, identificationParameters, specificAnnotationPreferences, peptideSpectrumAnnotator, psmScore);
    }

    public double getScore(Peptide peptide, Integer peptideCharge, MSnSpectrum spectrum, IdentificationParameters identificationParameters, SpecificAnnotationSettings specificAnnotationPreferences, PeptideSpectrumAnnotator peptideSpectrumAnnotator, PsmScore psmScore) throws InterruptedException, MathException {
        switch (psmScore) {
            case native_score: {
                throw new IllegalArgumentException("Impossible to compute the native score of an algorithm");
            }
            case precursor_accuracy: {
                return this.precursorAccuracy.getScore(peptide, peptideCharge, spectrum.getPrecursor(), identificationParameters.getSearchParameters().isPrecursorAccuracyTypePpm(), identificationParameters.getSearchParameters().getMinIsotopicCorrection(), identificationParameters.getSearchParameters().getMaxIsotopicCorrection());
            }
            case hyperScore: {
                return this.crossCorrelation.getScore(peptide, spectrum, identificationParameters.getAnnotationPreferences(), specificAnnotationPreferences, peptideSpectrumAnnotator);
            }
            case ms2_mz_fidelity: {
                return this.ms2MzFidelityScore.getScore(peptide, spectrum, identificationParameters.getAnnotationPreferences(), specificAnnotationPreferences, peptideSpectrumAnnotator);
            }
            case aa_ms2_mz_fidelity: {
                return this.aaMS2MzFidelityScore.getScore(peptide, spectrum, identificationParameters.getAnnotationPreferences(), specificAnnotationPreferences, peptideSpectrumAnnotator);
            }
            case intensity: {
                return this.intensityRankScore.getScore(peptide, spectrum, identificationParameters.getAnnotationPreferences(), specificAnnotationPreferences, peptideSpectrumAnnotator);
            }
            case aa_intensity: {
                return this.aaIntensityRankScore.getScore(peptide, spectrum, identificationParameters.getAnnotationPreferences(), specificAnnotationPreferences, peptideSpectrumAnnotator);
            }
            case complementarity: {
                return this.complementarityScore.getScore(peptide, spectrum, identificationParameters.getAnnotationPreferences(), specificAnnotationPreferences, peptideSpectrumAnnotator);
            }
        }
        throw new UnsupportedOperationException("Score not implemented.");
    }
}

