/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.spectrum_annotation.spectrum_annotators;

import com.compomics.util.experiment.biology.Ion;
import com.compomics.util.experiment.biology.NeutralLoss;
import com.compomics.util.experiment.biology.Peptide;
import com.compomics.util.experiment.biology.ions.ReporterIon;
import com.compomics.util.experiment.identification.matches.IonMatch;
import com.compomics.util.experiment.identification.spectrum_annotation.AnnotationSettings;
import com.compomics.util.experiment.identification.spectrum_annotation.simple_annotators.FragmentAnnotator;
import com.compomics.util.experiment.identification.spectrum_annotation.simple_annotators.FragmentAnnotatorNL;
import com.compomics.util.experiment.identification.spectrum_annotation.simple_annotators.ImmoniumIonAnnotator;
import com.compomics.util.experiment.identification.spectrum_annotation.simple_annotators.PrecursorAnnotator;
import com.compomics.util.experiment.identification.spectrum_annotation.simple_annotators.ReporterIonAnnotator;
import com.compomics.util.experiment.massspectrometry.indexes.SpectrumIndex;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

public class SimplePeptideAnnotator {
    private FragmentAnnotator axFragmentAnnotator;
    private FragmentAnnotator byFragmentAnnotator;
    private FragmentAnnotator czFragmentAnnotator;
    private FragmentAnnotatorNL axFragmentAnnotatorNL;
    private FragmentAnnotatorNL byFragmentAnnotatorNL;
    private FragmentAnnotatorNL czFragmentAnnotatorNL;
    private PrecursorAnnotator precursorAnnotator;
    private ImmoniumIonAnnotator immoniumIonAnnotator;
    private ReporterIonAnnotator reporterIonAnnotator;

    public SimplePeptideAnnotator(Peptide peptide, int charge, AnnotationSettings annotationSettings) throws InterruptedException {
        HashSet<Integer> reporterIonsIndexes;
        boolean neutralLossesSequence = annotationSettings.areNeutralLossesSequenceAuto();
        ArrayList<NeutralLoss> neutralLosses = annotationSettings.getNeutralLosses();
        HashMap<Ion.IonType, HashSet<Integer>> ionTypes = annotationSettings.getIonTypes();
        HashSet<Integer> peptideFragmentIons = ionTypes.get((Object)Ion.IonType.PEPTIDE_FRAGMENT_ION);
        if (peptideFragmentIons != null) {
            block5: for (int fragmentIonType : peptideFragmentIons) {
                switch (fragmentIonType) {
                    case 0: 
                    case 3: {
                        IonSeries ionSeries = IonSeries.ax;
                        if (this.axFragmentAnnotator != null) continue block5;
                        this.axFragmentAnnotator = new FragmentAnnotator(peptide, ionSeries, peptideFragmentIons.contains(0), peptideFragmentIons.contains(3));
                        if (neutralLosses.isEmpty()) continue block5;
                        this.axFragmentAnnotatorNL = new FragmentAnnotatorNL(peptide, ionSeries, neutralLossesSequence, peptideFragmentIons.contains(0), peptideFragmentIons.contains(3));
                        continue block5;
                    }
                    case 1: 
                    case 4: {
                        IonSeries ionSeries = IonSeries.by;
                        if (this.byFragmentAnnotator != null) continue block5;
                        this.byFragmentAnnotator = new FragmentAnnotator(peptide, ionSeries, peptideFragmentIons.contains(1), peptideFragmentIons.contains(4));
                        if (neutralLosses.isEmpty()) continue block5;
                        this.byFragmentAnnotatorNL = new FragmentAnnotatorNL(peptide, ionSeries, neutralLossesSequence, peptideFragmentIons.contains(1), peptideFragmentIons.contains(4));
                        continue block5;
                    }
                    case 2: 
                    case 5: {
                        IonSeries ionSeries = IonSeries.cz;
                        if (this.czFragmentAnnotator != null) continue block5;
                        this.czFragmentAnnotator = new FragmentAnnotator(peptide, ionSeries, peptideFragmentIons.contains(2), peptideFragmentIons.contains(5));
                        if (neutralLosses.isEmpty()) continue block5;
                        this.czFragmentAnnotatorNL = new FragmentAnnotatorNL(peptide, ionSeries, neutralLossesSequence, peptideFragmentIons.contains(2), peptideFragmentIons.contains(5));
                        continue block5;
                    }
                }
                throw new UnsupportedOperationException("Ion type " + fragmentIonType + " not supported.");
            }
        }
        if (ionTypes.containsKey((Object)Ion.IonType.PRECURSOR_ION)) {
            this.precursorAnnotator = new PrecursorAnnotator(peptide);
        }
        if (ionTypes.containsKey((Object)Ion.IonType.IMMONIUM_ION) || ionTypes.containsKey((Object)Ion.IonType.RELATED_ION)) {
            char[] peptideSequence = peptide.getSequence().toCharArray();
            this.immoniumIonAnnotator = new ImmoniumIonAnnotator(peptideSequence);
        }
        if ((reporterIonsIndexes = ionTypes.get((Object)Ion.IonType.REPORTER_ION)) != null) {
            ReporterIon[] reporterIons = new ReporterIon[reporterIonsIndexes.size()];
            int cpt = 0;
            for (int index : reporterIonsIndexes) {
                reporterIons[cpt++] = ReporterIon.getReporterIon(index);
            }
            this.reporterIonAnnotator = new ReporterIonAnnotator(reporterIons);
        }
    }

    public SimplePeptideAnnotator(Peptide peptide, int charge, boolean a, boolean b, boolean c, boolean x, boolean y, boolean z, boolean precursor, boolean immonium, boolean related, boolean reporter, boolean neutralLosses, boolean neutralLossesSequenceDependent, ReporterIon[] reporterIons) throws InterruptedException {
        if (a & x) {
            this.axFragmentAnnotator = new FragmentAnnotator(peptide, IonSeries.ax);
            if (neutralLosses) {
                this.axFragmentAnnotatorNL = new FragmentAnnotatorNL(peptide, IonSeries.ax, neutralLossesSequenceDependent);
            }
        } else if (a || x) {
            this.axFragmentAnnotator = new FragmentAnnotator(peptide, IonSeries.ax, a, x);
            if (neutralLosses) {
                this.axFragmentAnnotatorNL = new FragmentAnnotatorNL(peptide, IonSeries.ax, neutralLossesSequenceDependent, a, x);
            }
        }
        if (b & y) {
            this.byFragmentAnnotator = new FragmentAnnotator(peptide, IonSeries.by);
            if (neutralLosses) {
                this.byFragmentAnnotatorNL = new FragmentAnnotatorNL(peptide, IonSeries.by, neutralLossesSequenceDependent);
            }
        } else if (b || y) {
            this.byFragmentAnnotator = new FragmentAnnotator(peptide, IonSeries.by, b, y);
            if (neutralLosses) {
                this.byFragmentAnnotatorNL = new FragmentAnnotatorNL(peptide, IonSeries.by, neutralLossesSequenceDependent, b, y);
            }
        }
        if (c & z) {
            this.czFragmentAnnotator = new FragmentAnnotator(peptide, IonSeries.cz);
            if (neutralLosses) {
                this.czFragmentAnnotatorNL = new FragmentAnnotatorNL(peptide, IonSeries.cz, neutralLossesSequenceDependent);
            }
        } else if (c || z) {
            this.czFragmentAnnotator = new FragmentAnnotator(peptide, IonSeries.cz, c, z);
            if (neutralLosses) {
                this.czFragmentAnnotatorNL = new FragmentAnnotatorNL(peptide, IonSeries.cz, neutralLossesSequenceDependent, c, z);
            }
        }
        if (precursor) {
            this.precursorAnnotator = new PrecursorAnnotator(peptide);
        }
        if (immonium || related) {
            this.immoniumIonAnnotator = new ImmoniumIonAnnotator(peptide.getSequence().toCharArray(), immonium, related);
        }
        if (reporter) {
            this.reporterIonAnnotator = new ReporterIonAnnotator(reporterIons);
        }
    }

    public ArrayList<IonMatch> getIonMatches(SpectrumIndex spectrumIndex, int peptideCharge, int precursorIsotopeMax) {
        ArrayList<IonMatch> result = new ArrayList<IonMatch>(0);
        if (this.axFragmentAnnotator != null) {
            result.addAll(this.axFragmentAnnotator.getIonMatches(spectrumIndex, peptideCharge));
        }
        if (this.axFragmentAnnotatorNL != null) {
            result.addAll(this.axFragmentAnnotatorNL.getIonMatches(spectrumIndex, peptideCharge));
        }
        if (this.byFragmentAnnotator != null) {
            result.addAll(this.byFragmentAnnotator.getIonMatches(spectrumIndex, peptideCharge));
        }
        if (this.byFragmentAnnotatorNL != null) {
            result.addAll(this.byFragmentAnnotatorNL.getIonMatches(spectrumIndex, peptideCharge));
        }
        if (this.czFragmentAnnotator != null) {
            result.addAll(this.czFragmentAnnotator.getIonMatches(spectrumIndex, peptideCharge));
        }
        if (this.czFragmentAnnotatorNL != null) {
            result.addAll(this.czFragmentAnnotatorNL.getIonMatches(spectrumIndex, peptideCharge));
        }
        if (this.precursorAnnotator != null) {
            result.addAll(this.precursorAnnotator.getIonMatches(spectrumIndex, peptideCharge, precursorIsotopeMax));
        }
        if (this.immoniumIonAnnotator != null) {
            result.addAll(this.immoniumIonAnnotator.getIonMatches(spectrumIndex));
        }
        if (this.reporterIonAnnotator != null) {
            result.addAll(this.reporterIonAnnotator.getIonMatches(spectrumIndex));
        }
        return result;
    }

    public static enum IonSeries {
        ax(0, 3),
        by(1, 4),
        cz(2, 5);

        public final int forwardSeries;
        public final int complementarySeries;

        private IonSeries(int forwardSeries, int complementarySeries) {
            this.forwardSeries = forwardSeries;
            this.complementarySeries = complementarySeries;
        }
    }
}

