/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.io.identifications.idfilereaders;

import com.compomics.util.Util;
import com.compomics.util.experiment.biology.AminoAcid;
import com.compomics.util.experiment.biology.AminoAcidSequence;
import com.compomics.util.experiment.biology.Atom;
import com.compomics.util.experiment.biology.Peptide;
import com.compomics.util.experiment.identification.Advocate;
import com.compomics.util.experiment.identification.SpectrumIdentificationAssumption;
import com.compomics.util.experiment.identification.identification_parameters.SearchParameters;
import com.compomics.util.experiment.identification.matches.ModificationMatch;
import com.compomics.util.experiment.identification.matches.SpectrumMatch;
import com.compomics.util.experiment.identification.spectrum_assumptions.PeptideAssumption;
import com.compomics.util.experiment.io.identifications.IdfileReader;
import com.compomics.util.experiment.massspectrometry.Charge;
import com.compomics.util.experiment.massspectrometry.Spectrum;
import com.compomics.util.experiment.massspectrometry.SpectrumFactory;
import com.compomics.util.preferences.SequenceMatchingPreferences;
import com.compomics.util.waiting.WaitingHandler;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import javax.xml.bind.JAXBException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class PepxmlIdfileReader
implements IdfileReader {
    private LinkedList<SpectrumMatch> spectrumMatches = null;
    private String searchEngine = null;
    private String searchEngineVersion = null;
    private File idFile;
    private String inputFileName;
    private SpectrumFactory spectrumFactory = SpectrumFactory.getInstance();
    private HashMap<Character, ArrayList<Double>> fixedModificationsMassDiffs;
    private ArrayList<Double> fixedModificationMasses;
    private ArrayList<Double> fixedNTerminalModifications = new ArrayList();
    private ArrayList<Double> fixedCTerminalModifications = new ArrayList();

    public PepxmlIdfileReader() {
    }

    public PepxmlIdfileReader(File idFile) {
        this.idFile = idFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseFile(WaitingHandler waitingHandler, boolean expandAaCombinations, boolean overwriteExtension) throws XmlPullParserException, FileNotFoundException, IOException, SQLException, ClassNotFoundException, InterruptedException {
        XmlPullParserFactory factory = XmlPullParserFactory.newInstance((String)System.getProperty("org.xmlpull.v1.XmlPullParserFactory"), null);
        factory.setNamespaceAware(true);
        XmlPullParser parser = factory.newPullParser();
        BufferedReader br = new BufferedReader(new FileReader(this.idFile));
        try {
            int type;
            parser.setInput((Reader)br);
            boolean hasMatch = false;
            HashMap<String, SpectrumMatch> spectrumMatchesMap = new HashMap<String, SpectrumMatch>();
            this.spectrumMatches = new LinkedList();
            SpectrumMatch currentMatch = null;
            Integer currentCharge = null;
            while ((type = parser.next()) != 1) {
                String tagName = parser.getName();
                if (type == 2 && tagName.equals("msms_run_summary")) {
                    this.parseRunSummary(parser, overwriteExtension);
                    if (waitingHandler != null && this.spectrumFactory.fileLoaded(this.inputFileName)) {
                        waitingHandler.setMaxSecondaryProgressCounter(this.spectrumFactory.getNSpectra(this.inputFileName));
                        waitingHandler.setSecondaryProgressCounter(0);
                    }
                }
                if (type == 2 && tagName.equals("search_summary")) {
                    this.parseSearchSummary(parser);
                }
                if (type == 2 && tagName.equals("spectrum_query")) {
                    currentMatch = this.parseSpectrumQuery(parser);
                    SpectrumMatch previousMatch = (SpectrumMatch)spectrumMatchesMap.get(currentMatch.getKey());
                    if (previousMatch != null) {
                        currentMatch = previousMatch;
                    }
                    for (int i = 0; i < parser.getAttributeCount(); ++i) {
                        String attributeName = parser.getAttributeName(i);
                        if (!attributeName.equals("assumed_charge")) continue;
                        String value = parser.getAttributeValue(i);
                        try {
                            currentCharge = new Integer(value.trim());
                            continue;
                        }
                        catch (Exception e) {
                            throw new IllegalArgumentException("Charge " + value + " could not be parsed. Integer expected.");
                        }
                    }
                }
                if (type == 2 && tagName.equals("search_hit")) {
                    if (currentMatch == null) {
                        throw new IllegalArgumentException("No spectrum match when parsing search hit.");
                    }
                    if (currentCharge == null) {
                        throw new IllegalArgumentException("No charge found when parsing search hit of spectrum " + currentMatch.getKey() + ".");
                    }
                    PeptideAssumption peptideAssumption = this.parseSearchHit(parser, currentCharge);
                    Peptide peptide = peptideAssumption.getPeptide();
                    String peptideSequence = peptide.getSequence();
                    hasMatch = true;
                    boolean found = false;
                    if (currentMatch.getAllAssumptions() != null) {
                        for (SpectrumIdentificationAssumption tempAssumption : currentMatch.getAllAssumptions()) {
                            boolean sameModifications;
                            PeptideAssumption tempPeptideAssumption = (PeptideAssumption)tempAssumption;
                            Peptide tempPeptide = tempPeptideAssumption.getPeptide();
                            if (!peptide.getSequence().equals(tempPeptide.getSequence())) continue;
                            boolean bl = sameModifications = peptide.getNModifications() == tempPeptide.getNModifications();
                            if (sameModifications && peptide.isModified()) {
                                for (ModificationMatch modificationMatch : peptide.getModificationMatches()) {
                                    boolean ptmFound = false;
                                    for (ModificationMatch otherMatch : tempPeptide.getModificationMatches()) {
                                        if (!modificationMatch.getTheoreticPtm().equals(otherMatch.getTheoreticPtm()) || modificationMatch.getModificationSite() != otherMatch.getModificationSite()) continue;
                                        ptmFound = true;
                                        break;
                                    }
                                    if (ptmFound) continue;
                                    sameModifications = false;
                                    break;
                                }
                            }
                            if (!sameModifications) continue;
                            found = true;
                            break;
                        }
                    }
                    if (!found) {
                        Advocate advocate = Advocate.getAdvocate(this.searchEngine);
                        if (expandAaCombinations && AminoAcidSequence.hasCombination(peptideSequence)) {
                            ArrayList<ModificationMatch> previousModificationMatches = peptide.getModificationMatches();
                            ArrayList<ModificationMatch> newModificationMatches = null;
                            if (previousModificationMatches != null) {
                                newModificationMatches = new ArrayList<ModificationMatch>(previousModificationMatches.size());
                            }
                            for (StringBuilder expandedSequence : AminoAcidSequence.getCombinations(peptide.getSequence())) {
                                Peptide newPeptide = new Peptide(expandedSequence.toString(), newModificationMatches, true);
                                if (previousModificationMatches != null) {
                                    for (ModificationMatch modificationMatch : previousModificationMatches) {
                                        newPeptide.addModificationMatch(new ModificationMatch(modificationMatch.getTheoreticPtm(), modificationMatch.isVariable(), modificationMatch.getModificationSite()));
                                    }
                                }
                                PeptideAssumption peptideAssumption2 = new PeptideAssumption(newPeptide, peptideAssumption.getRank(), peptideAssumption.getAdvocate(), peptideAssumption.getIdentificationCharge(), peptideAssumption.getScore(), peptideAssumption.getIdentificationFile());
                                currentMatch.addHit(advocate.getIndex(), peptideAssumption2, false);
                            }
                        } else {
                            currentMatch.addHit(advocate.getIndex(), peptideAssumption, false);
                        }
                    }
                }
                if (type != 3 || !tagName.equals("spectrum_query")) continue;
                if (hasMatch) {
                    String key = currentMatch.getKey();
                    if (!spectrumMatchesMap.containsKey(key)) {
                        spectrumMatchesMap.put(key, currentMatch);
                        this.spectrumMatches.add(currentMatch);
                    }
                    hasMatch = false;
                    currentMatch = null;
                    currentCharge = null;
                }
                if (waitingHandler == null || !this.spectrumFactory.fileLoaded(this.inputFileName)) continue;
                waitingHandler.increaseSecondaryProgressCounter();
            }
            spectrumMatchesMap.clear();
        }
        finally {
            br.close();
        }
    }

    private PeptideAssumption parseSearchHit(XmlPullParser parser, Integer charge) throws XmlPullParserException, IOException {
        String attributeName;
        int type;
        Integer rank = null;
        String sequence = null;
        ArrayList<ModificationMatch> modificationMatches = new ArrayList<ModificationMatch>();
        Double score = null;
        for (int i = 0; i < parser.getAttributeCount(); ++i) {
            String name = parser.getAttributeName(i);
            if (name.equals("hit_rank")) {
                String value = parser.getAttributeValue(i);
                try {
                    rank = new Integer(value.trim());
                    continue;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("An error occurred while parsing rank " + value + ". Integer expected.");
                }
            }
            if (!name.equals("peptide")) continue;
            sequence = parser.getAttributeValue(i).trim();
        }
        while ((type = parser.next()) != 2) {
        }
        String tagName = parser.getName();
        if (tagName.equals("modification_info")) {
            for (int i = 0; i < parser.getAttributeCount(); ++i) {
                int site;
                boolean variableModification;
                String attributeName2 = parser.getAttributeName(i);
                if (!attributeName2.equals("mod_nterm_mass") && !attributeName2.equals("mod_cterm_mass")) continue;
                String value = parser.getAttributeValue(i).trim();
                Double terminalMass = null;
                try {
                    terminalMass = new Double(value);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("An error occurred while parsing modification terminal mass " + value + ". Number expected.");
                }
                if (attributeName2.equals("mod_nterm_mass")) {
                    variableModification = !this.fixedNTerminalModifications.contains(terminalMass);
                } else {
                    boolean bl = variableModification = !this.fixedCTerminalModifications.contains(terminalMass);
                }
                if (attributeName2.equals("mod_nterm_mass")) {
                    site = 1;
                    terminalMass = terminalMass - Atom.H.getMonoisotopicMass();
                } else {
                    site = sequence.length();
                    terminalMass = terminalMass - (Atom.O.getMonoisotopicMass() + Atom.H.getMonoisotopicMass());
                    if (this.searchEngine != null && this.searchEngine.equalsIgnoreCase("Comet") && this.searchEngineVersion != null && !this.searchEngineVersion.equalsIgnoreCase("2015.02 rev. 4") && !this.searchEngineVersion.equalsIgnoreCase("2015.02 rev. 5")) {
                        terminalMass = terminalMass - Atom.H.getMonoisotopicMass();
                    }
                }
                char aa = sequence.charAt(site - 1);
                terminalMass = Util.roundDouble(terminalMass, 2);
                String tempModificationName = terminalMass + "@" + aa;
                ModificationMatch modificationMatch = new ModificationMatch(tempModificationName, variableModification, site);
                modificationMatches.add(modificationMatch);
            }
            while ((type = parser.next()) != 1) {
                tagName = parser.getName();
                if (tagName == null) continue;
                if (tagName.equals("mod_aminoacid_mass")) {
                    boolean variableModification;
                    Integer site = null;
                    for (int i = 0; i < parser.getAttributeCount(); ++i) {
                        String attributeName3 = parser.getAttributeName(i);
                        if (!attributeName3.equals("position")) continue;
                        String value = parser.getAttributeValue(i);
                        try {
                            site = new Integer(value);
                            continue;
                        }
                        catch (Exception e) {
                            throw new IllegalArgumentException("An error occurred while parsing modification position " + value + ". Integer expected.");
                        }
                    }
                    if (site == null) continue;
                    Double modifiedAaMass = null;
                    for (int i = 0; i < parser.getAttributeCount(); ++i) {
                        attributeName = parser.getAttributeName(i);
                        if (!attributeName.equals("mass")) continue;
                        String value = parser.getAttributeValue(i);
                        try {
                            modifiedAaMass = new Double(value);
                            continue;
                        }
                        catch (Exception e) {
                            throw new IllegalArgumentException("An error occurred while parsing modification mass " + value + ". Number expected.");
                        }
                    }
                    if (modifiedAaMass == null) continue;
                    char aa = sequence.charAt(site - 1);
                    AminoAcid aminoAcid = AminoAcid.getAminoAcid(aa);
                    double fixedModificationMass = 0.0;
                    if (this.fixedModificationMasses.contains(modifiedAaMass)) {
                        variableModification = false;
                    } else {
                        if (this.fixedModificationsMassDiffs.get(Character.valueOf(aa)) != null) {
                            for (Double tempMassDiff : this.fixedModificationsMassDiffs.get(Character.valueOf(aa))) {
                                fixedModificationMass += tempMassDiff.doubleValue();
                            }
                        }
                        variableModification = true;
                    }
                    if (!variableModification) continue;
                    double modificationMass = modifiedAaMass - fixedModificationMass - aminoAcid.getMonoisotopicMass();
                    modificationMass = Util.roundDouble(modificationMass, 2);
                    String tempModificationName = modificationMass + "@" + aa;
                    ModificationMatch modificationMatch = new ModificationMatch(tempModificationName, true, site);
                    modificationMatches.add(modificationMatch);
                    continue;
                }
                if (type != 3 || !parser.getName().equals("modification_info")) continue;
                while ((type = parser.next()) != 2) {
                }
                break block13;
            }
        }
        while (type != 1) {
            tagName = parser.getName();
            if (tagName != null) {
                if (type == 2 && parser.getName().equals("search_score")) {
                    String name = null;
                    String value = null;
                    for (int i = 0; i < parser.getAttributeCount(); ++i) {
                        attributeName = parser.getAttributeName(i);
                        if (attributeName.equals("name")) {
                            name = parser.getAttributeValue(i);
                            continue;
                        }
                        if (!attributeName.equals("value")) continue;
                        value = parser.getAttributeValue(i);
                    }
                    if (name != null && value != null && (name.equals("expect") || name.equals("Morpheus Score"))) {
                        try {
                            score = new Double(value);
                        }
                        catch (Exception e) {
                            throw new IllegalArgumentException("Impossible to parse expectation value " + value + ". Number expected.");
                        }
                    }
                } else if (type == 3 && tagName.equals("search_hit")) break;
            }
            type = parser.next();
        }
        Peptide peptide = new Peptide(sequence, modificationMatches, true);
        Advocate advocate = Advocate.getAdvocate(this.searchEngine);
        return new PeptideAssumption(peptide, rank, advocate.getIndex(), new Charge(1, charge), score, this.idFile.getName());
    }

    private SpectrumMatch parseSpectrumQuery(XmlPullParser parser) throws XmlPullParserException, IOException {
        String spectrumTitle;
        Integer index = null;
        String spectrumId = null;
        String spectrumNativeID = null;
        for (int i = 0; i < parser.getAttributeCount(); ++i) {
            String name = parser.getAttributeName(i);
            if (name.equals("spectrum")) {
                spectrumId = parser.getAttributeValue(i);
                continue;
            }
            if (name.equals("index")) {
                String value = parser.getAttributeValue(i);
                try {
                    index = new Integer(value.trim());
                    continue;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("An error occurred while parsing index " + value + ". Integer expected.");
                }
            }
            if (!name.equals("spectrumNativeID")) continue;
            spectrumNativeID = parser.getAttributeValue(i);
        }
        if (index == null) {
            throw new IllegalArgumentException("No index found for spectrum " + spectrumId + ".");
        }
        if (spectrumNativeID != null) {
            spectrumTitle = spectrumNativeID;
        } else {
            spectrumTitle = index + "";
            if (this.spectrumFactory.fileLoaded(this.inputFileName)) {
                spectrumTitle = this.spectrumFactory.getSpectrumTitle(this.inputFileName, index);
            }
        }
        String spectrumKey = Spectrum.getSpectrumKey(this.inputFileName, spectrumTitle);
        SpectrumMatch spectrumMatch = new SpectrumMatch(spectrumKey);
        spectrumMatch.setSpectrumNumber(index);
        return spectrumMatch;
    }

    private void parseRunSummary(XmlPullParser parser, boolean overwriteExtension) throws XmlPullParserException, IOException {
        String path = "";
        for (int i = 0; i < parser.getAttributeCount(); ++i) {
            String name = parser.getAttributeName(i);
            if (name.equals("base_name")) {
                path = path + parser.getAttributeValue(i);
                continue;
            }
            if (overwriteExtension || !name.equals("raw_data")) continue;
            path = path + parser.getAttributeValue(i);
        }
        if (overwriteExtension) {
            path = path + ".mgf";
        }
        File spectrumFile = new File(path);
        this.inputFileName = Util.getFileName(spectrumFile);
    }

    private void parseSearchSummary(XmlPullParser parser) throws XmlPullParserException, IOException {
        int type;
        for (int i = 0; i < parser.getAttributeCount(); ++i) {
            String name = parser.getAttributeName(i);
            if (name.equals("search_engine")) {
                this.searchEngine = parser.getAttributeValue(i);
                continue;
            }
            if (!name.equals("search_engine_version")) continue;
            this.searchEngineVersion = parser.getAttributeValue(i);
        }
        this.fixedModificationsMassDiffs = new HashMap();
        this.fixedModificationMasses = new ArrayList();
        this.fixedNTerminalModifications = new ArrayList();
        this.fixedCTerminalModifications = new ArrayList();
        while (!((type = parser.next()) == 1 || type == 3 && parser.getName() != null && parser.getName().equals("search_summary"))) {
            if (type != 2) continue;
            String tagName = parser.getName();
            if (type == 2 && tagName.equals("aminoacid_modification")) {
                Character aminoacid = null;
                Boolean variable = null;
                Double massDiff = null;
                Double mass = null;
                for (int i = 0; i < parser.getAttributeCount(); ++i) {
                    String name = parser.getAttributeName(i);
                    if (name.equals("aminoacid")) {
                        aminoacid = Character.valueOf(parser.getAttributeValue(i).charAt(0));
                        continue;
                    }
                    if (name.equals("massdiff")) {
                        massDiff = new Double(parser.getAttributeValue(i));
                        continue;
                    }
                    if (name.equals("mass")) {
                        mass = new Double(parser.getAttributeValue(i));
                        continue;
                    }
                    if (!name.equals("variable")) continue;
                    String variableAsString = parser.getAttributeValue(i);
                    if (variableAsString.equalsIgnoreCase("Y")) {
                        variable = true;
                        continue;
                    }
                    if (!variableAsString.equalsIgnoreCase("N")) continue;
                    variable = false;
                }
                if (variable != null && massDiff != null && mass != null && aminoacid != null) {
                    if (variable.booleanValue()) continue;
                    ArrayList<Double> massDiffs = this.fixedModificationsMassDiffs.get(aminoacid);
                    if (massDiffs == null) {
                        massDiffs = new ArrayList();
                    }
                    massDiffs.add(massDiff);
                    this.fixedModificationsMassDiffs.put(aminoacid, massDiffs);
                    this.fixedModificationMasses.add(mass);
                    continue;
                }
                throw new IllegalArgumentException("An error occurred while parsing aminoacid_modification element. Missing values.");
            }
            if (type != 2 || !tagName.equals("terminal_modification")) continue;
            Boolean variable = null;
            Double mass = null;
            String terminus = null;
            for (int i = 0; i < parser.getAttributeCount(); ++i) {
                String name = parser.getAttributeName(i);
                if (name.equals("terminus")) {
                    String terminusAsString = parser.getAttributeValue(i);
                    if (!terminusAsString.equalsIgnoreCase("N") && !terminusAsString.equalsIgnoreCase("C")) continue;
                    terminus = terminusAsString;
                    continue;
                }
                if (name.equals("mass")) {
                    mass = new Double(parser.getAttributeValue(i));
                    continue;
                }
                if (!name.equals("variable")) continue;
                String variableAsString = parser.getAttributeValue(i);
                if (variableAsString.equalsIgnoreCase("Y")) {
                    variable = true;
                    continue;
                }
                if (!variableAsString.equalsIgnoreCase("N")) continue;
                variable = false;
            }
            if (variable != null && mass != null && terminus != null) {
                if (variable.booleanValue()) continue;
                if (terminus.equalsIgnoreCase("N")) {
                    this.fixedNTerminalModifications.add(mass);
                    continue;
                }
                this.fixedCTerminalModifications.add(mass);
                continue;
            }
            throw new IllegalArgumentException("An error occurred while parsing terminal_modification element. Missing values.");
        }
    }

    @Override
    public HashMap<String, ArrayList<String>> getSoftwareVersions() {
        ArrayList<String> versions = new ArrayList<String>(1);
        versions.add(this.searchEngineVersion);
        HashMap<String, ArrayList<String>> result = new HashMap<String, ArrayList<String>>(1);
        result.put(this.searchEngine, versions);
        return result;
    }

    @Override
    public String getExtension() {
        return ".pep.xml";
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public LinkedList<SpectrumMatch> getAllSpectrumMatches(WaitingHandler waitingHandler, SearchParameters searchParameters) throws IOException, IllegalArgumentException, SQLException, ClassNotFoundException, InterruptedException, JAXBException, XmlPullParserException {
        return this.getAllSpectrumMatches(waitingHandler, searchParameters, null, true);
    }

    @Override
    public LinkedList<SpectrumMatch> getAllSpectrumMatches(WaitingHandler waitingHandler, SearchParameters searchParameters, SequenceMatchingPreferences sequenceMatchingPreferences, boolean expandAaCombinations) throws IOException, IllegalArgumentException, SQLException, ClassNotFoundException, InterruptedException, JAXBException, XmlPullParserException {
        if (this.spectrumMatches == null) {
            this.parseFile(waitingHandler, expandAaCombinations, true);
        }
        return this.spectrumMatches;
    }

    @Override
    public boolean hasDeNovoTags() {
        return false;
    }
}

