/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.massspectrometry.indexes;

import com.compomics.util.experiment.massspectrometry.Peak;
import com.compomics.util.experiment.personalization.UrParameter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import org.apache.commons.math.util.FastMath;

public class SpectrumIndex
implements UrParameter {
    double precursorTolerance;
    boolean ppm;
    private HashMap<Integer, HashMap<Double, Peak>> peaksMap;
    private static final double mzAnchor = 1000.0;
    private static final double mzAnchorLog = FastMath.log((double)1000.0);
    private double scalingFactor;
    private Integer binMax;
    private Integer binMin;
    private double totalIntensity;
    public final double intensityLimit;

    public SpectrumIndex() {
        this.intensityLimit = 0.0;
    }

    public SpectrumIndex(HashMap<Double, Peak> peaks, double intenstiyLimit, double tolerance, boolean ppm) {
        this.intensityLimit = intenstiyLimit;
        this.peaksMap = new HashMap();
        this.precursorTolerance = tolerance;
        this.ppm = ppm;
        if (ppm) {
            this.scalingFactor = FastMath.log((double)((1000000.0 - tolerance) / (1000000.0 + tolerance)));
        }
        this.totalIntensity = 0.0;
        for (Peak peak : peaks.values()) {
            HashMap<Double, Peak> peaksInBin;
            if (!(peak.intensity >= intenstiyLimit)) continue;
            this.totalIntensity += peak.intensity;
            Integer bin = this.getBin(peak.mz);
            if (this.binMax == null || bin > this.binMax) {
                this.binMax = bin;
            }
            if (this.binMin == null || bin < this.binMin) {
                this.binMin = bin;
            }
            if ((peaksInBin = this.peaksMap.get(bin)) == null) {
                peaksInBin = new HashMap(4);
                this.peaksMap.put(bin, peaksInBin);
            }
            peaksInBin.put(peak.mz, peak);
        }
    }

    public int getBin(double mz) {
        if (this.ppm) {
            return this.getBinPpm(mz);
        }
        return this.getBinAbsolute(mz);
    }

    private int getBinAbsolute(double mz) {
        int bin = (int)(mz / this.precursorTolerance);
        return bin;
    }

    private int getBinPpm(double mz) {
        int bin = (int)((FastMath.log((double)mz) - mzAnchorLog) / this.scalingFactor);
        return bin;
    }

    public ArrayList<Peak> getMatchingPeaks(double mz) {
        double error;
        int bin0 = this.ppm ? this.getBinPpm(mz) : this.getBinAbsolute(mz);
        ArrayList<Peak> result = new ArrayList<Peak>(0);
        HashMap<Double, Peak> binContent = this.peaksMap.get(bin0 - 1);
        if (binContent != null) {
            for (Double peakMz : binContent.keySet()) {
                error = this.ppm ? 1000000.0 * (peakMz - mz) / mz : peakMz - mz;
                if (!(Math.abs(error) <= this.precursorTolerance)) continue;
                result.add(binContent.get(peakMz));
            }
        }
        if ((binContent = this.peaksMap.get(bin0)) != null) {
            for (Double peakMz : binContent.keySet()) {
                error = this.ppm ? 1000000.0 * (peakMz - mz) / mz : peakMz - mz;
                if (!(Math.abs(error) <= this.precursorTolerance)) continue;
                result.add(binContent.get(peakMz));
            }
        }
        if ((binContent = this.peaksMap.get(bin0 + 1)) != null) {
            for (Double peakMz : binContent.keySet()) {
                error = this.ppm ? 1000000.0 * (peakMz - mz) / mz : peakMz - mz;
                if (!(Math.abs(error) <= this.precursorTolerance)) continue;
                result.add(binContent.get(peakMz));
            }
        }
        return result;
    }

    public ArrayList<Integer> getBins() {
        return new ArrayList<Integer>(this.peaksMap.keySet());
    }

    public Set<Integer> getRawBins() {
        return this.peaksMap.keySet();
    }

    public HashMap<Double, Peak> getPeaksInBin(Integer bin) {
        return this.peaksMap.get(bin);
    }

    public Double getMass(int bin) {
        if (this.ppm) {
            return FastMath.exp((double)(this.scalingFactor * (double)bin + mzAnchorLog));
        }
        return this.precursorTolerance * (0.5 + (double)bin);
    }

    public Integer getBinMax() {
        return this.binMax;
    }

    public Integer getBinMin() {
        return this.binMin;
    }

    public double getTotalIntensity() {
        return this.totalIntensity;
    }

    @Override
    public String getParameterKey() {
        return "SpectrumIndex";
    }
}

