/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.general;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Logger;

public class FileLoggerImplementation
implements com.compomics.util.interfaces.Logger {
    Logger logger = Logger.getLogger(FileLoggerImplementation.class);
    private BufferedWriter iOut = null;
    private SimpleDateFormat iSdf = null;

    public FileLoggerImplementation(String aFilename) throws IOException {
        this(aFilename, "dd/MM/yyyy - HH:mm:ss");
    }

    public FileLoggerImplementation(String aFilename, String aFormat) throws IOException {
        this.iOut = new BufferedWriter(new FileWriter(aFilename));
        this.iSdf = new SimpleDateFormat(aFormat);
    }

    @Override
    public void logTime(String aMessage) {
        try {
            this.iOut.write(this.getTimestamp() + " " + aMessage + "\n");
            this.iOut.flush();
        }
        catch (IOException ioe) {
            this.logger.error((Object)ioe.getMessage(), (Throwable)ioe);
        }
    }

    @Override
    public void logNormalEvent(String aMessage) {
        try {
            this.iOut.write(" - " + aMessage + "\n");
            this.iOut.flush();
        }
        catch (IOException ioe) {
            this.logger.error((Object)ioe.getMessage(), (Throwable)ioe);
        }
    }

    @Override
    public void logExceptionalEvent(String aMessage) {
        try {
            this.iOut.write(" * " + this.getTimestamp() + " " + aMessage + "\n");
            this.iOut.flush();
        }
        catch (IOException ioe) {
            this.logger.error((Object)ioe.getMessage(), (Throwable)ioe);
        }
    }

    protected void finalize() throws Throwable {
        this.iOut.flush();
        this.iOut.close();
        this.iOut = null;
        super.finalize();
    }

    public void close() {
        try {
            this.iOut.flush();
            this.iOut.close();
            this.iOut = null;
        }
        catch (IOException ioe) {
            this.logger.error((Object)ioe.getMessage(), (Throwable)ioe);
        }
    }

    private String getTimestamp() {
        long current = System.currentTimeMillis();
        return this.iSdf.format(new Date(current));
    }
}

