/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRootPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.table.TableCellRenderer;

public class GuiUtilities {
    private static final KeyStroke escapeStroke = KeyStroke.getKeyStroke(27, 0);
    private static final String dispatchWindowClosingActionMapKey = "com.compomics.util.gui:WINDOW_CLOSING";

    public static int getPreferredWidthOfCell(JTable table, int rowIndex, int colIndex) {
        int width = 0;
        TableCellRenderer renderer = table.getCellRenderer(rowIndex, colIndex);
        Component comp = renderer.getTableCellRendererComponent(table, table.getValueAt(rowIndex, colIndex), false, false, rowIndex, colIndex);
        width = Math.max(width, comp.getPreferredSize().width);
        return width;
    }

    public static boolean validateIntegerInput(Component parentComponent, JLabel label, JTextField textField, String valueDescription, String errorTitle, boolean positiveValue, boolean showMessage, boolean valid) {
        label.setForeground(Color.BLACK);
        label.setToolTipText(null);
        if (textField.getText() == null || textField.getText().trim().equals("")) {
            if (showMessage) {
                JOptionPane.showMessageDialog(parentComponent, "You need to specify the " + valueDescription + ".", errorTitle, 2);
            }
            valid = false;
            label.setForeground(Color.RED);
            label.setToolTipText("Please select the " + valueDescription);
        }
        int tempValue = -1;
        try {
            tempValue = Integer.parseInt(textField.getText().trim());
        }
        catch (NumberFormatException nfe) {
            if (showMessage && valid) {
                JOptionPane.showMessageDialog(parentComponent, "You need to specify an integer for " + valueDescription + ".", errorTitle, 2);
            }
            valid = false;
            label.setForeground(Color.RED);
            label.setToolTipText("Please select an integer");
        }
        if (positiveValue && tempValue < 0) {
            if (showMessage && valid) {
                JOptionPane.showMessageDialog(parentComponent, "You need to specify an integer for " + valueDescription + ".", errorTitle, 2);
            }
            valid = false;
            label.setForeground(Color.RED);
            label.setToolTipText("Please select an integer");
        }
        return valid;
    }

    public static boolean validateDoubleInput(Component parentComponent, JLabel label, JTextField textField, String valueDescription, String errorTitle, boolean positiveValue, boolean showMessage, boolean valid) {
        label.setForeground(Color.BLACK);
        label.setToolTipText(null);
        if (textField.getText() == null || textField.getText().trim().equals("")) {
            if (showMessage) {
                JOptionPane.showMessageDialog(parentComponent, "You need to specify the " + valueDescription + ".", errorTitle, 2);
            }
            valid = false;
            label.setForeground(Color.RED);
            label.setToolTipText("Please select the " + valueDescription);
        }
        double tempValue = -1.0;
        try {
            tempValue = Double.parseDouble(textField.getText().trim());
        }
        catch (NumberFormatException nfe) {
            if (showMessage && valid) {
                JOptionPane.showMessageDialog(parentComponent, "You need to specify a number for " + valueDescription + ".", errorTitle, 2);
            }
            valid = false;
            label.setForeground(Color.RED);
            label.setToolTipText("Please select a number");
        }
        if (positiveValue && tempValue < 0.0) {
            if (showMessage && valid) {
                JOptionPane.showMessageDialog(parentComponent, "You need to specify a positive number for " + valueDescription + ".", errorTitle, 2);
                textField.requestFocus();
            }
            valid = false;
            label.setForeground(Color.RED);
            label.setToolTipText("Please select a positive number");
        }
        return valid;
    }

    public static void installEscapeCloseOperation(final JDialog dialog) {
        AbstractAction dispatchClosing = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                dialog.dispatchEvent(new WindowEvent(dialog, 201));
            }
        };
        JRootPane root = dialog.getRootPane();
        root.getInputMap(2).put(escapeStroke, dispatchWindowClosingActionMapKey);
        root.getActionMap().put(dispatchWindowClosingActionMapKey, dispatchClosing);
    }
}

