/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.gui.error_handlers;

import com.compomics.util.Util;
import com.compomics.util.examples.BareBonesBrowserLaunch;
import com.compomics.util.preferences.LastSelectedFolder;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.border.TitledBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class BugReport
extends JDialog {
    private LastSelectedFolder lastSelectedFolder;
    public static final String lastSelectedFolderKey = "bug_report";
    private String toolName;
    private String gitHubProjectName;
    private String toolVersion;
    private String googleGroup;
    private String googleGroupName;
    private File logFile;
    private JPanel backgroundPanel;
    private JButton clearJButton;
    private JButton exitButton;
    private JEditorPane infoJEditorPane;
    private JPanel infoJPanel;
    private JScrollPane infoJScrollPane;
    private JPanel logJPanel;
    private JScrollPane logJScrollPane;
    private JTextArea logTxt;
    private JButton saveJButton;

    public BugReport(JFrame frame, LastSelectedFolder selectionFolder, String toolName, String gitHubProjectName, String toolVersion, String googleGroup, String googleGroupName, File logFile) {
        super((Frame)frame, true);
        this.lastSelectedFolder = selectionFolder;
        this.toolName = toolName;
        this.gitHubProjectName = gitHubProjectName;
        this.toolVersion = toolVersion;
        this.googleGroup = googleGroup;
        this.googleGroupName = googleGroupName;
        this.logFile = logFile;
        this.initComponents();
        this.setUpGui();
        this.setLocationRelativeTo(frame);
        this.setVisible(true);
    }

    public BugReport(JDialog dialog, LastSelectedFolder selectionFolder, String toolName, String gitHubProjectName, String toolVersion, String googleGroup, String googleGroupName, File logFile) {
        super((Dialog)dialog, true);
        this.lastSelectedFolder = selectionFolder;
        this.toolName = toolName;
        this.gitHubProjectName = gitHubProjectName;
        this.toolVersion = toolVersion;
        this.googleGroup = googleGroup;
        this.googleGroupName = googleGroupName;
        this.logFile = logFile;
        this.initComponents();
        this.setUpGui();
        this.setLocationRelativeTo(dialog);
        this.setVisible(true);
    }

    private void setUpGui() {
        this.insertLogFileContent();
        this.setTitle(this.toolName + " Bug Report");
        ((TitledBorder)this.logJPanel.getBorder()).setTitle(this.toolName + " Log");
        if (this.googleGroup == null) {
            this.googleGroup = "peptide-shaker";
        }
        if (this.googleGroupName == null) {
            this.googleGroupName = "PeptideShaker";
        }
        this.infoJEditorPane.setText("<html><head></head><body>If you encounter any bugs while processing your data, please do one of the following:<br><ul><li>Create an issue on the <a href=\"https://github.com/compomics/" + this.gitHubProjectName + "/issues/\">" + this.toolName + " web page</a>.</li><li>Send an e-mail to the <a href=\"http://groups.google.com/group/" + this.googleGroup + "\">" + this.googleGroupName + " Google Group</a>.</li></ul>Please include any relevant information as well as the log message displayed below.</body></html>");
    }

    private void insertLogFileContent() {
        StringBuilder log = new StringBuilder();
        String lineBreak = System.getProperty("line.separator");
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(this.logFile));
            while ((line = br.readLine()) != null) {
                log.append(line).append(lineBreak);
            }
            br.close();
        }
        catch (FileNotFoundException e) {
            log.append(this.toolName).append(".log not found.");
            e.printStackTrace();
        }
        catch (IOException e) {
            log.append("An error occurred while reading resources/").append(this.toolName).append(".log.");
            e.printStackTrace();
        }
        this.logTxt.setText(log.toString());
        this.logTxt.setCaretPosition(0);
    }

    private String getLastSelectedFolder() {
        String result = null;
        if (this.lastSelectedFolder != null && (result = this.lastSelectedFolder.getLastSelectedFolder(lastSelectedFolderKey)) == null) {
            result = this.lastSelectedFolder.getLastSelectedFolder();
        }
        return result;
    }

    private void initComponents() {
        this.backgroundPanel = new JPanel();
        this.logJPanel = new JPanel();
        this.logJScrollPane = new JScrollPane();
        this.logTxt = new JTextArea();
        this.clearJButton = new JButton();
        this.saveJButton = new JButton();
        this.exitButton = new JButton();
        this.infoJPanel = new JPanel();
        this.infoJScrollPane = new JScrollPane();
        this.infoJEditorPane = new JEditorPane();
        this.setDefaultCloseOperation(2);
        this.setTitle("Bug Report");
        this.backgroundPanel.setBackground(new Color(230, 230, 230));
        this.logJPanel.setBorder(BorderFactory.createTitledBorder("Log"));
        this.logJPanel.setOpaque(false);
        this.logTxt.setColumns(20);
        this.logTxt.setEditable(false);
        this.logTxt.setRows(3);
        this.logTxt.setTabSize(4);
        this.logJScrollPane.setViewportView(this.logTxt);
        this.clearJButton.setText("Clear");
        this.clearJButton.setToolTipText("Clear the log");
        this.clearJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BugReport.this.clearJButtonActionPerformed(evt);
            }
        });
        this.saveJButton.setText("Save");
        this.saveJButton.setToolTipText("Save the log to a text file");
        this.saveJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BugReport.this.saveJButtonActionPerformed(evt);
            }
        });
        this.exitButton.setText("Exit");
        this.exitButton.setMaximumSize(new Dimension(57, 23));
        this.exitButton.setMinimumSize(new Dimension(57, 23));
        this.exitButton.setPreferredSize(new Dimension(57, 23));
        this.exitButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BugReport.this.exitButtonActionPerformed(evt);
            }
        });
        GroupLayout logJPanelLayout = new GroupLayout(this.logJPanel);
        this.logJPanel.setLayout(logJPanelLayout);
        logJPanelLayout.setHorizontalGroup(logJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(logJPanelLayout.createSequentialGroup().addContainerGap().addGroup(logJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.logJScrollPane).addGroup(GroupLayout.Alignment.TRAILING, logJPanelLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.saveJButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.clearJButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.exitButton, -2, -1, -2))).addContainerGap()));
        logJPanelLayout.linkSize(0, this.clearJButton, this.exitButton, this.saveJButton);
        logJPanelLayout.setVerticalGroup(logJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(logJPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.logJScrollPane, -1, 279, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(logJPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.saveJButton).addComponent(this.clearJButton).addComponent(this.exitButton, -2, -1, -2)).addGap(6, 6, 6)));
        logJPanelLayout.linkSize(1, this.clearJButton, this.exitButton, this.saveJButton);
        this.infoJPanel.setBorder(BorderFactory.createTitledBorder("Info"));
        this.infoJPanel.setOpaque(false);
        this.infoJEditorPane.setEditable(false);
        this.infoJEditorPane.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        this.infoJEditorPane.setContentType("text/html");
        this.infoJEditorPane.setText("<html>\r\n  <head>\r\n\r\n  </head>\r\n  <body>\r\nIf you encounter any bugs while processing your data, please do one of the following:\n<br>\n<ul>\n  <li>Create an issue on the <a href=\"https://github.com/compomics/peptide-shaker/issues\">PeptideShaker web page</a>.</li>\n  <li>or Send an e-mail to the <a href=\"http://groups.google.com/group/peptide-shaker\">PeptideShaker mailing list</a>.</li>\n</ul>\nPlease include any relevant information as well as the log message displayed below.\n  </body>\r\n</html>\r\n");
        this.infoJEditorPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent evt) {
                BugReport.this.infoJEditorPaneHyperlinkUpdate(evt);
            }
        });
        this.infoJScrollPane.setViewportView(this.infoJEditorPane);
        GroupLayout infoJPanelLayout = new GroupLayout(this.infoJPanel);
        this.infoJPanel.setLayout(infoJPanelLayout);
        infoJPanelLayout.setHorizontalGroup(infoJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(infoJPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.infoJScrollPane).addContainerGap()));
        infoJPanelLayout.setVerticalGroup(infoJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(infoJPanelLayout.createSequentialGroup().addComponent(this.infoJScrollPane, -1, 131, Short.MAX_VALUE).addContainerGap()));
        GroupLayout backgroundPanelLayout = new GroupLayout(this.backgroundPanel);
        this.backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.infoJPanel, -1, -1, Short.MAX_VALUE).addComponent(this.logJPanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        backgroundPanelLayout.setVerticalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.infoJPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.logJPanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void infoJEditorPaneHyperlinkUpdate(HyperlinkEvent evt) {
        if (evt.getEventType().toString().equalsIgnoreCase(HyperlinkEvent.EventType.ENTERED.toString())) {
            this.setCursor(new Cursor(12));
        } else if (evt.getEventType().toString().equalsIgnoreCase(HyperlinkEvent.EventType.EXITED.toString())) {
            this.setCursor(new Cursor(0));
        } else if (evt.getEventType().toString().equalsIgnoreCase(HyperlinkEvent.EventType.ACTIVATED.toString())) {
            if (evt.getDescription().startsWith("#")) {
                this.infoJEditorPane.scrollToReference(evt.getDescription());
            } else {
                this.setCursor(new Cursor(3));
                BareBonesBrowserLaunch.openURL(evt.getDescription());
                this.setCursor(new Cursor(0));
            }
        }
    }

    private void clearJButtonActionPerformed(ActionEvent evt) {
        try {
            FileWriter w = new FileWriter(this.logFile);
            BufferedWriter bw = new BufferedWriter(w);
            String lineBreak = System.getProperty("line.separator");
            bw.write(lineBreak + new Date() + ": " + this.toolName + " version " + this.toolVersion + "." + lineBreak);
            bw.close();
            w.close();
        }
        catch (FileNotFoundException e) {
            JOptionPane.showMessageDialog(this, "Failed to clear the log file.", "File Error", 0);
            e.printStackTrace();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, "Failed to clear the log file.", "File Error", 0);
            e.printStackTrace();
        }
        this.insertLogFileContent();
    }

    private void saveJButtonActionPerformed(ActionEvent evt) {
        File finalOutputFile = Util.getUserSelectedFile(this, ".txt", "Text File (*.txt)", "Select Destination File", this.getLastSelectedFolder(), this.toolName + " " + this.toolVersion + " log.txt", false);
        if (finalOutputFile != null) {
            try {
                if (this.logFile.exists()) {
                    Util.copyFile(this.logFile, finalOutputFile);
                }
                if (!finalOutputFile.exists()) {
                    JOptionPane.showMessageDialog(this, "An error occurred when saving the log.", "Save Error", 0);
                } else {
                    JOptionPane.showMessageDialog(this, "The log has been saved to '" + finalOutputFile.getPath() + "'.", "Log Saved", 1);
                }
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this, "An error occurred when saving the log file.", "Save Error", 0);
                e.printStackTrace();
            }
        }
    }

    private void exitButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }
}

