/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.gui.parameters.identification_parameters;

import com.compomics.util.experiment.biology.AminoAcid;
import com.compomics.util.experiment.biology.variants.AaSubstitutionMatrix;
import com.compomics.util.gui.error_handlers.HelpDialog;
import com.compomics.util.gui.renderers.AlignedListCellRenderer;
import com.compomics.util.gui.variants.aa_substitutions.AaSubstitutionMatrixTableModel;
import com.compomics.util.preferences.PeptideVariantsPreferences;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import no.uib.jsparklines.extra.TrueFalseIconRenderer;

public class PeptideVariantsSettingsDialog
extends JDialog {
    private Frame parentFrame;
    private boolean canceled = false;
    private boolean editable;
    private JPanel aaSubstitutionsTableJPanel;
    private JPanel backgrounPanel;
    private JButton cancelButton;
    private JLabel deletionsLbl;
    private JLabel deletionsLbl1;
    private JLabel deletionsLbl2;
    private JLabel deletionsLbl3;
    private JSpinner deletionsSpinner;
    private JButton helpJButton;
    private JSpinner insertionsSpinner;
    private JPanel maxVariantsJPanel;
    private JButton okButton;
    private JComboBox specificVariantsComboBox;
    private JLabel specificVariantsLbl;
    private JSpinner subsitutionsSpinner;
    private JComboBox substitutionMatrixComboBox;
    private JTable substitutionMatrixTable;
    private JScrollPane substitutionMatrixTableJScrollPane;
    private JSpinner swapSpinner;
    private JLabel totalVariantsLbl;
    private JSpinner totalVariantsSpinner;

    public PeptideVariantsSettingsDialog(Frame parentFrame, PeptideVariantsPreferences peptideVariantPreferences, boolean editable) {
        super(parentFrame, true);
        this.parentFrame = parentFrame;
        this.editable = editable;
        this.initComponents();
        this.setUpGui();
        this.populateGUI(peptideVariantPreferences);
        this.setLocationRelativeTo(parentFrame);
        this.setVisible(true);
    }

    public PeptideVariantsSettingsDialog(Dialog owner, Frame parentFrame, PeptideVariantsPreferences peptideVariantPreferences, boolean editable) {
        super(owner, true);
        this.parentFrame = parentFrame;
        this.editable = editable;
        this.initComponents();
        this.setUpGui();
        this.populateGUI(peptideVariantPreferences);
        this.setLocationRelativeTo(owner);
        this.setVisible(true);
    }

    private void setUpGui() {
        this.totalVariantsSpinner.setEnabled(this.editable);
        this.specificVariantsComboBox.setEnabled(this.editable);
        this.specificVariantsComboBox.setRenderer(new AlignedListCellRenderer(0));
        this.deletionsSpinner.setEnabled(this.editable);
        this.insertionsSpinner.setEnabled(this.editable);
        this.subsitutionsSpinner.setEnabled(this.editable);
        this.swapSpinner.setEnabled(this.editable);
        this.substitutionMatrixComboBox.setEnabled(this.editable);
        this.substitutionMatrixComboBox.setRenderer(new AlignedListCellRenderer(0));
        this.setTableProperties();
    }

    private void setTableProperties() {
        TableColumnModel tableColumnModel = this.substitutionMatrixTable.getColumnModel();
        tableColumnModel.getColumn(0).setMaxWidth(50);
        this.substitutionMatrixTableJScrollPane.getViewport().setOpaque(false);
        for (int i = 0; i < AminoAcid.getUniqueAminoAcids().length; ++i) {
            tableColumnModel.getColumn(i + 1).setCellRenderer((TableCellRenderer)new TrueFalseIconRenderer(new ImageIcon(this.getClass().getResource("/icons/selected_green.png")), null, "On", "Off"));
        }
    }

    private void populateGUI(PeptideVariantsPreferences peptideVariantPreferences) {
        this.totalVariantsSpinner.setValue(peptideVariantPreferences.getnVariants());
        boolean useSpecific = peptideVariantPreferences.getUseSpecificCount();
        if (useSpecific) {
            this.specificVariantsComboBox.setSelectedIndex(0);
        } else {
            this.specificVariantsComboBox.setSelectedIndex(1);
        }
        if (this.editable) {
            this.deletionsSpinner.setEnabled(useSpecific);
            this.insertionsSpinner.setEnabled(useSpecific);
            this.subsitutionsSpinner.setEnabled(useSpecific);
            this.swapSpinner.setEnabled(useSpecific);
        }
        this.deletionsSpinner.setValue(peptideVariantPreferences.getnAaDeletions());
        this.insertionsSpinner.setValue(peptideVariantPreferences.getnAaInsertions());
        this.subsitutionsSpinner.setValue(peptideVariantPreferences.getnAaSubstitutions());
        this.swapSpinner.setValue(peptideVariantPreferences.getnAaSwap());
        AaSubstitutionMatrix aaSubstitutionMatrix = peptideVariantPreferences.getAaSubstitutionMatrix();
        this.substitutionMatrixComboBox.setSelectedItem(aaSubstitutionMatrix);
        this.updateTableContent(aaSubstitutionMatrix);
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public PeptideVariantsPreferences getPeptideVariantsPreferences() {
        PeptideVariantsPreferences peptideVariantsPreferences = new PeptideVariantsPreferences();
        peptideVariantsPreferences.setnVariants((Integer)this.totalVariantsSpinner.getValue());
        peptideVariantsPreferences.setUseSpecificCount(this.specificVariantsComboBox.getSelectedIndex() == 0);
        peptideVariantsPreferences.setnAaDeletions((Integer)this.deletionsSpinner.getValue());
        peptideVariantsPreferences.setnAaInsertions((Integer)this.insertionsSpinner.getValue());
        peptideVariantsPreferences.setnAaSubstitutions((Integer)this.subsitutionsSpinner.getValue());
        peptideVariantsPreferences.setnAaSwap((Integer)this.swapSpinner.getValue());
        peptideVariantsPreferences.setAaSubstitutionMatrix((AaSubstitutionMatrix)this.substitutionMatrixComboBox.getSelectedItem());
        return peptideVariantsPreferences;
    }

    private void updateTableContent(AaSubstitutionMatrix aaSubstitutionMatrix) {
        ((AaSubstitutionMatrixTableModel)this.substitutionMatrixTable.getModel()).setAaSubstitutionMatrix(aaSubstitutionMatrix);
        this.updateTableContent();
    }

    private void updateTableContent() {
        ((DefaultTableModel)this.substitutionMatrixTable.getModel()).fireTableDataChanged();
    }

    private void initComponents() {
        this.backgrounPanel = new JPanel();
        this.maxVariantsJPanel = new JPanel();
        this.deletionsSpinner = new JSpinner();
        this.deletionsLbl = new JLabel();
        this.deletionsLbl1 = new JLabel();
        this.insertionsSpinner = new JSpinner();
        this.deletionsLbl2 = new JLabel();
        this.subsitutionsSpinner = new JSpinner();
        this.deletionsLbl3 = new JLabel();
        this.swapSpinner = new JSpinner();
        this.totalVariantsLbl = new JLabel();
        this.totalVariantsSpinner = new JSpinner();
        this.specificVariantsLbl = new JLabel();
        this.specificVariantsComboBox = new JComboBox();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.aaSubstitutionsTableJPanel = new JPanel();
        this.substitutionMatrixComboBox = new JComboBox();
        this.substitutionMatrixTableJScrollPane = new JScrollPane();
        this.substitutionMatrixTable = new JTable();
        this.helpJButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Peptide Variants");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                PeptideVariantsSettingsDialog.this.formWindowClosing(evt);
            }
        });
        this.backgrounPanel.setBackground(new Color(230, 230, 230));
        this.maxVariantsJPanel.setBorder(BorderFactory.createTitledBorder("Number of Variants Allowed per Peptide"));
        this.maxVariantsJPanel.setOpaque(false);
        this.deletionsSpinner.setModel(new SpinnerNumberModel((Number)0, Integer.valueOf(0), null, (Number)1));
        this.deletionsLbl.setText("Amino acid deletions");
        this.deletionsLbl1.setText("Amino acid insertions");
        this.insertionsSpinner.setModel(new SpinnerNumberModel((Number)0, Integer.valueOf(0), null, (Number)1));
        this.deletionsLbl2.setText("Amino acid substitutions");
        this.subsitutionsSpinner.setModel(new SpinnerNumberModel((Number)0, Integer.valueOf(0), null, (Number)1));
        this.deletionsLbl3.setText("Amino acid swap");
        this.swapSpinner.setModel(new SpinnerNumberModel((Number)0, Integer.valueOf(0), null, (Number)1));
        this.totalVariantsLbl.setText("Total");
        this.totalVariantsSpinner.setModel(new SpinnerNumberModel((Number)0, Integer.valueOf(0), null, (Number)1));
        this.specificVariantsLbl.setText("Use specific variants");
        this.specificVariantsComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.specificVariantsComboBox.setSelectedIndex(1);
        this.specificVariantsComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PeptideVariantsSettingsDialog.this.specificVariantsComboBoxActionPerformed(evt);
            }
        });
        GroupLayout maxVariantsJPanelLayout = new GroupLayout(this.maxVariantsJPanel);
        this.maxVariantsJPanel.setLayout(maxVariantsJPanelLayout);
        maxVariantsJPanelLayout.setHorizontalGroup(maxVariantsJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(maxVariantsJPanelLayout.createSequentialGroup().addContainerGap().addGroup(maxVariantsJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(maxVariantsJPanelLayout.createSequentialGroup().addGroup(maxVariantsJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.totalVariantsLbl).addComponent(this.specificVariantsLbl)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(maxVariantsJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.specificVariantsComboBox, 0, -1, Short.MAX_VALUE).addComponent(this.totalVariantsSpinner, -1, 150, Short.MAX_VALUE))).addGroup(maxVariantsJPanelLayout.createSequentialGroup().addGap(10, 10, 10).addGroup(maxVariantsJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.deletionsLbl).addGroup(GroupLayout.Alignment.TRAILING, maxVariantsJPanelLayout.createSequentialGroup().addComponent(this.deletionsLbl1).addGap(15, 15, 15)).addComponent(this.deletionsLbl2).addComponent(this.deletionsLbl3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 496, Short.MAX_VALUE).addGroup(maxVariantsJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.swapSpinner, GroupLayout.Alignment.TRAILING, -2, 150, -2).addComponent(this.subsitutionsSpinner, GroupLayout.Alignment.TRAILING, -2, 150, -2).addComponent(this.deletionsSpinner, GroupLayout.Alignment.TRAILING, -2, 150, -2).addComponent(this.insertionsSpinner, GroupLayout.Alignment.TRAILING, -2, 150, -2)))).addContainerGap()));
        maxVariantsJPanelLayout.setVerticalGroup(maxVariantsJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, maxVariantsJPanelLayout.createSequentialGroup().addContainerGap().addGroup(maxVariantsJPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.totalVariantsLbl).addComponent(this.totalVariantsSpinner, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(maxVariantsJPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.specificVariantsLbl).addComponent(this.specificVariantsComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(maxVariantsJPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.deletionsLbl).addComponent(this.deletionsSpinner, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(maxVariantsJPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.deletionsLbl1).addComponent(this.insertionsSpinner, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(maxVariantsJPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.deletionsLbl3).addComponent(this.swapSpinner, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(maxVariantsJPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.deletionsLbl2).addComponent(this.subsitutionsSpinner, -2, -1, -2)).addContainerGap()));
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PeptideVariantsSettingsDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PeptideVariantsSettingsDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.aaSubstitutionsTableJPanel.setBorder(BorderFactory.createTitledBorder("Allowed Amino Acid Substitutions"));
        this.aaSubstitutionsTableJPanel.setOpaque(false);
        this.substitutionMatrixComboBox.setModel(new DefaultComboBoxModel<AaSubstitutionMatrix>(AaSubstitutionMatrix.defaultMutationMatrices));
        this.substitutionMatrixComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PeptideVariantsSettingsDialog.this.substitutionMatrixComboBoxActionPerformed(evt);
            }
        });
        this.substitutionMatrixTable.setModel(new AaSubstitutionMatrixTableModel(null, false));
        this.substitutionMatrixTableJScrollPane.setViewportView(this.substitutionMatrixTable);
        GroupLayout aaSubstitutionsTableJPanelLayout = new GroupLayout(this.aaSubstitutionsTableJPanel);
        this.aaSubstitutionsTableJPanel.setLayout(aaSubstitutionsTableJPanelLayout);
        aaSubstitutionsTableJPanelLayout.setHorizontalGroup(aaSubstitutionsTableJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(aaSubstitutionsTableJPanelLayout.createSequentialGroup().addContainerGap().addGroup(aaSubstitutionsTableJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.substitutionMatrixTableJScrollPane).addComponent(this.substitutionMatrixComboBox, 0, -1, Short.MAX_VALUE)).addContainerGap()));
        aaSubstitutionsTableJPanelLayout.setVerticalGroup(aaSubstitutionsTableJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(aaSubstitutionsTableJPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.substitutionMatrixComboBox, -2, -1, -2).addGap(18, 18, 18).addComponent(this.substitutionMatrixTableJScrollPane, -1, 243, Short.MAX_VALUE).addContainerGap()));
        this.helpJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/help.GIF")));
        this.helpJButton.setToolTipText("Help");
        this.helpJButton.setBorder(null);
        this.helpJButton.setBorderPainted(false);
        this.helpJButton.setContentAreaFilled(false);
        this.helpJButton.setFocusable(false);
        this.helpJButton.setHorizontalTextPosition(0);
        this.helpJButton.setVerticalTextPosition(3);
        this.helpJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                PeptideVariantsSettingsDialog.this.helpJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                PeptideVariantsSettingsDialog.this.helpJButtonMouseExited(evt);
            }
        });
        this.helpJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PeptideVariantsSettingsDialog.this.helpJButtonActionPerformed(evt);
            }
        });
        GroupLayout backgrounPanelLayout = new GroupLayout(this.backgrounPanel);
        this.backgrounPanel.setLayout(backgrounPanelLayout);
        backgrounPanelLayout.setHorizontalGroup(backgrounPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgrounPanelLayout.createSequentialGroup().addContainerGap().addGroup(backgrounPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgrounPanelLayout.createSequentialGroup().addComponent(this.maxVariantsJPanel, -1, -1, Short.MAX_VALUE).addGap(7, 7, 7)).addGroup(GroupLayout.Alignment.TRAILING, backgrounPanelLayout.createSequentialGroup().addGroup(backgrounPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.aaSubstitutionsTableJPanel, -1, -1, Short.MAX_VALUE).addGroup(backgrounPanelLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.helpJButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.okButton, -2, 65, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton))).addContainerGap()))));
        backgrounPanelLayout.setVerticalGroup(backgrounPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgrounPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.maxVariantsJPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.aaSubstitutionsTableJPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(backgrounPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.helpJButton).addComponent(this.okButton).addComponent(this.cancelButton)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgrounPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgrounPanel, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.canceled = true;
        this.dispose();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.canceled = true;
    }

    private void substitutionMatrixComboBoxActionPerformed(ActionEvent evt) {
        AaSubstitutionMatrix aaSubstitutionMatrix = (AaSubstitutionMatrix)this.substitutionMatrixComboBox.getSelectedItem();
        this.updateTableContent(aaSubstitutionMatrix);
    }

    private void specificVariantsComboBoxActionPerformed(ActionEvent evt) {
        if (this.editable) {
            boolean useSpecific = this.specificVariantsComboBox.getSelectedIndex() == 0;
            this.deletionsSpinner.setEnabled(useSpecific);
            this.insertionsSpinner.setEnabled(useSpecific);
            this.subsitutionsSpinner.setEnabled(useSpecific);
            this.swapSpinner.setEnabled(useSpecific);
        }
    }

    private void helpJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void helpJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void helpJButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        new HelpDialog(this.parentFrame, this.getClass().getResource("/helpFiles/PeptideVariantsPreferences.html"), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/help.GIF")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), "PeptideShaker - Help");
        this.setCursor(new Cursor(0));
    }
}

