/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.gui.parameters.identification_parameters.algorithm_settings;

import com.compomics.util.examples.BareBonesBrowserLaunch;
import com.compomics.util.experiment.identification.identification_parameters.IdentificationAlgorithmParameter;
import com.compomics.util.experiment.identification.identification_parameters.tool_specific.AndromedaParameters;
import com.compomics.util.experiment.massspectrometry.FragmentationMethod;
import com.compomics.util.gui.GuiUtilities;
import com.compomics.util.gui.parameters.identification_parameters.AlgorithmSettingsDialog;
import com.compomics.util.gui.renderers.AlignedListCellRenderer;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class AndromedaSettingsDialog
extends JDialog
implements AlgorithmSettingsDialog {
    private boolean cancelled = false;
    private boolean editable;
    private JLabel advancedSettingsWarningLabel;
    private JComboBox ammoniaLossCmb;
    private JLabel ammoniaLossLabel;
    private JPanel backgroundPanel;
    private JButton closeButton;
    private JComboBox decoyModeCmb;
    private JLabel decoyModeLabel;
    private JComboBox empiricalCorrectionCombo;
    private JLabel empiricalCorrectionLabel;
    private JComboBox equalILCombo;
    private JLabel equalILLabel;
    private JComboBox fragMethodCmb;
    private JLabel fragMethodLabel;
    private JComboBox fragmentAllCmb;
    private JLabel fragmentAllLabel;
    private JComboBox higherChargeCombo;
    private JLabel higherChargeLabel;
    private JLabel maxCombinationsLabel;
    private JTextField maxCombinationsTxt;
    private JTextField maxPepLengthNoEnzymeTxt;
    private JLabel maxPeptideMassLabel;
    private JTextField maxPeptideMassTxt;
    private JLabel maxPtmsLabel;
    private JTextField maxPtmsTxt;
    private JTextField minPepLengthNoEnzymeTxt;
    private JComboBox neutralLossesCmb;
    private JLabel neutralLossesLabel;
    private JLabel numberMatchesLabel;
    private JTextField numberMatchesTxt;
    private JButton okButton;
    private JButton openDialogHelpJButton;
    private JLabel peptideLengthNoEnzymeDividerLabel;
    private JLabel peptideLengthNoEnzymeLabel;
    private JPanel settingsInnerPanel;
    private JPanel settingsPanel;
    private JScrollPane settingsScrollPane;
    private JLabel topPeaksLabel;
    private JTextField topPeaksTxt;
    private JLabel topPeaksWindowLabel;
    private JTextField topPeaksWindowTxt;
    private JComboBox waterLossCombo;
    private JLabel waterLossLabel;

    public AndromedaSettingsDialog(Frame parentFrame, AndromedaParameters andromedaParameters, boolean editable) {
        super(parentFrame, true);
        this.editable = editable;
        this.initComponents();
        this.setUpGUI();
        this.populateGUI(andromedaParameters);
        this.validateInput(false);
        this.setLocationRelativeTo(parentFrame);
        this.setVisible(true);
    }

    public AndromedaSettingsDialog(Dialog owner, Frame parentFrame, AndromedaParameters andromedaParameters, boolean editable) {
        super(owner, true);
        this.editable = editable;
        this.initComponents();
        this.setUpGUI();
        this.populateGUI(andromedaParameters);
        this.validateInput(false);
        this.setLocationRelativeTo(owner);
        this.setVisible(true);
    }

    private void setUpGUI() {
        this.neutralLossesCmb.setRenderer(new AlignedListCellRenderer(0));
        this.fragMethodCmb.setRenderer(new AlignedListCellRenderer(0));
        this.fragmentAllCmb.setRenderer(new AlignedListCellRenderer(0));
        this.empiricalCorrectionCombo.setRenderer(new AlignedListCellRenderer(0));
        this.higherChargeCombo.setRenderer(new AlignedListCellRenderer(0));
        this.ammoniaLossCmb.setRenderer(new AlignedListCellRenderer(0));
        this.waterLossCombo.setRenderer(new AlignedListCellRenderer(0));
        this.equalILCombo.setRenderer(new AlignedListCellRenderer(0));
        this.decoyModeCmb.setRenderer(new AlignedListCellRenderer(0));
        this.minPepLengthNoEnzymeTxt.setEditable(this.editable);
        this.minPepLengthNoEnzymeTxt.setEnabled(this.editable);
        this.maxPepLengthNoEnzymeTxt.setEditable(this.editable);
        this.maxPepLengthNoEnzymeTxt.setEnabled(this.editable);
        this.maxPeptideMassTxt.setEditable(this.editable);
        this.maxPeptideMassTxt.setEnabled(this.editable);
        this.numberMatchesTxt.setEditable(this.editable);
        this.numberMatchesTxt.setEnabled(this.editable);
        this.maxPtmsTxt.setEditable(this.editable);
        this.maxPtmsTxt.setEnabled(this.editable);
        this.fragMethodCmb.setEnabled(this.editable);
        this.waterLossCombo.setEnabled(this.editable);
        this.ammoniaLossCmb.setEnabled(this.editable);
        this.neutralLossesCmb.setEnabled(this.editable);
        this.equalILCombo.setEnabled(this.editable);
        this.fragmentAllCmb.setEnabled(this.editable);
        this.empiricalCorrectionCombo.setEnabled(this.editable);
        this.higherChargeCombo.setEnabled(this.editable);
        this.maxCombinationsTxt.setEditable(this.editable);
        this.maxCombinationsTxt.setEnabled(this.editable);
        this.topPeaksTxt.setEditable(this.editable);
        this.topPeaksTxt.setEnabled(this.editable);
        this.topPeaksWindowTxt.setEditable(this.editable);
        this.topPeaksWindowTxt.setEnabled(this.editable);
        this.decoyModeCmb.setEnabled(this.editable);
    }

    private void populateGUI(AndromedaParameters andromedaParameters) {
        this.minPepLengthNoEnzymeTxt.setText(andromedaParameters.getMinPeptideLengthNoEnzyme() + "");
        this.maxPepLengthNoEnzymeTxt.setText(andromedaParameters.getMaxPeptideLengthNoEnzyme() + "");
        this.maxPeptideMassTxt.setText(andromedaParameters.getMaxPeptideMass() + "");
        this.numberMatchesTxt.setText(andromedaParameters.getNumberOfCandidates() + "");
        this.maxPtmsTxt.setText(andromedaParameters.getMaxNumberOfModifications() + "");
        if (andromedaParameters.getFragmentationMethod() == FragmentationMethod.CID) {
            this.fragMethodCmb.setSelectedIndex(0);
        } else if (andromedaParameters.getFragmentationMethod() == FragmentationMethod.HCD) {
            this.fragMethodCmb.setSelectedIndex(1);
        } else if (andromedaParameters.getFragmentationMethod() == FragmentationMethod.ETD) {
            this.fragMethodCmb.setSelectedIndex(2);
        }
        if (andromedaParameters.isIncludeWater()) {
            this.waterLossCombo.setSelectedIndex(0);
        } else {
            this.waterLossCombo.setSelectedIndex(1);
        }
        if (andromedaParameters.isIncludeAmmonia()) {
            this.ammoniaLossCmb.setSelectedIndex(0);
        } else {
            this.ammoniaLossCmb.setSelectedIndex(1);
        }
        if (andromedaParameters.isDependentLosses()) {
            this.neutralLossesCmb.setSelectedIndex(0);
        } else {
            this.neutralLossesCmb.setSelectedIndex(1);
        }
        if (andromedaParameters.isEqualIL()) {
            this.equalILCombo.setSelectedIndex(0);
        } else {
            this.equalILCombo.setSelectedIndex(1);
        }
        if (andromedaParameters.isFragmentAll()) {
            this.fragmentAllCmb.setSelectedIndex(0);
        } else {
            this.fragmentAllCmb.setSelectedIndex(1);
        }
        if (andromedaParameters.isEmpiricalCorrection()) {
            this.empiricalCorrectionCombo.setSelectedIndex(0);
        } else {
            this.empiricalCorrectionCombo.setSelectedIndex(1);
        }
        if (andromedaParameters.isHigherCharge()) {
            this.higherChargeCombo.setSelectedIndex(0);
        } else {
            this.higherChargeCombo.setSelectedIndex(1);
        }
        this.decoyModeCmb.setSelectedItem((Object)andromedaParameters.getDecoyMode());
        this.maxCombinationsTxt.setText(andromedaParameters.getMaxCombinations() + "");
        this.topPeaksTxt.setText(andromedaParameters.getTopPeaks() + "");
        this.topPeaksWindowTxt.setText(andromedaParameters.getTopPeaksWindow() + "");
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public IdentificationAlgorithmParameter getParameters() {
        return this.getInput();
    }

    public AndromedaParameters getInput() {
        AndromedaParameters result = new AndromedaParameters();
        String input = this.minPepLengthNoEnzymeTxt.getText().trim();
        if (!input.equals("")) {
            result.setMinPeptideLengthNoEnzyme(new Integer(input));
        }
        if (!(input = this.maxPepLengthNoEnzymeTxt.getText().trim()).equals("")) {
            result.setMaxPeptideLengthNoEnzyme(new Integer(input));
        }
        if (!(input = this.maxPeptideMassTxt.getText().trim()).equals("")) {
            result.setMaxPeptideMass(new Double(input));
        }
        if (!(input = this.numberMatchesTxt.getText().trim()).equals("")) {
            result.setNumberOfCandidates(new Integer(input));
        }
        if (!(input = this.maxPtmsTxt.getText().trim()).equals("")) {
            result.setMaxNumberOfModifications(new Integer(input));
        }
        if (this.fragMethodCmb.getSelectedIndex() == 0) {
            result.setFragmentationMethod(FragmentationMethod.CID);
        } else if (this.fragMethodCmb.getSelectedIndex() == 1) {
            result.setFragmentationMethod(FragmentationMethod.HCD);
        } else {
            result.setFragmentationMethod(FragmentationMethod.ETD);
        }
        result.setIncludeWater(this.waterLossCombo.getSelectedIndex() == 0);
        result.setIncludeAmmonia(this.ammoniaLossCmb.getSelectedIndex() == 0);
        result.setDependentLosses(this.neutralLossesCmb.getSelectedIndex() == 0);
        result.setEqualIL(this.equalILCombo.getSelectedIndex() == 0);
        result.setFragmentAll(this.fragmentAllCmb.getSelectedIndex() == 0);
        result.setEmpiricalCorrection(this.empiricalCorrectionCombo.getSelectedIndex() == 0);
        result.setHigherCharge(this.higherChargeCombo.getSelectedIndex() == 0);
        input = this.maxCombinationsTxt.getText().trim();
        if (!input.equals("")) {
            result.setMaxCombinations(new Integer(input));
        }
        if (!(input = this.topPeaksTxt.getText().trim()).equals("")) {
            result.setTopPeaks(new Integer(input));
        }
        if (!(input = this.topPeaksWindowTxt.getText().trim()).equals("")) {
            result.setTopPeaksWindow(new Integer(input));
        }
        result.setDecoyMode((AndromedaParameters.AndromedaDecoyMode)((Object)this.decoyModeCmb.getSelectedItem()));
        return result;
    }

    private void initComponents() {
        this.backgroundPanel = new JPanel();
        this.settingsPanel = new JPanel();
        this.settingsScrollPane = new JScrollPane();
        this.settingsInnerPanel = new JPanel();
        this.peptideLengthNoEnzymeLabel = new JLabel();
        this.minPepLengthNoEnzymeTxt = new JTextField();
        this.peptideLengthNoEnzymeDividerLabel = new JLabel();
        this.maxPepLengthNoEnzymeTxt = new JTextField();
        this.maxPeptideMassLabel = new JLabel();
        this.maxPeptideMassTxt = new JTextField();
        this.numberMatchesLabel = new JLabel();
        this.numberMatchesTxt = new JTextField();
        this.fragMethodLabel = new JLabel();
        this.fragMethodCmb = new JComboBox();
        this.ammoniaLossLabel = new JLabel();
        this.ammoniaLossCmb = new JComboBox();
        this.maxPtmsLabel = new JLabel();
        this.maxPtmsTxt = new JTextField();
        this.empiricalCorrectionLabel = new JLabel();
        this.empiricalCorrectionCombo = new JComboBox();
        this.higherChargeLabel = new JLabel();
        this.higherChargeCombo = new JComboBox();
        this.topPeaksLabel = new JLabel();
        this.topPeaksTxt = new JTextField();
        this.neutralLossesLabel = new JLabel();
        this.neutralLossesCmb = new JComboBox();
        this.fragmentAllLabel = new JLabel();
        this.fragmentAllCmb = new JComboBox();
        this.maxCombinationsLabel = new JLabel();
        this.maxCombinationsTxt = new JTextField();
        this.topPeaksWindowLabel = new JLabel();
        this.topPeaksWindowTxt = new JTextField();
        this.waterLossLabel = new JLabel();
        this.waterLossCombo = new JComboBox();
        this.equalILLabel = new JLabel();
        this.equalILCombo = new JComboBox();
        this.decoyModeLabel = new JLabel();
        this.decoyModeCmb = new JComboBox();
        this.openDialogHelpJButton = new JButton();
        this.advancedSettingsWarningLabel = new JLabel();
        this.okButton = new JButton();
        this.closeButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Andromeda Advanced Settings");
        this.setMinimumSize(new Dimension(400, 400));
        this.backgroundPanel.setBackground(new Color(230, 230, 230));
        this.settingsPanel.setBackground(new Color(230, 230, 230));
        this.settingsPanel.setBorder(BorderFactory.createTitledBorder("Search Settings"));
        this.settingsPanel.setPreferredSize(new Dimension(518, 143));
        this.settingsScrollPane.setBorder(null);
        this.settingsInnerPanel.setBackground(new Color(230, 230, 230));
        this.peptideLengthNoEnzymeLabel.setText("Peptide Length No Enzyme");
        this.minPepLengthNoEnzymeTxt.setHorizontalAlignment(0);
        this.minPepLengthNoEnzymeTxt.setText("8");
        this.minPepLengthNoEnzymeTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                AndromedaSettingsDialog.this.minPepLengthNoEnzymeTxtKeyReleased(evt);
            }
        });
        this.peptideLengthNoEnzymeDividerLabel.setHorizontalAlignment(0);
        this.peptideLengthNoEnzymeDividerLabel.setText("-");
        this.maxPepLengthNoEnzymeTxt.setHorizontalAlignment(0);
        this.maxPepLengthNoEnzymeTxt.setText("25");
        this.maxPepLengthNoEnzymeTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                AndromedaSettingsDialog.this.maxPepLengthNoEnzymeTxtKeyReleased(evt);
            }
        });
        this.maxPeptideMassLabel.setText("Max Peptide Mass");
        this.maxPeptideMassTxt.setHorizontalAlignment(0);
        this.maxPeptideMassTxt.setText("4600");
        this.maxPeptideMassTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                AndromedaSettingsDialog.this.maxPeptideMassTxtKeyReleased(evt);
            }
        });
        this.numberMatchesLabel.setText("Number of Spectrum Matches");
        this.numberMatchesTxt.setHorizontalAlignment(0);
        this.numberMatchesTxt.setText("10");
        this.numberMatchesTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                AndromedaSettingsDialog.this.numberMatchesTxtKeyReleased(evt);
            }
        });
        this.fragMethodLabel.setText("Fragmentation Method");
        this.fragMethodCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"CID", "HCD", "ETD"}));
        this.ammoniaLossLabel.setText("Ammonia Loss");
        this.ammoniaLossCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.maxPtmsLabel.setText("Max Variable PTMs");
        this.maxPtmsTxt.setHorizontalAlignment(0);
        this.maxPtmsTxt.setText("5");
        this.maxPtmsTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                AndromedaSettingsDialog.this.maxPtmsTxtKeyReleased(evt);
            }
        });
        this.empiricalCorrectionLabel.setText("Empirical Correction");
        this.empiricalCorrectionCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.higherChargeLabel.setText("Higher Charge");
        this.higherChargeCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.topPeaksLabel.setText("Top Peaks");
        this.topPeaksTxt.setHorizontalAlignment(0);
        this.topPeaksTxt.setText("8");
        this.topPeaksTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                AndromedaSettingsDialog.this.topPeaksTxtKeyReleased(evt);
            }
        });
        this.neutralLossesLabel.setText("Sequence Dependent Neutral Loss");
        this.neutralLossesCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.fragmentAllLabel.setText("Fragment All");
        this.fragmentAllCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.maxCombinationsLabel.setText("Max Combinations");
        this.maxCombinationsTxt.setHorizontalAlignment(0);
        this.maxCombinationsTxt.setText("250");
        this.maxCombinationsTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                AndromedaSettingsDialog.this.maxCombinationsTxtKeyReleased(evt);
            }
        });
        this.topPeaksWindowLabel.setText("Top Peaks Windows");
        this.topPeaksWindowTxt.setHorizontalAlignment(0);
        this.topPeaksWindowTxt.setText("100");
        this.topPeaksWindowTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                AndromedaSettingsDialog.this.topPeaksWindowTxtKeyReleased(evt);
            }
        });
        this.waterLossLabel.setText("Water Loss");
        this.waterLossCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.equalILLabel.setText("Equal I and L");
        this.equalILCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.equalILCombo.setSelectedIndex(1);
        this.decoyModeLabel.setText("Decoy Mode");
        this.decoyModeCmb.setModel(new DefaultComboBoxModel<AndromedaParameters.AndromedaDecoyMode>(AndromedaParameters.AndromedaDecoyMode.values()));
        GroupLayout settingsInnerPanelLayout = new GroupLayout(this.settingsInnerPanel);
        this.settingsInnerPanel.setLayout(settingsInnerPanelLayout);
        settingsInnerPanelLayout.setHorizontalGroup(settingsInnerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(settingsInnerPanelLayout.createSequentialGroup().addComponent(this.peptideLengthNoEnzymeLabel, -2, 200, -2).addGap(21, 21, 21).addComponent(this.minPepLengthNoEnzymeTxt, -1, 78, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.peptideLengthNoEnzymeDividerLabel, -2, 27, -2).addGap(7, 7, 7).addComponent(this.maxPepLengthNoEnzymeTxt, -1, 84, Short.MAX_VALUE)).addGroup(settingsInnerPanelLayout.createSequentialGroup().addComponent(this.maxPeptideMassLabel, -2, 200, -2).addGap(21, 21, 21).addComponent(this.maxPeptideMassTxt)).addGroup(settingsInnerPanelLayout.createSequentialGroup().addComponent(this.numberMatchesLabel, -2, 200, -2).addGap(21, 21, 21).addComponent(this.numberMatchesTxt)).addGroup(settingsInnerPanelLayout.createSequentialGroup().addComponent(this.neutralLossesLabel, -2, 200, -2).addGap(21, 21, 21).addComponent(this.neutralLossesCmb, 0, -1, Short.MAX_VALUE)).addGroup(settingsInnerPanelLayout.createSequentialGroup().addComponent(this.ammoniaLossLabel, -2, 200, -2).addGap(21, 21, 21).addComponent(this.ammoniaLossCmb, 0, -1, Short.MAX_VALUE)).addGroup(settingsInnerPanelLayout.createSequentialGroup().addComponent(this.waterLossLabel, -2, 200, -2).addGap(21, 21, 21).addComponent(this.waterLossCombo, 0, -1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, settingsInnerPanelLayout.createSequentialGroup().addComponent(this.equalILLabel, -2, 200, -2).addGap(21, 21, 21).addComponent(this.equalILCombo, 0, -1, Short.MAX_VALUE)).addGroup(settingsInnerPanelLayout.createSequentialGroup().addGroup(settingsInnerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.maxPtmsLabel, -2, 200, -2).addComponent(this.fragMethodLabel, -2, 200, -2)).addGap(21, 21, 21).addGroup(settingsInnerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.fragMethodCmb, 0, -1, Short.MAX_VALUE).addComponent(this.maxPtmsTxt))).addGroup(settingsInnerPanelLayout.createSequentialGroup().addGroup(settingsInnerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.fragmentAllLabel, -2, 200, -2).addComponent(this.empiricalCorrectionLabel, -2, 200, -2).addComponent(this.higherChargeLabel, -2, 200, -2)).addGap(21, 21, 21).addGroup(settingsInnerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.empiricalCorrectionCombo, 0, -1, Short.MAX_VALUE).addComponent(this.higherChargeCombo, 0, -1, Short.MAX_VALUE).addComponent(this.fragmentAllCmb, 0, -1, Short.MAX_VALUE))).addGroup(settingsInnerPanelLayout.createSequentialGroup().addGroup(settingsInnerPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.topPeaksWindowLabel, -1, -1, Short.MAX_VALUE).addComponent(this.maxCombinationsLabel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.topPeaksLabel, GroupLayout.Alignment.LEADING, -2, 200, -2)).addGap(21, 21, 21).addGroup(settingsInnerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.topPeaksTxt).addComponent(this.topPeaksWindowTxt).addComponent(this.maxCombinationsTxt))).addGroup(settingsInnerPanelLayout.createSequentialGroup().addComponent(this.decoyModeLabel, -2, 200, -2).addGap(21, 21, 21).addComponent(this.decoyModeCmb, 0, -1, Short.MAX_VALUE)));
        settingsInnerPanelLayout.setVerticalGroup(settingsInnerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(settingsInnerPanelLayout.createSequentialGroup().addGroup(settingsInnerPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.minPepLengthNoEnzymeTxt, -2, -1, -2).addComponent(this.maxPepLengthNoEnzymeTxt, -2, -1, -2).addComponent(this.peptideLengthNoEnzymeDividerLabel).addComponent(this.peptideLengthNoEnzymeLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(settingsInnerPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.maxPeptideMassTxt, -2, -1, -2).addComponent(this.maxPeptideMassLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(settingsInnerPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.numberMatchesLabel).addComponent(this.numberMatchesTxt, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(settingsInnerPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.maxPtmsLabel).addComponent(this.maxPtmsTxt, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(settingsInnerPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fragMethodLabel).addComponent(this.fragMethodCmb, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(settingsInnerPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.waterLossLabel).addComponent(this.waterLossCombo, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(settingsInnerPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.ammoniaLossLabel).addComponent(this.ammoniaLossCmb, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(settingsInnerPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.neutralLossesLabel).addComponent(this.neutralLossesCmb, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(settingsInnerPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.equalILCombo, -2, -1, -2).addComponent(this.equalILLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(settingsInnerPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fragmentAllLabel).addComponent(this.fragmentAllCmb, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(settingsInnerPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.empiricalCorrectionLabel).addComponent(this.empiricalCorrectionCombo, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(settingsInnerPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.higherChargeLabel).addComponent(this.higherChargeCombo, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(settingsInnerPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.maxCombinationsLabel).addComponent(this.maxCombinationsTxt, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(settingsInnerPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.topPeaksLabel).addComponent(this.topPeaksTxt, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(settingsInnerPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.topPeaksWindowTxt, -2, -1, -2).addComponent(this.topPeaksWindowLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(settingsInnerPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.decoyModeLabel).addComponent(this.decoyModeCmb, -2, -1, -2)).addContainerGap()));
        this.settingsScrollPane.setViewportView(this.settingsInnerPanel);
        GroupLayout settingsPanelLayout = new GroupLayout(this.settingsPanel);
        this.settingsPanel.setLayout(settingsPanelLayout);
        settingsPanelLayout.setHorizontalGroup(settingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(settingsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.settingsScrollPane).addContainerGap()));
        settingsPanelLayout.setVerticalGroup(settingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(settingsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.settingsScrollPane, -1, 540, Short.MAX_VALUE).addContainerGap()));
        this.openDialogHelpJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/help.GIF")));
        this.openDialogHelpJButton.setToolTipText("Help");
        this.openDialogHelpJButton.setBorder(null);
        this.openDialogHelpJButton.setBorderPainted(false);
        this.openDialogHelpJButton.setContentAreaFilled(false);
        this.openDialogHelpJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                AndromedaSettingsDialog.this.openDialogHelpJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                AndromedaSettingsDialog.this.openDialogHelpJButtonMouseExited(evt);
            }
        });
        this.openDialogHelpJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AndromedaSettingsDialog.this.openDialogHelpJButtonActionPerformed(evt);
            }
        });
        this.advancedSettingsWarningLabel.setText("Click to open the Andromeda help page.");
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AndromedaSettingsDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.closeButton.setText("Close");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AndromedaSettingsDialog.this.closeButtonActionPerformed(evt);
            }
        });
        GroupLayout backgroundPanelLayout = new GroupLayout(this.backgroundPanel);
        this.backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.settingsPanel, -1, 453, Short.MAX_VALUE).addGroup(backgroundPanelLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.openDialogHelpJButton).addGap(18, 18, 18).addComponent(this.advancedSettingsWarningLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 92, Short.MAX_VALUE).addComponent(this.okButton, -2, 59, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.closeButton))).addContainerGap()));
        backgroundPanelLayout.setVerticalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.settingsPanel, -1, 585, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.openDialogHelpJButton).addComponent(this.advancedSettingsWarningLabel).addComponent(this.okButton).addComponent(this.closeButton)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.cancelled = true;
        this.dispose();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        if (this.validateInput(true)) {
            this.dispose();
        }
    }

    private void openDialogHelpJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void openDialogHelpJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void openDialogHelpJButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL("http://coxdocs.org/doku.php?id=maxquant:andromeda:start");
        this.setCursor(new Cursor(0));
    }

    private void topPeaksWindowTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void maxPtmsTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void minPepLengthNoEnzymeTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void maxPepLengthNoEnzymeTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void maxPeptideMassTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void topPeaksTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void maxCombinationsTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void numberMatchesTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    public boolean validateInput(boolean showMessage) {
        boolean valid = true;
        valid = GuiUtilities.validateIntegerInput(this, this.peptideLengthNoEnzymeLabel, this.minPepLengthNoEnzymeTxt, "minimum peptide length", "Peptide Length Error", true, showMessage, valid);
        valid = GuiUtilities.validateIntegerInput(this, this.peptideLengthNoEnzymeLabel, this.maxPepLengthNoEnzymeTxt, "minimum peptide length", "Peptide Length Error", true, showMessage, valid);
        valid = GuiUtilities.validateDoubleInput(this, this.maxPeptideMassLabel, this.maxPeptideMassTxt, "maximum peptide mass", "Peptide Mass Error", true, showMessage, valid);
        valid = GuiUtilities.validateIntegerInput(this, this.numberMatchesLabel, this.numberMatchesTxt, "number of spectrum matches", "Number of Spectrum Matches Error", true, showMessage, valid);
        valid = GuiUtilities.validateIntegerInput(this, this.maxPtmsLabel, this.maxPtmsTxt, "maximum number of variable PTMs", "Variable PTMs Error", true, showMessage, valid);
        valid = GuiUtilities.validateIntegerInput(this, this.maxCombinationsLabel, this.maxCombinationsTxt, "maximum combinations", "Max Combinations Error", true, showMessage, valid);
        valid = GuiUtilities.validateIntegerInput(this, this.topPeaksLabel, this.topPeaksTxt, "top peaks", "Top Peaks Error", true, showMessage, valid);
        valid = GuiUtilities.validateIntegerInput(this, this.topPeaksWindowLabel, this.topPeaksWindowTxt, "top peaks window", "Top Peaks Window Error", true, showMessage, valid);
        try {
            double lowValue = Double.parseDouble(this.minPepLengthNoEnzymeTxt.getText().trim());
            double highValue = Double.parseDouble(this.maxPepLengthNoEnzymeTxt.getText().trim());
            if (lowValue > highValue) {
                if (showMessage && valid) {
                    JOptionPane.showMessageDialog(this, "The lower range value has to be smaller than the upper range value.", "Peptide Length Error", 2);
                }
                valid = false;
                this.peptideLengthNoEnzymeLabel.setForeground(Color.RED);
                this.peptideLengthNoEnzymeLabel.setToolTipText("Please select a valid range (upper <= higher)");
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.okButton.setEnabled(valid);
        return valid;
    }
}

