/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.gui.parameters.identification_parameters.algorithm_settings;

import com.compomics.util.examples.BareBonesBrowserLaunch;
import com.compomics.util.experiment.identification.identification_parameters.IdentificationAlgorithmParameter;
import com.compomics.util.experiment.identification.identification_parameters.tool_specific.PNovoParameters;
import com.compomics.util.gui.GuiUtilities;
import com.compomics.util.gui.parameters.identification_parameters.AlgorithmSettingsDialog;
import com.compomics.util.gui.renderers.AlignedListCellRenderer;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class PNovoSettingsDialog
extends JDialog
implements AlgorithmSettingsDialog {
    private boolean canceled = false;
    private boolean editable;
    private JComboBox activationTypeCmb;
    private JLabel activationTypeLabel;
    private JPanel backgroundPanel;
    private JButton cancelButton;
    private JLabel maxPrecursorMassLabel;
    private JTextField maxPrecursorMassTextField;
    private JLabel minPrecursorMassLabel;
    private JTextField minPrecursorMassTextField;
    private JButton okButton;
    private JButton openDialogHelpJButton;
    private JPanel pNovoPanel;

    public PNovoSettingsDialog(Frame parent, PNovoParameters pNovoParameters, boolean editable) {
        super(parent, true);
        this.editable = editable;
        this.initComponents();
        this.setUpGUI();
        this.populateGUI(pNovoParameters);
        this.setLocationRelativeTo(parent);
        this.setVisible(true);
    }

    public PNovoSettingsDialog(Dialog owner, Frame parent, PNovoParameters pNovoParameters, boolean editable) {
        super(owner, true);
        this.editable = editable;
        this.initComponents();
        this.setUpGUI();
        this.populateGUI(pNovoParameters);
        this.setLocationRelativeTo(owner);
        this.setVisible(true);
    }

    private void setUpGUI() {
        this.activationTypeCmb.setRenderer(new AlignedListCellRenderer(0));
        this.activationTypeCmb.setEnabled(this.editable);
        this.minPrecursorMassTextField.setEditable(this.editable);
        this.minPrecursorMassTextField.setEnabled(this.editable);
        this.maxPrecursorMassTextField.setEditable(this.editable);
        this.maxPrecursorMassTextField.setEnabled(this.editable);
    }

    private void populateGUI(PNovoParameters pNovoParameters) {
        this.minPrecursorMassTextField.setText(String.valueOf(pNovoParameters.getLowerPrecursorMass()));
        this.maxPrecursorMassTextField.setText(String.valueOf(pNovoParameters.getUpperPrecursorMass()));
        this.activationTypeCmb.setSelectedItem(pNovoParameters.getActicationType());
    }

    private void initComponents() {
        this.backgroundPanel = new JPanel();
        this.okButton = new JButton();
        this.pNovoPanel = new JPanel();
        this.activationTypeLabel = new JLabel();
        this.minPrecursorMassLabel = new JLabel();
        this.minPrecursorMassTextField = new JTextField();
        this.maxPrecursorMassLabel = new JLabel();
        this.maxPrecursorMassTextField = new JTextField();
        this.activationTypeCmb = new JComboBox();
        this.cancelButton = new JButton();
        this.openDialogHelpJButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("pNovo+ Advanced Settings");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                PNovoSettingsDialog.this.formWindowClosing(evt);
            }
        });
        this.backgroundPanel.setBackground(new Color(230, 230, 230));
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PNovoSettingsDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.pNovoPanel.setBorder(BorderFactory.createTitledBorder("pNovo+ Settings"));
        this.pNovoPanel.setOpaque(false);
        this.activationTypeLabel.setText("Activation Type");
        this.minPrecursorMassLabel.setText("Min Precusor Mass (Da)");
        this.minPrecursorMassTextField.setHorizontalAlignment(0);
        this.minPrecursorMassTextField.setText("300");
        this.minPrecursorMassTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                PNovoSettingsDialog.this.minPrecursorMassTextFieldKeyReleased(evt);
            }
        });
        this.maxPrecursorMassLabel.setText("Max Precursor Mass (Da)");
        this.maxPrecursorMassTextField.setHorizontalAlignment(0);
        this.maxPrecursorMassTextField.setText("5000");
        this.maxPrecursorMassTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                PNovoSettingsDialog.this.maxPrecursorMassTextFieldKeyReleased(evt);
            }
        });
        this.activationTypeCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"HCD", "CID", "ETD"}));
        GroupLayout pNovoPanelLayout = new GroupLayout(this.pNovoPanel);
        this.pNovoPanel.setLayout(pNovoPanelLayout);
        pNovoPanelLayout.setHorizontalGroup(pNovoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pNovoPanelLayout.createSequentialGroup().addContainerGap().addGroup(pNovoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pNovoPanelLayout.createSequentialGroup().addComponent(this.activationTypeLabel, -2, 180, -2).addGap(18, 18, 18).addComponent(this.activationTypeCmb, -2, 130, -2)).addGroup(pNovoPanelLayout.createSequentialGroup().addComponent(this.minPrecursorMassLabel, -2, 180, -2).addGap(18, 18, 18).addComponent(this.minPrecursorMassTextField, -2, 130, -2)).addGroup(pNovoPanelLayout.createSequentialGroup().addComponent(this.maxPrecursorMassLabel, -2, 180, -2).addGap(18, 18, 18).addComponent(this.maxPrecursorMassTextField, -2, 130, -2))).addContainerGap(-1, Short.MAX_VALUE)));
        pNovoPanelLayout.setVerticalGroup(pNovoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pNovoPanelLayout.createSequentialGroup().addContainerGap().addGroup(pNovoPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.activationTypeLabel).addComponent(this.activationTypeCmb, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pNovoPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.minPrecursorMassTextField, -2, -1, -2).addComponent(this.minPrecursorMassLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pNovoPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.maxPrecursorMassLabel).addComponent(this.maxPrecursorMassTextField, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PNovoSettingsDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.openDialogHelpJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/help.GIF")));
        this.openDialogHelpJButton.setToolTipText("Open the pNovo+ web page");
        this.openDialogHelpJButton.setBorder(null);
        this.openDialogHelpJButton.setBorderPainted(false);
        this.openDialogHelpJButton.setContentAreaFilled(false);
        this.openDialogHelpJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                PNovoSettingsDialog.this.openDialogHelpJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                PNovoSettingsDialog.this.openDialogHelpJButtonMouseExited(evt);
            }
        });
        this.openDialogHelpJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PNovoSettingsDialog.this.openDialogHelpJButtonActionPerformed(evt);
            }
        });
        GroupLayout backgroundPanelLayout = new GroupLayout(this.backgroundPanel);
        this.backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.pNovoPanel, -1, -1, Short.MAX_VALUE).addGroup(backgroundPanelLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.openDialogHelpJButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.okButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton))).addContainerGap()));
        backgroundPanelLayout.linkSize(0, this.cancelButton, this.okButton);
        backgroundPanelLayout.setVerticalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.pNovoPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.openDialogHelpJButton).addComponent(this.okButton).addComponent(this.cancelButton)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -2, -1, -2));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -2, -1, -2));
        this.pack();
    }

    private void minPrecursorMassTextFieldKeyReleased(KeyEvent evt) {
        this.validateParametersInput(false);
    }

    private void maxPrecursorMassTextFieldKeyReleased(KeyEvent evt) {
        this.validateParametersInput(false);
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        boolean valid = this.validateParametersInput(true);
        if (valid) {
            this.dispose();
        }
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.canceled = true;
        this.dispose();
    }

    private void openDialogHelpJButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL("http://pfind.ict.ac.cn/software/pNovo/");
        this.setCursor(new Cursor(0));
    }

    private void openDialogHelpJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void openDialogHelpJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void formWindowClosing(WindowEvent evt) {
        this.cancelButtonActionPerformed(null);
    }

    public boolean validateParametersInput(boolean showMessage) {
        boolean valid = true;
        valid = GuiUtilities.validateIntegerInput(this, this.minPrecursorMassLabel, this.minPrecursorMassTextField, "minimum precursor mass", "Minimum Precursor Mass Error", true, showMessage, valid);
        valid = GuiUtilities.validateIntegerInput(this, this.maxPrecursorMassLabel, this.maxPrecursorMassTextField, "maximum precursor mass", "Maximum Precursor Mass Error", true, showMessage, valid);
        this.okButton.setEnabled(valid);
        return valid;
    }

    public PNovoParameters getPNovoParameters() {
        PNovoParameters pNovoParameters = new PNovoParameters();
        pNovoParameters.setLowerPrecursorMass(Integer.parseInt(this.minPrecursorMassTextField.getText()));
        pNovoParameters.setUpperPrecursorMass(Integer.parseInt(this.maxPrecursorMassTextField.getText()));
        pNovoParameters.setActicationType((String)this.activationTypeCmb.getSelectedItem());
        return pNovoParameters;
    }

    @Override
    public boolean isCancelled() {
        return this.canceled;
    }

    @Override
    public IdentificationAlgorithmParameter getParameters() {
        return this.getPNovoParameters();
    }
}

