/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.maps;

import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.Semaphore;

public class MapMutex<K> {
    private Integer cacheLimitSize = null;
    public final int permits;
    private final HashMap<K, Semaphore> semaphoreMap;
    private Semaphore mutex = new Semaphore(1, true);
    private boolean writing = false;

    public MapMutex(Integer permits, Integer cacheLimitSize, Integer initialSize) {
        this.permits = permits != null ? permits : 1;
        if (cacheLimitSize != null) {
            this.cacheLimitSize = cacheLimitSize;
        }
        this.semaphoreMap = initialSize != null ? new HashMap(initialSize) : new HashMap();
    }

    public MapMutex() {
        this(null, null, null);
    }

    public MapMutex(int permits) {
        this(permits, null, null);
    }

    public void acquire(K key) throws InterruptedException {
        Semaphore semaphore;
        if (this.writing) {
            this.mutex.acquire();
            this.mutex.release();
        }
        if ((semaphore = this.semaphoreMap.get(key)) == null) {
            this.mutex.acquire();
            semaphore = this.semaphoreMap.get(key);
            if (semaphore == null) {
                this.writing = true;
                semaphore = new Semaphore(this.permits);
                this.semaphoreMap.put(key, semaphore);
                this.writing = false;
            }
            this.mutex.release();
        }
        semaphore.acquire();
    }

    public void release(K key) throws InterruptedException {
        if (this.writing) {
            this.mutex.acquire();
            this.mutex.release();
        }
        if (this.cacheLimitSize != null && this.semaphoreMap.size() > this.cacheLimitSize) {
            this.writing = true;
            this.mutex.acquire();
            this.writing = true;
            HashSet<K> keys = new HashSet<K>(this.semaphoreMap.keySet());
            for (K tempKey : keys) {
                Semaphore tempSemaphore = this.semaphoreMap.get(tempKey);
                if (tempSemaphore.hasQueuedThreads() || tempSemaphore.availablePermits() != this.permits) continue;
                this.semaphoreMap.remove(tempKey);
            }
            this.writing = false;
            this.mutex.release();
        }
        Semaphore semaphore = this.semaphoreMap.get(key);
        semaphore.release();
    }
}

